/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.JavaVersion;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.util.Iterator;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DumbMethods
extends OpcodeStackDetector {
    private static final ObjectType CONDITION_TYPE = ObjectTypeFactory.getInstance("java.util.concurrent.locks.Condition");
    private final BugReporter bugReporter;
    private boolean sawCurrentTimeMillis;
    private BugInstance gcInvocationBugReport;
    private int gcInvocationPC;
    private CodeException[] exceptionTable;
    private String primitiveObjCtorSeen;
    private boolean ctorSeen;
    private boolean prevOpcodeWasReadLine;
    private int prevOpcode;
    private boolean isPublicStaticVoidMain;
    private boolean isEqualsObject;
    private boolean sawInstanceofCheck;
    private boolean reportedBadCastInEquals;
    private int sawCheckForNonNegativeSignedByte;
    private int sinceBufferedInputStreamReady;
    private int randomNextIntState;
    private boolean checkForBitIorofSignedByte;
    private final boolean jdk15ChecksEnabled;
    private final BugAccumulator accumulator;
    boolean isSynthetic;
    int opcodesSincePendingAbsoluteValueBug;
    BugInstance pendingAbsoluteValueBug;
    SourceLineAnnotation pendingAbsoluteValueBugSourceLine;
    boolean freshRandomOnTos = false;
    boolean freshRandomOneBelowTos = false;
    private static final int OOM_CATCH_LEN = 20;

    public DumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
        this.jdk15ChecksEnabled = JavaVersion.getRuntimeVersion().isSameOrNewerThan(JavaVersion.JAVA_1_5);
    }

    public void visit(JavaClass obj) {
        String superclassName = obj.getSuperclassName();
        this.isSynthetic = superclassName.equals("java.rmi.server.RemoteStub");
        Attribute[] attributes = obj.getAttributes();
        if (attributes != null) {
            for (Attribute a : attributes) {
                if (!(a instanceof Synthetic)) continue;
                this.isSynthetic = true;
            }
        }
    }

    public void visitAfter(JavaClass obj) {
        this.accumulator.reportAccumulatedBugs();
    }

    public static boolean isTestMethod(Method method) {
        return method.getName().startsWith("test");
    }

    public void visit(Method method) {
        String cName = this.getDottedClassName();
        this.isPublicStaticVoidMain = method.isPublic() && method.isStatic() && this.getMethodName().equals("main") || cName.toLowerCase().indexOf("benchmark") >= 0;
        this.prevOpcodeWasReadLine = false;
        Code code = method.getCode();
        if (code != null) {
            this.exceptionTable = code.getExceptionTable();
        }
        if (this.exceptionTable == null) {
            this.exceptionTable = new CodeException[0];
        }
        this.primitiveObjCtorSeen = null;
        this.ctorSeen = false;
        this.randomNextIntState = 0;
        this.checkForBitIorofSignedByte = false;
        this.isEqualsObject = this.getMethodName().equals("equals") && this.getMethodSig().equals("(Ljava/lang/Object;)Z") && !method.isStatic();
        this.sawInstanceofCheck = false;
        this.reportedBadCastInEquals = false;
        this.freshRandomOnTos = false;
        this.sinceBufferedInputStreamReady = 100000;
        this.sawCheckForNonNegativeSignedByte = -1000;
    }

    static boolean isPowerOfTwo(int i) {
        if (i <= 0) {
            return false;
        }
        return (i | i - 1) + 1 == 2 * i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item lhs;
        Object rhsConstant;
        OpcodeStack.Item top;
        OpcodeStack.Item item0;
        if (this.stack.getStackDepth() >= 2) {
            switch (seen) {
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    int year;
                    item0 = this.stack.getStackItem(0);
                    OpcodeStack.Item item1 = this.stack.getStackItem(1);
                    if (item0.getConstant() instanceof Integer) {
                        OpcodeStack.Item tmp = item0;
                        item0 = item1;
                        item1 = tmp;
                    }
                    Object constant1 = item1.getConstant();
                    XMethod returnValueOf = item0.getReturnValueOf();
                    if (!(constant1 instanceof Integer) || returnValueOf == null || !returnValueOf.getName().equals("getYear") || !returnValueOf.getClassName().equals("java.util.Date") && !returnValueOf.getClassName().equals("java.sql.Date") || (year = ((Integer)constant1).intValue()) <= 1900) break;
                    this.accumulator.accumulateBug(new BugInstance(this, "UNKNOWN", 1).addClassAndMethod(this).addMethod(returnValueOf).describe("METHOD_CALLED").addInt(year).describe("INT_VALUE"), this);
                }
            }
        }
        if (seen == 155 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getSpecialKind() == 1) {
            this.sawCheckForNonNegativeSignedByte = this.getPC();
        }
        if (this.pendingAbsoluteValueBug != null) {
            if (this.opcodesSincePendingAbsoluteValueBug == 0) {
                ++this.opcodesSincePendingAbsoluteValueBug;
            } else {
                Object constantValue;
                if (seen == 112 && (constantValue = (top = this.stack.getStackItem(0)).getConstant()) instanceof Number && DumbMethods.isPowerOfTwo(((Number)constantValue).intValue())) {
                    this.pendingAbsoluteValueBug.setPriority(3);
                }
                this.accumulator.accumulateBug(this.pendingAbsoluteValueBug, this.pendingAbsoluteValueBugSourceLine);
                this.pendingAbsoluteValueBug = null;
                this.pendingAbsoluteValueBugSourceLine = null;
            }
        }
        if (seen == 184 && this.getClassConstantOperand().equals("org/easymock/EasyMock") && (this.getNameConstantOperand().equals("replay") || this.getNameConstantOperand().equals("verify") || this.getNameConstantOperand().startsWith("reset")) && this.getSigConstantOperand().equals("([Ljava/lang/Object;)V") && this.getPrevOpcode(1) == 189 && this.getPrevOpcode(2) == 3) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_VACUOUS_CALL_TO_EASYMOCK_METHOD", 2).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if ((seen == 184 || seen == 182 || seen == 183 || seen == 185) && this.getSigConstantOperand().indexOf("Ljava/lang/Runnable;") >= 0) {
            SignatureParser parser = new SignatureParser(this.getSigConstantOperand());
            int count = 0;
            Iterator<String> i = parser.parameterSignatureIterator();
            while (i.hasNext()) {
                OpcodeStack.Item item;
                String parameter = i.next();
                if (parameter.equals("Ljava/lang/Runnable;") && "Ljava/lang/Thread;".equals((item = this.stack.getStackItem(parser.getNumParameters() - 1 - count)).getSignature())) {
                    this.accumulator.accumulateBug(new BugInstance(this, "DMI_THREAD_PASSED_WHERE_RUNNABLE_EXPECTED", 2).addClassAndMethod(this).addCalledMethod(this), this);
                }
                ++count;
            }
        }
        if (this.prevOpcode == 133 && seen == 184 && this.getClassConstantOperand().equals("java/lang/Double") && this.getNameConstantOperand().equals("longBitsToDouble")) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_LONG_BITS_TO_DOUBLE_INVOKED_ON_INT", 1).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if (seen == 182 && this.getClassConstantOperand().equals("java/util/Random") && (this.freshRandomOnTos || this.freshRandomOneBelowTos)) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_RANDOM_USED_ONLY_ONCE", 1).addClassAndMethod(this).addCalledMethod(this), this);
        }
        this.freshRandomOneBelowTos = this.freshRandomOnTos && this.isRegisterLoad();
        boolean bl = this.freshRandomOnTos = seen == 183 && this.getClassConstantOperand().equals("java/util/Random") && this.getNameConstantOperand().equals("<init>");
        if ((seen == 182 && this.getClassConstantOperand().equals("java/util/HashMap") && this.getNameConstantOperand().equals("get") || seen == 185 && this.getClassConstantOperand().equals("java/util/Map") && this.getNameConstantOperand().equals("get") || seen == 182 && this.getClassConstantOperand().equals("java/util/HashSet") && this.getNameConstantOperand().equals("contains") || seen == 185 && this.getClassConstantOperand().equals("java/util/Set") && this.getNameConstantOperand().equals("contains")) && (top = this.stack.getStackItem(0)).getSignature().equals("Ljava/net/URL;")) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod(this), this);
        }
        if (seen == 182 && this.getClassConstantOperand().equals("java/util/concurrent/ScheduledThreadPoolExecutor") && this.getNameConstantOperand().equals("setMaximumPoolSize")) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_FUTILE_ATTEMPT_TO_CHANGE_MAXPOOL_SIZE_OF_SCHEDULED_THREAD_POOL_EXECUTOR", 1).addClassAndMethod(this), this);
        }
        if (this.isEqualsObject && !this.reportedBadCastInEquals) {
            OpcodeStack.Item item;
            if (seen == 193 || seen == 182 && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
                item = this.stack.getStackItem(0);
                if (item.getRegisterNumber() == 1) {
                    this.sawInstanceofCheck = true;
                }
            } else if (seen == 183 && this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z")) {
                item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                if (item1.getRegisterNumber() + item0.getRegisterNumber() == 1) {
                    this.sawInstanceofCheck = true;
                }
            } else if (seen == 192 && !this.sawInstanceofCheck && (item = this.stack.getStackItem(0)).getRegisterNumber() == 1) {
                if (this.getSizeOfSurroundingTryBlock(this.getPC()) == Integer.MAX_VALUE) {
                    this.accumulator.accumulateBug(new BugInstance(this, "BC_EQUALS_METHOD_SHOULD_WORK_FOR_ALL_OBJECTS", 2).addClassAndMethod(this), this);
                }
                this.reportedBadCastInEquals = true;
            }
        }
        boolean foundVacuousComparison = false;
        if (seen == 163 || seen == 164) {
            Object lhsConstant;
            OpcodeStack.Item rhs = this.stack.getStackItem(0);
            rhsConstant = rhs.getConstant();
            if (rhsConstant instanceof Integer && (Integer)rhsConstant == Integer.MAX_VALUE) {
                foundVacuousComparison = true;
            }
            if ((lhsConstant = (lhs = this.stack.getStackItem(1)).getConstant()) instanceof Integer && (Integer)lhsConstant == Integer.MIN_VALUE) {
                foundVacuousComparison = true;
            }
        }
        if (seen == 161 || seen == 162) {
            Object lhsConstant;
            OpcodeStack.Item rhs = this.stack.getStackItem(0);
            rhsConstant = rhs.getConstant();
            if (rhsConstant instanceof Integer && (Integer)rhsConstant == Integer.MIN_VALUE) {
                foundVacuousComparison = true;
            }
            if ((lhsConstant = (lhs = this.stack.getStackItem(1)).getConstant()) instanceof Integer && (Integer)lhsConstant == Integer.MAX_VALUE) {
                foundVacuousComparison = true;
            }
        }
        if (foundVacuousComparison) {
            this.accumulator.accumulateBug(new BugInstance(this, "INT_VACUOUS_COMPARISON", this.getBranchOffset() < 0 ? 1 : 2).addClassAndMethod(this), this);
        }
        if (seen == 184 && (this.getClassConstantOperand().equals("java/lang/Math") || this.getClassConstantOperand().equals("java/lang/StrictMath")) && this.getNameConstantOperand().equals("abs") && this.getSigConstantOperand().equals("(I)I")) {
            OpcodeStack.Item item02 = this.stack.getStackItem(0);
            int special = item02.getSpecialKind();
            if (special == 2) {
                this.pendingAbsoluteValueBug = new BugInstance(this, "RV_ABSOLUTE_VALUE_OF_RANDOM_INT", 1).addClassAndMethod(this);
                this.pendingAbsoluteValueBugSourceLine = SourceLineAnnotation.fromVisitedInstruction(this);
                this.opcodesSincePendingAbsoluteValueBug = 0;
            } else if (special == 4) {
                this.pendingAbsoluteValueBug = new BugInstance(this, "RV_ABSOLUTE_VALUE_OF_HASHCODE", 1).addClassAndMethod(this);
                this.pendingAbsoluteValueBugSourceLine = SourceLineAnnotation.fromVisitedInstruction(this);
                this.opcodesSincePendingAbsoluteValueBug = 0;
            }
        }
        try {
            String sig;
            int majorVersion;
            OpcodeStack.Item item;
            Object value;
            OpcodeStack.Item item1;
            OpcodeStack.Item item03;
            Object constant0;
            int stackLoc = this.stackEntryThatMustBeNonnegative(seen);
            if (stackLoc >= 0) {
                OpcodeStack.Item tos = this.stack.getStackItem(stackLoc);
                switch (tos.getSpecialKind()) {
                    case 9: {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_REM_OF_HASHCODE", 1).addClassAndMethod(this), this);
                        break;
                    }
                    case 2: 
                    case 8: {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_REM_OF_RANDOM_INT", 1).addClassAndMethod(this), this);
                    }
                }
            }
            if (seen == 112 && (constant0 = (item03 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)constant0 == 1) {
                this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_REM_BY_1", 1).addClassAndMethod(this), this);
            }
            if (this.stack.getStackDepth() >= 1 && (seen == 171 || seen == 170) && (item0 = this.stack.getStackItem(0)).getSpecialKind() == 1) {
                int[] switchLabels = this.getSwitchLabels();
                int[] switchOffsets = this.getSwitchOffsets();
                for (int i = 0; i < switchLabels.length; ++i) {
                    int v = switchLabels[i];
                    if (v > -129 && v < 128) continue;
                    this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_SIGNED_BYTE", 1).addClassAndMethod(this).addInt(v).describe("INT_VALUE"), SourceLineAnnotation.fromVisitedInstruction(this, this.getPC() + switchOffsets[i]));
                }
            }
            if (this.stack.getStackDepth() >= 2) {
                switch (seen) {
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        int v1;
                        item0 = this.stack.getStackItem(0);
                        item1 = this.stack.getStackItem(1);
                        int seen2 = seen;
                        if (item0.getConstant() != null) {
                            OpcodeStack.Item tmp = item0;
                            item0 = item1;
                            item1 = tmp;
                            switch (seen) {
                                case 161: {
                                    seen2 = 163;
                                    break;
                                }
                                case 162: {
                                    seen2 = 164;
                                    break;
                                }
                                case 163: {
                                    seen2 = 161;
                                    break;
                                }
                                case 164: {
                                    seen2 = 162;
                                }
                            }
                        }
                        Object constant1 = item1.getConstant();
                        if (item0.getSpecialKind() == 1 && constant1 instanceof Number) {
                            v1 = ((Number)constant1).intValue();
                            if (v1 > -129 && v1 < 128 && (v1 != 127 || seen2 == 159 || seen2 == 160)) break;
                            int priority = 1;
                            if (v1 == 127) {
                                switch (seen2) {
                                    case 163: {
                                        priority = 3;
                                        break;
                                    }
                                    case 162: {
                                        priority = 2;
                                        break;
                                    }
                                    case 161: {
                                        priority = 2;
                                        break;
                                    }
                                    case 164: {
                                        priority = 3;
                                    }
                                }
                            } else if (v1 == 128) {
                                switch (seen2) {
                                    case 163: {
                                        priority = 2;
                                        break;
                                    }
                                    case 162: {
                                        priority = 1;
                                        break;
                                    }
                                    case 161: {
                                        priority = 1;
                                        break;
                                    }
                                    case 164: {
                                        priority = 2;
                                    }
                                }
                            } else if (v1 <= -129) {
                                priority = 2;
                            }
                            if (this.getPC() - this.sawCheckForNonNegativeSignedByte < 10) {
                                ++priority;
                            }
                            this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_SIGNED_BYTE", priority).addClassAndMethod(this).addInt(v1).describe("INT_VALUE"), this);
                            break;
                        }
                        if (item0.getSpecialKind() != 12 || !(constant1 instanceof Number) || (v1 = ((Number)constant1).intValue()) >= 0) break;
                        this.accumulator.accumulateBug(new BugInstance(this, "INT_BAD_COMPARISON_WITH_NONNEGATIVE_VALUE", 1).addClassAndMethod(this).addInt(v1).describe("INT_VALUE"), this);
                    }
                }
            }
            switch (seen) {
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    long badValue = seen == 126 || seen == 127 ? -1L : 0L;
                    OpcodeStack.Item rhs = this.stack.getStackItem(0);
                    OpcodeStack.Item lhs2 = this.stack.getStackItem(1);
                    int prevOpcode = this.getPrevOpcode(1);
                    int prevPrevOpcode = this.getPrevOpcode(2);
                    if (!rhs.hasConstantValue(badValue) || prevOpcode != 18 && prevOpcode != 3 && prevOpcode != 2 && prevOpcode != 9 || prevPrevOpcode == 167) break;
                    this.reportVacuousBitOperation(seen, lhs2);
                }
            }
            if (this.checkForBitIorofSignedByte && seen != 145) {
                String pattern = this.prevOpcode == 129 || this.prevOpcode == 128 ? "BIT_IOR_OF_SIGNED_BYTE" : "BIT_ADD_OF_SIGNED_BYTE";
                int priority = this.prevOpcode == 129 || this.prevOpcode == 97 ? 1 : 2;
                this.accumulator.accumulateBug(new BugInstance(this, pattern, priority).addClassAndMethod(this), this);
                this.checkForBitIorofSignedByte = false;
            } else if ((seen == 128 || seen == 129 || seen == 96 || seen == 97) && this.stack.getStackDepth() >= 2) {
                item0 = this.stack.getStackItem(0);
                item1 = this.stack.getStackItem(1);
                int special0 = item0.getSpecialKind();
                int special1 = item1.getSpecialKind();
                this.checkForBitIorofSignedByte = special0 == 1 && special1 == 3 && !item1.hasConstantValue(256) || special0 == 3 && !item0.hasConstantValue(256) && special1 == 1;
            } else {
                this.checkForBitIorofSignedByte = false;
            }
            if (this.prevOpcodeWasReadLine && this.sinceBufferedInputStreamReady >= 100 && seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getSigConstantOperand().startsWith("()")) {
                this.accumulator.accumulateBug(new BugInstance(this, "NP_IMMEDIATE_DEREFERENCE_OF_READLINE", 2).addClassAndMethod(this), this);
            }
            this.sinceBufferedInputStreamReady = seen == 182 && this.getClassConstantOperand().equals("java/io/BufferedReader") && this.getNameConstantOperand().equals("ready") && this.getSigConstantOperand().equals("()Z") ? 0 : ++this.sinceBufferedInputStreamReady;
            this.prevOpcodeWasReadLine = (seen == 182 || seen == 185) && this.getNameConstantOperand().equals("readLine") && this.getSigConstantOperand().equals("()Ljava/lang/String;");
            switch (this.randomNextIntState) {
                case 0: {
                    if ((seen != 182 || !this.getClassConstantOperand().equals("java/util/Random") || !this.getNameConstantOperand().equals("nextDouble")) && (seen != 184 || !this.getClassConstantOperand().equals("java/lang/Math") || !this.getNameConstantOperand().equals("random"))) break;
                    this.randomNextIntState = 1;
                    break;
                }
                case 1: {
                    if (seen == 142) {
                        this.accumulator.accumulateBug(new BugInstance(this, "RV_01_TO_INT", 1).addClassAndMethod(this), this);
                        this.randomNextIntState = 0;
                        break;
                    }
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 2;
                    break;
                }
                case 2: {
                    if (seen == 135) {
                        this.randomNextIntState = 3;
                        break;
                    }
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 3: {
                    if (seen == 107) {
                        this.randomNextIntState = 4;
                        break;
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                case 4: {
                    if (seen == 142) {
                        this.accumulator.accumulateBug(new BugInstance(this, "DM_NEXTINT_VIA_NEXTDOUBLE", 2).addClassAndMethod(this), this);
                    }
                    this.randomNextIntState = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.isPublicStaticVoidMain && seen == 182 && this.getClassConstantOperand().startsWith("javax/swing/") && (this.getNameConstantOperand().equals("show") && this.getSigConstantOperand().equals("()V") || this.getNameConstantOperand().equals("pack") && this.getSigConstantOperand().equals("()V") || this.getNameConstantOperand().equals("setVisible") && this.getSigConstantOperand().equals("(Z)V"))) {
                this.accumulator.accumulateBug(new BugInstance(this, "SW_SWING_METHODS_INVOKED_IN_SWING_THREAD", 3).addClassAndMethod(this), this);
            }
            if (seen == 182 && this.getNameConstantOperand().equals("isAnnotationPresent") && this.getSigConstantOperand().equals("(Ljava/lang/Class;)Z") && this.stack.getStackDepth() > 0 && (value = (item = this.stack.getStackItem(0)).getConstant()) instanceof String) {
                String annotationClassName = (String)value;
                boolean lacksClassfileRetention = AnalysisContext.currentAnalysisContext().getAnnotationRetentionDatabase().lacksRuntimeRetention(annotationClassName.replace('/', '.'));
                if (lacksClassfileRetention) {
                    ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptor(annotationClassName);
                    this.accumulator.accumulateBug(new BugInstance(this, "DMI_ANNOTATION_IS_NOT_VISIBLE_TO_REFLECTION", 1).addClassAndMethod(this).addCalledMethod(this).addClass(annotationClass).describe("CLASS_ANNOTATION"), this);
                }
            }
            if (seen == 182 && this.getNameConstantOperand().equals("next") && this.getSigConstantOperand().equals("()Ljava/lang/Object;") && this.getMethodName().equals("hasNext") && this.getMethodSig().equals("()Z") && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                this.accumulator.accumulateBug(new BugInstance(this, "DMI_CALLING_NEXT_FROM_HASNEXT", item.isInitialParameter() && item.getRegisterNumber() == 0 ? 2 : 3).addClassAndMethod(this).addCalledMethod(this), this);
            }
            if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("(Ljava/lang/String;)V")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_CTOR", 2).addClassAndMethod(this), this);
            }
            if (seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && this.getNameConstantOperand().equals("runFinalizersOnExit") || seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime") && this.getNameConstantOperand().equals("runFinalizersOnExit")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_RUN_FINALIZERS_ON_EXIT", 1).addClassAndMethod(this), this);
            }
            if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_VOID_CTOR", 2).addClassAndMethod(this), this);
            }
            if (!this.isPublicStaticVoidMain && seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && this.getNameConstantOperand().equals("exit") && !this.getMethodName().equals("processWindowEvent") && !this.getMethodName().startsWith("windowClos") && this.getMethodName().indexOf("exit") == -1 && this.getMethodName().indexOf("Exit") == -1 && this.getMethodName().indexOf("crash") == -1 && this.getMethodName().indexOf("Crash") == -1 && this.getMethodName().indexOf("die") == -1 && this.getMethodName().indexOf("Die") == -1 && this.getMethodName().indexOf("main") == -1) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_EXIT", this.getMethod().isStatic() ? 3 : 2).addClassAndMethod(this), SourceLineAnnotation.fromVisitedInstruction(this));
            }
            if ((seen == 184 && this.getClassConstantOperand().equals("java/lang/System") || seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime")) && this.getNameConstantOperand().equals("gc") && this.getSigConstantOperand().equals("()V") && !this.getDottedClassName().startsWith("java.lang") && !this.getMethodName().startsWith("gc") && !this.getMethodName().endsWith("gc") && this.gcInvocationBugReport == null) {
                if (this.isPublicStaticVoidMain) {
                    return;
                }
                if (DumbMethods.isTestMethod(this.getMethod())) {
                    return;
                }
                this.gcInvocationBugReport = new BugInstance(this, "DM_GC", 1).addClassAndMethod(this).addSourceLine(this);
                this.gcInvocationPC = this.getPC();
            }
            if (!this.isSynthetic && seen == 183 && this.getClassConstantOperand().equals("java/lang/Boolean") && this.getNameConstantOperand().equals("<init>") && !this.getClassName().equals("java/lang/Boolean") && (majorVersion = this.getThisClass().getMajor()) >= 48) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_BOOLEAN_CTOR", 2).addClassAndMethod(this), this);
            }
            if (seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && (this.getNameConstantOperand().equals("currentTimeMillis") || this.getNameConstantOperand().equals("nanoTime"))) {
                this.sawCurrentTimeMillis = true;
            }
            if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("toString") && this.getSigConstantOperand().equals("()Ljava/lang/String;")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_STRING_TOSTRING", 3).addClassAndMethod(this), this);
            }
            if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && (this.getNameConstantOperand().equals("toUpperCase") || this.getNameConstantOperand().equals("toLowerCase")) && this.getSigConstantOperand().equals("()Ljava/lang/String;")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_CONVERT_CASE", 3).addClassAndMethod(this), this);
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>")) {
                String cls = this.getClassConstantOperand();
                String sig2 = this.getSigConstantOperand();
                this.primitiveObjCtorSeen = cls.equals("java/lang/Integer") && sig2.equals("(I)V") || cls.equals("java/lang/Float") && sig2.equals("(F)V") || cls.equals("java/lang/Double") && sig2.equals("(D)V") || cls.equals("java/lang/Long") && sig2.equals("(J)V") || cls.equals("java/lang/Byte") && sig2.equals("(B)V") || cls.equals("java/lang/Character") && sig2.equals("(C)V") || cls.equals("java/lang/Short") && sig2.equals("(S)V") || cls.equals("java/lang/Boolean") && sig2.equals("(Z)V") ? cls : null;
            } else if (this.primitiveObjCtorSeen != null && seen == 182 && this.getNameConstantOperand().equals("toString") && this.getClassConstantOperand().equals(this.primitiveObjCtorSeen) && this.getSigConstantOperand().equals("()Ljava/lang/String;")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_BOXED_PRIMITIVE_TOSTRING", 3).addClassAndMethod(this), this);
                this.primitiveObjCtorSeen = null;
            } else {
                this.primitiveObjCtorSeen = null;
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>")) {
                this.ctorSeen = true;
            } else if (this.ctorSeen && seen == 182 && this.getClassConstantOperand().equals("java/lang/Object") && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_NEW_FOR_GETCLASS", 3).addClassAndMethod(this), this);
                this.ctorSeen = false;
            } else {
                this.ctorSeen = false;
            }
            if (this.jdk15ChecksEnabled && seen == 182 && this.isMonitorWait(this.getNameConstantOperand(), this.getSigConstantOperand())) {
                this.checkMonitorWait();
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getClassConstantOperand().equals("java/lang/Thread") && ((sig = this.getSigConstantOperand()).equals("()V") || sig.equals("(Ljava/lang/String;)V") || sig.equals("(Ljava/lang/ThreadGroup;Ljava/lang/String;)V"))) {
                OpcodeStack.Item invokedOn = this.stack.getItemMethodInvokedOn(this);
                if (!this.getMethodName().equals("<init>") || invokedOn.getRegisterNumber() != 0) {
                    this.accumulator.accumulateBug(new BugInstance(this, "DM_USELESS_THREAD", 3).addClassAndMethod(this), this);
                }
            }
        }
        finally {
            this.prevOpcode = seen;
        }
    }

    private void reportVacuousBitOperation(int seen, OpcodeStack.Item item) {
        if (item.getConstant() == null) {
            this.accumulator.accumulateBug(new BugInstance(this, "INT_VACUOUS_BIT_OPERATION", 2).addClassAndMethod(this).addString(OPCODE_NAMES[seen]).addOptionalAnnotation(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), item, this.getPC())), this);
        }
    }

    private int stackEntryThatMustBeNonnegative(int seen) {
        switch (seen) {
            case 185: {
                if (!this.getClassConstantOperand().equals("java/util/List")) break;
                return this.getStackEntryOfListCallThatMustBeNonnegative();
            }
            case 182: {
                if (!this.getClassConstantOperand().equals("java/util/LinkedList") && !this.getClassConstantOperand().equals("java/util/ArrayList")) break;
                return this.getStackEntryOfListCallThatMustBeNonnegative();
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return 0;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return 1;
            }
        }
        return -1;
    }

    private int getStackEntryOfListCallThatMustBeNonnegative() {
        String name = this.getNameConstantOperand();
        if ((name.equals("add") || name.equals("set")) && this.getSigConstantOperand().startsWith("(I")) {
            return 1;
        }
        if ((name.equals("get") || name.equals("remove")) && this.getSigConstantOperand().startsWith("(I)")) {
            return 0;
        }
        return -1;
    }

    private void checkMonitorWait() {
        try {
            TypeDataflow typeDataflow = this.getClassContext().getTypeDataflow(this.getMethod());
            TypeDataflow.LocationAndFactPair pair = typeDataflow.getLocationAndFactForInstruction(this.getPC());
            if (pair == null) {
                return;
            }
            Type receiver = (Type)pair.frame.getInstance(pair.location.getHandle().getInstruction(), this.getClassContext().getConstantPoolGen());
            if (!(receiver instanceof ReferenceType)) {
                return;
            }
            if (Hierarchy.isSubtype((ReferenceType)receiver, CONDITION_TYPE)) {
                this.accumulator.accumulateBug(new BugInstance(this, "DM_MONITOR_WAIT_ON_CONDITION", 1).addClassAndMethod(this), this);
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Exception caught by DumbMethods", e);
        }
    }

    private boolean isMonitorWait(String name, String sig) {
        return name.equals("wait") && (sig.equals("()V") || sig.equals("(J)V") || sig.equals("(JI)V"));
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.flush();
    }

    private void flush() {
        if (this.pendingAbsoluteValueBug != null) {
            this.accumulator.accumulateBug(this.pendingAbsoluteValueBug, this.pendingAbsoluteValueBugSourceLine);
            this.pendingAbsoluteValueBug = null;
            this.pendingAbsoluteValueBugSourceLine = null;
        }
        if (this.gcInvocationBugReport != null && !this.sawCurrentTimeMillis) {
            boolean outOfMemoryHandler = false;
            for (CodeException handler : this.exceptionTable) {
                String exClassName;
                ConstantPool cp;
                Constant constant;
                int catchTypeIndex;
                if (this.gcInvocationPC < handler.getHandlerPC() || this.gcInvocationPC > handler.getHandlerPC() + 20 || (catchTypeIndex = handler.getCatchType()) <= 0 || !((constant = (cp = this.getThisClass().getConstantPool()).getConstant(catchTypeIndex)) instanceof ConstantClass) || !(exClassName = (String)((ConstantClass)constant).getConstantValue(cp)).equals("java/lang/OutOfMemoryError")) continue;
                outOfMemoryHandler = true;
                break;
            }
            if (!outOfMemoryHandler) {
                this.bugReporter.reportBug(this.gcInvocationBugReport);
            }
        }
        this.sawCurrentTimeMillis = false;
        this.gcInvocationBugReport = null;
        this.exceptionTable = null;
    }
}

