/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.InterproceduralFirstPassDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.plan.ByInterfaceDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.ReportingDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.SingleDetectorFactorySelector;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.debug.PluginLoader");
    private ClassLoader classLoader;
    private static int nextUnknownId;
    private Plugin plugin;
    private final boolean corePlugin;

    public PluginLoader(URL url) throws PluginException {
        this.classLoader = new URLClassLoader(new URL[]{url});
        this.corePlugin = false;
        this.init();
    }

    public PluginLoader(URL url, ClassLoader parent) throws PluginException {
        this.classLoader = new URLClassLoader(new URL[]{url}, parent);
        this.corePlugin = false;
        this.init();
    }

    public PluginLoader() {
        this.classLoader = this.getClass().getClassLoader();
        this.corePlugin = true;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Plugin getPlugin() throws PluginException {
        if (this.plugin == null) {
            this.init();
        }
        return this.plugin;
    }

    private URL getResource(String name) {
        URLClassLoader urlClassLoader;
        URL url = null;
        if (this.classLoader instanceof URLClassLoader && (url = (urlClassLoader = (URLClassLoader)this.classLoader).findResource(name)) == null) {
            url = urlClassLoader.findResource("/" + name);
        }
        if (url == null && (url = this.classLoader.getResource(name)) == null) {
            url = this.classLoader.getResource("/" + name);
        }
        if (url != null) {
            return url;
        }
        return null;
    }

    @CheckForNull
    public static URL getCoreResource(String name) {
        URL u = PluginLoader.loadFromFindBugsPluginDir(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource("/" + name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource(name);
        if (u != null) {
            return u;
        }
        return PluginLoader.loadFromFindBugsEtcDir(name);
    }

    @CheckForNull
    public static URL loadFromFindBugsEtcDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "etc"), name)).canRead()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public static URL loadFromFindBugsPluginDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "plugin"), name)).canRead()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void init() throws PluginException {
        Iterator i$;
        Node orderingConstraintsNode;
        String website;
        String defaultEnabled;
        Document pluginDescriptor;
        ArrayList<Document> messageCollectionList = new ArrayList<Document>();
        String name = "findbugs.xml";
        URL findbugsXML_URL = this.getResource(name);
        if (findbugsXML_URL == null) {
            throw new PluginException("Couldn't find \"" + name + "\" in plugin");
        }
        if (DEBUG) {
            System.out.println("PluginLoader found " + name + " at: " + findbugsXML_URL);
        }
        SAXReader reader = new SAXReader();
        try {
            InputStreamReader r = new InputStreamReader(findbugsXML_URL.openStream());
            pluginDescriptor = reader.read(r);
        }
        catch (DocumentException e) {
            throw new PluginException("Couldn't parse \"" + findbugsXML_URL + "\" using " + reader.getClass().getName(), e);
        }
        catch (IOException e) {
            throw new PluginException("Couldn't open \"" + findbugsXML_URL + "\"", e);
        }
        String pluginId = pluginDescriptor.valueOf("/FindbugsPlugin/@pluginid");
        if (pluginId.equals("")) {
            Class<PluginLoader> e = PluginLoader.class;
            // MONITORENTER : edu.umd.cs.findbugs.PluginLoader.class
            pluginId = "plugin" + nextUnknownId++;
            // MONITOREXIT : e
        }
        boolean pluginEnabled = (defaultEnabled = pluginDescriptor.valueOf("/FindbugsPlugin/@defaultenabled")).equals("") || Boolean.valueOf(defaultEnabled) != false;
        Locale locale = I18N.defaultLocale;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        try {
            if (country != null) {
                this.addCollection(messageCollectionList, "messages_" + language + "_" + country + ".xml");
            }
            this.addCollection(messageCollectionList, "messages_" + language + ".xml");
        }
        catch (PluginException e) {
            AnalysisContext.logError("Error loading localized message file", e);
        }
        this.addCollection(messageCollectionList, "messages.xml");
        Plugin plugin = new Plugin(pluginId, this);
        plugin.setEnabled(pluginEnabled);
        String provider = pluginDescriptor.valueOf("/FindbugsPlugin/@provider");
        if (!provider.equals("")) {
            plugin.setProvider(provider);
        }
        if (!(website = pluginDescriptor.valueOf("/FindbugsPlugin/@website")).equals("")) {
            plugin.setWebsite(website);
        }
        Node pluginShortDesc = null;
        try {
            pluginShortDesc = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Plugin/ShortDescription", "no plugin description");
        }
        catch (PluginException e) {
            // empty catch block
        }
        if (pluginShortDesc != null) {
            plugin.setShortDescription(pluginShortDesc.getText());
        }
        if (!FindBugs.noAnalysis) {
            try {
                List detectorNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/Detector");
                int detectorCount = 0;
                for (Node detectorNode : detectorNodeList) {
                    Class<?> detectorClass;
                    String className = detectorNode.valueOf("@class");
                    String speed = detectorNode.valueOf("@speed");
                    String disabled = detectorNode.valueOf("@disabled");
                    String reports = detectorNode.valueOf("@reports");
                    String requireJRE = detectorNode.valueOf("@requirejre");
                    String hidden = detectorNode.valueOf("@hidden");
                    if (speed == null || speed.length() == 0) {
                        speed = "fast";
                    }
                    if (!Detector.class.isAssignableFrom(detectorClass = this.classLoader.loadClass(className)) && !Detector2.class.isAssignableFrom(detectorClass)) {
                        throw new PluginException("Class " + className + " does not implement Detector or Detector2");
                    }
                    DetectorFactory factory = new DetectorFactory(plugin, detectorClass, !disabled.equals("true"), speed, reports, requireJRE);
                    if (Boolean.valueOf(hidden).booleanValue()) {
                        factory.setHidden(true);
                    }
                    factory.setPositionSpecifiedInPluginDescriptor(detectorCount++);
                    plugin.addDetectorFactory(factory);
                    Node node = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Detector[@class='" + className + "']/Details", "Missing Detector description for detector " + className);
                    Element details = (Element)node;
                    String detailHTML = details.getText();
                    StringBuilder buf = new StringBuilder();
                    buf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                    buf.append("<HTML><HEAD><TITLE>Detector Description</TITLE></HEAD><BODY>\n");
                    buf.append(detailHTML);
                    buf.append("</BODY></HTML>\n");
                    factory.setDetailHTML(buf.toString());
                }
            }
            catch (ClassNotFoundException e) {
                throw new PluginException("Could not instantiate detector class: " + e, e);
            }
        }
        if ((orderingConstraintsNode = pluginDescriptor.selectSingleNode("/FindbugsPlugin/OrderingConstraints")) != null) {
            for (Element constraintElement : orderingConstraintsNode.selectNodes("./SplitPass|./WithinPass")) {
                DetectorFactorySelector earlierSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Earlier");
                DetectorFactorySelector laterSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Later");
                DetectorOrderingConstraint constraint = new DetectorOrderingConstraint(earlierSelector, laterSelector);
                constraint.setSingleSource(earlierSelector instanceof SingleDetectorFactorySelector);
                if (constraintElement.getName().equals("SplitPass")) {
                    plugin.addInterPassOrderingConstraint(constraint);
                    continue;
                }
                plugin.addIntraPassOrderingConstraint(constraint);
            }
        }
        I18N i18n = I18N.instance();
        Iterator<Object> i$2 = messageCollectionList.iterator();
        block27: while (true) {
            List categoryNodeList;
            if (i$2.hasNext()) {
                Document messageCollection = (Document)i$2.next();
                categoryNodeList = messageCollection.selectNodes("/MessageCollection/BugCategory");
                if (DEBUG) {
                    System.out.println("found " + categoryNodeList.size() + " categories in " + messageCollection.getName());
                }
            } else {
                List bugPatternNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/BugPattern");
                i$ = bugPatternNodeList.iterator();
                break;
            }
            Iterator i$3 = categoryNodeList.iterator();
            while (true) {
                BugCategory bc;
                String key;
                Node categoryNode;
                block63: {
                    if (!i$3.hasNext()) continue block27;
                    categoryNode = (Node)i$3.next();
                    key = categoryNode.valueOf("@category");
                    if (key.equals("")) {
                        throw new PluginException("BugCategory element with missing category attribute");
                    }
                    String shortDesc = PluginLoader.getChildText(categoryNode, "Description");
                    bc = new BugCategory(key, shortDesc);
                    boolean b = i18n.registerBugCategory(key, bc);
                    if (DEBUG) {
                        System.out.println(b ? "category " + key + " -> " + shortDesc : "rejected \"" + shortDesc + "\" for category " + key + ": " + i18n.getBugCategoryDescription(key));
                    }
                    if (!b) {
                        bc = i18n.getBugCategory(key);
                    }
                    try {
                        String abbrev = PluginLoader.getChildText(categoryNode, "Abbreviation");
                        if (bc.getAbbrev() == null) {
                            bc.setAbbrev(abbrev);
                            if (DEBUG) {
                                System.out.println("category " + key + " abbrev -> " + abbrev);
                            }
                            break block63;
                        }
                        if (DEBUG) {
                            System.out.println("rejected abbrev '" + abbrev + "' for category " + key + ": " + bc.getAbbrev());
                        }
                    }
                    catch (PluginException pe) {
                        if (!DEBUG) break block63;
                        System.out.println("missing Abbreviation for category " + key + "/" + shortDesc);
                    }
                }
                try {
                    String details = PluginLoader.getChildText(categoryNode, "Details");
                    if (bc.getDetailText() == null) {
                        bc.setDetailText(details);
                        if (!DEBUG) continue;
                        System.out.println("category " + key + " details -> " + details);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println("rejected details [" + details + "] for category " + key + ": [" + bc.getDetailText() + ']');
                }
                catch (PluginException pe) {}
            }
            break;
        }
        while (i$.hasNext()) {
            Node bugPatternNode = (Node)i$.next();
            String type = bugPatternNode.valueOf("@type");
            String abbrev = bugPatternNode.valueOf("@abbrev");
            String category = bugPatternNode.valueOf("@category");
            String experimental = bugPatternNode.valueOf("@experimental");
            String query = "/MessageCollection/BugPattern[@type='" + type + "']";
            Node messageNode = PluginLoader.findMessageNode(messageCollectionList, query, "messages.xml missing BugPattern element for type " + type);
            String shortDesc = PluginLoader.getChildText(messageNode, "ShortDescription");
            String longDesc = PluginLoader.getChildText(messageNode, "LongDescription");
            String detailText = PluginLoader.getChildText(messageNode, "Details");
            int cweid = 0;
            try {
                String cweString = bugPatternNode.valueOf("@cweid");
                cweid = Integer.parseInt(cweString);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            BugPattern bugPattern = new BugPattern(type, abbrev, category, Boolean.valueOf(experimental), shortDesc, longDesc, detailText, cweid);
            try {
                String deprecatedStr = bugPatternNode.valueOf("@deprecated");
                boolean deprecated = Boolean.valueOf(deprecatedStr);
                if (deprecated) {
                    bugPattern.setDeprecated(deprecated);
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            plugin.addBugPattern(bugPattern);
            boolean unknownCategory = null == i18n.getBugCategory(category);
            if (!unknownCategory) continue;
            i18n.registerBugCategory(category, new BugCategory(category, category));
            if (!DEBUG) continue;
            System.out.println("Category " + category + " (of BugPattern " + type + ") has no description in messages*.xml");
        }
        HashSet<String> definedBugCodes = new HashSet<String>();
        Iterator<Document> i$4 = messageCollectionList.iterator();
        block30: while (true) {
            if (!i$4.hasNext()) {
                Node node = pluginDescriptor.selectSingleNode("/FindbugsPlugin/EngineRegistrar");
                if (node != null) {
                    String engineClassName = node.valueOf("@class");
                    if (engineClassName == null) {
                        throw new PluginException("EngineRegistrar element with missing class attribute");
                    }
                    try {
                        Class<?> engineRegistrarClass = this.classLoader.loadClass(engineClassName);
                        if (!IAnalysisEngineRegistrar.class.isAssignableFrom(engineRegistrarClass)) {
                            throw new PluginException(engineRegistrarClass + " does not implement IAnalysisEngineRegistrar");
                        }
                        plugin.setEngineRegistrarClass(engineRegistrarClass.asSubclass(IAnalysisEngineRegistrar.class));
                    }
                    catch (ClassNotFoundException e) {
                        throw new PluginException("Could not instantiate analysis engine registrar class: " + e, e);
                    }
                }
                try {
                    URL bugRankURL = this.getResource("bugrank.txt");
                    if (bugRankURL == null && DEBUG) {
                        System.out.println("bugrank.txt not found for plugin " + pluginId);
                    }
                    BugRanker ranker = new BugRanker(bugRankURL);
                    plugin.setBugRanker(ranker);
                }
                catch (IOException e) {
                    throw new PluginException("Couldn't parse \"bugrank.txt\"", e);
                }
                this.plugin = plugin;
                return;
            }
            Document messageCollection = i$4.next();
            List bugCodeNodeList = messageCollection.selectNodes("/MessageCollection/BugCode");
            Iterator i$5 = bugCodeNodeList.iterator();
            while (true) {
                if (!i$5.hasNext()) continue block30;
                Node bugCodeNode = (Node)i$5.next();
                String abbrev = bugCodeNode.valueOf("@abbrev");
                if (abbrev.equals("")) {
                    throw new PluginException("BugCode element with missing abbrev attribute");
                }
                if (definedBugCodes.contains(abbrev)) continue;
                String description = bugCodeNode.getText();
                String query = "/FindbugsPlugin/BugCode[@abbrev='" + abbrev + "']";
                Node fbNode = pluginDescriptor.selectSingleNode(query);
                int cweid = 0;
                if (fbNode != null) {
                    try {
                        cweid = Integer.parseInt(fbNode.valueOf("@cweid"));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                BugCode bugCode = new BugCode(abbrev, description, cweid);
                plugin.addBugCode(bugCode);
                definedBugCodes.add(abbrev);
            }
            break;
        }
    }

    private static DetectorFactorySelector getConstraintSelector(Element constraintElement, Plugin plugin, String singleDetectorElementName) throws PluginException {
        boolean spanPlugins;
        Node node = constraintElement.selectSingleNode("./" + singleDetectorElementName);
        if (node != null) {
            String detectorClass = node.valueOf("@class");
            return new SingleDetectorFactorySelector(plugin, detectorClass);
        }
        node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Category");
        if (node != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String categoryName = node.valueOf("@name");
            if (!categoryName.equals("")) {
                if (categoryName.equals("reporting")) {
                    return new ReportingDetectorFactorySelector(spanPlugins ? null : plugin);
                }
                if (categoryName.equals("training")) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, TrainingDetector.class);
                }
                if (categoryName.equals("interprocedural")) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, InterproceduralFirstPassDetector.class);
                }
                throw new PluginException("Invalid category name " + categoryName + " in constraint selector node");
            }
        }
        if ((node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Subtypes")) != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String superName = node.valueOf("@super");
            if (!superName.equals("")) {
                try {
                    Class<?> superClass = Class.forName(superName);
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, superClass);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Unknown class " + superName + " in constraint selector node");
                }
            }
        }
        throw new PluginException("Invalid constraint selector node");
    }

    private String lookupDetectorClass(Plugin plugin, String name) throws PluginException {
        if (name.indexOf(46) < 0) {
            DetectorFactory factory = plugin.getFactoryByShortName(name);
            if (factory == null) {
                throw new PluginException("No detector found for short name '" + name + "'");
            }
            name = factory.getFullName();
        }
        return name;
    }

    private void addCollection(List<Document> messageCollectionList, String filename) throws PluginException {
        URL messageURL = this.getResource(filename);
        if (messageURL != null) {
            SAXReader reader = new SAXReader();
            try {
                InputStreamReader stream = new InputStreamReader(messageURL.openStream());
                Document messageCollection = reader.read(stream);
                messageCollectionList.add(messageCollection);
            }
            catch (Exception e) {
                throw new PluginException("Couldn't parse \"" + messageURL + "\"", e);
            }
        }
    }

    private static Node findMessageNode(List<Document> messageCollectionList, String xpath, String missingMsg) throws PluginException {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node;
        }
        throw new PluginException(missingMsg);
    }

    @CheckForNull
    private static Node findOptionalMessageNode(List<Document> messageCollectionList, String xpath) throws PluginException {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static String getChildText(Node node, String childName) throws PluginException {
        Node child = node.selectSingleNode(childName);
        if (child == null) {
            throw new PluginException("Could not find child \"" + childName + "\" for node");
        }
        return child.getText();
    }

    public boolean isCorePlugin() {
        return this.corePlugin;
    }
}

