/* arm.v4t-wince.pe.h
   created from arm.v4t-wince.pe.bin, 7542 (0x1d76) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2009 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2009 Laszlo Molnar
   Copyright (C) 2000-2009 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM_V4T_WINCE_PE_SIZE    7542
#define STUB_ARM_V4T_WINCE_PE_ADLER32 0xc50af55d
#define STUB_ARM_V4T_WINCE_PE_CRC32   0x99d633b4

unsigned char stub_arm_v4t_wince_pe[7542] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 132, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  26,  0, 23,  0,  1,  0, 81,227, 10,  0,  0, 26,255, 79, 45,233,
/* 0x0040 */  44, 48,143,226,224, 30,147,232,  1, 90,143,226,  0, 96,151,229,
/* 0x0050 */   1,122,135,226,  5,  0, 87,225,  2,  0,  0,154, 53, 64,143,226,
/* 0x0060 */  15,224,160,225, 20,255, 47,225,255, 79,189,232, 32,192,159,229,
/* 0x0070 */  28,255, 47,225,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0080 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0090 */   0,  0,  0,  0,  0,  0,  0,  0,  7,203,145, 70,100, 70, 16,181,
/* 0x00a0 */  11, 72,  0, 34, 11, 76, 15, 37,255, 38, 54,  6,247, 67,160, 66,
/* 0x00b0 */  18,208,  3,104, 25, 14, 41, 64, 11, 41,  5,209, 25, 28, 49, 64,
/* 0x00c0 */ 155, 26, 59, 64, 11, 67,  3, 96,  4, 48,  1, 50,239,231,  0,  0,
/* 0x00d0 */   0,  0,  0,  0,  0,  0,  0,  0, 14, 72, 74, 70, 17, 31,  3,120,
/* 0x00e0 */   1, 48,  0, 43, 24,208,240, 43,  8,211, 15, 36, 28, 64, 67,120,
/* 0x00f0 */  36,  2,228, 24,  3,120,  2, 48, 36,  2, 27, 25,201, 24,  0, 37,
/* 0x0100 */  75, 93, 36,  2,228, 24,  1, 53,  4, 45,249,209,164, 24, 12, 96,
/* 0x0110 */ 229,231,  0,  0,  0,  0,  0,  0,111, 70,255,176,255,176,255,176,
/* 0x0120 */ 255,176, 27, 76, 32, 28,  0,240, 48,248, 53,208, 25, 73, 64, 24,
/* 0x0130 */ 105, 70,  2,120,  1, 48, 10,128,  2, 49,  0, 42,249,209,104, 70,
/* 0x0140 */   0,240, 56,248,  6, 28, 32, 29,  0,240, 48,248, 77, 70, 45, 24,
/* 0x0150 */   8, 52, 32,120,  1, 52,  1, 40,228,212,  5,209, 33, 28, 32,120,
/* 0x0160 */   1, 52,  0, 40,251,209,  4,224, 32,120, 97,120,  2, 52,  9,  2,
/* 0x0170 */   9, 24, 48, 28,  0,240, 57,248,  1,197,234,231,  3, 33, 67, 92,
/* 0x0180 */  18,  2,210, 24,  1, 57,250,213, 16, 28,112, 71, 80, 71, 88, 71,
/* 0x0190 */   0,  0,  0,  0,  0,  0,  0,  0,189, 70,  6,188,  4, 32,150, 70,
/* 0x01a0 */   8, 71, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,
/* 0x01b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x01c0 */   0, 45,  9, 24,254,181,  1, 36,101, 66,228,  7, 13, 39, 63,  2,
/* 0x01d0 */  15,224, 26,188, 64, 26,210, 26, 34, 96,240,188,  2,188,  8, 71,
/* 0x01e0 */   4,120,100, 65,  1, 48, 36,  6,247, 70,  3,120,  1, 48, 19,112,
/* 0x01f0 */   1, 50, 36, 25,254, 70,243,208,247,210,  1, 33, 36, 25,254, 70,
/* 0x0200 */ 238,208, 73, 65, 36, 25,254, 70,234,208,247,211,203, 30,  0, 33,
/* 0x0210 */   5,211, 27,  2,  5,120,  1, 48, 29, 67,237, 67,217,208, 36, 25,
/* 0x0220 */ 254, 70,221,208, 73, 65, 36, 25,254, 70,217,208, 73, 65,  9,209,
/* 0x0230 */   1, 33, 36, 25,254, 70,211,208, 73, 65, 36, 25,254, 70,207,208,
/* 0x0240 */ 247,211,  2, 49,  1, 49,253, 66,  0,210,  1, 49, 19,120, 83, 93,
/* 0x0250 */  19,112,  1, 50,  1, 57,250,209,203,231,255,247,254,255,252,181,
/* 0x0260 */  15, 24,  1, 36,101, 66,228,  7,  5, 38, 54,  2, 15,224, 24,188,
/* 0x0270 */ 192, 27,210, 26, 34, 96,240,188,  2,188,  8, 71,  4,120,100, 65,
/* 0x0280 */   1, 48, 36,  6,247, 70,  3,120,  1, 48, 19,112,  1, 50, 36, 25,
/* 0x0290 */ 254, 70,243,208,247,210,  1, 33,  4,224,  1, 57, 36, 25,254, 70,
/* 0x02a0 */ 236,208, 73, 65, 36, 25,254, 70,232,208, 73, 65, 36, 25,254, 70,
/* 0x02b0 */ 228,208,242,211,203, 30,  0, 33,  8,211, 27,  2,  5,120,  1, 48,
/* 0x02c0 */  29, 67,237, 67,211,208,109, 16, 19,210,  3,224, 36, 25,254, 70,
/* 0x02d0 */ 212,208, 14,210,  1, 33, 36, 25,254, 70,207,208,  9,210, 36, 25,
/* 0x02e0 */ 254, 70,203,208, 73, 65, 36, 25,254, 70,199,208,247,211,  4, 49,
/* 0x02f0 */   4,224, 36, 25,254, 70,193,208, 73, 65,  2, 49,238, 66,  0,210,
/* 0x0300 */   1, 49, 19,120, 83, 93, 19,112,  1, 50,  1, 57,250,209,190,231,
/* 0x0310 */ 255,247,254,255,  8,167,120,207,111, 70,108, 68,  0, 33,  2,180,
/* 0x0320 */ 165, 69,252,209, 28,180, 35, 29, 42, 28,129, 28, 24, 29,  6, 96,
/* 0x0330 */ 255,247,254,255,189, 70,  7,224,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0340 */   0,  0,  0,  0,  0,  0,  0,  0,240,181,159,176,  4,145,  1, 29,
/* 0x0350 */   6,145,  3,147, 21, 28,131,120,  1, 34, 17, 28,153, 64, 11, 28,
/* 0x0360 */   1, 59,  8,147, 67,120,154, 64,  1, 58,  9,146,  2,120,  3,153,
/* 0x0370 */  10,146, 38,154,  0, 35, 11, 96, 19, 96, 10,155, 66,120,154, 24,
/* 0x0380 */ 192, 35,204, 72,155,  0,147, 64,  6,154, 28, 24,  0, 32,  4,224,
/* 0x0390 */ 128, 35,219,  0, 19,128,  1, 48,  2, 50,160, 66,248,209,  4,153,
/* 0x03a0 */  77, 25, 16,149,  0, 39, 13, 28,  0, 32, 16,154,  4,153, 83, 26,
/* 0x03b0 */ 152, 66,  0,209,115,227, 43,120, 58,  2, 23, 28,  1, 48, 31, 67,
/* 0x03c0 */   1, 53,  5, 40,241,209,  0, 34,  1, 33,  1, 35,148, 70, 73, 66,
/* 0x03d0 */   7,146, 11,146, 30,147, 12,147, 13,147, 14,147, 74,227,182, 72,
/* 0x03e0 */ 129, 66,  9,216, 16,154,149, 66,  0,209, 88,227, 43,120, 58,  2,
/* 0x03f0 */  23, 28,  9,  2, 31, 67,  1, 53,  8,152,  7,155, 11,154,  3, 64,
/* 0x0400 */  18,  1, 17,147,  6,152,155, 24, 91,  0,196, 24,  5,146, 34,136,
/* 0x0410 */ 203, 10, 22, 28, 94, 67,183, 66,  0,211,174,224,128, 35, 27,  1,
/* 0x0420 */ 155, 26, 91, 17,211, 24,  9,153,  7,154, 35,128, 10,155, 10, 64,
/* 0x0430 */  10,152,154, 64,  8, 35, 27, 26, 97, 70, 25, 65, 82, 24, 83,  0,
/* 0x0440 */ 155, 24,  6,154, 91,  2,157, 72,211, 24, 11,153, 24, 24, 28,144,
/* 0x0450 */   6, 41,  3,220,  1, 34, 49, 28, 18,146,114,224, 30,153,  7,152,
/* 0x0460 */  36,154, 67, 26,211, 92, 19,147,  1, 35, 18,147, 49, 28,146, 75,
/* 0x0470 */ 153, 66,  9,216, 16,152,133, 66,  0,209, 16,227, 43,120, 58,  2,
/* 0x0480 */  23, 28,  9,  2, 31, 67,  1, 53, 19,154,128, 35, 82,  0, 91,  0,
/* 0x0490 */  22, 28, 28,152, 19,146, 30, 64, 18,154,115,  0, 82,  0,195, 24,
/* 0x04a0 */ 128, 32,155, 24,128,  0, 28, 24,  1,146, 34,136,203, 10, 16, 28,
/* 0x04b0 */  88, 67,135, 66, 11,210,128, 35, 27,  1,155, 26, 91, 17,  1,153,
/* 0x04c0 */ 211, 24, 35,128, 18,145,  0, 46, 47,209,  1, 28, 11,224, 83,  9,
/* 0x04d0 */ 211, 26, 35,128, 18,155, 18,154,  1, 51,210, 24,  9, 26, 63, 26,
/* 0x04e0 */  18,146,  0, 46, 45,208, 18,155,255, 43, 45,220,191,231,114, 75,
/* 0x04f0 */ 153, 66,  9,216, 16,152,133, 66,  0,209,208,226, 43,120, 58,  2,
/* 0x0500 */  23, 28,  9,  2, 31, 67,  1, 53, 18,154, 28,155, 86,  0,156, 25,
/* 0x0510 */  34,136,203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,
/* 0x0520 */ 155, 26, 91, 17,211, 24, 35,128, 18,150,  1, 28,  9,224, 83,  9,
/* 0x0530 */ 211, 26, 35,128, 18,155,  9, 26, 63, 26, 18,152,  1, 51,192, 24,
/* 0x0540 */  18,144, 18,154,255, 42,210,221, 18,152,  3,  6, 27, 14, 24, 28,
/* 0x0550 */  36,154,156, 70,  7,155,208, 84, 26, 28, 11,155,  1, 50,  3, 43,
/* 0x0560 */   1,220,  0, 32,  7,224, 11,155,  9, 43,  2,220,  3, 59, 11,147,
/* 0x0570 */ 127,226, 11,152,  6, 56, 11,144,123,226,136, 27, 83,  9, 78, 73,
/* 0x0580 */ 211, 26,191, 27, 35,128,136, 66,  9,216, 16,154,149, 66,  0,209,
/* 0x0590 */ 133,226, 43,120, 58,  2, 23, 28,  0,  2, 31, 67,  1, 53, 11,153,
/* 0x05a0 */   6,154, 75,  0,210, 24,192, 38,148, 70,118,  0,102, 68, 50,136,
/* 0x05b0 */ 195, 10, 17, 28, 89, 67,143, 66, 24,210,128, 35, 27,  1,155, 26,
/* 0x05c0 */  91, 17,211, 24, 51,128, 11,155,  6, 43,  2,220,  0, 32, 11,144,
/* 0x05d0 */   1,224,  3, 34, 11,146,  6,155, 57, 72, 30, 24, 30,152, 13,154,
/* 0x05e0 */  12,155, 12,144,  8, 28, 14,146, 13,147,209,224, 68, 26,127, 26,
/* 0x05f0 */  83,  9, 49, 73,211, 26, 51,128,140, 66,  9,216, 16,154,149, 66,
/* 0x0600 */   0,209, 76,226, 43,120, 58,  2, 23, 28, 36,  2, 31, 67,  1, 53,
/* 0x0610 */ 204, 38,118,  0,102, 68, 48,136,227, 10,  2, 28, 90, 67,151, 66,
/* 0x0620 */  80,210,128, 35, 27,  1, 27, 26, 91, 17,195, 24, 51,128, 34, 75,
/* 0x0630 */ 154, 66,  1,217, 16, 28,  9,224, 16,152,133, 66,  0,209, 46,226,
/* 0x0640 */  43,120, 16,  2, 58,  2, 23, 28, 31, 67,  1, 53,  5,153,  6,154,
/* 0x0650 */  75,  0, 17,153,211, 24, 74,  0,155, 24,240, 34, 82,  0,156, 24,
/* 0x0660 */  34,136,195, 10, 22, 28, 94, 67,183, 66, 28,210,128, 35, 27,  1,
/* 0x0670 */ 155, 26, 91, 17,211, 24, 35,128,  7,155,  0, 43,  0,209, 14,226,
/* 0x0680 */  11,152,  6, 40,  2,220,  9, 33, 11,145,  1,224, 11, 34, 11,146,
/* 0x0690 */   7,152, 30,153, 36,154, 67, 26,211, 92, 19, 84,  2, 28,156, 70,
/* 0x06a0 */   1, 50, 49, 28,229,225, 83,  9,211, 26,128, 27,191, 27, 35,128,
/* 0x06b0 */  99,224,  0,  0, 54,  7,  0,  0,255,255,255,  0,108, 14,  0,  0,
/* 0x06c0 */ 100,  6,  0,  0, 67,  9,195, 26,213, 72,164, 26,191, 26, 51,128,
/* 0x06d0 */ 132, 66,  9,216, 16,153,141, 66,  0,209,224,225, 43,120, 58,  2,
/* 0x06e0 */  23, 28, 36,  2, 31, 67,  1, 53,216, 38,118,  0,102, 68, 50,136,
/* 0x06f0 */ 227, 10, 16, 28, 88, 67,135, 66,  9,210,128, 35, 27,  1,155, 26,
/* 0x0700 */  91, 17,211, 24, 51,128, 12,154, 30,155, 12,147, 52,224, 33, 26,
/* 0x0710 */  63, 26, 83,  9,194, 72,211, 26, 51,128,129, 66,  9,216, 16,154,
/* 0x0720 */ 149, 66,  0,209,187,225, 43,120, 58,  2, 23, 28,  9,  2, 31, 67,
/* 0x0730 */   1, 53,228, 38,118,  0,102, 68, 50,136,203, 10, 20, 28, 92, 67,
/* 0x0740 */ 167, 66, 13,210,128, 35, 27,  1,155, 26, 91, 17,211, 24, 30,152,
/* 0x0750 */  13,154, 51,128, 12,155, 12,144, 32, 28, 13,147, 30,146, 12,224,
/* 0x0760 */  83,  9,  8, 27, 13,153,211, 26, 51,128, 14,154, 12,155, 14,145,
/* 0x0770 */  30,153, 13,147, 12,145, 63, 27, 30,146, 11,154,  6, 42,  2,220,
/* 0x0780 */   8, 35, 11,147,  1,224, 11, 33, 11,145,  6,154,165, 75,214, 24,
/* 0x0790 */ 163, 73,140, 70, 96, 69,  9,216, 16,154,149, 66,  0,209,126,225,
/* 0x07a0 */  43,120, 58,  2, 23, 28,  0,  2, 31, 67,  1, 53, 50,136,195, 10,
/* 0x07b0 */  17, 28, 89, 67,143, 66, 15,210,128, 35, 27,  1,155, 26, 91, 17,
/* 0x07c0 */  17,152,211, 24, 51,128,  3,  1,243, 24,  4, 51, 22,147,  3, 34,
/* 0x07d0 */   0, 35, 20,146, 21,147, 53,224, 83,  9,211, 26, 68, 26,127, 26,
/* 0x07e0 */  51,128,100, 69,  9,216, 16,152,133, 66,  0,209, 87,225, 43,120,
/* 0x07f0 */  58,  2, 23, 28, 36,  2, 31, 67,  1, 53,114,136,227, 10, 16, 28,
/* 0x0800 */  88, 67,135, 66, 17,210,128, 35, 27,  1,155, 26, 17,153, 91, 17,
/* 0x0810 */ 211, 24,115,128,130, 34, 11,  1,243, 24, 82,  0,154, 24,  1, 28,
/* 0x0820 */   3, 35,  8, 32, 22,146, 20,147, 11,224, 83,  9,211, 26,129, 34,
/* 0x0830 */ 146,  0,115,128,178, 24,  8, 35, 22,146, 20,147, 33, 26, 63, 26,
/* 0x0840 */  16, 32, 21,144, 20,154,  1, 35, 15,147,148, 70,116, 75,153, 66,
/* 0x0850 */   9,216, 16,152,133, 66,  0,209, 33,225, 43,120, 58,  2, 23, 28,
/* 0x0860 */   9,  2, 31, 67,  1, 53, 15,154, 22,155, 86,  0,156, 25, 34,136,
/* 0x0870 */ 203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,155, 26,
/* 0x0880 */  91, 17,211, 24,  1, 28, 35,128, 15,150,  9,224, 83,  9,211, 26,
/* 0x0890 */  35,128, 15,155,  9, 26, 63, 26, 15,152,  1, 51,192, 24, 15,144,
/* 0x08a0 */   1, 34, 82, 66,148, 68, 99, 70,  0, 43,207,209, 20,152, 15,154,
/* 0x08b0 */   1, 35,131, 64, 21,152,211, 26, 11,154, 27, 24, 29,147,  3, 42,
/* 0x08c0 */   0,221,189,224,  3, 43,  0,221,  3, 35,  6,152,219,  1,216, 34,
/* 0x08d0 */ 195, 24,146,  0,154, 24,  6, 35, 27,146, 23,147,  1, 38, 80, 75,
/* 0x08e0 */ 153, 66,  9,216, 16,152,133, 66,  0,209,216,224, 43,120, 58,  2,
/* 0x08f0 */  23, 28,  9,  2, 31, 67,  1, 53,114,  0, 27,156,148, 70,100, 68,
/* 0x0900 */  34,136,203, 10, 16, 28, 88, 67,135, 66,  8,210,128, 35, 27,  1,
/* 0x0910 */ 155, 26, 91, 17,211, 24,102, 70,  1, 28, 35,128,  6,224, 83,  9,
/* 0x0920 */ 211, 26, 35,128,115, 28,  9, 26, 63, 26,246, 24, 23,155,  1, 59,
/* 0x0930 */  23,147,  0, 43,211,209, 48, 28, 64, 56,  3, 40,120,221, 70, 16,
/* 0x0940 */ 114, 30,  1, 35,148, 70,  2, 28, 26, 64, 20, 28,  2, 35, 28, 67,
/* 0x0950 */  13, 40, 11,220, 99, 70, 38, 28,  6,154,158, 64,115,  0,211, 24,
/* 0x0960 */  66,  0, 49, 72,155, 26, 24, 24, 26,144, 31,224,  5, 62,  0, 32,
/* 0x0970 */  43, 75,153, 66,  9,216, 16,154,149, 66,  0,209,143,224, 43,120,
/* 0x0980 */  58,  2, 23, 28,  9,  2, 31, 67,  1, 53, 73,  8,100,  0,143, 66,
/* 0x0990 */   2,211,  1, 35,127, 26, 28, 67,  1, 48,176, 66,232,209, 35, 72,
/* 0x09a0 */   6,155, 24, 24,  4, 34, 26,144, 38,  1,148, 70,  1, 35, 24,147,
/* 0x09b0 */  25,147, 27, 75,153, 66,  8,216, 16,152,133, 66,111,208, 43,120,
/* 0x09c0 */  58,  2, 23, 28,  9,  2, 31, 67,  1, 53, 25,154, 26,155, 82,  0,
/* 0x09d0 */ 156, 24,  2,146, 34,136,203, 10, 16, 28, 88, 67,135, 66,  9,210,
/* 0x09e0 */ 128, 35, 27,  1,  2,153,155, 26, 91, 17,211, 24, 25,145,  1, 28,
/* 0x09f0 */  35,128, 11,224, 83,  9,211, 26, 35,128, 25,155, 25,154,  1, 51,
/* 0x0a00 */ 210, 24, 24,155, 25,146,  9, 26, 63, 26, 30, 67,  1, 32, 64, 66,
/* 0x0a10 */ 132, 68, 98, 70,  0, 42, 12,208, 24,155, 91,  0, 24,147,200,231,
/* 0x0a20 */ 255,255,255,  0,104, 10,  0,  0, 94,  5,  0,  0, 68,  6,  0,  0,
/* 0x0a30 */   6, 28,  1, 54, 30,150,  0, 46, 33,208, 11,152,  7, 48, 11,144,
/* 0x0a40 */  30,154,  7,155,154, 66, 42,216,155, 26, 36,152, 29,158,  7,154,
/* 0x0a50 */ 196, 24,  2, 54,128, 24, 35,120,  3,112,156, 70,  7,155,  1, 50,
/* 0x0a60 */ 155, 25,  0,147,154, 66,  4,208, 37,155,  1, 52,  1, 48,154, 66,
/* 0x0a70 */ 241,209,  7,146,  7,152, 37,154,144, 66,  0,210,175,228,  9, 75,
/* 0x0a80 */ 153, 66,  3,216, 16,155,157, 66,  9,208,  1, 53,  4,152,  3,153,
/* 0x0a90 */  43, 26, 11, 96,  7,154, 38,155,  0, 32, 26, 96,  0,224,  1, 32,
/* 0x0aa0 */  31,176,240,189,255,255,255,  0,102,105,108,101, 32,102,111,114,
/* 0x0ab0 */ 109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101,
/* 0x0ac0 */  97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x0ad0 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0ae0 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x0af0 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x0b00 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x0b10 */ 108, 97,103,115, 10, 32, 32, 48, 32, 68,108,108, 83,116, 97,114,
/* 0x0b20 */ 116, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x0b30 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0b40 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50,
/* 0x0b50 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0b60 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x0b70 */  32, 49, 32, 69,120,101, 83,116, 97,114,116, 32, 32, 32, 32, 32,
/* 0x0b80 */  32, 48, 48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48, 48, 48,
/* 0x0b90 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0ba0 */  48, 48, 48, 48, 48, 51, 99, 32, 32, 50, 42, 42, 49, 32, 32, 67,
/* 0x0bb0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x0bc0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 85,110,102,
/* 0x0bd0 */ 105,108,116,101,114, 95, 48,120, 53, 48, 32, 48, 48, 48, 48, 48,
/* 0x0be0 */  48, 51, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0bf0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97,
/* 0x0c00 */  48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0c10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x0c20 */  76, 89, 10, 32, 32, 51, 32, 82,101,108,111, 99,115, 32, 32, 32,
/* 0x0c30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 48,
/* 0x0c40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c50 */  48, 32, 32, 48, 48, 48, 48, 48, 48,100, 56, 32, 32, 50, 42, 42,
/* 0x0c60 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x0c70 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52,
/* 0x0c80 */  32, 73,109,112,111,114,116,115, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x0c90 */  48, 48, 48, 48, 48, 56, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ca0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0cb0 */  48, 48, 49, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x0cc0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x0cd0 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 80,114,111, 99,101,
/* 0x0ce0 */ 115,115, 69,110,100, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0cf0 */  56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0d00 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 57, 97, 32,
/* 0x0d10 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x0d20 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 85, 80,
/* 0x0d30 */  88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x0d40 */  48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0d50 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x0d60 */  97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0d70 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55,
/* 0x0d80 */  32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,
/* 0x0d90 */ 109,112,114,101,115,115, 95, 56, 32, 48, 48, 48, 48, 48, 48, 57,
/* 0x0da0 */  56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0db0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99, 50, 32,
/* 0x0dc0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x0dd0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 67, 97,
/* 0x0de0 */ 108,108, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x0df0 */  48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0e00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x0e10 */  53, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0e20 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x0e30 */  78, 76, 89, 10, 32, 32, 57, 32, 46,117, 99,108, 95,110,114,118,
/* 0x0e40 */  50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 32,
/* 0x0e50 */  48, 48, 48, 48, 48, 48, 98, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0e60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0e70 */  48, 48, 48, 50, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x0e80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x0e90 */  10, 32, 49, 48, 32, 67, 97,108,108, 50, 69, 32, 32, 32, 32, 32,
/* 0x0ea0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x0eb0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0ec0 */  32, 48, 48, 48, 48, 48, 51, 49, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x0ed0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x0ee0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 67,
/* 0x0ef0 */  97,108,108, 76, 90, 77, 65, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x0f00 */  48, 48, 48, 51, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0f10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0f20 */  51, 49, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69,
/* 0x0f30 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x0f40 */  79, 78, 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x0f50 */  67, 79, 68, 69, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0f60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0f70 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52, 56, 32, 32, 50,
/* 0x0f80 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0f90 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 77, 65,
/* 0x0fa0 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 55,
/* 0x0fb0 */  54, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0fc0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52, 56,
/* 0x0fd0 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0fe0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79,
/* 0x0ff0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1000 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,120,101, 83,116, 97,
/* 0x1010 */ 114,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69,120,101, 83,
/* 0x1020 */ 116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1030 */  32, 32, 32, 32, 32, 32, 73,109,112,111,114,116,115,  9, 48, 48,
/* 0x1040 */  48, 48, 48, 48, 48, 48, 32, 46,114,101, 97,108, 95,115,116, 97,
/* 0x1050 */ 114,116, 95,111,102, 73,109,112,111,114,116,115, 10, 48, 48, 48,
/* 0x1060 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 46,117,
/* 0x1070 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x1080 */ 101,115,115, 95, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 46,
/* 0x1090 */ 117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,
/* 0x10a0 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x10b0 */ 108, 32, 32, 32, 32,100, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x10c0 */  50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,  9,
/* 0x10d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 46,117, 99,108, 95,110,114,
/* 0x10e0 */ 118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x10f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32, 32,
/* 0x1100 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69,  9, 48, 48,
/* 0x1110 */  48, 48, 48, 48, 48, 48, 32, 46,114,101, 97,108, 95,115,116, 97,
/* 0x1120 */ 114,116, 95,111,102, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69,
/* 0x1130 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1140 */  32, 32, 68,108,108, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48,
/* 0x1150 */  48, 48, 48, 32, 68,108,108, 83,116, 97,114,116, 10, 48, 48, 48,
/* 0x1160 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85,110,
/* 0x1170 */ 102,105,108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48, 48, 48,
/* 0x1180 */  48, 48, 48, 48, 32, 85,110,102,105,108,116,101,114, 95, 48,120,
/* 0x1190 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x11a0 */  32,100, 32, 32, 82,101,108,111, 99,115,  9, 48, 48, 48, 48, 48,
/* 0x11b0 */  48, 48, 48, 32, 82,101,108,111, 99,115, 10, 48, 48, 48, 48, 48,
/* 0x11c0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 73,109,112,111,
/* 0x11d0 */ 114,116,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 73,109,112,
/* 0x11e0 */ 111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x11f0 */  32, 32, 32,100, 32, 32, 80,114,111, 99,101,115,115, 69,110,100,
/* 0x1200 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80,114,111, 99,101,115,
/* 0x1210 */ 115, 69,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1220 */  32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48,
/* 0x1230 */  48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68,
/* 0x1240 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1250 */  32, 32, 67, 97,108,108, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1260 */  48, 32, 67, 97,108,108, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1270 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 97,108,108, 50, 69,
/* 0x1280 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 97,108,108, 50, 69,
/* 0x1290 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x12a0 */  32, 32, 67, 97,108,108, 76, 90, 77, 65,  9, 48, 48, 48, 48, 48,
/* 0x12b0 */  48, 48, 48, 32, 67, 97,108,108, 76, 90, 77, 65, 10, 48, 48, 48,
/* 0x12c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x12d0 */  77, 65, 95, 68, 69, 67, 79, 68, 69,  9, 48, 48, 48, 48, 48, 48,
/* 0x12e0 */  48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10, 48,
/* 0x12f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1300 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x1310 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x1320 */  48, 48, 48, 48, 48, 51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1330 */  69,120,101, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1340 */  48, 32, 83, 82, 67, 48, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,
/* 0x1350 */ 103, 32, 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116,
/* 0x1360 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 68, 83, 84, 48, 10, 48,
/* 0x1370 */  48, 48, 48, 48, 48, 52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1380 */  69,120,101, 83,116, 97,114,116,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1390 */  48, 32, 73, 65, 84, 84, 10, 48, 48, 48, 48, 48, 48, 53, 56, 32,
/* 0x13a0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116,
/* 0x13b0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 78, 84, 82, 10, 48,
/* 0x13c0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13d0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,
/* 0x13e0 */ 116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,
/* 0x13f0 */ 101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1400 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x1410 */  48, 48, 32, 99,111,109,112,114,101,115,115,101,100, 95,108,101,
/* 0x1420 */ 110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x1430 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x1440 */  48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,110,
/* 0x1450 */  99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48,
/* 0x1460 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x1470 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,117,110, 99,111,109,
/* 0x1480 */ 112,114,101,115,115,101,100, 95,108,101,110,103,116,104, 10, 48,
/* 0x1490 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x14a0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,
/* 0x14b0 */ 114,105,103,105,110, 97,108, 95,101,110,116,114,121, 10, 48, 48,
/* 0x14c0 */  48, 48, 48, 48, 51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x14d0 */ 110,102,105,108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48, 48,
/* 0x14e0 */  48, 48, 48, 48, 48, 32, 70, 73, 66, 83, 10, 48, 48, 48, 48, 48,
/* 0x14f0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x1500 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,
/* 0x1510 */ 114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 48,
/* 0x1520 */  48, 48, 48, 48, 48, 51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1530 */  85,110,102,105,108,116,101,114, 95, 48,120, 53, 48,  9, 48, 48,
/* 0x1540 */  48, 48, 48, 48, 48, 48, 32, 70, 73, 66, 69, 10, 48, 48, 48, 48,
/* 0x1550 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x1560 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,
/* 0x1570 */ 101,114, 95, 98,117,102,102,101,114, 95,101,110,100, 10, 48, 48,
/* 0x1580 */  48, 48, 48, 48, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 82,
/* 0x1590 */ 101,108,111, 99,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 66,
/* 0x15a0 */  82, 69, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x15b0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x15c0 */  48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,114,101,108,
/* 0x15d0 */ 111, 99,115, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32,103, 32, 32,
/* 0x15e0 */  32, 32, 32, 32, 32, 73,109,112,111,114,116,115,  9, 48, 48, 48,
/* 0x15f0 */  48, 48, 48, 48, 48, 32, 66, 73, 77, 80, 10, 48, 48, 48, 48, 48,
/* 0x1600 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x1610 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116,
/* 0x1620 */  95,111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48,
/* 0x1630 */  48, 48, 55, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 73,109,112,
/* 0x1640 */ 111,114,116,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 79, 78,
/* 0x1650 */  65, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1660 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x1670 */  48, 48, 32,115,116, 97,114,116, 95,111,102, 95,100,108,108, 95,
/* 0x1680 */ 110, 97,109,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1690 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x16a0 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110,
/* 0x16b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x16c0 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16d0 */  32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,
/* 0x16e0 */ 115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x16f0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x1700 */  48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,
/* 0x1710 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x1720 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,
/* 0x1730 */ 109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82,
/* 0x1740 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x1750 */  83, 32, 70, 79, 82, 32, 91, 68,108,108, 83,116, 97,114,116, 93,
/* 0x1760 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1770 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1780 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82,
/* 0x1790 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,120,
/* 0x17a0 */ 101, 83,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x17b0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x17c0 */  69,120,101, 83,116, 97,114,116, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x17d0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x17e0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x17f0 */  48, 48, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1800 */  32, 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116, 10,
/* 0x1810 */  48, 48, 48, 48, 48, 48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1820 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,
/* 0x1830 */  95,111,102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 48,
/* 0x1840 */  48, 48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66,
/* 0x1850 */  83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,
/* 0x1860 */ 115,115,101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,
/* 0x1870 */  48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,
/* 0x1880 */  32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,
/* 0x1890 */ 117,110, 99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48,
/* 0x18a0 */  48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,
/* 0x18b0 */  50, 32, 32, 32, 32, 32, 32, 32,117,110, 99,111,109,112,114,101,
/* 0x18c0 */ 115,115,101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,
/* 0x18d0 */  48, 48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,
/* 0x18e0 */  32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108, 95,
/* 0x18f0 */ 101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1900 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,
/* 0x1910 */ 110,102,105,108,116,101,114, 95, 48,120, 53, 48, 93, 58, 10, 79,
/* 0x1920 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1930 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1940 */  48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1950 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,
/* 0x1960 */ 114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 48,
/* 0x1970 */  48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66,
/* 0x1980 */  83, 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x1990 */  95, 98,117,102,102,101,114, 95,101,110,100, 10, 10, 82, 69, 76,
/* 0x19a0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x19b0 */  70, 79, 82, 32, 91, 82,101,108,111, 99,115, 93, 58, 10, 79, 70,
/* 0x19c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x19d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x19e0 */  48, 48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66,
/* 0x19f0 */  83, 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,
/* 0x1a00 */ 111,102, 95,114,101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x1a10 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1a20 */  82, 32, 91, 73,109,112,111,114,116,115, 93, 58, 10, 79, 70, 70,
/* 0x1a30 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1a40 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1a50 */  48, 48, 48, 48, 48,101, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77,
/* 0x1a60 */  95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,
/* 0x1a70 */ 116, 97,114,116, 95,111,102, 73,109,112,111,114,116,115, 10, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 84, 72,
/* 0x1a90 */  77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,
/* 0x1aa0 */ 115,116, 97,114,116, 95,111,102, 73,109,112,111,114,116,115, 10,
/* 0x1ab0 */  48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 84,
/* 0x1ac0 */  72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108,
/* 0x1ad0 */  95,115,116, 97,114,116, 95,111,102, 73,109,112,111,114,116,115,
/* 0x1ae0 */  10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1af0 */  84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,
/* 0x1b00 */ 108, 95,115,116, 97,114,116, 95,111,102, 73,109,112,111,114,116,
/* 0x1b10 */ 115, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x1b20 */  95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,
/* 0x1b30 */ 114,116, 95,111,102, 95,105,109,112,111,114,116,115, 10, 48, 48,
/* 0x1b40 */  48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,
/* 0x1b50 */  51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x1b60 */ 102, 95,100,108,108, 95,110, 97,109,101,115, 10, 10, 82, 69, 76,
/* 0x1b70 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x1b80 */  70, 79, 82, 32, 91, 67, 97,108,108, 50, 66, 93, 58, 10, 79, 70,
/* 0x1b90 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1bb0 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 84, 72,
/* 0x1bc0 */  77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,117, 99,108, 95,110,
/* 0x1bd0 */ 114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x1be0 */  56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1bf0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 97,108,108, 50,
/* 0x1c00 */  69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x1c10 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1c20 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,
/* 0x1c30 */  65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32,
/* 0x1c40 */  46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,
/* 0x1c50 */ 112,114,101,115,115, 95, 56, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1c60 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1c70 */  91, 67, 97,108,108, 76, 90, 77, 65, 93, 58, 10, 79, 70, 70, 83,
/* 0x1c80 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c90 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1ca0 */  48, 48, 48, 49, 99, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95,
/* 0x1cb0 */  67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116,
/* 0x1cc0 */  97,114,116, 95,111,102, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68,
/* 0x1cd0 */  69, 10, 48, 48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77,
/* 0x1ce0 */  95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x1cf0 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 56,
/* 0x1d00 */  32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32,
/* 0x1d10 */  32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,
/* 0x1d20 */ 106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95,
/* 0x1d30 */  65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d40 */ 108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48,
/* 0x1d50 */  48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32,
/* 0x1d60 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,
/* 0x1d70 */ 114,116,105,101,115, 10
};
