/*
	̓NX@`scanner.h + scanner.cpp`
*/
#ifndef	__SCANNER_H
#define	__SCANNER_H

#pragma warning(disable:4786)

#include <stdio.h>
#include <stdlib.h>
#include <iostream>

#include <string>
#include <list>
#include <map>
#include <stack>

using namespace std;

#include "macro.h"
#include "module.h"
#include "tokendef.h"

class ScannerSub{
	int		nLine;					// ݏĂsԍ
	Module	Mdl;					// ݏĂt@C
	FILE*	lpLogFP;				// G[bZ[Wo͗pt@C|C^
	char	linebuf[1024];			// ݏĂs̃obt@
	LPSTR	lpPos;					// ݏĂs̒̈ʒu
	Token	token;					// g[N̎
	char	labelbuf[256];			// tokenTK_LABEL̎̃obt@
	LONG	numbuf;					// tokenTK_NUM̎̃obt@
	bool	bPeeked;				// łPeekToken()Ńg[N𓾂Ă邩
	int		nErrorCount;			// ̃\[XŋNG[̐

	void	Init(void);				// obt@̏
	HRESULT	ReadLine(void);			// Psǂݍ
	bool	IsToken(LPSTR &lp,LPSTR lp2);	// vĂlp1g[N̏I܂Ői߂
	void	CopyLabel(LPSTR& lpPos);		// lpPos玟̃g[N܂ŃRs[
	HRESULT	NumCheck(LPSTR& lpPos);			// ׂĐlȂnumbufɁBłȂΖ߂lF0
	void	GetQuotedLabel(LPSTR &lpPos);	// px𓾂
	Token	PeekToken2(void);				// PeekToken()̖{
	void	Error(LPSTR str);				// G[bZ[W\

  public:
	ScannerSub(){ lpLogFP=stderr; nErrorCount=0; Init(); }
	~ScannerSub(){}

#ifdef WINVC
	HRESULT	ReadFile(string& filename);// t@Cǂݍ
#else
	HRESULT	ReadFile(string filename);// t@Cǂݍ
#endif
	
	Token	GetToken(void);			// token𓾂iǂݍ݃|C^i߂j
	Token	PeekToken(void){ token=PeekToken2(); return token; }
									// token𓾂iǂݍ݃|C^i߂Ȃj
	LPSTR	GetLabel(void){ return labelbuf; }	// tokenTK_LABEL̎Ãx
	LONG	GetNum(void){ return numbuf; }		// tokenTK_NUM̎A̐l

	int		GetScanline(void){ return nLine; }
	string	GetFileName(void){ return Mdl.GetFileName(); }
	void	SetLogFile(FILE* fp){ lpLogFP = fp; }
	int		GetErrorCount(void){ return nErrorCount; }
};

typedef stack<ScannerSub*> StacklpScannerSub;

class Scanner{
	StacklpScannerSub files;
	int		nIncludeNest;			// CN[h̃lXgBȂ̎ 0
	FILE*	lpLogFP;				// G[bZ[Wo͗pt@C|C^
	int		nErrorCount;			// ͕ŋNG[̐

  public:
	Scanner(){ lpLogFP=stderr; nIncludeNest=0; nErrorCount=0; }
	~Scanner(){ while(!files.empty()){ DELETE_SAFE(files.top()); files.pop(); } }

#ifdef WINVC
	HRESULT	ReadFile(string& filename);// t@Cǂݍ
#else
	HRESULT	ReadFile(string filename);// t@Cǂݍ
#endif

	Token	GetToken(void);		// token𓾂iǂݍ݃|C^i߂j
	Token	PeekToken(void);	// token𓾂iǂݍ݃|C^i߂Ȃj
	LPSTR	GetLabel(void){ return files.top()->GetLabel(); }
								// tokenTK_LABEL̎Ãx
	LONG	GetNum(void){ return files.top()->GetNum(); }
								// tokenTK_NUM̎A̐l
	int		GetScanline(void){ return files.top()->GetScanline(); }
	string	GetFileName(void){ return files.top()->GetFileName(); }
	void	SetLogFile(FILE* fp){ lpLogFP = fp; }
	int		GetErrorCount(void){ return nErrorCount; }
};

#endif
