/* "test021.cpp" */
/* stack:4k, malloc:1k */

extern "C" {
	#include <guigui00.h>
	void OsaskMain();
};

class C_WINDOW {
protected:
	LIB_WINDOW win;
public:
	inline C_WINDOW(int slot, int xsiz, int ysiz)
	{
		lib_openwindow_nm(&win, slot, xsiz, ysiz);
		return;
	}
	inline operator LIB_WINDOW *()
	{
		return &win;
	}
};

class C_TEXTBOX {
protected:
	LIB_TEXTBOX *textbox;
public:
	inline C_TEXTBOX(int xsiz, int ysiz, LIB_WINDOW *win, int x0 = 0, int y0 = 0,
		int opt = 0, int backcol = 0, int chset = 0x00c0, int initch = 0)
	{
		textbox = lib_opentextbox(opt, 0, backcol, xsiz, ysiz, x0, y0, win,
			chset, initch);
	}
	inline void putstr_asc(int x, int y, int c, const char *str, int bc)
	{
		lib_putstring_ASCII(0x0001, x, y, textbox, c, bc, str);
	}
	inline void putstr_asc(int x, int y, int c, const char *str)
	{
		lib_putstring_ASCII(0x0000, x, y, textbox, c, 0, str);
	}
};

class C_WINTITLE : public C_TEXTBOX {
public:
	inline C_WINTITLE(int len, LIB_WINDOW *win, int chset = 0x00c0, int initch = 0)
		: C_TEXTBOX(len, 1, win, 0, 0, 0x1000, chset, initch) {}
	inline void set(const char *str)
	{
		putstr_asc(0, 0, 0, str);
	}
};

void OsaskMain()
{
	lib_init(0);

	C_WINDOW win(0x0200, 136, 48);
	C_WINTITLE title(7, win);
	C_TEXTBOX text(12, 1, win, 16, 16);

	title.set("test021");
	text.putstr_asc(0, 0, 0, "hello, world");

	lib_waitsignal(0x0001, 0, 0);
}
