using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public partial class TableDefineForm : Form
    {
        protected DatabaseContext _database;
        private string _tableName;

        public string TableName
        {
            get { return _tableName; }
            set { _tableName = value; }
        }

        private string _catalogName;

        public string CatalogName
        {
            get { return _catalogName; }
            set { _catalogName = value; }
        }

        private string _schemaName;

        public string SchemaName
        {
            get { return _schemaName; }
            set { _schemaName = value; }
        }


        public TableDefineForm(DatabaseContext database, string catalogName, string schemaName, string tableName)
        {
            if (database == null)
            {
                throw new ArgumentNullException("database");
            }
            if (schemaName == null)
            {
                throw new ArgumentNullException("schemaName");
            }
            if (catalogName == null)
            {
                throw new ArgumentNullException("catalogName");
            }
            if (tableName == null)
            {
                throw new ArgumentNullException("tableName");
            }
            InitializeComponent();

            _database = database;
            _schemaName = schemaName;
            _catalogName = catalogName;
            _tableName = tableName;
        }

        private void TableDefineForm_Load(object sender, EventArgs e)
        {
            _gridColumn.AllowUserToAddRows = false;
            _gridColumn.ReadOnly = true;
            _gridColumn.Columns.Add("name", "Name");
            _gridColumn.Columns.Add("type", "Type");
            _gridColumn.Columns.Add("notNull", "Not Null");
            _gridColumn.Columns.Add("key", "Key");
            _gridColumn.Columns.Add("order", "Order");

            _gridIndex.Columns.Add("indexName", "Index Name");
            _gridIndex.Columns.Add("unique", "Unique");
            _gridIndex.Columns.Add("columnName", "Column Name");
            _gridIndex.Columns.Add("order", "Order");
        }

        public void RefreshPanel()
        {
            if (_tabPanel.SelectedIndex == 0)
            {
                _gridColumn.Rows.Clear();
                try
                {
                    List<DatabaseColumn> columns = new List<DatabaseColumn>();
                    _database.GetTableColumnList(_catalogName, _schemaName, _tableName, columns);

                    foreach (DatabaseColumn column in columns)
                    {
                        int rowIndex = _gridColumn.Rows.Add();
                        DataGridViewRow row = _gridColumn.Rows[rowIndex];
                        string columnName = column.ColumnName;
                        row.Cells[0].Value = columnName;
                        row.Cells[1].Value = column.TypeAndSize;
                        row.Cells[2].Value = (column.IsNullable ? "" : "NOT NULL");
                        row.Cells[3].Value = (column.IsKey ? "PRIMARY" : "");
                        row.Cells[4].Value = (column.Index + 1).ToString();
                    }
                }
                catch (DatabaseContextException de)
                {
                    throw new ProgramException("Get schema information failed.", de);
                }
            }
            else if (_tabPanel.SelectedIndex == 1)
            {
                _gridIndex.Rows.Clear();
                try
                {
                    DatabaseObjectIndex[] indexList = _database.GetIndexList(_catalogName, _schemaName, _tableName);
                    foreach (DatabaseObjectIndex indexObject in indexList)
                    {
                        int rowIndex = _gridIndex.Rows.Add();
                        DataGridViewRow row = _gridIndex.Rows[rowIndex];
                        row.Cells[0].Value = indexObject.ObjectName;
                        row.Cells[1].Value = (indexObject.IsUnique ? "UNIQUE" : "NON UNIQUE");
                        foreach (DatabaseColumn column in indexObject.ColumnList)
                        {
                            if (column.Index > 0)
                            {
                                rowIndex = _gridIndex.Rows.Add();
                                row = _gridIndex.Rows[rowIndex];
                            }
                            row.Cells[2].Value = column.ColumnName;
                            row.Cells[3].Value = column.Index + 1;
                        }
                    }
                }
                catch (DatabaseContextException de)
                {
                    throw new ProgramException("Get schema information failed.", de);
                }
            }
        }

        private void _tabPanel_SelectedIndexChanged(object sender, EventArgs e)
        {
            RefreshPanel();
        }
    }
}