using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.Common;
using System.Data.Odbc;
using System.IO;

namespace Oratorio
{
	public partial class ScriptForm : Form
	{
		public enum SheetTypes
		{
			Table,
			Query,
			Schema,
		}

		protected DatabaseContext _database;
//		protected DbTransaction _transaction;

		public ScriptFormEditControl EditControl
		{
			get { return _editControl; }
		}

        protected string _tableName;

        public string TableName
        {
            get { return _tableName; }
            set { _tableName = value; }
        }

		protected string _filePath;

		public string FilePath
		{
			get { return _filePath; }
			set { _filePath = value; }
		}

		public bool IsGridFocused
		{
			get { return _gridControl.GridView.Focused; }
		}

		public bool IsScriptFocused
		{
			get { return _editControl.TextBox.Focused; }
		}
	

		public DatabaseContext Database
		{
			get { return _database; }
		}

        protected SheetTypes _sheetType = SheetTypes.Query;
		public SheetTypes SheetType
		{
			get { return _sheetType; }
		}

        public MainForm MainForm
        {
            get { return (MainForm)base.MdiParent; }
        }

		public bool AutoCommit
		{
			get { return _autoCommitButton.Checked; }
			set { _autoCommitButton.Checked = value; }
		}
	

		public ScriptForm(DatabaseContext database, SheetTypes sheetType)
		{
			InitializeComponent();

			//if (database == null)
			//{
			//    throw new ArgumentNullException("database");
			//}

			this._sheetType = sheetType;
			_database = database;
            

//			ctrlDataGrid.RowHeadersWidth = 100;
		}

        protected void ParseScript(string script, out List<string> scriptList)
        {
            scriptList = new List<string>();
            int maxIndex = script.Length;
            for (int index = 0; index < maxIndex; index++)
            {
                char ch = script[index];
                if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n')
                {
                    continue;
                }
                int scriptBegin = index;
                for (; index < maxIndex; index++)
                {
                    ch = script[index];
                    if (ch == ';')
                    {
                        index++;
                        break;
                    }
                    else if (ch == '\'')
                    {
                        int endQuot = script.IndexOf('\'', index + 1);
                        if (endQuot < 0)
                        {
                            endQuot = script.Length - 1;
                        }
                        index = endQuot;
                    }
                }
                string subScript = script.Substring(scriptBegin, index - scriptBegin);

                if (subScript.Trim() == "/")
                {
                    //Support Oracle
                    index--;
                    continue;
                }
                //TODO Rg
                //if (subScript.StartsWith("--"))
                //{
                //}
                if (subScript.EndsWith(";"))
                {
                    subScript = subScript.Substring(0, subScript.Length - 1);
                }
                if (subScript.Length == 0)
                {
                    index--;
                    continue;
                }
                ProgramUtility.WriteLine("sql[" + subScript + "]");

                scriptList.Add(subScript);
                index--;
            }
        }

        protected void OutputRows(DbDataReader reader)
        {
            StringBuilder builder = new StringBuilder("");
            int columnCount = reader.FieldCount;
            for (int columnIndex = 0; columnIndex < columnCount; columnIndex++)
            {
                string name = reader.GetName(columnIndex);
                if (builder.Length > 0)
                {
                    builder.Append(",");
                }
                builder.Append("\"");
                builder.Append(name);
                builder.Append("\"");
            }
            int fieldsLineLength = builder.Length;
            builder.Append("\r\n");
            MainForm.OutputScriptLogLine(builder.ToString());
            builder = new StringBuilder("");
            for (int index = 0; index < Math.Max(fieldsLineLength, 8); index++)
            {
                builder.Append("-");
            }
//            builder[2] = ' ';
            builder.Append("\r\n");
            MainForm.OutputScriptLogLine(builder.ToString(), Color.Green);

            int recordCount = 0;
            while (reader.Read())
            {
                builder = new StringBuilder("");
                for (int columnIndex = 0; columnIndex < columnCount; columnIndex++)
                {
                    object value = reader.GetValue(columnIndex);
                    if (value == null)
                    {
                        value = "";
                    }
                    else
                    {
                        value = value.ToString();
                    }
                    if (builder.Length > 0)
                    {
                        builder.Append(",");
                    }
                    builder.Append("\"");
                    builder.Append(value);
                    builder.Append("\"");
                }
                builder.Append("\r\n");
                MainForm.OutputScriptLogLine(builder.ToString());
                recordCount++;
            }
            MainForm.OutputScriptLogLine("-- #Select " + recordCount.ToString() + " record(s).", Color.Green);
        }


        public void ExecuteScript()
		{
			if (_database == null)
			{
				ProgramUtility.ShowError("Database not connected.");
				return;
			}
			if (!_database.Connected)
            {
                ProgramUtility.ShowError("f[^x[Xؒf߃XNvgsł܂B");
                return;
            }
			string sNewState = _editControl.TextBox.Text;
            List<string> scriptList = null;
            ParseScript(sNewState, out scriptList);

            if (scriptList.Count == 0)
            {
                ProgramUtility.ShowError(this, "Input sql.", null);
                return;
            }
            if (scriptList.Count == 1)
            {
                string scriptFirst = scriptList[0];
                if (scriptFirst.StartsWith("SELECT", StringComparison.OrdinalIgnoreCase))
                {
                    try
                    {
                        DoQueryScript(scriptFirst);
                    }
                    catch (ProgramException pge)
                    {
                        string detailMessage = pge.Message;
                        if (pge.InnerException is DbException)
                        {
                            detailMessage = ((DbException)pge.InnerException).Message;
                        }
                        MainForm.OutputScriptLogLine("-- #Execute failed. " + detailMessage, Color.Red);
                        ProgramUtility.ShowError(pge);
                        return;
                    }
                    _gridControl.Focus();
                    return;
                }
            }

            MainForm mainForm = MainForm;
			DbTransaction transaction = null;
            string currentScript = null;
            try
            {
                Cursor.Current = Cursors.WaitCursor;
				//if (_transaction == null)
				//{
				//    _transaction = _database.Connection.BeginTransaction();
				//}
				transaction = _database.Connection.BeginTransaction();
				//_database.CreateCommand("BEGIN").ExecuteNonQuery();

				foreach (string script in scriptList)
                {
                    currentScript = script;
                    mainForm.OutputScriptLogLine(script + ";");

                    using (DbCommand command = _database.CreateCommand(script))
                    {
						command.Transaction = transaction;
                        int nUpdate = 0;
                        using (DbDataReader reader = command.ExecuteReader())
                        {
                            nUpdate = reader.RecordsAffected;
                            if (reader.HasRows)
                            {
                                OutputRows(reader);
                            }
                            else if (nUpdate >= 0)
                            {
                                mainForm.OutputScriptLogLine("-- #Update " + nUpdate.ToString() + " record(s).", Color.Green);
                            }
                            else
                            {
                                mainForm.OutputScriptLogLine("-- #Execute success.", Color.Green);
                            }
                        }
                    }
                }
				if (!AutoCommit)
				{
					if (MessageBox.Show(this, "Execute success.\r\nCommit transaction?", Application.ProductName, MessageBoxButtons.YesNo) != DialogResult.Yes)
					{
						transaction.Rollback();
						transaction.Dispose();
						transaction = null;
						mainForm.OutputScriptLogLine("-- #Rollback success.", Color.Blue);
					}
				}
				if (transaction != null)
				{
					transaction.Commit();
					transaction.Dispose();
					transaction = null;
					mainForm.OutputScriptLogLine("-- #Commit success.", Color.Blue);
				}
				if (AutoCommit)
				{
					MessageBox.Show("Execute success.");
				}
			}
            catch (DbException dbe)
            {
                string message = "Execute failed.\r\n" + currentScript + "\r\n";
                mainForm.OutputScriptLogLine("-- #Execute failed. " + dbe.Message, Color.Red);
				try
				{
					if (transaction != null)
					{
						transaction.Rollback();
						transaction.Dispose();
						transaction = null;
						mainForm.OutputScriptLogLine("-- #Rollback success.", Color.Blue);
					}
				}
				catch (DbException)
				{
					//iognore
				}
                ProgramUtility.ShowError(this, message, dbe);
                return;
            }
            finally
            {
				if (transaction != null)
				{
					try
					{
						transaction.Rollback();
						transaction.Dispose();
					}
					catch (DbException)
					{
					}
					catch (InvalidOperationException)
					{
					}
				}
                Cursor.Current = Cursors.Default;
            }

            //string sStateType = sNewState.TrimStart(null);
            //if (sStateType.Length == 0)
            //{
            //    MessageBox.Show("SQL͂ĂB", Application.ProductName);
            //    return;
            //}
            //if (sStateType.StartsWith("SELECT", StringComparison.OrdinalIgnoreCase))
            //{
            //    try
            //    {
            //        DoQueryScript(sNewState);
            //    }
            //    catch (ProgramException pge)
            //    {
            //        ProgramUtility.ShowError(pge);
            //        return;
            //    }
            //}
            //else
            //{
            //    DoUpdate(sNewState);
            //}
		}

		protected DataSet _dataSet;
		protected DataAdapter _adapter;

		public DataGridView GridCtrl
		{
			get { return _gridControl.GridView; }
		}
	
		public void DoQueryTable(string sDatabase, string sSchema, string sTable)
		{
			DataGridView grid = GridCtrl;

			string sFullName = sTable;
			if (sSchema != null && sSchema.Length > 0)
			{
				sFullName = sSchema + "." + sTable;
			}
            string sQuery = "SELECT * FROM " + sFullName + "";
			_editControl.TextBox.Text = sQuery;

            //DoQueryScript(sQuery);
            DoQuery(sQuery, ((_sheetType == SheetTypes.Schema)? true: false));
            if (_filePath == null)
            {
                this.Text = sTable;
                if (_gridControl.GridView.ReadOnly)
                {
                    this.Text = sTable + " <Read Only>";
                }
            }
            List<DatabaseColumn> columnList = new List<DatabaseColumn>();
            _database.GetTableColumnList(sDatabase, sSchema, sTable, columnList);
            foreach(DatabaseColumn column in columnList)
            {
                _gridControl.GridView.Columns[column.Index].Tag = column;
            }
            //sQuery += " WHERE 1 = 2";
            //DbCommand selectComand = _database.CreateCommand(sQuery);
            //using (DbDataReader reader = selectComand.ExecuteReader())
            //{
            //    int fieldCount = reader.FieldCount;
            //    for(int index = 0; index < fieldCount; index++)
            //    {
            //        string dataTypeName = reader.GetDataTypeName(index);

            //    }
            //}
            _tableName = sTable;
		}

        public void DoQueryScript(string sQuery)
        {
            DoQuery(sQuery, false);
            string sQuerySub = sQuery;
            sQuerySub = sQuerySub.Replace("\r\n", " ");
            sQuerySub = sQuerySub.Replace("\r", " ");
            sQuerySub = sQuerySub.Replace("\n", " ");
            sQuerySub = sQuerySub.Replace("\t", " ");
            if (sQuerySub.Length > 100)
            {
                sQuerySub = sQuerySub.Substring(0, 100) + "...";
            }
            if (_filePath == null)
            {
                Text = sQuerySub;
            }
        }

        protected void DoQuery(string sQuery, bool schemaOnly)
		{
			if (_database == null)
			{
				ProgramUtility.ShowError("Database not connected.");
				return;
			}
			if (!_database.Connected)
			{
				ProgramUtility.ShowError("f[^x[Xؒf߃XNvgsł܂B");
				return;
			}
            MainForm.OutputScriptLogLine(sQuery + ";");
			DataGridView grid = GridCtrl;

			DatabaseContext database = _database;

            DbDataAdapter adapter = null;
            try
            {
				//if (_transaction == null)
				//{
				//    _transaction = _database.Connection.BeginTransaction();
				//}
				
				adapter = _database.CreateDataAdapter();
                adapter.SelectCommand = _database.CreateCommand(sQuery);
				//adapter.SelectCommand.Transaction = _transaction;

                DataSet dataSet = new DataSet();
                try
                {
                    if (schemaOnly)
                    {
                        adapter.FillSchema(dataSet, SchemaType.Mapped);
                    }
                    else
                    {
                        adapter.Fill(dataSet);
                    }
                }
                catch (InvalidOperationException ioe)
                {
                    throw new ProgramException("SQL̎sɎs܂B", ioe);
                }
				//catch (DbException dbe)
				//{
				//    throw new ProgramException("SQL̎sɎs܂B", dbe);
				//}

                DatabaseExecuter script = new DatabaseExecuter();
                script.Adapter = adapter;
                script.Data = dataSet;
                script.Database = _database;
                script.Table = dataSet.Tables[0];
                _gridControl.Executer = script;
                //			_gridControl.GridView.DataBindings.DefaultDataSourceUpdateMode = DataSourceUpdateMode.OnPropertyChanged;

                DbCommandBuilder builder = _database.CreateCommandBuilder();
                builder.DataAdapter = adapter;
                try
                {
                    adapter.InsertCommand = builder.GetInsertCommand();
#if DEBUG
                    ProgramUtility.WriteLine("isnert sql:" + adapter.InsertCommand.CommandText);
#endif
                    this._gridControl.GridView.ReadOnly = false;
                    script.Table.DefaultView.AllowNew = true;
                    try
                    {
                        adapter.DeleteCommand = builder.GetDeleteCommand();
                        adapter.UpdateCommand = builder.GetUpdateCommand();
#if DEBUG
                        ProgramUtility.WriteLine("update sql:" + adapter.UpdateCommand.CommandText);
                        ProgramUtility.WriteLine("delete sql:" + adapter.UpdateCommand.CommandText);
#endif
                        _gridControl.GridView.AllowUserToDeleteRows = true;
                        //                    _gridControl.GridView.ReadOnly = false;
                        //                    script.Table.DefaultView.AllowEdit = true;
                        //                    script.Table.DefaultView.AllowDelete = true;
                    }
                    catch (InvalidOperationException ioe)
                    {
                        ProgramUtility.WriteLine(ioe);
                        _gridControl.GridView.AllowUserToDeleteRows = false;
                        //                    _gridControl.GridView.ReadOnly = true;
                        //                    script.Table.DefaultView.AllowEdit = false;
                        //                    script.Table.DefaultView.AllowDelete = false;
                    }
                }
                catch (InvalidOperationException ioe)
                {
                    ProgramUtility.WriteLine(ioe);
                    this._gridControl.GridView.ReadOnly = true;
                    _gridControl.GridView.AllowUserToAddRows = false;
                    _gridControl.GridView.AllowUserToDeleteRows = false;
                    script.Table.DefaultView.AllowEdit = false;
                    script.Table.DefaultView.AllowDelete = false;
                }
                _adapter = adapter;
                _dataSet = dataSet;
                _adapter = null;
            }
            finally
            {
                if (adapter != null)
                {
                    adapter.Dispose();
                }
            }
            string message = "-- Select {0} row(s).";
            message = String.Format(message, _dataSet.Tables[0].Rows.Count);
            MainForm.OutputScriptLogLine(message, Color.Green);


			if (_sheetType == SheetTypes.Query && _splitContainer.Panel2MinSize == 0)
			{
				this._splitContainer.Panel2MinSize = 20;
				this._splitContainer.SplitterDistance = _splitContainer.ClientSize.Height / 2;
				this._splitContainer.IsSplitterFixed = false;
				_splitContainer.Panel2Collapsed = false;
			}

            grid.DataSource = _dataSet.Tables[0];
		}


        protected void _scriptRunButton_Click(object sender, EventArgs e)
		{
			ExecuteScript();
		}

        //protected void DoUpdate(string sNewState)
        //{
        //    DbCommand command = _database.CreateCommand(sNewState);
        //    command.CommandText = sNewState;
        //    int nUpdate = 0;
        //    try
        //    {
        //        nUpdate = command.ExecuteNonQuery();
        //        if (nUpdate < 0)
        //        {
        //            MessageBox.Show("sɐ܂B");
        //        }
        //        else
        //        {
        //            MessageBox.Show("" + nUpdate + "XV܂B\n");
        //        }
        //    }
        //    catch (DbException dbe)
        //    {
        //        ProgramUtility.ShowError(dbe);
        //    }
        //}

		protected void ScriptForm_Load(object sender, EventArgs e)
		{
            if (_sheetType == SheetTypes.Table || _sheetType == SheetTypes.Schema)
			{
				this._splitContainer.Panel1MinSize = 0;
				this._splitContainer.SplitterDistance = 0;
				this._splitContainer.IsSplitterFixed = true;
			}
            else if (_sheetType == SheetTypes.Query)
            {
                this._splitContainer.Panel2MinSize = 0;
                this._splitContainer.SplitterDistance = _splitContainer.ClientSize.Height;
                this._splitContainer.IsSplitterFixed = true;
                _splitContainer.Panel2Collapsed = true;
            }

            if (_sheetType == SheetTypes.Table || _sheetType == SheetTypes.Schema)
            {
                _gridControl.GridView.Focus();
            }
            else  if (_sheetType == SheetTypes.Query)
            {
                _editControl.TextBox.Focus();
            }
//            _gridControl.GridView.DefaultCellStyle.NullValue = "(null)";
//            _gridControl.GridView.DefaultCellStyle.DataSourceNullValue = "";
//            _gridControl.GridView.Nu
		}

        public bool IsCallEditActionEnable(ProgramUtility.CallEditActionModes mode)
        {
            Control focusControl = ProgramUtility.FindFocus(this);
            if (focusControl is DataGridView)
            {
                if (_gridControl.IsCallEditActionEnable(mode))
                {
                    return true;
                }
            }
            return false;
        }

        public void CallEditAction(ProgramUtility.CallEditActionModes mode)
        {
            Control focusControl = ProgramUtility.FindFocus(this);
            Control activeControl = ActiveControl;
            if (focusControl is DataGridView)
            {
                _gridControl.CallEditAction(mode);
            }
        }

		public void SaveFileFromGrid(string fileName)
		{
			DataGridView gridView = _gridControl.GridView;
			int columnCount = gridView.ColumnCount;

			StringBuilder buffer = new StringBuilder("", 1024 * 1024);
			StringBuilder headBuffer = new StringBuilder("", 1024 * 1024);
			foreach (DataGridViewColumn col in gridView.Columns)
			{
				if (headBuffer.Length > 0)
				{
					headBuffer.Append(",");
				}
				headBuffer.Append(col.Name);
			}
			headBuffer.Append("\r\n");
			buffer.Append(headBuffer.ToString());
			foreach (DataGridViewRow row in gridView.Rows)
			{
                if (row.IsNewRow)
                {
                    continue;
                }
				StringBuilder lineBuffer = new StringBuilder();
				for (int col = 0; col < columnCount; col++)
				{
					if (col > 0)
					{
						lineBuffer.Append(",");
					}
					object value = row.Cells[col].Value;
					if (value != null)
					{
						lineBuffer.Append(value.ToString());
					}
				}
				lineBuffer.Append("\r\n");
				buffer.Append(lineBuffer.ToString());
			}
			try
			{
				Encoding encoding = Encoding.GetEncoding("Shift_JIS");
				byte[] byteBuffer = encoding.GetBytes(buffer.ToString());
				using (FileStream stream = new FileStream(fileName, FileMode.Create, FileAccess.Write))
				{
					stream.Write(byteBuffer, 0, byteBuffer.Length);
				}
			}
			catch (IOException ioe)
			{
				ProgramUtility.ShowError(ioe);
			}
		}

        public class TextFieldBuilder
        {
            protected StringBuilder _buffer = new StringBuilder();
            protected bool _firstField = true;

            public void WriteField(string value)
            {
                if (_firstField)
                {
                    _firstField = false;
                }
                else
                {
                    _buffer.Append(",");
                }
                value = Escape(value);
                if (value == null)
                {
                    value = "";
                }
                _buffer.Append(value);
            }
            public void EndLine()
            {
                _buffer.Append("\r\n");
                _firstField = true;
            }
            public string GetData()
            {
                return _buffer.ToString();
            }
            public string Escape(String value)
            {
                if (value == null)
                {
                    return null;
                }
                value = value.Replace("\"", "\"\"");
                value = "\"" + value + "\"";
                return value;
            }
        }

        public void SaveFile(string fileName)
		{
			string script = _editControl.TextBox.Text;
			try
			{
				Encoding encoding = Encoding.GetEncoding("Shift_JIS");
				byte[] byteBuffer = encoding.GetBytes(script);
				using (FileStream stream = new FileStream(fileName, FileMode.Create, FileAccess.Write))
				{
					stream.Write(byteBuffer, 0, byteBuffer.Length);
				}
			}
			catch (IOException ioe)
			{
				ProgramUtility.ShowError(ioe);
                return;
			}
            _filePath = fileName;
            Text = Path.GetFileName(fileName);
        }

		public void OpenFile(string fileName)
		{
			string script = null;
			try
			{
				Encoding encoding = Encoding.GetEncoding("Shift_JIS");
				byte[] byteBuffer = null;
				using (FileStream stream = new FileStream(fileName, FileMode.Open, FileAccess.Read))
				{
					byteBuffer = new byte[stream.Length];
					stream.Read(byteBuffer, 0, byteBuffer.Length);
					script = encoding.GetString(byteBuffer);
				}
			}
			catch (IOException ioe)
			{
				ProgramUtility.ShowError(ioe);
				return;
			}
            _editControl.TextBox.Text = script;
            _filePath = fileName;
            Text = Path.GetFileName(fileName);
		}

        public void ShowFindForm()
        {
            DataGridView dataGridView = _gridControl.GridView;
            if (dataGridView.ColumnCount == 0 || dataGridView.RowCount == 0)
            {
                ProgramUtility.ShowError(this, "Warning: Grid is empty.", null);
                return;
            }

            FindForm form = new FindForm();

            bool beforeFind = false;
            while (true)
            {
                DataGridViewCell beforeCell = dataGridView.CurrentCell;
                int startRowIndex = 0;
                int startColumnIndex = 0;
                if(beforeCell != null)
                {
                    startRowIndex = beforeCell.RowIndex;
                    startColumnIndex = beforeCell.ColumnIndex;
                }
                if (form.ShowDialog(this) != DialogResult.OK)
                {
                    return;
                }
                StringComparison compareOption = StringComparison.OrdinalIgnoreCase;
                if (form.SenseCase)
                {
                    compareOption = StringComparison.Ordinal;
                }
                string targetText = form.TargetText;
                if (targetText.Length == 0)
                {
                    return;
                }

                if (beforeFind)
                {
                    startColumnIndex++;
                    if (startColumnIndex == dataGridView.ColumnCount)
                    {
                        startColumnIndex = 0;
                        startRowIndex++;
                    }
                    if (startRowIndex + 1 == dataGridView.RowCount)
                    {
                        if (MessageBox.Show(this, "Search grid head?", Application.ProductName, MessageBoxButtons.YesNo) != DialogResult.Yes)
                        {
                            break;
                        }
                        startColumnIndex = 0;
                        startRowIndex = 0;
                    }
                }

                int columnCount = _gridControl.GridView.ColumnCount;
                DataGridViewRowCollection rows = _gridControl.GridView.Rows;
                DataGridViewCell findCell = null;
                foreach (DataGridViewRow row in rows)
                {
                    if (row.Index < startRowIndex)
                    {
                        continue;
                    }
                    for (int column = 0; column < columnCount; column++)
                    {
                        if (row.Index == startRowIndex && column < startColumnIndex)
                        {
                            continue;
                        }
                        object value = row.Cells[column].Value;
                        if (value == null)
                        {
                            continue;
                        }
                        if (value.ToString().IndexOf(targetText, compareOption) >= 0)
                        {
                            findCell = row.Cells[column];
                            break;
                        }
                    }
                    if (findCell != null)
                    {
                        break;
                    }
                }
                if (findCell == null)
                {
                    MessageBox.Show(this, "Not found.", Application.ProductName);
                    beforeFind = false;
                }
                else
                {
                    _gridControl.GridView.CurrentCell = findCell;
                    beforeFind = true;
                }
            }
        }

		private void _runButton_Click(object sender, EventArgs e)
		{
			ExecuteScript();
		}

		private void _commitButton_Click(object sender, EventArgs e)
		{
			//if (_transaction == null)
			//{
			//    return;
			//}
			//try
			//{
			//    _transaction.Commit();
			//    _transaction = null;
			//}
			//catch (DbException dbe)
			//{
			//    ProgramUtility.ShowError(dbe);
			//}
		}

		private void _rollbackButton_Click(object sender, EventArgs e)
		{
			//if (_transaction == null)
			//{
			//    return;
			//}
			//try
			//{
			//    _transaction.Rollback();
			//    _transaction = null;
			//}
			//catch (DbException dbe)
			//{
			//    ProgramUtility.ShowError(dbe);
			//}
			if (_database == null)
			{
				ProgramUtility.ShowError("Database not connected.");
				return;
			}
			try
			{
				_database.CreateCommand("COMMIT").ExecuteNonQuery();
			}
			catch (DbException dbe)
			{
				ProgramUtility.ShowError(dbe);
			}
		}

		private void _commitModeCombo_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (_database == null)
			{
				ProgramUtility.ShowError("Database not connected.");
				return;
			}
			try
			{
				_database.CreateCommand("ROLLBACK").ExecuteNonQuery();
			}
			catch (DbException dbe)
			{
				ProgramUtility.ShowError(dbe);
			}
		}

		private void _autoCommitButton_Click(object sender, EventArgs e)
		{

		}
	}
}