using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
	public class ObjectTreeData
	{
		public static readonly string NEW_NODE = "<.>";
		public enum NodeTypes
		{
			UNKNOWN,
			DATABASE,
            SCHEMA_LIST,
            TABLE_LIST,
            VIEW_LIST,
            DICTIONARY_LIST,
            SCHEMA,
			TABLE,
            VIEW,
            DICTIONARY,
            RELOAD,
		}

		protected NodeTypes _nodeType;

		public NodeTypes NodeType
		{
			get { return _nodeType; }
			set { _nodeType = value; }
		}
	

		protected string _schema;

		public string Schema
		{
			get { return _schema; }
			set { _schema = value; }
		}
		protected string _catalog;

		public string Catalog
		{
			get { return _catalog; }
			set { _catalog = value; }
		}

        protected string _name;

        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
	
        public static TreeNode CreateReloadNode()
		{
			TreeNode node = new TreeNode(NEW_NODE);
			ObjectTreeData data = new ObjectTreeData(NodeTypes.RELOAD);
			node.Tag = data;
			return node;
		}

		public static bool IsReloadNode(TreeNode node)
		{
			if(node == null)
			{
				return false;
			}
			if (node.Tag == null)
			{
				return false;
			}
			ObjectTreeData data = (ObjectTreeData)node.Tag;
			return (data._nodeType == NodeTypes.RELOAD);
		}

		public NodeTypes Type
		{
			get { return _nodeType; }
			set { _nodeType = value; }
		}

		public ObjectTreeData(NodeTypes type)
		{
			_nodeType = type;
		}

	}
}
