using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;

namespace Oratorio
{
    public class LoginSettingData : Dictionary<string, string>
    {
        public const string KEY_NAME = "__name";
        public const string KEY_UID = "uid";
        public const string KEY_PWD = "pwd";
        public const string KEY_DRIVER = "driver";
        public const string KEY_DATABASE = "database";
        public const string KEY_SERVER = "server";
        public const string KEY_DBQ = "dbq";
        public const string KEY_METHOD = "__method";
        public const string KEY_DATA_SOURCE = "data source";
		public const string KEY_PORT = "port";

        public LoginSettingData()
        {
            Add(KEY_NAME, "");
            Add(KEY_UID, "");
            Add(KEY_PWD, "");
            Add(KEY_DRIVER, "");
            Add(KEY_DATABASE, "");
            Add(KEY_SERVER, "");
            Add(KEY_DBQ, "");
            Add(KEY_METHOD, "");
			Add(KEY_DATA_SOURCE, "");
			Add(KEY_PORT, "");
		}

        public string Name
        {
            get { return this[KEY_NAME]; }
            set { this[KEY_NAME] = value; }
        }
        public string Uid
        {
            get { return this[KEY_UID]; }
            set { this[KEY_UID] = value; }
        }

        public string Pwd
        {
            get { return this[KEY_PWD]; }
            set { this[KEY_PWD] = value; }
        }

        public string Driver
        {
            get { return this[KEY_DRIVER]; }
            set { this[KEY_DRIVER] = value; }
        }

        public string Database
        {
            get { return this[KEY_DATABASE]; }
            set { this[KEY_DATABASE] = value; }
        }

        public string Server
        {
            get { return this[KEY_SERVER]; }
            set { this[KEY_SERVER] = value; }
        }

        public string Dbq
        {
            get { return this[KEY_DBQ]; }
            set { this[KEY_DBQ] = value; }
        }
        public string Method
        {
            get { return this[KEY_METHOD]; }
            set { this[KEY_METHOD] = value; }
        }
		public string Dsn
		{
			get { return this[KEY_DATA_SOURCE]; }
			set { this[KEY_DATA_SOURCE] = value; }
		}
		public string Port
		{
			get { return this[KEY_PORT]; }
			set { this[KEY_PORT] = value; }
		}
		public override string ToString()
        {
            return Name;
        }
    }

    public class LoginSettings : List<LoginSettingData>
    {
        private string _settingPath;

        public string SettingPath
        {
            get { return _settingPath; }
            set { _settingPath = value; }
        }

        protected readonly string _settingNode;
        protected const string PREFIX_CONNECT = "login";
        protected Properties.ApplicationSettingsConverter _converter = new Properties.ApplicationSettingsConverter();

        public LoginSettings()
        {
            _settingNode = GetType().Name;
            _settingPath = Path.Combine(new Properties.ApplicationSettingsProvider().SettingFolder, "login.config");
        }

        public void Load()
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(_settingPath);

            IDictionary<string, string> settings = null;
            _converter.ConvertXmlToSettings(doc, _settingNode, out settings);
            for (int index = 0; ; index++)
            {
                string nameKey = PREFIX_CONNECT + "." + index.ToString() + "." + LoginSettingData.KEY_NAME;
                if (!settings.ContainsKey(nameKey) || settings[nameKey].Length == 0)
                {
                    break;
                }

                LoginSettingData data = new LoginSettingData();
                Dictionary<string, string> values = new Dictionary<string, string>();
                string[] keys = {
                    LoginSettingData.KEY_NAME,
                    LoginSettingData.KEY_UID,
                    LoginSettingData.KEY_PWD,
                    LoginSettingData.KEY_DRIVER,
                    LoginSettingData.KEY_DATABASE,
                    LoginSettingData.KEY_SERVER,
                    LoginSettingData.KEY_DBQ,
                    LoginSettingData.KEY_DATA_SOURCE,
                    LoginSettingData.KEY_METHOD,
                    LoginSettingData.KEY_PORT,
                };
                foreach (string key in keys)
                {
                    data.Remove(key);
                    string key2 = PREFIX_CONNECT + "." + index.ToString() + "." + key;
                    if (settings.ContainsKey(key2))
                    {
                        data.Add(key, settings[key2]);
                    }
                    else
                    {
                        data.Add(key, "");
                    }
                }
                this.Add(data);
            }
        }

        public void Save()
        {
            Dictionary<string, string> settings = new Dictionary<string, string>();
            int index = 0;
            foreach (LoginSettingData data in this)
            {
                foreach (KeyValuePair<string, string> item in data)
                {
                    settings[PREFIX_CONNECT + "." + index.ToString() + "." + item.Key] = item.Value;
                }
                index++;
            }

            XmlDocument doc = _converter.ConvertSettingsToXml(settings, _settingNode);
            doc.Save(_settingPath);
        }

    }
}
