using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Data.Odbc;

namespace Oratorio
{
    public class DatabaseContextOdbcMsSqlServer : DatabaseContextOdbc
    {
        public DatabaseContextOdbcMsSqlServer(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.MsSqlServer;
            _currentCatalogName = connection.Database;
        }
        public override string[] GetSchemaList()
        {
            DbCommand command2 = Connection.CreateCommand();
            command2.CommandText = "SELECT * FROM information_schema.schemata ORDER BY schema_name";
            try
            {
                DbDataReader reader2 = command2.ExecuteReader();
                List<string> resultList = new List<string>();
                while (reader2.Read())
                {
                    resultList.Add(reader2.GetString(1));
                }
                return resultList.ToArray();
            }
            catch (InvalidOperationException ioe)
            {
                throw new DatabaseContextException("Get schema list failed.", ioe);
            }
        }
        public override string GetCurrentSchema()
        {
            try
            {
                DbCommand command2 = Connection.CreateCommand();
                command2.CommandText = "SELECT name FROM sys.schemas WHERE schema_id = schema_id()";
                DbDataReader reader2 = command2.ExecuteReader();
                if (!reader2.Read())
                {
                    throw new NotSupportedException();
                }
                _currentSchemaName = reader2.GetString(0);
                return _currentSchemaName;
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("XL[}̎擾Ɏs܂B", dbe);
            }
        }

        //public override string GetOdbcTypeName(OdbcType type)
        //{
        //    switch(type)
        //    {
        //        case ((OdbcType)(-9)):
        //            return "DECIMAL";
        //        case ((OdbcType)93):
        //            return "VARCHAR";
        //    }
        //    return base.GetOdbcTypeName(type);
        //}
    }
}
