using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Data.Odbc;
using System.Data;

namespace Oratorio
{
    public class DatabaseContextOdbc : DatabaseContextCommon
	{
        public new OdbcConnection Connection
        {
            get { return (OdbcConnection)_connection; }
        }

        public DatabaseContextOdbc(OdbcConnection connection) : base(connection)
		{
            _scriptGenerator = new DatabaseScriptGenerator(this);
			_currentCatalogName = connection.Database;
            _factory = OdbcFactory.Instance;
			if (GetType() != typeof(DatabaseContextOdbc))
            {
                try
                {
                    _currentSchemaName = GetCurrentSchema();
                }
                catch (NotSupportedException)
                {
                    //ignore
                }
            }
		}

        public static DatabaseContextOdbc ConnectOdbc(string sDataSource, string sUser, string sPassword)
		{
			DbConnectionStringBuilder connStr = new DbConnectionStringBuilder();
			connStr.Add("DSN", sDataSource);
			if (sUser != null && sUser.Length > 0)
			{
				connStr.Add("UID", sUser);
			}
			if (sPassword != null && sPassword.Length > 0)
			{
				connStr.Add("PWD", sPassword);
			}
			return Connect(connStr.ToString());
		}
        public static DatabaseContextOdbc Connect(string sConnectString)
		{
			OdbcConnection conn = new OdbcConnection();
#if DEBUG
            ProgramUtility.WriteLine("connect=" + sConnectString);
#endif
			conn.ConnectionString = sConnectString;
			try
			{
				conn.Open();
			}
			catch (DbException dbe)
            {
                throw new DatabaseContextException("f[^x[Xւ̐ڑɎs܂B", dbe);
			}

			string sDriver = conn.Driver.ToUpper();
            if (sDriver.StartsWith("SQORA"))
            {
                DatabaseContextOdbcOracle oracleAdapter = new DatabaseContextOdbcOracle(conn);
                return oracleAdapter;
            }
            else if (sDriver.StartsWith("SQLNCLI") || sDriver.StartsWith("SQLSRV32"))
            {
                DatabaseContextOdbcMsSqlServer msSqlAdapter = new DatabaseContextOdbcMsSqlServer(conn);
                return msSqlAdapter;
            }
			else if (sDriver.StartsWith("MYSQL"))
			{
				DatabaseContextOdbcMySQL mySqlAdapter = new DatabaseContextOdbcMySQL(conn);
				return mySqlAdapter;
			}
			else if (sDriver.StartsWith("PSQLODBC"))
			{
				DatabaseContextOdbcH2 h2Adapter = new DatabaseContextOdbcH2(conn);
				return h2Adapter;
			}
			else
            {
				DatabaseContextOdbc context = new DatabaseContextOdbc(conn);
				return context;
				//                throw new DatabaseContextException("ΉĂȂhCołB\n" + sDriver);
            }
		}

        //public override string[] GetSchemaList()
        //{
        //    throw new NotSupportedException();
        //}

        //public override string GetCurrentSchema()
        //{
        //    throw new NotSupportedException();
        //}

        //public override DbDataAdapter CreateDataAdapter()
        //{
        //    return _factory.CreateDataAdapter();
        //}

        //public override DbCommand CreateCommand(string sql)
        //{
        //    DbCommand command1 = Connection.CreateCommand();
        //    command1.CommandText = sql;
        //    return command1;
        //}


		public override DbParameter CreateParameter(string name, object value)
        {
            return new OdbcParameter(null, value);
        }

        //public int ExecuteUpdate(string sCommandText, DbParameter[] aParameters)
        //{
        //    DbCommand command = Connection.CreateCommand();
        //    command.CommandText = sCommandText;
        //    command.Parameters.AddRange(aParameters);
        //    return command.ExecuteNonQuery();
        //}

        //public override string[] GetTableList(string catalog, string schema)
        //{
        //    string[] aFilter = new string[] { catalog, schema };
        //    DataTable tableInfos = Connection.GetSchema(OdbcMetaDataCollectionNames.Tables, aFilter);
        //    List<string> tableList = new List<string>();
        //    foreach (DataRow row in tableInfos.Rows)
        //    {
        //        string sTableName = row["TABLE_NAME"].ToString();
        //        /*
        //        ProgramUtility.WriteLine(row[0].ToString());
        //        ProgramUtility.WriteLine(row[1].ToString());
        //        ProgramUtility.WriteLine(row[2].ToString());
        //        ProgramUtility.WriteLine(row[3].ToString());
        //        ProgramUtility.WriteLine(row[4].ToString());
        //         */
        //        tableList.Add(sTableName);
        //    }
        //    return tableList.ToArray();
        //}

        //public override string[] GetViewList(string catalog, string schema)
        //{
        //    string[] aFilter = new string[] { catalog, schema };
        //    DataTable tableInfos = Connection.GetSchema(OdbcMetaDataCollectionNames.Views, aFilter);
        //    List<string> tableList = new List<string>();
        //    foreach (DataRow row in tableInfos.Rows)
        //    {
        //        string sTableName = row["TABLE_NAME"].ToString();
        //        tableList.Add(sTableName);
        //    }
        //    return tableList.ToArray();
        //}

        //public virtual string GetOdbcTypeName(OdbcType type)
        //{
        //    string result = ((OdbcType)type).ToString().ToUpper();
        //    if (result[0] >= '0' && result[0] <= '9')
        //    {
        //        result = "";
        //    }
        //    return result;
        //}

//        public override void GetTableColumnList(string catalog, string schema, string tableName, List<DatabaseColumn> list)
//        {
//            string[] sFilter = { catalog, schema, tableName };
////			string[] sFilter = { null, "SYS", tableName };
//            DataTable tableInfos = null;
//            try
//            {
//                tableInfos = Connection.GetSchema(OdbcMetaDataCollectionNames.Columns, sFilter);
//            }
//            catch (OdbcException oe)
//            {
//                throw new DatabaseContextException("Get schema information failed.", oe);
//            }
//            int nColumnCount = tableInfos.Columns.Count;
//            foreach (DataRow row in tableInfos.Rows)
//            {
//                ProgramUtility.WriteLine("");
//                for (int nColumn = 0; nColumn < nColumnCount; nColumn++)
//                {
//                    ProgramUtility.WriteLine(tableInfos.Columns[nColumn].ColumnName + "=" + row[nColumn]);
//                }
//                /*
//TABLE_CAT=oratorio_db
//TABLE_SCHEM=oratorio_schema
//TABLE_NAME=oratorio_table
//COLUMN_NAME=id
//DATA_TYPE=4
//TYPE_NAME=int
//COLUMN_SIZE=10
//BUFFER_LENGTH=4
//DECIMAL_DIGITS=0
//NUM_PREC_RADIX=10
//NULLABLE=0
//REMARKS=
//COLUMN_DEF=
//SQL_DATA_TYPE=4
//SQL_DATETIME_SUB=
//CHAR_OCTET_LENGTH=
//ORDINAL_POSITION=1
//IS_NULLABLE=NO 
//SS_DATA_TYPE=56

//TABLE_CAT=oratorio_db
//TABLE_SCHEM=oratorio_schema
//TABLE_NAME=oratorio_table
//COLUMN_NAME=name
//DATA_TYPE=-9
//TYPE_NAME=nvarchar
//COLUMN_SIZE=50
//BUFFER_LENGTH=100
//DECIMAL_DIGITS=
//NUM_PREC_RADIX=
//NULLABLE=0
//REMARKS=
//COLUMN_DEF=
//SQL_DATA_TYPE=-9
//SQL_DATETIME_SUB=
//CHAR_OCTET_LENGTH=100
//ORDINAL_POSITION=2
//IS_NULLABLE=NO 
//SS_DATA_TYPE=39
//TABLE_CAT=oratorio_db
//TABLE_SCHEM=oratorio_schema
//TABLE_NAME=oratorio_table
//COLUMN_NAME=create_timestamp
//DATA_TYPE=93
//TYPE_NAME=datetime
//COLUMN_SIZE=23
//BUFFER_LENGTH=16
//DECIMAL_DIGITS=3
//NUM_PREC_RADIX=
//NULLABLE=0
//REMARKS=
//COLUMN_DEF=(getdate())
//SQL_DATA_TYPE=9
//SQL_DATETIME_SUB=3
//CHAR_OCTET_LENGTH=
//ORDINAL_POSITION=3
//IS_NULLABLE=NO 
//SS_DATA_TYPE=61
//                 */
//                DatabaseColumn column = new DatabaseColumn();
//                column.ColumnName = row["COLUMN_NAME"].ToString();
//                int dataType = -1;
//                int.TryParse(row["DATA_TYPE"].ToString(), out dataType);
//                string dataTypeString = null;
//                dataTypeString = GetOdbcTypeName((OdbcType)dataType);
//                if (dataTypeString.Length == 0)
//                {
//                    dataTypeString = "UNKNOWN" + row["DATA_TYPE"];
//                }
//                column.TypeString = dataTypeString;
//                list.Add(column);
//            }

//        }


        //public override void Close()
        //{
        //    if (_connection != null)
        //    {
        //        _connection.Close();
        //        _connection.Dispose();
        //    }
        //    _currentSchemaName = "";
        //    _connected = false;
        //}

    }
}
