/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XMLUtil
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/**
 *	XMLUtil NX<br>
 *	XML̃[eBeBNX<br>
 */
public class XMLUtil {

	/**
	 * DocumentBuilder擾
	 *
	 * @param	namespaceAware	OԂLɂ邩ǂw肷
	 */
	public static DocumentBuilder newDocumentBuilder(boolean namespaceAware) throws ParserConfigurationException {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setNamespaceAware(namespaceAware);

		return dbf.newDocumentBuilder();
	}

	/**
	 * DOM Document쐬
	 *
	 * @param	is	InputStreamw肷
	 * @return	쐬DOM Documentԋp
	 */
	public static Document createDocument(InputStream is, boolean namespaceAware)
		throws IOException, ParserConfigurationException, SAXException {

		return newDocumentBuilder(namespaceAware).parse(is);
	}

	/**
	 * DOM Document쐬
	 *
	 * @param	rootNodeName	[gm[ĥ̖w肷
	 * @param	namespaceAware	OԂLɂ邩ǂw肷
	 * @return	쐬DOM Documentԋp
	 */
	public static Document createDocument(String rootNodeName, boolean namespaceAware)
		throws ParserConfigurationException {

		Document doc = newDocumentBuilder(namespaceAware).newDocument();
		doc.appendChild(doc.createElement(rootNodeName));
		return doc;
	}

	/**
	 * DOM Document쐬
	 *
	 * @param	rootNode		[gm[hw肷
	 * @param	namespaceAware	OԂLɂ邩ǂw肷
	 * @return	쐬DOM Documentԋp
	 */
	public static Document createDocument(Node rootNode, boolean namespaceAware)
		throws ParserConfigurationException {

		Document doc = newDocumentBuilder(namespaceAware).newDocument();
		doc.appendChild(doc.importNode(rootNode, true));
		return doc;
	}

	/**
	 * Textm[h쐬
	 *
	 * @param	doc		DOM Documentw肷
	 * @param	text	쐬Textm[hɐݒ肷eLXgw肷B
	 *					eLXgꍇnull""(󕶎)w肷
	 * @return	쐬Textm[hԋp
	 */
	public static Text createTextNode(Document doc, String text) {
		return doc.createTextNode((text == null) ? "" : text);
	}

	/**
	 * Elementm[h쐬
	 *
	 * @param	doc			DOM Documentw肷
	 * @param	nodeName	쐬Elementm[h̃m[ĥw肷
	 * @param	text		쐬Elementm[hɐݒ肷eLXgw肷B
	 *						eLXgꍇnull""(󕶎)w肷
	 * @return	쐬Elementm[hԋp
	 */
	public static Element createElement(Document doc, String nodeName, String text) {

		Element element = doc.createElement(nodeName);
		element.appendChild(createTextNode(doc, text));

		return element;
	}

	/**
	 * ReiElementm[h쐬AqElementǉ
	 *
	 * @param	doc					DOM Documentw肷
	 * @param	containerNodeName	쐬Reim[h̃m[ĥw肷
	 * @param	children			ǉElementm[h̔zw肷
	 * @return	쐬ReiElementm[hԋp
	 */
	public static Element createElement(Document doc, String containerNodeName, Element[] children) {

		Element element = doc.createElement(containerNodeName);

		if (children != null) {
			for (int i = 0; i < children.length; i++) {
				element.appendChild(children[i]);
			}
		}

		return element;
	}

	/**
	 * Elementm[h쐬Aw肳ꂽm[h֒ǉ
	 *
	 * @param	doc			DOM Documentw肷
	 * @param	parent		ǉ̃m[hw肷
	 * @param	nodeName	ǉm[h̃m[ĥw肷
	 * @param	text		ǉm[hɐݒ肷Textm[h̃eLXgw肷B
	 *						eLXgꍇnull""(󕶎)w肷
	 * @return	(쐬)ǉElementm[hԋp
	 */
	public static Element append(Document doc, Element parent, String nodeName, String text) {

		Element element = createElement(doc, nodeName, text);
		parent.appendChild(element);

		return element;
	}

	/**
	 * ReiElementm[h쐬AqElementǉAparent
	 * w肳ꂽm[hփReim[hǉ
	 *
	 * @param	doc					DOM Documentw肷
	 * @param	parent				Reim[h̒ǉ̃m[hw肷
	 * @param	containerNodeName	쐬Reim[h̃m[ĥw肷
	 * @param	children			ǉElementm[h̔zw肷
	 * @return	쐬ReiElementm[hԋp
	 */
	public static Element append(Document doc, Element parent, String containerNodeName, Element[] children) {

		Element element = doc.createElement(containerNodeName);

		if (children != null) {
			for (int i = 0; i < children.length; i++) {
				element.appendChild(children[i]);
			}
		}

		parent.appendChild(element);

		return element;
	}

	/**
	 * parentŎw肳ꂽm[h(q)Elementǉ
	 *
	 * @param	doc		DOM Documentw肷
	 * @param	parent	Reim[h̒ǉ̃m[hw肷
	 * @param	child	ǉElementm[hw肷
	 * @return	ElementǉꂽElementm[h(parent)ԋp
	 */
	public static Element append(Document doc, Element parent, Element child) {
		parent.appendChild(child);
		return parent;
	}

	/**
	 * parentŎw肳ꂽm[h(q)Elementǉ
	 *
	 * @param	doc			DOM Documentw肷
	 * @param	parent		Reim[h̒ǉ̃m[hw肷
	 * @param	children	ǉElementm[h̔zw肷
	 * @return	ElementǉꂽElementm[h(parent)ԋp
	 */
	public static Element append(Document doc, Element parent, Element[] children) {

		for (int i = 0; i < children.length; i++) {
			parent.appendChild(children[i]);
		}

		return parent;
	}

	/**
	 * parentŎw肳ꂽm[h(q)Elementǉ
	 *
	 * @param	doc			DOM Documentw肷
	 * @param	parent		Reim[h̒ǉ̃m[hw肷
	 * @param	childName	ǉElementm[ĥ̖w肷
	 * @return	ǉ(q)Elementԋp
	 */
	public static Element append(Document doc, Element parent, String childName) {

		Element child = doc.createElement(childName);
		parent.appendChild(child);
		return child;
	}

	/**
	 * parentŎw肳ꂽm[h(q)Elementǉ
	 *
	 * @param	doc		DOM Documentw肷
	 * @param	parent	Reim[h̒ǉ̃m[hw肷
	 * @param	child	ǉElementm[hw肷
	 * @return	childԋp
	 */
	public static Element appendChild(Document doc, Element parent, Element child) {

		parent.appendChild(child);
		return child;
	}

	/**
	 * m[h쐬
	 *
	 * @param	doc				DOM Documentw肷
	 * @param	attributeName	m[ĥ̖w肷
	 * @param	value			m[h̒lw肷
	 * @return	쐬m[hԋp
	 */
	public static Attr createAttribute(Document doc, String attributeName, String value) {

		Attr attribute = doc.createAttribute(attributeName);
		attribute.setValue(value);

		return attribute;
	}

	/**
	 * w肳ꂽElementm[hɑm[h̒ǉs
	 *
	 * @param	doc				DOM Documentw肷
	 * @param	parent			m[hǉElementm[hw肷
	 * @param	attributeName	m[ĥ̖w肷
	 * @param	value			m[h̒lw肷
	 * @return	ǉꂽElementm[h(parent)ԋp
	 */
	public static Element insertAttribute(Document doc, Element parent, String attributeName, String value) {

		parent.setAttributeNode(createAttribute(doc, attributeName, value));

		return parent;
	}

	/**
	 * w肳ꂽElementm[hɑm[h̒ǉs
	 *
	 * @param	doc				DOM Documentw肷
	 * @param	parent			m[hǉElementm[hw肷
	 * @param	attributes		ǉ鑮m[h̔zw肷
	 * @return	ǉꂽElementm[h(parent)ԋp
	 */
	public static Element insertAttribute(Document doc, Element parent, Attr[] attributes) {

		if (attributes != null) {
			for (int i = 0; i < attributes.length; i++) {
				parent.setAttributeNode(attributes[i]);
			}
		}

		return parent;
	}

	/**
	 * w肳ꂽElementm[hɑm[h̒ǉs
	 *
	 * @param	doc				DOM Documentw肷
	 * @param	parentName		m[hǉElementm[h𖼏̂w肷
	 * @param	attributes		ǉ鑮m[h̔zw肷
	 * @return	ǉꂽElementm[h(parent)ԋp
	 */
	public static Element insertAttribute(Document doc, String parentName, Attr[] attributes) {

		Element parent = doc.createElement(parentName);

		if (attributes != null) {
			for (int i = 0; i < attributes.length; i++) {
				parent.setAttributeNode(attributes[i]);
			}
		}

		return parent;
	}

	/**
	 * w肳ꂽm[houtŎw肳ꂽResult֏o͂
	 *
	 * @param	node				o͂m[hw肷
	 * @param	omitXMLDeclaration	XML錾t^邩ǂw肷
	 *								ȗꍇtrueAȗȂꍇfalsew肷
	 * @param	encoding			GR[fBOw肷Bnullw肵ꍇ͏ȗB
	 *								(UTF-8ŃGR[fBOs)
	 * @param	out					o͐ResultŎw肷
	 */
	public static void output(Node node, boolean omitXMLDeclaration, String encoding, Result out)
		throws TransformerConfigurationException, TransformerException {

		Transformer transformer = TransformerFactory.newInstance().newTransformer();

		Properties prop = new Properties();

		prop.setProperty(OutputKeys.METHOD, "xml");
		prop.setProperty(OutputKeys.VERSION, "1.0");
		if (encoding != null) {
			prop.setProperty(OutputKeys.ENCODING, encoding);
		}
		prop.setProperty(OutputKeys.OMIT_XML_DECLARATION, (omitXMLDeclaration) ? "yes" : "no");
		prop.setProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperties(prop);

		transformer.transform(new DOMSource(node), out);
	}

	/**
	 * w肳ꂽXMLt@CoutŎw肳ꂽResult֏o͂
	 *
	 * @param	file				o͂XMLt@Cw肷
	 * @param	omitXMLDeclaration	XML錾t^邩ǂw肷
	 *								ȗꍇtrueAȗȂꍇfalsew肷
	 * @param	encoding			GR[fBOw肷Bnullw肵ꍇ͏ȗB
	 *								(UTF-8ŃGR[fBOs)
	 * @param	out					o͐ResultŎw肷
	 */
	public static void output(File file, boolean omitXMLDeclaration, String encoding, Result out)
		throws TransformerConfigurationException, TransformerException {

		Transformer transformer = TransformerFactory.newInstance().newTransformer();

		Properties prop = new Properties();

		prop.setProperty(OutputKeys.METHOD, "xml");
		prop.setProperty(OutputKeys.VERSION, "1.0");
		if (encoding != null) {
			prop.setProperty(OutputKeys.ENCODING, encoding);
		}
		prop.setProperty(OutputKeys.OMIT_XML_DECLARATION, (omitXMLDeclaration) ? "yes" : "no");
		prop.setProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperties(prop);

		transformer.transform(new StreamSource(file), out);
	}
}
