//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	CommunicationModuleWrapper
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;
import java.util.Hashtable;

import jp.co.ntt.lms.lo.scorm.kernel.exception.CommunicationModuleWrapperException;

/**
 *	APIAdapterWrapper<BR>
 *	APIA_v^̉zNX<BR>
 */
public abstract class CommunicationModuleWrapper {
	/**
	 * Activity
	 */
	protected Activity activity;

	/**
	 * ftHgRXgN^ <BR>
	 */
	public CommunicationModuleWrapper() {}

	public CommunicationModuleWrapper(Activity activity) {
		this.activity = activity;
	}
	/**
	 * Activityݒ肷<BR>
	 *
	 * @param	 activity	 ANeBreB<BR>
	 */
	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	/**
	 * Activity擾<BR>
	 *
	 * @return	ANeBreB<BR>
	 */
	public Activity getActivity() {
		return activity;
	}

	/**
	 * <BR>
	 *
	 * @param	initialParameter	p[^BHashtableɂ͈ȉ2L[K{ł<BR>
	 *					̃L[͔hNXKvȂ̂ݒ肷<BR><BR>
	 *
	 *					userID	   [UID<BR>
	 *					userName   [U<BR>
	 *
	 * @param	savedValue	ۑꂽf[^BȌԂ𕜌ׂɎgp<BR>
	 *						ۑf[^݂Ȃꍇnullw肷<BR>
	 *						ۑf[^̌`Ee͔hNXŗL̃tH[}bgƂȂ
	 */
	protected abstract void initialize(Hashtable initialParameter, String savedValue)
		throws CommunicationModuleWrapperException;

	/**
	 * f擾<BR>
	 *
	 * @return	ۑf[^<BR>
	 */
	protected abstract String save() throws CommunicationModuleWrapperException;

	/**
	 * I<BR>
	 */
	protected abstract void terminate() throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBlL^tOݒ肷<BR>
	 *
	 * @param  objectiveID wKڕWID<BR>
	 * @param  status BԂw肷(true:L / false:)<BR>
	 */
	protected abstract void setObjectiveProgressStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBԗL^tO擾<BR>
	 *
	 * @param  objectiveID wKڕWID<BR>
	 * @return wKڕW̗L^<BR>
	 */
	protected abstract Boolean getObjectiveProgressStatus(String objectiveID)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBԂݒ肷<BR>
	 *
	 * @param  objectiveID wKڕWID<BR>
	 * @param  status iԂw肷(true: / false:)<BR>
	 */
	protected abstract void setObjectiveSatisfiedStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBԂ擾<BR>
	 *
	 * @param	objectiveID wKڕWID<BR>
	 * @return	wKڕWB<BR>
	 */
	protected abstract Boolean getObjectiveSatisfiedStatus(String objectiveID)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBlL^tOݒ肷<BR>
	 *
	 * @param objectiveID wKڕWID<BR>
	 * @param status Bl̗L^ݒ肷<BR>
	 */
	protected abstract void setObjectiveMeasureStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBlL^tO擾<BR>
	 *
	 * @param objectiveID wKڕWID<BR>
	 * @return wKڕWBl̗L^<BR>
	 */
	protected abstract Boolean getObjectiveMeasureStatus(String objectiveID)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBl(K)ݒ肷<BR>
	 *
	 * @param	 objectiveID wKڕWID<BR>
	 * @param	 value wKڕWBl9.9999`(-1`1)BigDecimalŎw肷<BR>
	 */
	protected abstract void setObjectiveNormalizedMeasure(String objectiveID, BigDecimal value)
		throws CommunicationModuleWrapperException;

	/**
	 * wKڕWBl(K)擾<BR>
	 *
	 * @param	 objectiveID wKڕWID<BR>
	 * @return	 wKڕWBl(K)<BR>
	 */
	protected abstract BigDecimal getObjectiveNormalizedMeasure(String objectiveID)
		throws CommunicationModuleWrapperException;

	/**
	 * wKԗL^tO̐ݒ<BR>
	 *
	 * @param	status wKԗL^tO<BR>
	 */
	protected abstract void setAttemptProgressStatus(boolean status)
		throws CommunicationModuleWrapperException;

	/**
	 * wKԗL^tO̎擾<BR>
	 *
	 * @return wKԂ̗L^<BR>
	 */
	protected abstract Boolean getAttemptProgressStatus() throws CommunicationModuleWrapperException;

	/**
	 * wKԂݒ肷<BR>
	 *
	 * @param	 value ( 1.0`0.0 )w肷<BR>
	 */
	protected abstract void setAttemptCompletionAmount(BigDecimal value)
		throws CommunicationModuleWrapperException;

	/**
	 * wK()ݒ肷<BR>
	 *
	 * @return	wK( 1.0`0.0 )Ŏw<BR>
	 */
	protected abstract BigDecimal getAttemptCompletionAmount() throws CommunicationModuleWrapperException;

	/**
	 * wKԂݒ肷<BR>
	 *
	 * @param	 status Ԃw肷(true: / false:)<BR>
	 */
	protected abstract void setAttemptCompletionStatus(boolean status)
		throws CommunicationModuleWrapperException;

	/**
	 * wKԂݒ肷<BR>
	 *
	 * @return	wK<BR>
	 */
	protected abstract Boolean getAttemptCompletionStatus() throws CommunicationModuleWrapperException;
}
