/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ManifestFactory
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.engine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManifestFactory implements Runnable {
	/** LbV̓ꕨ */
	private static HashMap cacheHolder = new HashMap();

	/** LbV̕ێ(msec) */
	private static long preserveTime;

	/** B̎g */
	private static ManifestFactory self;

	/** LbVjXbh */
	private static Thread discarderThread;

	static {
		try {
			// SGLbVێԂ擾
			String value = SG.get("CacheManifestMinutes");

			// 擾łꍇmsecɒAvpeB֐ݒ肷
			if (value != null) {
				try {
					preserveTime = Long.parseLong(value) * 60 * 1000;
				}
				catch (Exception ex) {
					Debug.write(ex);

					preserveTime = 0;
					ex.printStackTrace(System.out);
				}
			}

			// g쐬
			new ManifestFactory();
		}
		catch (Exception ex) {
			Debug.write(ex);

			preserveTime = 0;
			ex.printStackTrace(System.out);
		}
	}

	/**
	 * cacheHolderɊi[Item
	 */
	private static class CacheItem {
		/** j */
		private long discardTime;

		/** LbVĂCachedNode */
		private CachedNode node;

		/** LbVĂCachedNodeDOM Document */
		private Document doc;

		/**
		 * jݒ肷
		 *
		 * @param discardTime	j
		 */
		private void setDiscardTime(long discardTime) {
			this.discardTime = discardTime;
		}

		/**
		 * j擾
		 *
		 * @return j
		 */
		private long getDiscardTime() {
			return discardTime;
		}

		/**
		 * CachedNodeݒ肷
		 *
		 * @param node	CachedNode
		 */
		private void setNode(CachedNode node) {
			this.node = node;
		}

		/**
		 * CachedNode擾
		 *
		 * @return CachedNode
		 */
		private CachedNode getNode() {
			return node;
		}

		/**
		 * Documentݒ肷
		 *
		 * @param doc	Document
		 */
		private void setDocument(Document doc) {
			this.doc = doc;
		}
	}

	/**
	 * ftHgRXgN^
	 */
	private ManifestFactory() {
		self = this;

		if (preserveTime > 0) {
			discarderThread = new Thread(this);
			discarderThread.setDaemon(true);
			discarderThread.start();
		}
	}

	/**
	 * manifestIDAΉmanifestCachedNode擾<br>
	 * 1.manifestIDŎw肳ꂽ}jtFXgLbV(cacheHolder)ɑ݂Ȃꍇ
	 * manifestNodep[^CachedNode쐬LbVɒǉB݂ꍇ́A
	 * 擾łLbVԋpB<br>
	 * 2.LbVɑ݂ȂꍇAmanifestNodeŎw肳ꂽNode<sequencing>m[h
	 * 1ȏ㑶݂邩ǂ`FbNA1݂Ȃꍇ́A<sequencing>m[h
	 * ̍쐬sAS<item>m[hɈȉ̓eǉB<br>
	 * &nbsp;&nbsp;<pre><imsss:sequencing></pre><br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;<pre><imsss:controlMode flow="true" choice="true"/></pre><br>
	 * &nbsp;&nbsp;<pre></imsss:sequencing></pre><br>
	 *
	 * @param manifestID	}jtFXgID
	 * @param manifestNode	}jtFXg̃m[h
	 * @param doc			manifestNodẽI[ihLg
	 * @return manifestNodep[^Ŏw肳ꂽNodeCachedNodeԋp
	 */
	public static CachedNode getCachedNode(String manifestID, Node manifestNode, Document doc)
		throws IOException, ParserConfigurationException, SAXException, TransformerException {

		synchronized (self) {
			CacheItem item = null;

			// LbVCachedNode擾
			if (preserveTime > 0) {
				item = (CacheItem)cacheHolder.get(manifestID);
			}

			// LbVɑ݂Ȃꍇ
			if (item == null) {
				// LbVɒǉ
				item = new CacheItem();

				item.setNode(new CachedNode(manifestNode));
				item.setDocument(doc);
				cacheHolder.put(manifestID, item);

				// <sequencing>^O1ȏ㑶݂邩ǂ`FbN
				CachedNode sequencingNode =
					item.getNode().selectSingleNode("organizations/organization//sequencing", false);

				// <sequencing>^O1ȏ㑶݂Ȃꍇ
				if (sequencingNode == null) {
					// S<item>^O擾
					CachedNode[] itemNodes =
						item.getNode().selectNodeList(
							"organizations/organization|organizations/organization//item",
							false);

					// 擾łS<item>^O<sequencing>^Oǉ
					if (itemNodes != null) {
						Document complementSequencing;

						// JX^}CYꂽ{^oxslւ̃tpX쐬
						StringBuffer complementSequencingFileURL = new StringBuffer();

						complementSequencingFileURL.append(SG.get("ContentsBaseURL"));
						complementSequencingFileURL.append(manifestID);
						complementSequencingFileURL.append(File.separator);
						complementSequencingFileURL.append("_customize");
						complementSequencingFileURL.append(File.separator);
						complementSequencingFileURL.append("ComplementSequencing.xml");

						String complementSequencingFilename = complementSequencingFileURL.toString();

						if (new File(complementSequencingFilename).exists()) {
							BufferedInputStream bis =
								new BufferedInputStream(new FileInputStream(complementSequencingFilename));

							try {
								complementSequencing = XMLUtil.createDocument(bis, false);
							}
							finally {
								bis.close();
							}

							for (int i = 0; i < itemNodes.length; i++) {
								itemNodes[i].getNode().appendChild(
									doc.importNode(complementSequencing.getDocumentElement(), true));
							}
						}
					}
				}
				// <sequencing>^O1ȏ㑶݂ꍇ
				else {
					// <sequencingCollection>/<sequencing>QƂĂ`Ă<sequencing>
					// }[Ws
					Node[] referedSequencingsNodes =
						XPathUtil.selectSimpleNodeList(manifestNode, "sequencingCollection/sequencing");

					if ((referedSequencingsNodes != null) && (referedSequencingsNodes.length > 0)) {
						Node organizationNode =
							item
								.getNode()
								.selectSingleNode("organizations/organization[@identifier=../@default]")
								.getNode();

						for (int i = 0; i < referedSequencingsNodes.length; i++) {
							String referedSequencingID =
								XPathUtil.selectSingleChildNode(referedSequencingsNodes[i], "@ID").getNodeValue();

							Node[] referingSequencingsNodes =
								XPathUtil.selectNodeList(
									manifestNode,
									"organizations/organization//sequencing[@IDRef='" + referedSequencingID + "']");

							for (int j = 0; j < referingSequencingsNodes.length; j++) {
								Node[] referedSequencingChildNodes =
									XPathUtil.selectChildNodeList(referedSequencingsNodes[i], "*");

								for (int k = 0; k < referedSequencingChildNodes.length; k++) {
									Node node =
										XPathUtil.selectSingleChildNode(
											referingSequencingsNodes[j],
											XPathUtil.getLocalName(referedSequencingChildNodes[k]));

									if (node == null) {
										referingSequencingsNodes[j].appendChild(
											referedSequencingChildNodes[k].cloneNode(true));
									}
								}
							}
						}
					}
				}
			}

			// LbVjݒ肷
			item.setDiscardTime(System.currentTimeMillis() + preserveTime);

			// LbVjXbhɃLbV̍XVʒm
			self.notify();

			// CachedNodeԋp
			return item.getNode();
		}
	}

	/**
	 * LbVjXbh<br>
	 * SGŎw肳ꂽԂ߂ăANZXsȂCachedItemcacheHolder菜
	 */
	public void run() {
		try {
			ArrayList discardItems = new ArrayList();
			long wackupMillis;

			synchronized (self) {
				while (true) {
					wackupMillis = Long.MAX_VALUE;

					// LbVSčXVAj߂ĂItem̃Xg쐬
					for (Iterator keys = cacheHolder.keySet().iterator(); keys.hasNext();) {
						Object key = keys.next();
						CacheItem item = (CacheItem)cacheHolder.get(key);

						if (item.getDiscardTime() <= System.currentTimeMillis()) {
							discardItems.add(key);
						}
						else {
							if (item.getDiscardTime() < wackupMillis) {
								wackupMillis = item.getDiscardTime();
							}
						}
					}

					// j߂ĂItemLbV폜
					for (int i = 0; i < discardItems.size(); i++) {
						cacheHolder.remove(discardItems.get(i));
					}

					discardItems.clear();

					// ̔jCxg܂őҋ@
					if (cacheHolder.size() <= 0) {
						self.wait();
					}
					else {
						wackupMillis -= System.currentTimeMillis();

						if (wackupMillis > 0) {
							self.wait(wackupMillis);
						}
					}
				}
			}
		}
		catch (Exception ex) {
			Debug.write(ex);

			ex.printStackTrace(System.out);
		}
	}
}
