/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//@\ 
//			 CMI f[^f@m[hNX
//	ύX
//				2003.11.26	lcg  VK쐬		
//
package jp.co.ntt.lms.lo.scorm.cbtcom;

import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.Iterator;
//import java.util.StringTokenizer;

/**
 * CMI f[^f@vfNX
 * @author lcg
 */
public class CMINode extends CMIElement {
	
	/**
	 * lobt@
	 */
	protected CMIValueBuffer m_value = null;
   
	/**
	 * qGgxN^
	 */
	protected Vector m_children = null;
   
	/**
	 * Jg
	 */
	protected int m_cur;
   
	protected String m_childrenStr = null;
   
	/**
     * CMINode NX̏<br>
     * @param proto vg^CvEf[^
     */
	public CMINode(CMIElementProto proto) {
		super(proto);
		m_children = new Vector();
		m_value = new CMIValueBuffer();
		initialize();
   }
   
	/**
     * CMINode NX̏<br>
     */
	public CMINode() {
		m_children = new Vector();
		m_value = new CMIValueBuffer();
	}
 
	/**
	 * NX̏I <BR>
	 */
	public void finalize() {
		m_childrenStr = null;
	}
	   
	/**
     * qGgǉ<br>
     * @param child qGg
     */
	public void addChild(CMIElement child) {
		m_children.add( child );
		child.setParent(this);
		child.incrementLinkCount();
   }
   
	/**
     * qGgǉ<br>
     * @param child qGg
     */
	public void addChildLink(CMIElement child) {
		m_children.add( child );
		child.incrementLinkCount();
	}
   
	/**
     * vgf[^Ɏq̃CX^X쐬<br>
     * @param proto vgf[^
     */
	public void makeChildren(CMIElementProto proto) {
		if ( proto == null ) {
   			return;
   		}
	    Vector vtrTable = proto.getMemberTable();
	    if ( vtrTable == null ) {
	    	return;
	    }
	    Iterator iterator = vtrTable.iterator();
	    while ( iterator.hasNext() ) {
	 		CMIElementProto memberProto = (CMIElementProto)iterator.next();
			CMIUtil.makeInstance(memberProto, this);
	    }
		m_proto = proto;
	}
   
	/**
     * vgf[^Ɏq̃CX^X쐬B<br>
     * @param proto CMIElementProto vgf[^
     */
	public void makeGlobalChildren(CMIElementProto proto) {
		if ( proto == null ) {
			return;
		}
		Vector vtrTable = proto.getMemberTable();
		if ( vtrTable == null ) {
			return;
		}
		Iterator iterator = vtrTable.iterator(); 
		while ( iterator.hasNext() ) {
			CMIElementProto memberProto = (CMIElementProto)iterator.next();
			CMIUtil.makeGlobalInstance(memberProto, this);
		}
		m_proto = proto;
	}
   
	/**
     * qGg폜B<br>
     */
	public void deleteChild() {
	 	// XgNA
		m_children.clear();
	}
   
	/**
     * qGg擾B<br>
     * @param index qGg̃CfbNX
     */
	public CMIElement getChild(int index) {
		CMIElement child = null;
		if ( m_children == null ) {
			return null;
		}
		if ( index < m_children.size() ) {
			child = (CMIElement)m_children.get( index );
		}
		return child;
	}
   
	/**
     * qGg擾B<br>
     * @param name qGg̖O
     */
	public CMIElement getChild(String name) {
	   	if ( m_children.size() == 0 || null == name || "".equals( name )) {
	   		return null;
	   	}
		CMIElement child = null;
		
		Iterator iterator = m_children.iterator();
		while ( iterator.hasNext() ){
			CMIElement  childTmp = ( CMIElement )iterator.next();
			String strName = childTmp.getName();
			if ( name.equals( strName ) ) {
				child = childTmp;
				break;
			}
		}
	    return child;
	}
   
	/**
     * qGg擾B<br>
     * @param name qGg̖O
     */
	public CMIElement getNChild(String name) {
	   	if ( null == name || "".equals(name) ){
	   		return null;
	   	}
		CMIParameterPath param = new CMIParameterPath(name);
		String strChildName = param.popFirstElement();
		CMIElement child = null;
		Iterator iterator = m_children.iterator();
		while ( iterator.hasNext() ) {
			CMIElement node = ( CMIElement ) iterator.next();
			String strName = node.getName();
			if ( strChildName.equals( strName ) ) {
				String strPath = param.getPath();
				if ( null == strPath || "".equals( strPath )) {
					child = node;
				} else {
					child = ((CMINode)node).getNChild( strPath );
				}
				break;
			}	
		}
		return child;
	}
   
	/**
	 * qGg擾B<br>
	 * @return int qGg
	 */
	public int getChildCount() {
	   	return m_children.size();
	}
   
	/**
	 * L[[hŎqGg擾B<br>
	 * @param keyWord String L[[h
	 * @return CMIElement qGg
	 */
	public CMIElement getChildByKeyWord(String keyWord) {
	    if ( null == keyWord || "".equals( keyWord ) ) {
	    	return null;
	    }
		CMIElement child = null;
	    Iterator iterator = m_children.iterator();
		keyWord = keyWord.toLowerCase();
	    while ( iterator.hasNext() ) {
			CMIElement element = (CMIElement)iterator.next();
			String strKeyWord = element.getKeyWord();
			strKeyWord = strKeyWord.toLowerCase();
			if ( keyWord.equals( strKeyWord )  ) {
				child = element;
				break;
			}
	    }
	    return child;
	}
   
	/**
	 * qGg̖̃Xg擾B<br>
	 * @return String qGg
	 */
	public String getChildList() {
   	
		CMIElement child = null;
		
		StringBuffer nameList = new StringBuffer();
		
		//qGg̖
		String strChildName = null;
		
		//f[^f
		String strNodeName = getName();
		
		//o[W
		int intVersion = getVersion();
		
		//nameListւ̒lǉtO
		boolean blnAddListFlag = false;

		boolean blnNumber = CMIUtil.isNumber( strNodeName );
		
		// m[h n ̏ꍇAeGg̖O擾
		if ( blnNumber ) {
			strNodeName = m_parent.getName();
		}
		Iterator iterator = m_children.iterator();
		while ( iterator.hasNext() ) {
			blnAddListFlag = true;
			child = ( CMIElement ) iterator.next();
			strChildName = child.getName();
			//f[^fcmi.objectives.n ̏ꍇ
			if ( "objectives".equals( strNodeName ) ) {
				//o[W3.4ȍ~ł΁Acmi.objectives.n.attempts
				// f[^f݂͑Ȃ
				if ( intVersion >= 3400 ) {
					if ( "attempts".equals( strChildName ) ) {
						blnAddListFlag = false;
					}
				}
				// o[W3.4ȑOł΁Acmi.objectives.n.score
				// cmi.objectives.n.status ̊ef[^f݂͑Ȃ
				else {
					if ( "score".equals( strChildName ) || "status".equals( strChildName ) ) {
						blnAddListFlag = false;
					}
				}
			}
			//f[^f cmi.evaluation ̏ꍇ
			else if ("evaluation".equals( strNodeName ) ) {
			// o[W3.4ȑÓAcmi.evaluation.[lesson_id, date] 
			// ݂Ȃ̂ŁAnameListɒǉȂ
				if ( intVersion < 3400 ) {
					if ( "lesson_id".equals( strNodeName ) 
 						|| "date".equals( strNodeName ) ) {
						blnAddListFlag = false;
	 				}
 				}
			 }
			if ( blnAddListFlag ) {
				if ( nameList.length() > 0 ) {
					nameList.append( "," );
				}
				nameList.append( strChildName );
			}
		}
    	return nameList.toString();
	}
   
	/**
	 * 擪̎qGg擾B<br>
	 * @return CMIElement 擪̎qGg
	 */
	public CMIElement getTopChild() {
		CMIElement child = null;
		m_cur = m_children.size();
		if ( 0 < m_cur ) {
			child = ( CMIElement ) m_children.get( 0 ); 
		}
		return child;
	}
   
	/**
	 * Ō̎qGg擾B<br>
	 * @return CMIElement Ō̎qGg
	 */
	public CMIElement getLastChild() {
		CMIElement child = null;
		m_cur = m_children.size();
		if ( m_cur > 0 ) {
			child = ( CMIElement ) m_children.get( m_cur - 1 ); 
		}
		return child;
	}
   
	/**
	 * O̎qGg擾B<br>
	 * @return CMIElement O̎qGg
	 */
	public CMIElement getPrevChild() {
		CMIElement child = null;

		if ( 0 < m_cur-1 && m_cur-1 <= m_children.size() ) {
			m_cur--;
			child = ( CMIElement )m_children.get( m_cur-1 );
		} else {
			m_cur = 0;
		}
		return child;
	}
   
	/**
	 * ̎qGg擾B<br>
	 * @return CMIElement ̎qGg
 	 */
	public CMIElement getNextChild() {
		CMIElement child = null;
	
		if ( 0 < m_cur+1 && m_cur+1 <= m_children.size() ) {
			m_cur++;
			child = ( CMIElement )m_children.get( m_cur - 1 );
		}
		else {
			m_cur = 0;
		}
		return child;
	}
   
	/**
	 * qGg̃VACYsAVACY𐶐B<br>
	 * @param buf StringBuffer VACYf[^
     */
	protected void serializeChildren(StringBuffer buf) {
		
		boolean blnFirstTime = true;
		CMIElement child = null;
		Iterator iterator = m_children.iterator();
		
		while ( iterator.hasNext() ) {
			child = ( CMIElement )iterator.next();
			if ( child != null ) {
				if ( child.isSerializable() ) {
					if ( blnFirstTime ) {
						blnFirstTime = false;
					} else {
						buf.append( "&" );
					}
					child.serialize(buf);
				} else {
					continue;
				}
			} else {
				//program error;
			}
		}
	}
   
	/**
	 * ʂ̃lXglĒloB<br>
	 * @param inString String ͕   O=l&O=l&...
	 * @param head int l̐擪ʒu
	 * @param value StringBuffer ol
	 * @return int P[V
	 */
   	protected int getNestedValue(String inString, int head, StringBuffer value) {
		int intTail = 0;
		
		String strIn = inString;
		int intEnd = strIn.length();
		String strValue = null;
		value.delete(0,value.length());
		try {		
			if ( strIn.charAt(head) != '(') {
				intTail = strIn.indexOf('&', head);
				if ( -1 == intTail ) {
					//headȍ~oB
					strValue = inString.substring(head);	
					head = intTail;
				} else {// inString[intTail] == '&'
					strValue = inString.substring(head, intTail );
					head = intTail + 1;
					if ( inString.length() <= head ) {
						head = -1;
					}
				}
			} else {
				int intDepth = 1;	// ʂ̐[
				intTail = head;
				while (true) {
				int intLeft = strIn.indexOf("(", intTail + 1);
				int intRight = strIn.indexOf(")", intTail + 1);
				if( intLeft != -1) {
					if(intRight != -1) {
						intTail = (intLeft < intRight) ? intLeft : intRight;
					}else{
						intTail = intLeft;
					}
				}else{
					if(intRight == -1) {
						intTail = -1;
					}else{
						intTail = intRight;
					}
				}

				if ( intTail == -1 ) {
					// error
					String strPath = null;
					strPath = getPath();
					value.append("CMINode.getNestedValue: Unexpected end of data");
					value.append(strPath);
					throw new Exception("UnexpectedData");
				} else if ( strIn.charAt(intTail) == '(' ) {
					intDepth++;
				} else if ( strIn.charAt(intTail) == ')' ) {
					intDepth--;
					if (intDepth == 0) {
						break;
					}
				}
			}
			// inString[head] == '('
			// inString[intTail] == ')'
			head++;
			strValue = strIn.substring(head, intTail );
			head = intTail + 1;
			if ( head < strIn.length() ) {
				if ( strIn.charAt(head) == '&') {
					head++;
				}
			}
			if ( head >= strIn.length() ) {
				head = -1;
			}
		} 
		}catch (Exception Ex){
			if("UnexpectedData".equals(Ex.getMessage())) {
				setError(CMIError.ERR_PROGRAM_ERROR);
				setVendorError(getVendorData("CMINode.getNestedValue", this));
				head = -1;
			}
		}
		value.append(strValue);
		return head;
	}
   
	/**
	 * [Jlݒ肷B<br>
	 * @param name String O
	 * @param value String ݒl
	 * @param doCheck boolean `FbNtO
	 */
	public void localSetValue(String name, String value, boolean doCheck) {
		CMIParameterPath param = new CMIParameterPath( name );
		
		String strTheName = param.popFirstElement();
		
		String strNodeName = getName();

		// o[W̎擾
		int intVersion = getVersion();

		if ( strTheName.equals( strNodeName ) ) {
			
			// Ym[h̏ꍇ
			String strChildName = param.getNthElement(1);
			
			if ( strChildName == null || "".equals(strChildName) ) {
				// pXw肪̏ꍇ
				if  ( isWritable( ) ) {
					if ( 3400 <= intVersion ) {
						// ił́AKiɂf[^^`FbNsȂBKiɂ߂B
						//LocalValue ɒlZbg
						m_value.setLocalValue(value);	
						//NULL tOUɂ
						m_value.setLocalIsNull(false);
						//setValue ɂݒtO^ɂ
						m_bySetValue	= true;
					}
					// o[W3.4ȑȌꍇ́Af[^^̃`FbNsȂ
					else {
						//LocalValue ɒlZbg
						m_value.setLocalValue(value);
						//NULL tOUɂ
						m_value.setLocalIsNull(false);
						//setValue ɂݒtO^ɂ
						m_bySetValue	= true;
					}
				} else {
					// ݋Ȃ

					// o[WɂG[ύX
					// o[W3.4ȍ~̏ꍇ
					if ( 3400 <= intVersion ) {
						// GgL[[h`FbN
						if ( checkParamKeyword( strTheName ) ) {
							// G[FGg̓L[[h
							setError( CMIError.ERR_INVALID_SETVALUE_CMI_KEYWORD);
						} else {
							// G[ F ǂݍݐp̃GgɒlZbg悤Ƃ
							setError( CMIError.ERR_ELEMENT_IS_READ_ONLY );
						}
					}
					// o[W3.4ȑȌꍇ
					else {
						// G[(CMI) G[(RF݋Ȃ)
						setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
					}
					setVendorError(getVendorData("CMINode.localSetValue1", this));
				}
			} else {
				// pXw肪cĂꍇ
				CMIElement child = getChild( strChildName );

				if ( child != null ) {
					// pXw̎qGgꍇ
					//qsetValueR[
					child.localSetValue(param.getPath(), value, doCheck);
				} else {
					// qGg̃pXw肪 "_children" "_count" "_version"
					// ꂩłꍇ
					if ( "_children".equals(strChildName) || "_count".equals(strChildName) ||
					   "_version".equals(strChildName)) {
						// G[R[h͊gĎgp
						// KĩG[R[hɂẮA܂API̋Kił
						setError( CMIError.ERR_ELEMENT_IS_READ_ONLY );
					} else {
						// pXw̎qGgȂꍇ
						// G[(CMI) G[(RFpXw肵)
						setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
					}
					setVendorError( getVendorData( "CMINode.localSetValue2", this ) );
				}
			}
		} else {
			// Ggw肳ĂȂꍇ
			// G[(CMI) G[(RFpXw肵)
			setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
			setVendorError( getVendorData("CMINode.localSetValue3", this) );
		}
	}
   
	/**
	 * [Jlݒ肷B<br>
	 * @param name String pX
	 * @param value String ݒl
	 */
	public void localSetValue(String name, String value) {
		localSetValue( name, value, true );
	}
   
	/**
	 * [Jl擾B<br>
	 * @param name String pX
	 * @return String 擾f[^
	 */
	public String localGetValue(String name) {
		return localGetValue( name, true );
	}
   
	/**
	 * [Jl擾B<br>
	 * @param name String pX
	 * @param doCheck boolean `FbNtO
	 * @return String 擾f[^
	 */
	public String localGetValue(String name, boolean doCheck) {
   	
		String strRet = null;
		CMIParameterPath param = new CMIParameterPath( name );
		String strTheName = param.popFirstElement();
		String strNodeName = getName();
		
		if ( strTheName.equals( strNodeName ) ) {
			
			String strChildName = param.getNthElement(1);
			if  ( strChildName == null || "".equals(strChildName) ) {
				if ( isReadable() ) {
					// ǂݍ݋̏ꍇ
					if ( isSession() ) {
						// ZbV̏ꍇ
						if ( !m_value.getLessonIsNull() ) {
							//LessonValue Ԃ
							strRet = m_value.getLessonValue();
						}
					} else {
						// Œ̏ꍇ
						if ( !m_value.getLessonIsNull() ) {
							//LessonValue Ԃ
							strRet = m_value.getLessonValue();
						} else {
							if ( !m_value.getLocalIsNull() ) {
								//LocalValue Ԃ
								strRet = m_value.getLocalValue();
							}
						}
					}
				} else {
					// ǂݍ݋Ȃ̏ꍇ

					// o[W̎擾
					int intVersion = getVersion();

					// o[WɂG[ύX
				
					// o[W3.4 ȍ~̏ꍇ
					if ( 3400 <= intVersion ) {
						// G[ F ݂̂݃G[
						setError(CMIError.ERR_ELEMENT_IS_WRITE_ONLY);
					}
					// o[W3.4ȑȌꍇ
					else {
						setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
					}
					setVendorError(getVendorData( "CMINode.localGetValue", this));
				}
			}
			else {
				if ( "_children".equals( strChildName ) ) {
					if ( m_parent != null && !m_parent.isArray() ) {
						// ezȂꍇ
						m_childrenStr = getChildList();
						strRet = m_childrenStr;
					} else {
						// ezꍇ
						setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
						setVendorError(getVendorData( "CMINode.localGetValue", this ) );
					}
				} else if ( "_version".equals( strChildName ) ) {
					// pX`FbN
					String strPath = null;
					strPath = getPath(  );
					if ( ("cmi.core").equals( strPath ) ) {
						strRet = m_CBT.getVersionStr();
					} else {
						setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
						setVendorError( getVendorData("CMINode.localGetValue", this ) );
					}
				} else if ( "_count".equals( strChildName ) ) {
					setError( CMIError.ERR_ELEMENT_NOT_AN_ARRAY );
					setVendorError( getVendorData( "CMINode.localGetValue" , this ) );
				} else {  // ʏ̒l
					CMIElement child = getChild(strChildName);
					if ( child != null ) {
						strRet = child.localGetValue(param.getPath(), doCheck);
					} else {
						setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
						setVendorError(getVendorData( "CMINode.localGetValue", this ) );
					}
				}
			}
		}
		else {
			// pXw̌
			setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
			setVendorError(getVendorData( "CMINode.localGetValue", this ) );
		}
		return strRet;
   }
   
	/**
     * localValue ̒lݒ肷B<br>
     * @param name String pX
     * @param value String l
     */
	public void setLocalValue(String name, String value) {
	
		if ( null == name || "".equals(name)) {
			if ( value != null ) {
				m_value.setLocalValue(value);
				m_value.setLocalIsNull(false);
			}
		} else {
			CMIParameterPath param = new CMIParameterPath( name );
			String strChildName = param.popFirstElement(  );
			CMIElement child = getChild( strChildName );
			
			if ( child != null ) {
				child.setLocalValue( param.getPath(), value);
			} else {
				setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
				setVendorError( getVendorData( "CMINode.setLocalValue", this));
			}
		}
	}
   
	/**
	 * localValue ̒lݒ肷B<br>
	 * @param value String ݒl
	 */
	public void setLocalValue( String value ) {
		m_value.setLocalValue(value);
		m_value.setLocalIsNull(false);
	}
   
	/**
	 * localValue ̒l擾B<br>
	 * @param name String pX
	 * @return String localValue l
	 */
	public String getLocalValue ( String name ) {
		String strValue = null;
		String strName = null;
		if ( name == null || "".equals(name) ) {
			strValue = m_value.getLocalValue();
		} else {
			CMIParameterPath param = new CMIParameterPath( name );
			String strChildName = param.popFirstElement();
			CMIElement child = getChild( strChildName );
			if ( child != null ) {
				strValue = child.getLocalValue( param.getPath() );
			} else {
				setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
				setVendorError( getVendorData( new String ( "CMINode.getLocalValue" ), this ) );
			}
		}

		return strValue;
	}
   
	/**
	 * localValue ̒l擾B<br>
	 * @return String localValue l
	 */
	public String getLocalValue() {
   		return m_value.getLocalValue();
	}
   
	/**
	 * localValue ̒lnullǂf<br>
	 * @return boolean ߂l
	 */
	public boolean getIsNullValue(){
		return m_value.getLocalIsNull();
	}

	/**
	 * lessonValue ̒lݒ肷B<br>
	 * @param value String ݒl
	 */
	public void setLessonValue(String value) {
		m_value.setLessonValue( value );
		m_value.setLessonIsNull( false );
	}
   
	/**
	 * lessonValue ̒lݒ肷B<br>
	 * @param name String pX
	 * @param value String l
	 */
	public void setLessonValue(String name, String value) {
		if ( name == null || "".equals(name) ) {
			m_value.setLessonValue( value );
			m_value.setLessonIsNull( false );
		} else {
			CMIParameterPath param = new CMIParameterPath(name);
			String strChildName = param.popFirstElement();
			CMIElement child = getChild( strChildName );
	
			if ( child != null ) {
				child.setLessonValue(param.getPath(), value);
			} else {
				setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
				setVendorError(getVendorData("CMINode.setLocalValue", this));
			}
		}
	}
   
	/**
	 * lessonValue ̒l擾B<br>
	 * @return String localValue l
	 */
	public String getLessonValue() {
		return m_value.getLessonValue();
	}
   
	/**
	 * lessonValue ̒l擾B<br>
	 * @param name pX
	 * @return String localValue l
	 */
	public String getLessonValue(String name) {
		String strValue = null;
		if ( null == name || "".equals(name) ) {
			strValue = m_value.getLessonValue();
		} else {
			CMIParameterPath param = new CMIParameterPath(name);
			String strChildName = param.popFirstElement();
			CMIElement child = getChild(strChildName);
	
			if ( child != null ) {
				strValue = child.getLessonValue(param.getPath());
			} else {
				setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
				setVendorError(getVendorData("CMINode.getLessonValue", this));
			}
		}
		return strValue;
	}
   
	/**
	 * localValue ̒lB<br>
	 */
	public void initLocalValue() {
		m_value.setLocalValue("");
		m_value.setLocalIsNull(true);
	}
   
	/**
	 * localValue ̒lB<br>
	 * @param value String localValue l
	 */
	public void initLocalValue(String value) {
		if ( value == null || "".equals(value) ) {
			m_value.setLocalValue("");
			m_value.setLocalIsNull(true);
		} else {
			CMIParameterPath param = new CMIParameterPath(value);
			String strChildName = param.popFirstElement();
			CMIElement child = getChild( strChildName );
			if ( child != null ) {
				child.initLocalValue( param.getPath() );
			} else {
				setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
				setVendorError(getVendorData("CMINode.initLocalValue", this));
			}
		}
	}
	
	/**
	 * lessonValue ̒lB<br>
	 * @param value String localValue l
	 */
	public void initLessonValue(String value) {
		if ( null == value || "".equals(value) ) {
			m_value.setLessonValue("");
			m_value.setLessonIsNull(true);
		} else {
			CMIParameterPath param = new CMIParameterPath(value);
			String strChildName = param.popFirstElement();
			CMIElement child = getChild(strChildName);

			if ( child != null ) {
				child.initLessonValue(param.getPath());
			} else {
				setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
				setVendorError(getVendorData("CMINode.initLessonValue", this));
			}
		}
	}
	
	/**
	 * lessonValue ̒lB<br>
	 */
	public void initLessonValue() {
		m_value.setLessonValue("");
		m_value.setLessonIsNull(true);
	}
   
	/**
	 * K{͍ڂ̃`FbNsB<br>
	 * @return boolean K{͂̏
	 */
	public boolean checkMandatory() {
   	
		if ( isMandatory() ) {
			// ͕K{̏ꍇ
			if ( !m_bySetValue && m_value.getLocalIsNull() ) {
				// G[
				setError( CMIError.ERR_INVALID_AURGUMENT_ERROR );
				setVendorError( getVendorData( "CMINode.initLessonValue", this ) );
				return false;
			}
		}
	
		int intChildCount = getChildCount();
		for ( int i = 0;  i < intChildCount; i++ ) {
			CMIElement child = getChild( i );
			if ( child != null ) {
				if ( !child.checkMandatory() ) {
					return false;
				}
			}
		}
		return true;
	}
   
	/**
	 * ftHglݒ肷B<br>
	 */
	public void setDefaultValue() {
   	
		if ( m_proto.getDefaultData() != null ) {
			m_value.setLocalValue(m_proto.getDefaultData());
			m_value.setLocalIsNull(false);
			//setValue ɂݒtO^ɂ
			m_bySetValue	= true;
		}
	
		int intChildCount = getChildCount();
		for ( int i = 0; i < intChildCount; i++ ) {
			CMIElement child = getChild( i );
			if ( child != null ) {
				child.setDefaultValue();
			}
		}
	}
   
	/**
	 * ZbV̑OsB<br>
	 */
	public void before_initialize() {
   		
		IBeforeInitializer beforeInitializer = m_proto.getBeforeInitializer();
		if ( beforeInitializer != null ) {
			//before_initializer \bho^Ăꍇ
			//\bhR[
			beforeInitializer.before_Initializer(this);
		} else {
			// before_initializer \bho^ĂȂꍇ
			if ( isSession() ) {
				// ZbV^Cv̏
				if ( !m_bySetValue ) {
					// setValue ɂXVȂ
					// LessonValue ̒lLocalValue ɃRs[
					if ( !m_value.getLessonIsNull() ) {
						m_value.setLocalValue( m_value.getLessonValue() );
					}
				} else {
					// setValue ɂXV
					//setValue ɂXVtOUɂ
					m_bySetValue = false;
				}
			} else {
				// ZbV^CvȊO(Œ^Cv)̏
				// 
			}

			//qGgSĂ̏OR[
			//qGg擾
			int intChildCount = m_children.size();
			CMIElement child = null;
			for ( int i = 0;  i < intChildCount; i++ ) {
				child = (CMIElement)m_children.get(i);
				child.before_initialize();
			}
		}
	}
   
	/**
     * ZbVsB<br>
     */
	public void initialize() {
		IInitializer initializer = m_proto.getInitializer();
		if ( initializer != null ) {
			//initializer \bho^Ăꍇ
			//\bhR[
			initializer.initializer(this);
		} else {
			// initializer \bho^ĂȂꍇ
			if ( isSession() ) {
				// ZbV^Cv̏
				// 
			} else {
				// ZbV^CvȊO(Œ^Cv)̏
				// 
			}

			// qGgSĂ̏R[
			int intChildCount = m_children.size();
			CMIElement child = null;
			for ( int i = 0;  i < intChildCount; i++ ) {
				child = (CMIElement)m_children.get(i);
				child.initialize();
			}
		}
	}
   
	/**
	 * lVACYf[^𐶐B<br>
	 * @param buf StringBuffer VACYf[^
	 */
	public void serialize(StringBuffer buf) {
   		if ( buf == null ) {
   			buf = new StringBuffer();
   		}
   		String strName = getName();
   		buf.append(strName);
   		buf.append("=(");
		if ( isSerializable() ) {
			// serializableł΁Am[ĥ̒lo͂B
			String strSerializeValue = serializeCMIValue();
			buf.append( strSerializeValue );
			buf.append(";");
		}
		//qGg̃VACYs
		serializeChildren(buf);
		buf.append(  ")" );
	}
   
	/**
	 * VACYf[^𓀂Alݒ肷B<br>
	 * @param inString String VACYf[^
	 */
	public void deserialize(String inString) {
	
		//O
		String strName = null;
		
		//l
		String strValue = null;
		
		StringBuffer bufValue = new StringBuffer();
		
		String strChildrenValue = null;
			
		//serializableł΁Am[ĥ̒l擾ݒ肷B
		if ( isSerializable() ) {
			
			CMITokenizer tokenizer = new CMITokenizer( inString, ";" );


			
			//m[ĥ̒l擾
			String strOwnValue = tokenizer.nextToken();
			
			//q̒l擾
			int intOwnEnd = inString.indexOf(";");
			if(intOwnEnd == -1) {
				strChildrenValue = "";
			}else{
				strChildrenValue = inString.substring( intOwnEnd+1);
			}
			//m[ĥ̒lݒ肷
			deserializeCMIValue(strOwnValue);
			
		} else {
			//q̒l擾
			strChildrenValue = inString;
		}
		
		if(strChildrenValue == null || "".equals(strChildrenValue)){
			setError( CMIError.ERR_PROGRAM_ERROR );
			setVendorError( getVendorData(  "CMINode.deserialize" , this ) );
			return;
		}
		//q̒lݒ肷
		int intHead = 0;
		int intTail = 0;
		while ( intHead != -1 ) {
			// vff[^̖OƒloB
			intTail = strChildrenValue.indexOf( "=", intHead );
			if ( intTail == -1 ) {
				setError( CMIError.ERR_PROGRAM_ERROR );
				setVendorError( getVendorData(  "CMINode.deserialize" , this ) );
				break;
			} else {
				strName = strChildrenValue.substring( intHead, intTail );
				//'=' ̎擾
				intHead = getNestedValue( strChildrenValue, intTail + 1, bufValue );
			}
			CMIElement child = getChild( strName );
			if ( child != null ) {
				// ʃoɎw肳ꂽÕCX^X΁AsetAllValue(l)sB
				child.deserialize( bufValue.toString() );
			} else {
				// o݂Ȃ΁AG[ƂB
				// error
			}
		}
	}
   
	/**
	 * p[^擾B<br>
	 * @param value StringBuffer l
	 * @return int G[R[h
	 */
	public int getParamSub(StringBuffer value) {
   		if ( value == null ) {
   			value = new StringBuffer();
   		}
   		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		value.append("[");
		String strKeyWord = getKeyWord();
		value.append( strKeyWord );
		value.append( "]" );
		value.append( STR_CRLF );
		
		int intChildCount = getChildCount();
		
		for ( int i = 0; i < intChildCount; i++ ) {
			CMIElement child = getChild( i );
			if ( child != null ) {
				intErrCode = child.getParam( value );
			} else {
				// program error;
			}
		}
		return intErrCode;
	}
   
	/**
	 * PutParamR}hMɎMf[^𕪐͂Aef[^ɐݒ肷
	 * ĂяoB<br>
	 * @param name String pX
	 * @param inString String Mf[^
	 * @return int G[R[h
	 */
	public int putParamSub(String name, String inString) {
   	
	int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;

	CMITokenizer strTokenizer = new CMITokenizer( inString, CHAR_CRLF);
	CMITokenizer strPairDivider = null;
	
	String strLine = null;
	String strKeyWord = null;
	String strValue = null;
	
	while( strTokenizer.hasMoreTokens()){
		strLine = strTokenizer.nextToken();
		if ( CMIUtil.isComment( strLine ) ) {
			continue;	
		}
		strPairDivider = new CMITokenizer( strLine, "=" );
		strKeyWord =	strPairDivider.nextToken();
		try{
			strValue = strPairDivider.nextToken();
		} catch (NoSuchElementException nseE) {
			strValue = "";
		}		
		
		CMIElement child = getChildByKeyWord( strKeyWord );
		if ( child != null ) {
			child.putParam( strKeyWord, strValue );
		} else {
			intErrCode = HACPError.HACP_ERR_INVALID_COMMAND;
		}
	}
	return intErrCode;
	}
   
	/**
	 * fobO(CMIf[^)擾B<br>
	 * @return String fobO(CMIf[^)
	 */
	public String getDebugCMIData() {
   	
		//pX擾B
	   	String strPath = getPath();
		String strVal = null;
		StringBuffer ret = new StringBuffer();
		
		ret.append( strPath );
		ret.append("F(");
		ret.append(String.valueOf(m_LinkCount));
		ret.append(")\n");
		ret.append("    Node  Value=");
		ret.append("[");
		String strSet = m_bySetValue ? " SET ": " --- ";
		ret.append(strSet);
		ret.append("]");
		StringBuffer value = new StringBuffer();
		value.append(m_value.getLocalIsNull() ? "(null)" : "");
		
		value.append("[");
		value.append( m_value.getLocalValue() );
		value.append("]");
		String strValue = value.toString();
		ret.append(value.toString());
		
		for ( int i = 0; i < ( 40 - strValue.length() ); i++ ) {
			ret.append(" ");
		}
		
		StringBuffer lessonValue = new StringBuffer();
		lessonValue.append(" / ");
		strValue = m_value.getLessonIsNull()?"(null)":"";
		lessonValue.append(strValue);
		lessonValue.append("[");
		lessonValue.append(m_value.getLessonValue());
		lessonValue.append("]");
		ret.append(lessonValue.toString());
		ret.append("\n");
	
		Iterator iterator = m_children.iterator();
		while ( iterator.hasNext() ) {
			CMIElement element = ( CMIElement )iterator.next();
			String strChild = element.getDebugCMIData();
			ret.append(strChild);
		}
		return ret.toString();
	}
   
	/**
	 * fobO(vg^Cv)擾B<br>
	 * @return String fobO(CMIf[^)
	 */
	public String getDebugProto() {
	
		String strPath = null;
		
		//pX擾B
		strPath = getPath();	
		
		//[ 擾B
		String strLeaf = null;
		if ( isLeaf() ){
			strLeaf = "1";
		} else {
			strLeaf = "0";
		}
		
		//z 擾B
		String strArray = null;
		if ( isArray( ) ) {
			strArray = "1";
		} else {
			strArray = "0";
		}
		
		//Get ۔擾B
		String strRead = null;
		if ( isReadable() ) {
			strRead = "1";
		} else {
			strRead = "0";
		}
		
		//Set ۔擾B
		String strWrite = null;
		if ( isWritable() ) {
			strWrite = "1";
		} else {
			strWrite ="0";
		}
		
		//K{ 擾B
		String strMandatory = null;
		if ( isMandatory() ) {
			strMandatory = "1";
		} else {
			strMandatory ="0";
		}
		
		//VACY擾B
		String strSerializable = null;
		if ( isSerializable() ){
			strSerializable = "1";
		} else {
			strSerializable = "0";
		}
		
		StringBuffer sbBuffer = new StringBuffer();
		
		sbBuffer.append(strPath);
		sbBuffer.append("F(");
		String strLinkCount = null;
		try {
			strLinkCount = String.valueOf( m_LinkCount );
		} catch(NumberFormatException ex){
			strLinkCount = "";
		}
		sbBuffer.append(strLinkCount);
		sbBuffer.append(")\n");
		sbBuffer.append("    ");
		
		sbBuffer.append( "Node " );
		sbBuffer.append("Leaf="+strLeaf+"/");
		sbBuffer.append("Array="+strArray+"/");
		sbBuffer.append("Readable="+strRead+"/");
		sbBuffer.append("Write="+strWrite+"/");
		sbBuffer.append("Man="+strMandatory+"/");
		sbBuffer.append("Serial="+strSerializable+"\n");
	
		Iterator iterator = m_children.iterator();
		while ( iterator.hasNext() ) {
			CMIElement element = ( CMIElement )iterator.next();
			String strChild = element.getDebugProto();
			sbBuffer.append(strChild);
		}
		return sbBuffer.toString();
	}

	/**
	 * ێf[^XML`Ŏ擾B<br>
	 * @param buf StringBuffer Of[^
	 */
	public void serializeXMLLog(StringBuffer buf) {
		if ( buf == null ) {
			buf = new StringBuffer();
		}
		String strName = getName();
		buf.append("<");
		buf.append(strName);
		buf.append(">");
		//qGg̃VACYs
		serializeXMLChildren(buf);
		buf.append("</");
		buf.append(strName);
		buf.append(">");
		buf.append("\n");

	}

	/**
	 * qGgXMLVACYsA^O𐶐B<br>
	 * @param buf StringBuffer VACYXMLf[^
	 */
	protected void serializeXMLChildren(StringBuffer buf) {
		
		boolean blnFirstTime = true;
		CMIElement child = null;
		Iterator iterator = m_children.iterator();
		
		while ( iterator.hasNext() ) {
			child = ( CMIElement )iterator.next();
			if ( child != null ) {
				child.serializeXMLLog(buf);
			} else {
				//program error;
			}
		}
	}

}
