/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// ʐU`wlkΉNX
//
//
//	ύX
//	2004/01/08 VK쐬	T.Nishiki
//
package jp.co.ntt.lms.xms.framework;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.common.util.StringUtil;
import jp.co.ntt.lms.xms.common.util.XmlUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * ʐU`wlkΉNXB<br>
 * @author T.Nishiki
 */
class XmsScreenXMLPerser {

	/**
	 *  XML`t@C̃pXB
	 */
	private static final String SCREEN_XMLFILE_PATH;

	/**
	 *  <screen>m[hstatusB
	 */
	private static final String NODE_SCREEN_ATTR_STATUS;

	/**
	 *  <screen>m[hclassB
	 */
	private static final String NODE_SCREEN_ATTR_CLASS;

	/**
	 *  <screen>m[hjspB
	 */
	private static final String NODE_SCREEN_ATTR_JSP;

	/**
	 *  <screen>m[hforwardB
	 */
	private static final String NODE_SCREEN_ATTR_FORWARD;

	/**
	 *  <action>m[h̃pXB
	 */
	private static final String PATH_NODE_ACTION;

	/**
	 *  <common><property>m[h̃pXB
	 */
	private static final String PATH_NODE_COMMON_PROPERTY;

	/**
	 *  <common><error>m[h̃pXB
	 */
	private static final String PATH_NODE_COMMON_ERROR;

	/**
	 *  <action>m[hnameB
	 */
	private static final String NODE_ACTION_ATTR_NAME;

	/**
	 *  <common><property>m[hnameB
	 */
	private static final String NODE_COMMON_PROPERTY_ATTR_NAME;
	/**
	 *  <common><property>m[hvalueB
	 */
	private static final String NODE_COMMON_PROPERTY_ATTR_VALUE;
	/**
	 *  vpeB́FJSP[gB
	 */
	private static final String NODE_COMMON_PROPERTY_JSPROOT;
	/**
	 *  vpeB́Ft@Co͐B
	 */
	private static final String NODE_COMMON_PROPERTY_OUTPUT;

	/**
	 * warninǵB
	 */
	private static final String ATTR_WARNING;

	/**
	 * systeḿB
	 */
	private static final String ATTR_SYSTEM;

	/**
	 * inneŕB
	 */
	private static final String ATTR_INNER;

	/**
	 * throwabléB
	 */
	private static final String ATTR_THROWABLE;

	/**
	 * <error>m[h́B
	 */
	private static final String NODE_NAME_ERROR;

	/**
	 * <screen>m[h́B
	 */
	private static final String NODE_NAME_SCREEN;

	/**
	 * XML`DocumentB
	 */
	private static Document DOCUMENT;

	/**
	 * XML`ʃvpeBE}bvB
	 */
	private static Map COMMON_PROPERTIES;

	/**
	 * t@Co͐B
	 */
	private static String OUTPUT_DIR;

	/**
	 * JSP̃[gfBNgB
	 */
	private static String JSPROOT_DIR;

	/**
	 * XmsWarningExceptioñftHgtH[hJSPB
	 */
	private static String JSP_WARNING;

	/**
	 * XmsSystemExceptioñftHgtH[hJSPB
	 */
	private static String JSP_SYSTEM;

	/**
	 * XmsInnerExceptioñftHgtH[hJSPB
	 */
	private static String JSP_INNER;

	/**
	 * ThrowablẽftHgtH[hJSPB
	 */
	private static String JSP_THROWAOBLE;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		DebugLog.write(
			XmsScreenXMLPerser.class,
			"HEAD XmsScreenControl.static-initilizer",
			DebugLog.ROW);
		SCREEN_XMLFILE_PATH = "/conf/xms/XmsScreenDefine.xml";
		NODE_SCREEN_ATTR_STATUS = "status";
		NODE_SCREEN_ATTR_CLASS = "class";
		NODE_SCREEN_ATTR_JSP = "jsp";
		NODE_SCREEN_ATTR_FORWARD = "forward";

		PATH_NODE_ACTION = "root/action";
		PATH_NODE_COMMON_PROPERTY = "root/common/property";
		PATH_NODE_COMMON_ERROR = "root/common/error";

		NODE_NAME_ERROR = "error";
		NODE_NAME_SCREEN = "screen";
		NODE_ACTION_ATTR_NAME = "name";
		NODE_COMMON_PROPERTY_ATTR_NAME = "name";
		NODE_COMMON_PROPERTY_ATTR_VALUE = "value";
		NODE_COMMON_PROPERTY_JSPROOT = "jsproot";
		NODE_COMMON_PROPERTY_OUTPUT = "output";

		ATTR_WARNING = "warning";
		ATTR_SYSTEM = "system";
		ATTR_INNER = "inner";
		ATTR_THROWABLE = "throwable";

		DebugLog.write(
			XmsScreenXMLPerser.class,
			"TAIL XmsScreenControl.static-initilizer",
			DebugLog.ROW);
	}

	/**
	 * ʏ擾pANVNX擾B<br>
	 * w肵ANVIDAXVnƖ̌ʕ̑gݍ킹ŁA
	 * ʐU`t@CAANVNX擾A߂B
	 * @param actionId ANVIDB
	 * @param businessStatus XVnƖ̌ʕB
	 * @return w肵gݍ킹ɐݒ肳ꂽNXԋpB
	 *
	 * @throws XmsException ɗOꍇB
	 */
	static String getScreenActionName(String actionId, String businessStatus)
		throws XmsException {
		String actionName = null;
		Node screenNode = null;
		try {
			// <screen>m[h擾B
			screenNode = getScreenNode(actionId, businessStatus);
			// <screen>m[hAclass擾
			actionName =
				XmlUtil.getAttributeValue(screenNode, NODE_SCREEN_ATTR_CLASS);
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return actionName;
	}

	/**
	 * tH[htqh擾B<br>
	 * w肵ANVIDAXVnƖ̌ʕȂтɏo͎w
	 * gݍ킹ɊÂAʐU`t@CA
	 * tH[hƂȂiro܂̓tH[hptqh擾A߂B<br>
	 * iro擾邩AtH[hptqh擾邩̔f͈ȉ̒ʂƂB
	 * Ŏw肳ꂽo͎w肪{@link XmsResponse#JSP}܂
	 * {@link XmsResponse#JSP_CSV}Ȃ΁A
	 * ANVIDAXVnƖ̌ʕ񂩂擾ł&lt;screen&gt;vf
	 * jsp擾BjspȂꍇ́Aforward擾B
	 * Ŏw肳ꂽo͎w肪{@link XmsResponse#FORWARD}Ȃ΁A
	 * &lt;screen&gt;vfforward擾B
	 * JSP擾ꍇAʓrAJSP[g擾EAAJSPURIƂĖ߂B
	 * @param actionId ANVIDB
	 * @param businessStatus XVnƖ̌ʕB
	 * @param type o͎wB
	 * @return w肵gݍ킹ɐݒ肳ꂽtH[htqhB
	 * @throws XmsException ɗOꍇB
	 * @see XmsResponse#JSP
	 * @see XmsResponse#JSP_CSV
	 * @see XmsResponse#FORWARD
	 */
	static String getUriToForward(
		String actionId,
		String businessStatus,
		int type)
		throws XmsException {
		String uri = null;
		try {
			// <screen>m[h擾B
			Node screenNode = getScreenNode(actionId, businessStatus);
			if (type == XmsResponse.JSP || type == XmsResponse.JSP_CSV) {
				// <screen>m[hAjsp擾
				String jspName = XmlUtil.getAttributeValue(
						screenNode, NODE_SCREEN_ATTR_JSP);
				// JSP擾łꍇJSP[g擾āAAB
				if (jspName != null) {
					// iro[g
					String jspRoot = getJspRootDirectory();
					// irôtqh
					uri = jspRoot + jspName;
				}
				// jspȂꍇforward擾
				else {
					uri = XmlUtil.getAttributeValue(
							screenNode, NODE_SCREEN_ATTR_FORWARD);
				}
			}
			// tH[hw̏ꍇAfoward擾
			else if (type == XmsResponse.FORWARD) {
				uri = XmlUtil.getAttributeValue(
						screenNode, NODE_SCREEN_ATTR_FORWARD);
			}
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return uri;
	}

	/**
	 * XmsWariningExceptionƂɃtH[hirõpX擾B<br>
	 * ʐU`t@CAw肵ANVIDɑΉ&lt;action&gt;vf擾B
	 * ̎qvf&lt;error&gt;擾Awarining̒l擾B
	 * ̑lƃ[gfBNgAA߂B
	 * &lt;error&gt;vfwarining݂Ȃꍇ́A
	 * ʗvfƂĒ`ĂirõpX߂B
	 * @param actionId ANVIDB
	 * @return w肵ANVIDɑΉXmsWarningExceptionp̂irõpXB
	 *
	 * @throws XmsException ɗOꍇB
	 * @see XmsWarningException
	 */
	static String getWarningExceptiontJspPath(String actionId)
		throws XmsException {

		String jspPath = null;
		try {
			// <error>vfwarning擾B
			jspPath = getExceptionJspPath(actionId, ATTR_WARNING, JSP_WARNING);
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return jspPath;
	}

	/**
	 * XmsSystemExceptionƂɃtH[hirõpX擾B<br>
	 * ʐU`t@CAw肵ANVIDɑΉ&lt;action&gt;vf擾B
	 * ̎qvf&lt;error&gt;擾Asystem̒l擾B
	 * ̑lƃ[gfBNgAA߂B
	 * &lt;error&gt;vfsystem݂Ȃꍇ́A
	 * ʗvfƂĒ`ĂirõpX߂B
	 * @param actionId ANVIDB
	 * @return w肵ANVIDɑΉXmsWarningExceptionp̂irõpXB
	 *
	 * @throws XmsException ɗOꍇB
	 * @see XmsSystemException
	 */
	static String getSystemExceptiontJspPath(String actionId)
		throws XmsException {

		String jspPath = null;
		try {
			// <error>vfsystem擾B
			jspPath = getExceptionJspPath(actionId, ATTR_SYSTEM, JSP_SYSTEM);
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return jspPath;
	}

	/**
	 * XmsInnerExceptionƂɃtH[hirõpX擾B<br>
	 * ʐU`t@CAw肵ANVIDɑΉ
	 * &lt;action&gt;vf擾B
	 * ̎qvf&lt;error&gt;擾Ainner̒l擾B
	 * ̑lƃ[gfBNgAA߂B
	 * &lt;error&gt;vfinner݂Ȃꍇ́A
	 * ʗvfƂĒ`ĂirõpX߂B
	 * @param actionId ANVIDB
	 * @return w肵ANVIDɑΉXmsWarningExceptionp̂irõpXB
	 *
	 * @throws XmsException ɗOꍇB
	 * @see XmsInnerException
	 */
	static String getInnerExceptiontJspPath(String actionId)
		throws XmsException {

		String jspPath = null;
		try {
			// <error>vfinner擾B
			jspPath = getExceptionJspPath(actionId, ATTR_INNER, JSP_INNER);
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return jspPath;
	}

	/**
	 * ThrowableƂɃtH[hirõpX擾B<br>
	 * &lt;error&gt;vfthrowable݂Ȃꍇ́A
	 * ʗvfƂĒ`ĂirõpX߂B
	 * @return Throwablep̂irõpXB
	 *
	 * @throws XmsException ɗOꍇB
	 * @see XmsInnerException
	 */
	static String getThrowableJspPath() throws XmsException {

		String jspPath = null;
		String jspRoot = null;
		try {
			jspRoot = getJspRootDirectory();
			jspPath = jspRoot + JSP_THROWAOBLE;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return jspPath;
	}

	/**
	 * OƂɃtH[hirõpX擾B<br>
	 * ʐU`t@CAw肵ANVIDɑΉ&lt;action&gt;vf擾B
	 * ̎qvf&lt;error&gt;擾Aw肵̒l擾B
	 * ̑lƃ[gfBNgAA߂B
	 * &lt;error&gt;vfwarining݂Ȃꍇ́A
	 * ftHglƎw肵iro𗘗pA[gfBNgAA߂B
	 * @param actionId ANVIDB
	 * @param errorAttrName 擾鑮́B
	 * @param defaultJsp w肵擾łȂƂɗpJSPB
	 * @return w肵ANVIDɑΉXmsWarningExceptionp̂irõpXB
	 *
	 * @throws XmsException ɗOꍇB
	 * @see #ATTR_INNER
	 * @see #ATTR_SYSTEM
	 * @see #ATTR_WARNING
	 */
	private static String getExceptionJspPath(
		String actionId,
		String errorAttrName,
		String defaultJsp)
		throws XmsException {

		Node errorNode = null;
		String jspPath = null;
		String jspFile = null;
		try {
			// <error>m[h擾
			errorNode = getErrorNode(actionId);
			if (errorNode != null) {
				// <error>m[hꍇAwarning擾B
				jspFile = XmlUtil.getAttributeValue(errorNode, errorAttrName);
			}
			// errorȂꍇwarningȂꍇA
			// ʂJSP𗘗pB
			if (StringUtil.isNullString(jspFile) == true) {
				jspFile = defaultJsp;
			}
			// [gfBNgƍ킹Ė߂B
			jspPath = getJspRootDirectory() + jspFile;
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return jspPath;
	}

	/**
	 * ʃf[^t@C̏o͐fBNg߂B<br>
	 * @return ʃf[^t@C̏o͐fBNgB
	 * @throws XmsException o͐fBNg̎擾ɎsꍇB
	 */
	static synchronized String getOutputDirectory() throws XmsException {
		if (OUTPUT_DIR == null) {
			initializeDocument();
			initializeCommons();
		}
		return OUTPUT_DIR;
	}

	/**
	 * irot@C̃[gfBNg߂B<br>
	 * @return irot@C̃[gfBNgB
	 */
	private static String getJspRootDirectory() {
		return JSPROOT_DIR;
	}

	/**
	 * w肳ꂽANVIDɑΉ&lt;error&gt;m[h߂B<br>
	 * ʐU`t@CAw肵ANVID
	 * Ή&lt;action&gt;vf擾B
	 * ̎qvf&lt;error&gt;擾łꍇ́A̗vf\m[h߂B
	 * 擾łȂꍇnull߂B
	 *
	 * @param actionId ANVIDB
	 * @return ANVIDɑΉ&lt;error&gt;m[hB
	 * @throws XmsException
	 * 	        w肵ANVIDɑΉ&lt;action&gt;vf݂ȂꍇB
	 *          ̑AɗOꍇB
	 */
	private static Node getErrorNode(String actionId) throws XmsException {
		Node actionNode = null;
		Node errorNode = null;
		try {
			// ANVIDɈv<action>m[h擾
			actionNode = getActionNode(actionId);
			if (actionNode == null) {
				throw new XmsSystemException("actionNode == null");
			}
			// <error>m[h擾
			errorNode = XmlUtil.selectNode(actionNode, NODE_NAME_ERROR);
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return errorNode;
	}

	/**
	 * w肵hcƌʂɑΉ&lt;screen&gt;m[h擾B<br>
	 * w肵ANVIDAXVnƖ̌ʕ̑gݍ킹ŁA
	 * ʐU`t@CAANVNX擾A߂B
	 * @param actionId ANVIDB
	 * @param businessStatus XVnƖ̌ʕB
	 * @return w肵gݍ킹ɐݒ肳ꂽ&lt;screen&gt;m[hB
	 *
	 * @throws XmsException
	 *          ɗOꍇB
	 *          Ή&lt;screen&gt;m[h݂ȂꍇB
	 *          ܂͂̐e&lt;action&gt;m[h݂ȂꍇB
	 */
	private static Node getScreenNode(String actionId, String businessStatus)
		throws XmsException {

		Node actionNode = null;
		Node[] screenNodes = null;
		Node screenNode = null;
		try {
			// ANVIDɈv<action>m[h擾
			actionNode = getActionNode(actionId);
			if (actionNode == null) {
				throw new XmsSystemException("actionNode == null");
			}
			// <action>m[hz<screen>m[hEXg擾B
			// statusv<screen>m[h擾B
			screenNodes = XmlUtil.selectNodes(actionNode, NODE_NAME_SCREEN);
			screenNode =
				XmlUtil.searchNodeByAttribute(
					screenNodes, NODE_SCREEN_ATTR_STATUS, businessStatus);
			if (screenNode == null) {
				throw new XmsSystemException(
					"screenNode[status=\"" + businessStatus + "\"] not found");
			}
		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return screenNode;
	}

	/**
	 * w肵ANVIDɍv&lt;action&gt;m[h߂B<br>
	 * @param actionId L[ƂȂANVIDB
	 * @return w肵ANVIDɍv&lt;action&gt;m[h΁A
	 *          ̃m[hAȂnull߂B
	 * @throws XmsException ɗOꍇB
	 */
	private static Node getActionNode(String actionId) throws XmsException {
		// <action>m[h̏W
		Node[] actionNodes = null;
		// ̃\bh̖߂lB
		Node returnNode = null;

		try {
			// <action>m[h擾
			actionNodes = XmlUtil.selectNodes(getDocument(), PATH_NODE_ACTION);
			// NAMElw肵ANVIDƈvm[hI
			returnNode = XmlUtil.searchNodeByAttribute(
					actionNodes, NODE_ACTION_ATTR_NAME, actionId);

		}
		catch (XmsException e) {
			throw e;
		}
		catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return returnNode;
	}

	/**
	 * cnlf[^̏B<br>
	 * @throws XmsException ɗOꍇB
	 */
	private static synchronized void initializeDocument()
			throws XmsException {
		DebugLog.write( XmsScreenXMLPerser.class,
			"HEAD initializeDocument()", DebugLog.ROW);
		// ϊpr_Et@Ng
		DocumentBuilderFactory dbf = null;
		// ϊpr_
		DocumentBuilder db = null;
		// `t@C̓̓Xg[
		InputStream in = null;
		// OtOitryubNj
		boolean exceptionFlag = true;

		try {
			dbf = DocumentBuilderFactory.newInstance();
			// XMLt@C̋󔒂r܂
			dbf.setIgnoringElementContentWhitespace(true);
			// XMLt@C̃Rg𖳎܂
			dbf.setIgnoringComments(true);

			db = dbf.newDocumentBuilder();
			in = (XmsScreenXMLPerser.class).getResourceAsStream(
					SCREEN_XMLFILE_PATH);
			// t@CDOMɕϊ
			DOCUMENT = db.parse(in);
			DebugLog.write(XmsScreenXMLPerser.class,
					"DOCUMENT==null:" + (DOCUMENT == null), DebugLog.HIGHT);

			// tryubNŗOĂȂ
			exceptionFlag = false;
		}
		catch (Exception e) {
			DebugLog.write(XmsScreenXMLPerser.class, e, DebugLog.HIGHT);
			throw new XmsSystemException(e);
		}
		finally {
			// InputStream̃N[Y
			try {
				if (in != null) {
					in.close();
				}
			}
			catch (Exception e) {
				DebugLog.write(XmsScreenXMLPerser.class, e, DebugLog.HIGHT);
				// tryubNŗOĂȂꍇAX[
				if (exceptionFlag == false) {
					throw new XmsSystemException(e);
				}
			}
			finally {
				in = null;
				DebugLog.write( XmsScreenXMLPerser.class,
					"TAIL initializeDocument()", DebugLog.ROW);
			}
		}
	}

	/**
	 * ʃvpeB`t@C擾B<br>
	 * @throws XmsException ɗOꍇB
	 */
	private static synchronized void initializeCommons()
			throws XmsException {
		DebugLog.write( XmsScreenXMLPerser.class,
			"HEAD initializeCommons()", DebugLog.ROW);
		try {
			////////////////////////////////////////////////////////////////////
			// vpeB擾
			// -----------------------------------------------------------------
			// <var>m[h擾
			Node[] varNodes = null;
			String varName = null;
			String varValue = null;
			COMMON_PROPERTIES = new HashMap();
			varNodes =
				XmlUtil.selectNodes(getDocument(), PATH_NODE_COMMON_PROPERTY);
			for (int i = 0; i < varNodes.length; i++) {
				varName =
					XmlUtil.getAttributeValue(
						varNodes[i],
						NODE_COMMON_PROPERTY_ATTR_NAME);
				varValue =
					XmlUtil.getAttributeValue(
						varNodes[i],
						NODE_COMMON_PROPERTY_ATTR_VALUE);
				DebugLog.write( XmsScreenXMLPerser.class,
					"varName=[" + varName + "]", DebugLog.ROW);
				DebugLog.write( XmsScreenXMLPerser.class,
					"varValue=[" + varValue + "]", DebugLog.ROW);

				if ((varName != null) && (varValue != null)) {
					COMMON_PROPERTIES.put(varName, varValue);
				}
			}

			// ʃf[^t@Co͐
			OUTPUT_DIR =
				(String)COMMON_PROPERTIES.get(NODE_COMMON_PROPERTY_OUTPUT);
			if (StringUtil.isNullString(OUTPUT_DIR) == true) {
				throw new XmsSystemException(
					NODE_COMMON_PROPERTY_OUTPUT + " is not found.");
			}
			// irot@C[gpX
			JSPROOT_DIR =
				(String)COMMON_PROPERTIES.get(NODE_COMMON_PROPERTY_JSPROOT);
			if (StringUtil.isNullString(JSPROOT_DIR) == true) {
				throw new XmsSystemException(
					NODE_COMMON_PROPERTY_JSPROOT + " is not found.");
			}
			////////////////////////////////////////////////////////////////////
			// O^G[̑Jڐ擾
			// -----------------------------------------------------------------
			// <error>m[h擾
			Node errorNode = null;
			String jspWarning = null;
			String jspSystem = null;
			String jspInner = null;
			String jspThrowable = null;
			errorNode =
				XmlUtil.selectNode(getDocument(), PATH_NODE_COMMON_ERROR);

			// throwablȇJڐ
			jspThrowable = XmlUtil.getAttributeValue(errorNode, ATTR_THROWABLE);
			if (StringUtil.isNullString(jspThrowable) == true) {
				throw new XmsSystemException(
					ATTR_THROWABLE + " is not found.");
			}
			JSP_THROWAOBLE = jspThrowable;

			// XmsWarningException̑Jڐ
			jspWarning = XmlUtil.getAttributeValue(errorNode, ATTR_WARNING);
			if (StringUtil.isNullString(jspWarning) == true) {
				JSP_WARNING = jspThrowable;
			}
			else {
				JSP_WARNING = jspWarning;
			}
			// XmsSystemException̑Jڐ
			jspSystem = XmlUtil.getAttributeValue(errorNode, ATTR_SYSTEM);
			if (StringUtil.isNullString(jspSystem) == true) {
				JSP_SYSTEM = jspThrowable;
			}
			else {
				JSP_SYSTEM = jspSystem;
			}
			// XmsInnerException̑Jڐ
			jspInner = XmlUtil.getAttributeValue(errorNode, ATTR_INNER);
			if (StringUtil.isNullString(jspInner) == true) {
				JSP_INNER = jspThrowable;
			}
			else {
				JSP_INNER = jspInner;
			}
		}
		catch (XmsException e) {
			DebugLog.write(XmsScreenXMLPerser.class, e, DebugLog.HIGHT);
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(XmsScreenXMLPerser.class, e, DebugLog.HIGHT);
			throw new XmsSystemException(e);
		}
		finally {
			DebugLog.write( XmsScreenXMLPerser.class,
				"TAIL initializeCommons()", DebugLog.ROW);
		}
	}
	/**
	 * ʐU`wlk|cnlԋpB<br>
	 * @return Document ʐU`wlkB
	 * @throws XmsException ɗOꍇB
	 */
	private static synchronized Document getDocument()
			throws XmsException {
		if (DOCUMENT == null) {
			initializeDocument();
			initializeCommons();
		}
		return DOCUMENT;
	}
}
