/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	LumpParserNX
//			ύX
//				2004.01.08	VK쐬    ܖؓc ׎j
//
package jp.co.ntt.lms.xmo.LumpInsert;

import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.util.FileControl;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.XMOString;

import java.io.IOException;
import java.io.StringReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.*;


import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

/**
 * LumpParserNXłB<BR>
 * ꊇo^XMLt@C͂܂B<BR>
 * ͌ʂƂLumpTreeNX߂܂B<BR>
 *
 * @author Y.Gokita
 * @version 0.0.0.1 2004/01/08
 */
public class LumpParser
	implements LumpInsertMessage
{

	// ꊇo^t@C̃^O`l
	static final String TAG_ROOT       = "Lump";
	static final String TAG_GROUP      = "group";
	static final String TAG_FOREIGNID  = "foreign_id";
	static final String TAG_GROUP_NAME = "group_name";
	static final String TAG_PEOPLE     = "people";
	static final String TAG_LOGINID    = "login_id";
	static final String TAG_USER_NAME  = "user_name";
	static final String TAG_PASSWORD   = "password";
	static final String TAG_ADDRESS    = "contact_address";
	static final String TAG_SEX        = "sex";
	static final String TAG_EMAIL1     = "contact_email";
	static final String TAG_EMAIL2     = "contact_email2";
	static final String TAG_KANA       = "reading_name";
	static final String TAG_BIRTHDAY   = "birthday";
	static final String TAG_TEL        = "contact_tel";
	static final String TAG_COMMENT    = "comment";

	static final String TAG_OID        = "oid";
	static final String TAG_AD_DN      = "ad_dn";
	static final String TAG_AD_USER_ID = "ad_user_id";
	static final String ATTR_TYPE    = "type";
	static final String ATTR_UPFLAG    = "up_flag";


	// [MtO
	private boolean mblMailFlag = false;


	private String mstrLumpRootGroup = null;

	// O[ṽIuWFNgID̏d`FbNp̃nbVe[ułB
	private Hashtable mhtbOid = new Hashtable();

	public LumpParser(String strLumpRootGroup ){
		mstrLumpRootGroup = strLumpRootGroup;
	}

	/**
	 * ꊇo^t@CWJ<BR>
	 * w肳ꂽꊇo^t@C<BR>
	 * LumpTreeIuWFNgɑSĂ̏WJB<BR>
	 *
	 * @param String ꊇo^t@C
	 * @return LumpTree O[vƐl̃c[擪NX
	 * @exception XMOException
	 */
	public LumpTree parse(String strXML, boolean blMailFlag)
		throws XMOException
	{
		LumpTree objTree = null;
		try
		{
			//[tOݒ
			mblMailFlag = blMailFlag;

			// [gm[h̎擾
			Node objRootNode = load(strXML);

			// [gm[hLumpGroupNXc[쐬
			LumpGroup objTop = new LumpGroup();
			objTop.setType(LumpGroupAndPeople.TYPE_GROUP);

			makeTree((Element)objRootNode, objTop);

			// 擪LumpGroupAndPeopleNXc[NXɐݒ
			objTree = new LumpTree();

			objTree.setTop(objTop);
		}
		catch(SAXException se)
		{
			// @LOG >err >1
			DebugLog.write(this.getClass(), se, DebugLog.HIGHT);
			throw new XMOException(PARSE_WAR);
		}
		catch(IOException ie)
		{
			// @LOG >err >1
			DebugLog.write(this.getClass(), ie, DebugLog.HIGHT);
			throw new XMOException(PARSE_ERR);
		}
		catch(ParserConfigurationException pe)
		{
			// @LOG >err >1
			DebugLog.write(this.getClass(), pe, DebugLog.HIGHT);
			throw new XMOException(PARSE_ERR);
		}
		// ꊇo^C^tF[Xł
		// c[NX߂
		return objTree;
	}

	/**
	 * Abv[ht@Cݏ<BR>
	 * w肳ꂽAbv[ht@C<BR>
	 * w肳ꂽtH_ɏށB<BR>
	 *
	 * @param String Abv[ht@C
	 * @param String OCID
	 * @return String ꊇo^t@C
	 * @exception XMOException
	 */
	public String save(String strXML, String strLoginID)
		throws XMOException
	{
		String strDir      = "";
		String strFileName = "";

		try
		{
			// t@C쐬
			SimpleDateFormat objFormat = new SimpleDateFormat("yyyyMMdd");
			Date objNow                = new Date();
			String strDate             = objFormat.format(objNow);			//ݎ擾
			// OCIDt̑Oɒǉ
			strDate = strLoginID + strDate;

			LumpInsertEnv objEnv = LumpInsertEnv.getInstance();
			strDir               = objEnv.getLumpDir();

			// tH_t@C擾
			FileControl objFc = new FileControl();
			String[] strList  = objFc.getFileList(strDir, 1);
			int i             = 0;
			int intXmlIndex   = 0;
			int intFileCount  = 0;
			String strFullFileName = "";
			String strTempName     = "";
			for(i = 0; i < strList.length; i++)
			{
				strFullFileName = strList[i];
				if(strFullFileName != null)
				{
					intXmlIndex = strFullFileName.indexOf(".xml");
					// t@CvȂ
					if(intXmlIndex > 0)
					{
						strTempName = strFullFileName.substring(0, intXmlIndex);
					}
					// 擪tf[^vȂ
					if(strTempName.indexOf(strDate) == 0)
					{
						intFileCount++;
					}
				}
			}
			if(intFileCount == 0)
			{
				strFileName = strDate + ".xml";
			}
			else
			{
				strFileName = strDate + "_" +
								String.valueOf(intFileCount) + ".xml";
			}

			File objFile         = new File(strDir + "/" + strFileName);

			// o͐tH_쐬
			File objParentDir = objFile.getParentFile();
			objParentDir.mkdirs();

				// Kt@C𐶐
				if(!objFile.createNewFile())
				{
					throw new XMOException(FILE_MAKE_ERR);
				}
			FileOutputStream objFos = new FileOutputStream(objFile);
			OutputStreamWriter objPw = new OutputStreamWriter(objFos,"Windows-31J");
			

			objPw.write(strXML);
			objPw.close();
			objFos.close();
		}
		catch(XMOException xe)
		{
			// @LOG >err >1
			DebugLog.write(this.getClass(), xe, DebugLog.HIGHT);
			throw xe;
		}
		catch(Exception e)
		{
			// @LOG >err >1
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			throw new XMOException(SAVE_WAR);
		}
		return strFileName;
	}


	/**
	 * ͂sRootNodeIuWFNg擾܂<BR>
	 * ł̓XML`f[^͂܂B
	 * @param String XML
	 * @return Node RootNodeIuWFNg
	 * @exception SAXException
	 */
	private Node load(String strXML)
		throws SAXException,IOException,ParserConfigurationException
	{

		DocumentBuilder objDocumentBuilder;

		// ꊇo^t@Cǂݍ݂cnlc[쐬
		// 쐬sꍇɂ́Aʂ`oExceptionthrow
		// syуRg͖Ƃ
		DocumentBuilderFactory objDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
		objDocumentBuilderFactory.setIgnoringElementContentWhitespace(true);
		objDocumentBuilderFactory.setIgnoringComments(true);

		try
		{
			objDocumentBuilder = objDocumentBuilderFactory.newDocumentBuilder();
		}
		catch(ParserConfigurationException ex)
		{
			throw ex;
		}

		Document objXmlDoc;

		try
		{
			StringReader objStream = new StringReader(strXML);
			InputSource objInput = new InputSource(objStream);		// DOMc[쐬
			objXmlDoc = objDocumentBuilder.parse(objInput);
			objStream.close();
		}
		catch(SAXException ex)
		{
			throw ex;
		}
		catch(IOException ex) {
			throw ex;
		}

		// [gm[h̎擾s
		return objXmlDoc.getDocumentElement();
	}

	/**
	 * LumpGroupAndPeoplec[쐬<BR>
	 * NodeLumpGroupAndPeoplec[쐬܂<BR>
	 *
	 * @param Element [gGgNX
	 * @param LumpGroup 擪LumpGroupNX
	 * @return void
	 * @exception SAXException
	 * @exception IOException
	 * @exception ParserConfigurationException
	 * @exception XMOException
	 */
	private void makeTree(Element objRootNode, LumpGroup objTopGroup)
		throws SAXException,IOException,ParserConfigurationException,
				XMOException
	{
		// @LOG >debug >10 ꊇo^FXML̃c[쐬Jn܂B
		DebugLog.write( this.getClass(), "ꊇo^FXML̃c[쐬Jn܂", DebugLog.ROW );

		// [g^O邩`FbN܂B
		if(!objRootNode.getNodeName().equalsIgnoreCase(TAG_ROOT))
		{
			// @LOG >err >1 [g^OȂG[
			DebugLog.write(this.getClass(), "NOT ROOT TAG : " + objRootNode.getNodeName(), DebugLog.HIGHT);
			throw new XMOException(NOROOT_WAR);
		}

		// [gݒ肵܂B
		LumpGroupAndPeople objNull = null;
		objTopGroup.setParent(objNull);							// eNXNULLݒ

		if ( mstrLumpRootGroup == null ){
			// @LOG >err >1 p[^G[ G[
			DebugLog.write(this.getClass(), "ꊇo^FG[: ROOTGROUPID is NULL", DebugLog.HIGHT);
			throw new XMOException(PARAM_WAR);
		}
		else{

			// lump^Otype擾܂B
			String strType = objRootNode.getAttribute( ATTR_TYPE );
			if( strType == null || strType.equals( "" ) ) {
				// ftHgl (1)ݒ
				strType = XMOPropertyDef.XMS_TYPE;
			}
			// ^Cṽ`FbNs܂B
			if( !checkType( strType ) ) {

				// @LOG >err >1 ꊇo^Fʑ(type)słB
				DebugLog.write(this.getClass(), "ꊇo^Fʑ(type)słB" + strType, DebugLog.HIGHT );
				// ^OsG[ƂăX[B
				throw new XMOException(TAG_WAR);
			}
			objTopGroup.setGroupType(strType);				// O[vʂݒ

			objTopGroup.setGroupID(mstrLumpRootGroup);				// O[vIDݒ
			objTopGroup.setGroupName("[g");						// O[v"[g"Œ
		}

		// [g̎qݒ肵܂B
		for(Node objChild = objRootNode.getFirstChild();
			objChild != null;
			objChild = objChild.getNextSibling())
		{
			// #TEXT^̃Cfg͓ǂݔ΂
			if(objChild.getNodeType() != Node.TEXT_NODE)
			{
				// O[vȂ
				if(objChild.getNodeName().equalsIgnoreCase(TAG_GROUP))
				{
					LumpGroup objGroup = new LumpGroup();		// qO[v쐬
					objTopGroup.addChild(objGroup);				// qO[vǉ
					// e̎ʂqɂݒ
					objGroup.setGroupType( objTopGroup.getGroupType() );
					objGroup.setType(LumpGroupAndPeople.TYPE_GROUP);

					makeGroup((Element)objChild, objGroup);		// qO[vvfݒ菈
				}
				else if( objChild.getNodeName().equalsIgnoreCase(TAG_PEOPLE) )
				{
					LumpPeople objPeople = new LumpPeople();			// qlNX쐬
					objTopGroup.addChild(objPeople);						// qlǉ
					// e̎ʂqɂݒ
					objPeople.setUserType( objTopGroup.getGroupType() );
					// [Mݒ
					objPeople.mblMailFlag = mblMailFlag;
					objPeople.setType(LumpGroupAndPeople.TYPE_PEOPLE);	// l(=0)ݒ
					objPeople.setParent(objTopGroup);						// qlɐeO[vݒ
					makePeople((Element)objChild, objPeople);			// qlvfݒ菈
				}
				else{
					// [g̎q<group>^OE<people>^Oł͂Ȃꍇ̓G[
					// @LOG >err >1 [g̎q<group>^OE<people>^Oł͂ȂB
					DebugLog.write(this.getClass(), "NOT GROUP OR PEOPLE TAG : " + objChild.getNodeName(), DebugLog.HIGHT);
					throw new XMOException(ROOT_WAR);
				}
			}
		}

		// @LOG  >debug >10 ꊇo^FXML̃c[쐬I܂B
		DebugLog.write( this.getClass(), "ꊇo^FXML̃c[쐬I܂B", DebugLog.ROW );
	}

	/**
	 * O[vNX쐬<BR>
	 * O[vGgO[vNX<BR>
	 * 쐬܂<BR>
	 *
	 * @param Element O[vGg
	 * @param LumpGroup O[vNX
	 * @return void
	 * @exception SAXException
	 * @exception IOException
	 * @exception ParserConfigurationException
	 * @exception XMOException
	 */
	private void makeGroup(Element objElGroup, LumpGroup objGroup)
		throws SAXException,IOException,ParserConfigurationException,
				XMOException
	{

		// @LOG >debug >10 ꊇo^FO[v̍쐬Jn܂B
		DebugLog.write( this.getClass(), "ꊇo^FO[v̍쐬Jn܂B", DebugLog.ROW );

		// qm[hێxN^[
		Vector vecChildNode = new Vector();

		for(Node objChild = objElGroup.getFirstChild();
			objChild != null;
			objChild = objChild.getNextSibling())
		{
			//#TEXT^̃Cfg͓ǂݔ΂
			if(objChild.getNodeType() != Node.TEXT_NODE)
			{
				// ^O
				String strNodeName = objChild.getNodeName();

				// O[vvfȂ
				if(strNodeName.equalsIgnoreCase(TAG_GROUP))
				{
					// qm[hxN^[ɕێB
					vecChildNode.add( objChild );
				}
				// lvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_PEOPLE))
				{
					// qm[hxN^[ɕێB
					vecChildNode.add( objChild );
				}
				// OL[vfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_FOREIGNID))
				{
					// OL[vfl擾
					objGroup.setForeignID(getElementValue(objChild));

					// XVtO̎擾
					objGroup.mblForeignIDUpFlag = getUpFlag((Element)objChild);

				}
				// O[vvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_GROUP_NAME))
				{
					// O[vvfl擾
					objGroup.setGroupName(getElementValue(objChild));

					// XVtO̎擾
					objGroup.mblGroupNameUpFlag = getUpFlag((Element)objChild);
				}
				// RgvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_COMMENT))
				{
					// Rgvfl擾
					objGroup.setCustomMsgDir(getElementValue(objChild));
				}
				// IuWFNgIDvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_OID))
				{
					String strOid = getElementValue( objChild );
					// O[ṽIuWFNgIDd`FbNs܂B
					if( mhtbOid.get( strOid ) == null ) {
						// dĂȂꍇ͏d`FbNnbVe[uɊi[B
						mhtbOid.put( strOid, strOid );
						// IuWFNgIDvfl擾
						objGroup.setOid(getElementValue(objChild));
					}
					else {
						// LOG >err >1
						DebugLog.write( this.getClass(), "O[ṽIuWFNgIDdĂ܂B:: " + strOid, DebugLog.HIGHT );
						// dĂꍇ̓G[ƂB
						throw new XMOException( DUPLICATION_OID_WAR );
					}
				}
				// ADDNvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_AD_DN))
				{
					// Rgvfl擾
					objGroup.setADDN(getElementValue(objChild));
				}
				else
				{
					// w^OȊO
					throw new XMOException(TAG_WAR);
				}
			}
		}

		// O[ṽp[^`FbN
		if(objGroup.checkParseParameter()) {
			// z̃O[vE[U̍쐬
			for( int i = 0; i < vecChildNode.size(); i++ ) {
				Element objChildNode = (Element)vecChildNode.get(i);
				String strNodeName = objChildNode.getNodeName();

				if( strNodeName.equals( TAG_GROUP ) ) {
					LumpGroup objGroupChild = new LumpGroup();			// qO[vNX쐬
					objGroup.addChild(objGroupChild);					// qO[vǉ
					// e̎ʂqɂݒ
					objGroupChild.setGroupType( objGroup.getGroupType() );
					objGroup.setType(LumpGroupAndPeople.TYPE_GROUP);	// O[v(=1)ݒ
					makeGroup(objChildNode, objGroupChild);		// qO[vvfݒ菈(ċAďo)
				}
				else {
					LumpPeople objPeople = new LumpPeople();			// qlNX쐬
					objGroup.addChild(objPeople);						// qlǉ
					// e̎ʂqɂݒ
					objPeople.setUserType( objGroup.getGroupType() );
					objPeople.setType(LumpGroupAndPeople.TYPE_PEOPLE);	// l(=0)ݒ
					objPeople.setParent(objGroup);						// qlɐeO[vݒ
					makePeople(objChildNode, objPeople);			// qlvfݒ菈
				}
			}
		}
		else {
			objGroup.boolFailFlag = true;
			// @LOG >err >1
			DebugLog.write(this.getClass(), "O[v̕K{p[^słB", DebugLog.HIGHT);
			DebugLog.write(this.getClass(), "ForeignID : " + objGroup.getForeignID(), DebugLog.HIGHT);
			DebugLog.write(this.getClass(), "GroupName : " + objGroup.getGroupName(), DebugLog.HIGHT);
		}


		// @LOG >debug >10 ꊇo^FO[v̍쐬I܂B
		DebugLog.write( this.getClass(), "ꊇo^FO[v̍쐬I܂B" + objGroup.getGroupName(), DebugLog.ROW );
	}

	/**
	 * lNX쐬<BR>
	 * lGglNX<BR>
	 * 쐬܂<BR>
	 *
	 * @param Element lGg
	 * @param LumpPeople lNX
	 * @return void
	 * @exception SAXException
	 * @exception IOException
	 * @exception ParserConfigurationException
	 * @exception XMOException
	 */
	private void makePeople(Element objElPeople, LumpPeople objPeople)
		throws SAXException,IOException,ParserConfigurationException,
				XMOException
	{
		// @LOG >debug >10 ꊇo^F[U̍쐬Jn܂B
		DebugLog.write( this.getClass(), "ꊇo^F[U̍쐬Jn܂B", DebugLog.ROW );

		for(Node objChild = objElPeople.getFirstChild();
			objChild != null;
			objChild = objChild.getNextSibling())
		{
			//#TEXT^̃Cfg͓ǂݔ΂
			if(objChild.getNodeType() != Node.TEXT_NODE)
			{
				// ^O
				String strNodeName = objChild.getNodeName();

				// OL[vfȂ
				if(strNodeName.equalsIgnoreCase(TAG_FOREIGNID))
				{
					// OL[vfl擾
					objPeople.setForeignID(getElementValue(objChild));
					// XVtO̎擾
					objPeople.mblForeignIDUpFlag = getUpFlag((Element)objChild);
				}
				// OCIDvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_LOGINID))
				{
					objPeople.setLoginID(getElementValue(objChild));
					// XVtO̎擾
					objPeople.mblLoginIDUpFlag = getUpFlag((Element)objChild);
				}
				// [UvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_USER_NAME))
				{
					objPeople.setUserName(getElementValue(objChild));
					// XVtO̎擾
					objPeople.mblUserNameUpFlag = getUpFlag((Element)objChild);
				}
				// pX[hvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_PASSWORD))
				{
					objPeople.setEncryptPassword(getElementValue(objChild));
					// XVtO̎擾
					objPeople.mblPasswordUpFlag = getUpFlag((Element)objChild);
				}
				// ZvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_ADDRESS))
				{
					objPeople.setContactAddress(getElementValue(objChild));
				}
				// ʗvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_SEX))
				{
					objPeople.setSex(getElementValue(objChild));
				}
				// E[1vfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_EMAIL1))
				{
					objPeople.setContactEmail(getElementValue(objChild));
				}
				// E[2vfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_EMAIL2))
				{
					objPeople.setContactEmail2(getElementValue(objChild));
				}
				// JivfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_KANA))
				{
					objPeople.setReadingName(getElementValue(objChild));
				}
				// avfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_BIRTHDAY))
				{
					objPeople.setBirthday(getElementValue(objChild));
				}
				// dbԍvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_TEL))
				{
					objPeople.setContactTel(getElementValue(objChild));
				}
				// RgvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_COMMENT))
				{
					objPeople.setCustomMsgDir(XMOString.escapeLF(getElementValue(objChild)));
				}
				// IuWFNgIDvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_OID))
				{
					// IuWFNgIDvfl擾
					objPeople.setOid(getElementValue(objChild));
				}
				// ADDNvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_AD_DN))
				{
					// Rgvfl擾
					objPeople.setADDN(getElementValue(objChild));
				}
				// AD[UIDvfȂ
				else if(strNodeName.equalsIgnoreCase(TAG_AD_USER_ID))
				{
					// AD[UIDvfl擾
					objPeople.setADUserID(getElementValue(objChild));
				}
				else
				{
					// ڂsłG[o
					throw new XMOException(TAG_WAR);
				}
			}
		}

		// @LOG >debug >10 ꊇo^F[U̍쐬I܂B
		DebugLog.write( this.getClass(), "ꊇo^F[U̍쐬I܂B" + objPeople.getUserName(), DebugLog.ROW );

	}

	/**
	 * vfl擾
	 * @param objElementNode m[hIuWFNg
	 * @return String m[hl
	 */
	private String getElementValue(Node objElementNode)
	{
		String strRet = "";
		Node objTextNode = objElementNode.getFirstChild();
		if(objTextNode != null)
		{
			if(objTextNode.getNodeName().equals("#text"))
			{
				// 󔒂Ƃ̂lݒ
				strRet = objTextNode.getNodeValue().trim();
			}
		}
		return strRet;
	}

	/**
	 * ʑ̃`FbNs܂B<BR>
	 * ʑ4̂Pȏ̐łȂ΂܂B
	 * @param strType 
	 * @return boolean trur:  false: s
	 */
	private boolean checkType( String strType ) {
		try {
			int intType = Integer.parseInt( strType );
			if( intType < 1 || intType > 9999 ) {
				return false;
			}
		}
		catch( NumberFormatException ne  ){
			return false;
		}

		return true;
	}

	/**
	 * XVtO擾AXVtOԂ܂B
	 * @param Element
	 * @return boolean true: XVtOON false: XVtOOFF
	 */
	private boolean getUpFlag( Element objNode )
		throws XMOException
	{
		String strFlag = objNode.getAttribute( ATTR_UPFLAG );
		if( strFlag == null || strFlag.equals( "" ) ) {
			return true;
		}
		else {

			if( strFlag.equals( "on" ) ) {
				return true;
			}
			else if( strFlag.equals( "off" ) ) {
				return false;
			}
			else {
				// LOG >err >1
				DebugLog.write( this.getClass(), "ꊇo^:XVtO(up_flag)ɂ\"on\"܂\"off\"w肵ĂB", DebugLog.HIGHT );
				// w^OȊO
				throw new XMOException(TAG_WAR);
			}
		}
	}
}

