/*
 * 쐬: 2007/11
 *
 */
package jp.co.ntt.lms.xmo;

import jp.co.ntt.lms.xms.common.user.User;
import jp.co.ntt.lms.xms.login.base.OperateSession;

import java.io.IOException;

import java.util.List;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * @author yasu
 *
 */
public class LoginCheckFilter implements Filter
{

    List ignoreURIs = new ArrayList();
    List ignoreTypes = new ArrayList();
    String redirectURI = null;

    public void init(FilterConfig config) throws ServletException
	{
        try
        {
            String ignoreURIString = config.getInitParameter("ignore_uri");
            String ignoreTypeString = config.getInitParameter("ignore_type");
            String redirectURI = config.getInitParameter("redirect_uri");

            StringTokenizer stURI = new StringTokenizer(ignoreURIString, ",");
            while (stURI.hasMoreTokens())
            {
                ignoreURIs.add(stURI.nextToken().trim());
            }

            StringTokenizer stType = new StringTokenizer(ignoreTypeString, ",");
            while (stType.hasMoreTokens())
            {
                ignoreTypes.add(stType.nextToken().trim());
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws ServletException, IOException
	{
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);

        if (!isAuthenticated(session))
        {
            String requestURI = httpRequest.getRequestURI();
            //System.out.println("requestURI=" + requestURI);

            boolean redirect = true;

            if (redirect)
            {
                for (int i=0; i < ignoreTypes.size(); i++)
                {
                    String type = (String)ignoreTypes.get(i);
                    if (requestURI.endsWith("." + type))
                    {
                        redirect = false;
                        break;
                    }
                }
            }

            if (redirect)
            {
                if (ignoreURIs.contains(requestURI))
                {
                    redirect = false;
                }
            }

            if (redirect)
            {
                httpResponse.sendRedirect(redirectURI);
                return;
            }
        }

        chain.doFilter(request, response);
    }

    private boolean isAuthenticated(HttpSession session)
    {
         if (session != null)
         {
              User user = (User)session.getAttribute(OperateSession.USER_SESSION);
              if (user != null)
              {
                  return true;
              }
         }
         return false;
    }

    public void destroy()
    {
        ignoreURIs = null;
        redirectURI = null;
    }
}
