/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	LoRelation ǗXMO f[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.LoRelation;

import java.util.*;
import java.sql.*;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.LoRelation.*;
import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.Common.status.*;
import jp.co.ntt.lms.Common.status.prerequisite.*;

/**
 * LoRelation ǗXMO f[^ANZXNXłB<BR>
 * ̃NXLoRelatione[uւ̓o^ACA폜As܂B<BR>
 * DataAccessNXgpAo^ACA폜APʂ
 * gUNVǗs܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class LoRelationDataAccess
	implements LoRelationMessage, LoRelationTable
{

	/**
	 * RXgN^łB<BR>
	 */
	public LoRelationDataAccess() {
	}

	/**
	 * LoRelatione[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             PARENT_ID               eID
	 *             CHILD_ID                qID
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized String insert( Hashtable htData )
		throws XMOException
	{
		// LORelationf[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// o^s\bhs܂
			insertAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * o^s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// o^p̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );
		// eID̎擾
		String strParentID = (String)htbParam.get(PARENT_ID);
		// qID̎擾
		String strChildID = (String)htbParam.get(CHILD_ID);
		// \[gԍ̎擾
		String strSortNo = (String)htbParam.get(SORT_NO);
		// p[^Ƀ\[gԍݒ肳ĂȂꍇ́A\[gԍ̔ԂB
		if(strSortNo==null || strSortNo.equals("")){
			// \[gԍ̍ől擾܂
			int intMaxSortNo = getMaxSortNo( strParentID, objDataAccess );
			// \[gԍ+1āAo^pHashtablesort_noL[ɂĊi[܂B
			strSortNo = Integer.toString( ++intMaxSortNo );
		}
		htbData.put( SORT_NO, strSortNo );

		htbData.put( MATERIAL_ID, strParentID + strChildID );

		//////////////////////////////////////////////////////
		// ID̑݃`FbNs܂
		//////////////////////////////////////////////////////
		if( objDataAccess.isExit( htbData, MATERIAL_ID ) ) {
			throw new XMOException( getMessageData( EXIT_MATERIALID_WAR ) );
		}


		String strSQL = objDataAccess.getInsertSQL(htbData);

		// o^s
		objDataAccess.execute( strSQL );

	}

	/**
	 * LoRelatioine[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MATERIAL_ID             }eAID
	 *             PARENT_ID               eID
	 *             CHILD_ID                qID
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized String update( Hashtable htData )
		throws XMOException
	{
		// LoRelatioinf[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// XVs\bhs܂
			updateAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// XV郌R[h擾܂
		Vector vecSelect = selectAction( htbParam, objDataAccess );

		//////////////////////////////////////////////////////
		// ݃`FbNs܂
		//////////////////////////////////////////////////////
		// eID̎擾
		String strParentID = (String)htbParam.get(PARENT_ID);
		// qID̎擾
		String strChildID = (String)htbParam.get(CHILD_ID);
		// XV}eAID
		String strUpdateMaterialID = strParentID + strChildID;
		// XVO}eAID
		String strBeforeMaterialID = "";
		// XVOeID
		String strBeforeParentID = "";

		// eIDAqIDǂ炩XVΏۂ̏ꍇ̂ݑ݃`FbNs
		if( strParentID != null && strChildID != null ) {
			int intCount = vecSelect.size();
			for( int i = 0; i < intCount; i++ ) {
				LoRelationData objData = (LoRelationData)vecSelect.get(i);
				strBeforeMaterialID = objData.getMaterialID();
				// XVOeID̎擾
				strBeforeParentID = objData.getParentID();
				if( !strUpdateMaterialID.equals( strBeforeMaterialID ) ) {
					if( objDataAccess.isExit( htbParam, MATERIAL_ID ) ) {
						throw new XMOException( getMessageData( EXIT_MATERIALID_WAR ) );
					}
				}
			}
		}

		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );

		String strDont = (String)htbParam.get( UPDATE_ASSIGNMENTS );
		if( strDont == null ) {
			try {
				// LOe[uXV܂
				AssignmentsClient objAss = new AssignmentsClient();
				objAss.setMaterialID( strUpdateMaterialID );
				objAss.setWhereMaterialID( strBeforeMaterialID );

				// LOe[uXV
				if( !objAss.update() ) {
					// DBG[𓊂
					throw new XMOException( objAss.getMessageData() );
				}
			}
			catch( Exception e ) {
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
				// VXeG[𓊂
				throw new XMOException( getMessageData( SYSTEM_ERR ) );
			}
		}

		// Reiϊɂ̓Xe[^X`d͍sȂB
		if((String)htbParam.get( CHANGE_PARENTID ) == null){
			// XVO̐eIDŃXe[^X`s܂
			propagate( strBeforeParentID, objDataAccess );
			// XV̐eIDŃXe[^X`s܂
			propagate( strParentID, objDataAccess );
		}

	}

	/**
	 * LoRelatione[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           폜
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized String delete( Hashtable htData )
		throws XMOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// 폜s\bhs܂
			deleteAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return "";
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SelectID̎擾
		String strSelectID = (String)htbParam.get( DELETE_SELECTID );
		if( strSelectID == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}
		// ParentID̎擾
		String strParentID = (String)htbParam.get( DELETE_PARENTID );
		if( strParentID == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// materialIDݒ肵AAssignments XMO ̍폜s
		deleteAssignments( strSelectID, strParentID, objDataAccess );


		// LoRelatione[u烌R[h폜
		StringBuffer sbSQL = new StringBuffer( "DELETE FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strSelectID) );
		sbSQL.append( "' AND " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "'");
		// SQLs
		objDataAccess.execute( sbSQL.toString() );


		/// LO폜ȊOĂ΂ꂽꍇɓ`s
		if( htbParam.get( CALL_FROM_DELETE ) == null ) {
			// eLO̓_̍ďWvs܂
			// 폜̐eIDŃXe[^X`s܂
			propagate( strParentID, objDataAccess );
		}


	}

	/**
	 * LoRelatione[uA擾R[hmaterialID
	 * ݒ肵āAAssignments XMO ̍폜s܂
	 *
	 * @param strSelectID
	 * @paran strParentID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAssignments( String strSelectID, String strParentID,
		DataAccess objDataAccess ) throws XMOException, SQLException
	{
		try {
			// MaterialID̍쐬
			String strMaterialID = strParentID + strSelectID;
			// AssignmentsNCAgCX^X܂B
			AssignmentsClient objAssignments = new AssignmentsClient();
			// materialIDݒ肵AAssignments XMO ̍폜s
			objAssignments.setWhereMaterialID( strMaterialID );
			objAssignments.setConnectionIndex(
				objDataAccess.getConnectionIndex() );
			if( !objAssignments.delete() ) {
				throw new XMOException( objAssignments.getMessageData() );
			}
		} catch (Exception e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}



	/**
	 * SelectIDO[v𔻒肵A
	 * LoRelatione[u̍XV܂͍폜s܂B
	 *
	 * @param strSelectID
	 * @param strParentID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqSelectID( String strSelectID, String strParentID,
		DataAccess objDataAccess ) throws XMOException, SQLException
	{

	}

	/**
	 * LoRelatione[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized Vector select( Hashtable htData )
		throws XMOException
	{
		// LoRelationf[^null̂Ƃ
		if( htData == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}


		// ߂l
		Vector vecReturn = new Vector();
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = selectAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );
		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
			// ORDER BY傪ȂꍇALOIDORDER BYǉ
			if(strCondition.indexOf("ORDER BY") == -1)
			{
				sbSQL.append(" ORDER BY " + SORT_NO );
			}
		}
		else
		{
				sbSQL.append(" ORDER BY " + SORT_NO );
		}

		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			String strMaterialID = ChangeEncode.setChar( rs.getString( MATERIAL_ID ) );
			String strParentID = ChangeEncode.setChar( rs.getString( PARENT_ID ) );
			String strChildID = ChangeEncode.setChar( rs.getString( CHILD_ID ) );
			LoRelationData objData = new LoRelationData();
			objData.setMaterialID( strMaterialID );
			objData.setParentID( strParentID );
			objData.setChildID( strChildID );
			vecReturn.add( objData );
		}

		return vecReturn;

	}

	/**
	 * eIDw肵āAsort_no̍ől擾A
	 * int^ŕԂ܂B
	 * @param strParentID eID
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public int getMaxSortNo(String strParentID, DataAccess objDataAccess)
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT MAX(sort_no) as sort_no FROM " + TABLE_NAME + " WHERE " + PARENT_ID + "='" + StringEscapeUtils.escapeSql(strParentID) + "'" );

		// SQL̎ss܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		int intSortNo = 0;
		if( rs.next() ) {
			intSortNo = rs.getInt( "sort_no" );
		}

		return intSortNo;
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, MATERIAL_ID );
		putData( htbData, htbParam, PARENT_ID );
		putData( htbData, htbParam, CHILD_ID );
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * Xe[^X`
	 * ړA폜ɃXe[^X`𑖂点܂B
	 * @param strLoID LOID
	 */
	private void propagate( String strLoID, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		StatusPropagation objPropagation = new StatusPropagation( strLoID );
		PropagateControl.getInstance().addPropagate(objPropagation);
	}

	/**
	 * eqIDw肵āAsort_no擾A
	 * int^ŕԂ܂B
	 * @param strMaterialID eqID
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public int getMaterialIDSortNo(String strMaterialID, DataAccess objDataAccess)
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT sort_no FROM " + TABLE_NAME + " WHERE " + MATERIAL_ID + "='" + StringEscapeUtils.escapeSql(strMaterialID) + "'" );
		// SQL̎ss܂
		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL));
		int intSortNo = 0;
		if( rs.next() ) {
			intSortNo = rs.getInt( "sort_no" );
		}
		return intSortNo;
	}

	/**
	 * ւ̎Fړsort_noȏsort_no\bḧړIDXgz񐔃vXB
	 * ւ̎Fړsort_no傫sort_no\bḧړIDXgz񐔃vXB
	 * @param intSortNo ړsort_no
	 * @param intSendListLength ړIDz
	 * @param strParentID ړ̐eID
	 * @param intType 敪(ցF1AցF2AցF3)
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void updateSortNo(int intSortNo,
										int intSendListLength,
										String strParentID,
										int intType, DataAccess objDataAccess)
		throws SQLException
	{

				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "UPDATE " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " SET " );
		sbSQL.append( SORT_NO );
		sbSQL.append( " = " );
		sbSQL.append( SORT_NO );
		sbSQL.append( " + '" );
		sbSQL.append( intSendListLength );
		sbSQL.append( "' ");
		sbSQL.append( " WHERE " );
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ");
		sbSQL.append( " AND " );
		sbSQL.append( SORT_NO );
		//ւ̎
		if (intType == 1){
			sbSQL.append( " >= '" );
		}
		//ւ̎
		if (intType == 3){
			sbSQL.append( " > '" );
		}
		sbSQL.append( intSortNo );
		sbSQL.append( "' ");

		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );

	}

	/**
	 * LoRelationIDL[LORelatione[uLoRelationIDAparentIDAsort_noXVB
	 * @param objSendData ړFLoRelationIDAparentIDAchildID
	 * @param strParentID eID(֖͉ւ̎Fړ̐eIDBւ̎Fړ̎qIDB)
	 * @param intSortNo ֖͉ւ̎Fړsort_no
	 *                          ւ̎Fړ̎q̔zsort_no̍ől
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void updateLoRelation(LoRelationData objSendData,
							String strParentID,
							int intSortNo,
							DataAccess objDataAccess)
		throws SQLException
	{
				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "UPDATE " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " SET " );
		sbSQL.append( MATERIAL_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID + objSendData.getChildID()) );
		sbSQL.append( "' ,");
		sbSQL.append( PARENT_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' ,");
		sbSQL.append( SORT_NO );
		sbSQL.append( " = '" );
		sbSQL.append( intSortNo );
		sbSQL.append( "' ");
		sbSQL.append( " WHERE " );
		sbSQL.append( MATERIAL_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(objSendData.getMaterialID()) );
		sbSQL.append( "' ");

		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );

	}

	/**
	 * ɕMemberShipIDAparentIDAchildIDAsort_noǉB
	 * @param objSendData ړFLoRelationIDAparentIDAchildID
	 * @param intSortNo ֖͉ւ̎Fړsort_no
	 *                          ւ̎Fړ̎q̔zsort_no̍ől
	 * @param objDataAccess f[^ANZX
	 * @exception SQLException DBG[ꍇ
	 */
	public void insertLoRelation(LoRelationData objSendData,
							String strParentID,
							int intSortNo,
							DataAccess objDataAccess)
		throws SQLException
	{
				// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "INSERT " );
		sbSQL.append( "INTO " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( "( " );
		sbSQL.append( MATERIAL_ID );
		sbSQL.append( "," );
		sbSQL.append( SORT_NO );
		sbSQL.append( "," );
		sbSQL.append( PARENT_ID );
		sbSQL.append( "," );
		sbSQL.append( CHILD_ID );
		sbSQL.append( " )" );
		sbSQL.append( "VALUES" );
		sbSQL.append( "( '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID + objSendData.getChildID()) );
		sbSQL.append( "' , '");
		sbSQL.append( intSortNo );
		sbSQL.append( "' , '");
		sbSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		sbSQL.append( "' , '");
		sbSQL.append( StringEscapeUtils.escapeSql(objSendData.getChildID()) );
		sbSQL.append( "' ");
		sbSQL.append( " )" );
		// SQL̎ss܂
		objDataAccess.execute( new String(sbSQL) );
	}

	/**
	 * MaterialIDw肵āAR[ȟ擾܂B
	 * Ńe[urs܂B
	 * @param strMaterialID MaterialID
	 * @param objDataAccess objDataAccess
	 * @return int R[h݊mF(R[h݂ꍇ"P"AȂꍇ"0")
	 * @exception SQLException DBO
	 */
	public int getCountMaterialID( String strMaterialID, DataAccess objDataAccess )
		throws SQLException
	{
		int intCount = 0;

		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();

			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT * " );
			sbSQL.append( " FROM " );
			sbSQL.append( TABLE_NAME );

			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( " WITH(TABLOCKX) WHERE ");
			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( " WHERE ");
			}
			sbSQL.append( MATERIAL_ID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strMaterialID) );
			sbSQL.append( "'" );
			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( " FOR UPDATE" );
			}

			DebugLog.write( this.getClass(), new String(sbSQL) , DebugLog.ROW );
			ResultSet rs = objDataAccess.executeQuery( new String(sbSQL) );

			while(rs.next()) {
				//R[h݂ꍇ
				intCount = 1;
			}
		}
		catch(Exception ex)
		{

		}
		return intCount;
	}

	/**
	 * ChildIDw肵āAR[ȟ擾܂B
	 * Ńe[urs܂B
	 * @param strChildID qID
	 * @param objDataAccess objDataAccess
	 * @return int R[h
	 * @exception SQLException DBO
	 */
	public int getCountChildID( String strChildID, DataAccess objDataAccess )
		throws SQLException
	{
			int intCount = 0;
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();

			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT COUNT(*) " );
			sbSQL.append( " FROM " );
			sbSQL.append( TABLE_NAME );

			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( " WITH(TABLOCKX) WHERE ");
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbSQL.append( " WHERE ");
			}

			sbSQL.append( CHILD_ID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strChildID) );
			sbSQL.append( "'" );

			ResultSet rs = objDataAccess.executeQuery( new String(sbSQL) );
			if( rs.next() ) {
				intCount = rs.getInt(1);
			}
		}
		catch(Exception ex)
		{

		}
		return intCount;
	}


	/**
	 * Oe[uɓo^s܂B<BR>
	 * @param strLOID o^LOID
	 * @param strPrereID o^ePrereID
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	public void insertPrerequisiteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// LOID̎擾
		String strLOID              = (String)htbParam.get( LO_ID );
		if ( strLOID == null || strLOID.equals( "" ) )
		{
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}
		try {

			// PrerequisiteNXCX^X
			String strPrerequisite      = (String)htbParam.get( PRERE );
			Prerequisite objPrere = new Prerequisite( strPrerequisite );
			objPrere.parse();
			String strPrere[] = (String[])objPrere.getLoIDList();
			for ( int i=0; i < strPrere.length; i++ )
			{
				Hashtable htbData = new Hashtable();
				htbData.put( LO_ID , strLOID );
				htbData.put( PRERE_ID , strPrere[i] );
				// o^p̃f[^Zbg܂
				String strSQL = objDataAccess.getInsertSQL(htbData,TABLE_NAME2);
				// o^s
				objDataAccess.execute( strSQL );
			}
		}
		catch( Exception e )
		{
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw new XMOException( getMessageData( SYSTEM_ERR ) );
		}
	}

}
