/*
 * 쐬: 2005/02/08
 */
package jp.co.ntt.lms.xmo.Lo.lom;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.Setup;
import jp.co.ntt.lms.lo.scorm.ScormLoEnv;
import jp.co.ntt.lms.lo.scorm.ScormManifestUtil;
import jp.co.ntt.lms.xmf.common.CommonFunction;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Lo.LoMessage;
import jp.co.ntt.lms.xmo.Lo.LoTable;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * <p>LOMf[^ANZXNXB</p>
 * <p>f[^x[X̃e[uALOMLOM_TYPẼf[^ANZX񋟂܂B
 * </p>
 * @author t-sugawara
 */
public class LomDataAccess implements LoMessage, LoTable {

    /** ^CXp擾ppX */
    private static final String PATH_TIMESPAN = "//:lom/:educational/:typicallearningtime";
    /** e[uLOM̍ځFvalue */
    private static final String LOM_VALUE = "value";
    /** e[uLOM̃e[u */
    private static final String LOM_TABLE = "lom";
    /** e[uLOM_TYPẼe[u */
    private static final String LOM_TYPE_TABLE = "lom_type";
    /** e[uLOM̍ځFpath */
    private static final String LOM_PATH = "path";
    /** e[uLOM_TYPE̍ځFpath */
    private static final String LOM_TYPE_PATH = "path";
    /** e[uLOM̍ځFLOM_TYPE */
    private static final String LOM_TYPE = "lom_type";
    /** e[uLOM_TYPE̍ځFname */
    private static final String LOM_TYPE_NAME = "name";
    /** e[uLOM_TYPE̍ځFvalue */
    private static final String LOM_TYPE_VALUE = "value";
    /** e[uLOM_TYPE̍ځFdisp_value */
    private static final String LOM_TYPE_DISPLAY_VALUE = "disp_value";
    /** e[uLOM_TYPE̍ځFselected */
    private static final String LOM_TYPE_SELECTED = "selected";
    /** e[uLOM_TYPE̍ځFdisplay_no */
    private static final String LOM_TYPE_DISPLAY_NO = "display_no";
    /** LOM_TYPEm̏ꍇɈꎞIɐݒ肵܂ */
    private static final String LOM_TYPE_MAGIC_NO = "ZZ";
    
    /** \pf[^擾邽߂SQL */
    private static final String QUERY_GET_DISPLAY_DATA = "SELECT path, lom_type, name, value, disp_value FROM lom_type WHERE NOT lom_type = 'ZZ' ORDER BY display_no";
    /** pathlom_type擾邽߂SQL */
    private static final String QUERY_GET_LOM_TYPE = "SELECT DISTINCT path, lom_type FROM lom_type WHERE NOT lom_type = 'ZZ'";
    /** e[uLOMɃf[^o^邽߂SQL */
    private static final String QUERY_INSERT_LOM = "INSERT INTO LOM VALUES(?, ?, ?, ?, ?)";
    /** e[uLOM_TYPẼpXƃpX̌擾邽߂SQL */
    private static final String QUERY_GET_LOM_PATH = "SELECT path, count(value) as value  FROM lom_type GROUP BY path";
    /** e[uLOM_TYPEɃf[^o^邽߂SQL */
    private static final String QUERY_INSERT_LOM_TYPE = "INSERT INTO lom_type VALUES(?, ?, ?, ?, ?, ?, ?)";
    /** e[uLOM_TYPEdisplay_no̍ől擾邽߂SQL */
    private static final String QUERY_GET_MAX_DISPLAY_NO = "SELECT max(display_no) FROM lom_type";
    /** pathvalueALOMLoID擾邽߂SQL */
    private static final String QUERY_GET_LOID = "SELECT DISTINCT loid FROM lom WHERE path=? AND value = ? AND NOT lom_type = 'ZZ'";
    /** e[uLOMɃf[^o^邽߂SQL */
    private static final String QUERY_GET_MAX_LOM_NO = "SELECT max(lom_no) FROM lom";
    
    /**
     * ftHgRXgN^
     */
    public LomDataAccess() {
    }
    
    /**
     * <p>wKԂ擾܂B</p>
     * <p>LoIDLOM̊wK擾܂B</p>
     * <p>R[h݂Ȃꍇ<code>null</code>Ԃ܂B</p>
     * @param loID LoID
     * @return wK
     * @throws SQLException
     */
    public String getEductionalTimeSpan(String loID) throws SQLException {
        ResultSet rs = null;
        DataAccess dataAccess = new DataAccess();
        try {
	        
	        dataAccess.trans();
	        StringBuffer queryString = new StringBuffer();
			queryString.append("SELECT ").append(LOM_VALUE);
			queryString.append(" FROM ").append(LOM_TABLE);
			queryString.append(" WHERE ").append(LO_ID).append(" = '").append(StringEscapeUtils.escapeSql(loID)).append("'");
			queryString.append(" AND ").append(LOM_PATH).append(" = '").append(PATH_TIMESPAN).append("'");
			
			rs = dataAccess.executeQuery(queryString.toString());
	
			if(rs != null && rs.next()) {
				return ChangeEncode.setChar(rs.getString(LOM_VALUE));
			}
        }
        finally {
            if (rs != null) {
                rs.close();
            }
		    dataAccess.commit();
        }
        
        return null;
    }

    /**
     * <p>LOMDB擾܂B</p>
     * <p>LOMǉ̏\Ɏgp܂B</p>
     * @return LOMiDisplayDatai[zj
     * @throws SQLException
     */
    public Vector getDisplayData() throws SQLException {
        ResultSet rs = null;
        DataAccess dataAccess = new DataAccess();
        try {
            dataAccess.trans();
            rs = getLomType(dataAccess);
			return editEmptyDisplayData(rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
			dataAccess.commit();
        }
    }

    /**
     * <p>lom_typee[ũUgZbg擾܂B</p>
     * @param dataAccess DBڑ
     * @return lom_typee[ũUgZbg
     * @throws SQLException
     */
    private ResultSet getLomType(DataAccess dataAccess) throws SQLException{
        //P̃eXg̓sADataAccessɎ󂯎
      return dataAccess.executeQuery(QUERY_GET_DISPLAY_DATA);
    }

    /**
     * <p>UgZbgɁALOM\pf[^쐬܂B</p>
     * @param rs 擾LOM̃UgZbg
     * @return LOMiDisplayDatai[zj
     * @throws SQLException
     */
    private Vector editEmptyDisplayData(ResultSet rs) throws SQLException{
        Vector data = new Vector();
        boolean end = false;
        
		if (rs == null || !(rs.next())) {
		    return null;
		}

		while(!end) {
            String path = getEncodingString(rs.getString(LOM_TYPE_PATH));
            String lom_type = getEncodingString(rs.getString(LOM_TYPE));
            //nameDispValue擾
            String name = null;
            Vector temp = new Vector();
            //eږDisplayDataɂ܂Ƃ߂
            while(!end && path.equals(getEncodingString(rs.getString(LOM_TYPE_PATH)))) {
                name = getEncodingString(rs.getString(LOM_TYPE_NAME));
                temp.add(editDisplayValue(rs, null)); 
                //ȂΏI
                if (!(rs.next())) {
                    end = true;
                }
            }
            data.add(new DisplayData(path, lom_type, name, temp));
        }
        if (data.size() == 0) {
            data = null;
        }

        return data;
    }

    /**
     * <p>LoIDɁALOMDB擾܂B</p>
     * <p>LOMǉ̏\Ɏgp܂B</p>
     * @param loID LoID
     * @return LOMiDisplayDatai[zj
     * @throws SQLException
     */
    public Vector getDisplayData(String loID) throws SQLException {
        DataAccess dataAccess = new DataAccess();
        ResultSet lomTypeResult = null;
        try {
            dataAccess.trans();
            //LoIDLOM獀ڒl擾
            Hashtable lomHash = getLomHashtable(dataAccess, loID);
            //LOM_TYPE\ڂ擾
            lomTypeResult = getLomType(dataAccess);
            //LOM_TYPE\ڂ擾ALOM̍ڒlƁALOM_TYPE̕\ڂ}b`O
            return editDisplayData(lomHash, lomTypeResult);
        }
        finally {
            if (lomTypeResult == null) {
                lomTypeResult.close();
            }
            dataAccess.commit();
        }
    }

    /**
     * <p>LOMɑ΂āApXL[ƂnbVe[u쐬܂B</p>
     * <p>LoIDL[ƂāADBLOM擾܂BLOM̍pathL[ƂāA
     *    DisplayValuei[nbVe[u쐬܂B
     * </p>
     * @param dataAccess DBڑ
     * @param loID LoID
     * @return LOMɑ΂āApXL[ƂnbVe[u
     * @throws SQLException
     */
    private Hashtable getLomHashtable(DataAccess dataAccess, String loID) throws SQLException {
        ResultSet rs = null;
        try {
            //LoIDLOM獀ڒl擾
            StringBuffer queryString = new StringBuffer();
			queryString.append("SELECT ").append(LOM_TYPE_PATH);
			queryString.append(", ").append(LOM_TYPE_VALUE);
			queryString.append(" FROM ").append(LOM_TABLE);
			queryString.append(" WHERE ").append("loid = '").append(StringEscapeUtils.escapeSql(loID)).append("'");
			queryString.append(" order by ").append(LOM_PATH).append(", ").append(LOM_VALUE);
			rs = dataAccess.executeQuery(queryString.toString());
			Hashtable lomHash = new Hashtable();
			if (rs != null && rs.next()) {
			    boolean end = false;
			    while(!end) {
	                String path = getEncodingString(rs.getString(LOM_PATH));
	                Vector displayValue = new Vector();
		            while(!end && path.equals(getEncodingString(rs.getString(LOM_TYPE_PATH)))) {
		                String value = getEncodingString(rs.getString(LOM_TYPE_VALUE));
		                displayValue.add(new DisplayValue(value, value, true));
		                //ȂΏI
		                if (!(rs.next())) {
		                    end = true;
		                }
		            }
			        lomHash.put(path, displayValue);
			    }
			}
			return lomHash;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /**
     * <p>LOM\pf[^ҏW܂B</p>
     * <p>LoID擾LOM̃nbVe[uƁALOM_TYPẼUgZbgA
     *    ΏۂLoLOMʕ\pɕҏW܂B
     *    <code>lomHash</code>́AIڗpɍږɑSĂ̑Iڂi[Ă܂B
     *    eLXgڂɂẮAl̂܂܁AZbgAIڂ͂<code>lomHash</code>rA
     *    lɑItOt^܂B
     * </p>
     * @param lomHash LOM
     * @param rs UgZbg
     * @return DisplayDatai[xN^
     * @throws SQLException
     */
    private Vector editDisplayData(Hashtable lomHash, ResultSet rs) throws SQLException {
        Vector data = new Vector();
        boolean end = false;
        
		if (rs == null || !(rs.next())) {
		    return null;
		}

		while(!end) {
            String path = getEncodingString(rs.getString(LOM_TYPE_PATH));
            String lom_type = getEncodingString(rs.getString(LOM_TYPE));
            //nameDispValue擾
            Vector lomValue = (Vector) lomHash.get(path);
            Vector temp = new Vector();
//            System.out.println("lom_type:" + lom_type);
            String name = null;
            //eږDisplayDataɂ܂Ƃ߂
            while(!end && path.equals(getEncodingString(rs.getString(LOM_TYPE_PATH)))) {
                name = getEncodingString(rs.getString(LOM_TYPE_NAME));
//                System.out.println("lomValue:" + lomValue);
                //eLXgڂƁÃeLXgڂ̏ꍇ
                if(lom_type.equals(DisplayData.LOM_TYPE_TEXT)
                        || lom_type.equals(DisplayData.LOM_TYPE_ANYTEXT)) {
                    if (lomValue == null) {
                        temp.add(new DisplayValue("","",false));
                    }
                    else {
                        temp = lomValue;
                    }
                }
                else {
                    //Iڂ̏ꍇ
                    temp.add(editDisplayValue(rs, lomValue)); 
                }

                //ȂΏI
                if (!(rs.next())) {
                    end = true;
                }
            }
            data.add(new DisplayData(path, lom_type, name, temp));
//            System.out.println("end... " + name);
        }
        if (data.size() == 0) {
            data = null;
        }

        return data;
    }
    
    /**
     * <p>LOM̑IڂҏW܂B</p>
     * <p>LOMŉʏAIڂɎw肳Ă鍀ڂҏW܂B<br>
     *    LoID擾LOMɑ΂āALOM_TYPȆIڂƃ}b`O܂B<br>
     *    }b`Iڂɑ΂āAʏIĂ邱Ƃ𔻕ʂ邽߁A<code>DisplayValue.selected</code>̒l<code>true</code>ɂč쐬܂B
     * </p>
     * @param rs UgZbg
     * @param lomValue
     * @return ҏW̑I
     * @throws SQLException
     */
    private DisplayValue editDisplayValue(ResultSet rs, Vector lomValue) throws SQLException{
        String value = getEncodingString(rs.getString(LOM_TYPE_VALUE));
        String display_value = getEncodingString(rs.getString(LOM_TYPE_DISPLAY_VALUE));
        boolean selected = false;
        if (lomValue != null) {
            for (int i = 0; i < lomValue.size(); ++i) {
                DisplayValue selectedValue = (DisplayValue) lomValue.get(i);
                if(selectedValue.getLomTypeValue().equals(value)) {
                    selected = true;
                }
            }
        }
        return new DisplayValue(value, display_value, selected);
    }
    
    /**
     * <p>LOM̃eLXgڂΏۂɌ܂B</p>
     * <p>LOʂ̍ځu܂܂镶vɓ͂ꂽL[LoID܂B
     * </p>
     * @param searchText L[[h
     * @return LoIDi[xN^
     * @throws SQLException
     */
    public Vector searchText(String searchText) throws SQLException {
        DataAccess dataAccess = null;
        ResultSet rs = null;
        try {
            dataAccess = new DataAccess();
            dataAccess.trans();
            StringBuffer queryString = new StringBuffer();
            queryString.append("SELECT DISTINCT loid FROM lom ");
            queryString.append(" WHERE (lom_type='00' OR lom_type='15') AND value LIKE '%");
            queryString.append(/*CommonFunction.encodeSJIS(*/searchText/*)*/).append("%'");

            DebugLog.write(getClass(),
    				"searchText() QueryString"+queryString.toString(), DebugLog.ROW);

            rs = dataAccess.executeQuery(queryString.toString());
    		if (rs == null) {
    		    return new Vector();
    		}

    		Vector loIDArray = new Vector();
    		while(rs.next()) {
    		    loIDArray.add(rs.getString(1).trim());
    		}
    		dataAccess.commit();

    		if (loIDArray.size() == 0) {
                loIDArray = new Vector();
            }

            return loIDArray;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }
    
    /**
     * <p>LOM̑IڂΏۂɌ܂B</p>
     * <p>LOʂ̊eIڂœ͂ꂽ͒lƁAځipXjLoID܂B
     *    LoID擾łȂꍇAvf[̃xN^Ԃ܂B
     * </p>
     * @param params i[Vector
     * @return LoIDi[xN^
     * @throws SQLException
     */
    public Vector searchLom(Vector params) throws SQLException {
        DataAccess dataAccess = null;
        PreparedStatement pstmt = null;
        try {
            Iterator paramIterator = params.iterator();
            dataAccess = new DataAccess();
            dataAccess.trans();
            pstmt = dataAccess.prepareStatement(QUERY_GET_LOID);
            
            Hashtable loIDTable = null;
            while (paramIterator.hasNext()) {
                DisplayData data = (DisplayData) paramIterator.next();
                Iterator itemIterator = data.getDisplayValueIterator();
                while (itemIterator.hasNext()) {
                    DisplayValue value = (DisplayValue) itemIterator.next();
                    //f[^̏ꍇAnbVe[uɂ̂܂܃Zbg
                    if (loIDTable == null) {
                        loIDTable = getLoIDTable(pstmt, data.getPath(), value.getLomTypeValue());
                        //擾łȂÃxN^ԂďIB
                        if(loIDTable == null) {
                            return new Vector();
                        }
                    }
                    else {
                        //f[^擾ixN^j
                        Vector loIDArray = getLoIDArray(pstmt, data.getPath(), value.getLomTypeValue());
                        //nbVƔrB
                        loIDTable = matchingLoID(loIDTable, loIDArray);
                    }
                    //ǂƂ}b`Ȃ΋̃xN^ԂďIB
                    if (loIDTable == null || loIDTable.size() == 0) {
                        return new Vector();
                    }
                }
            }
            return new Vector(loIDTable.values());
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
            dataAccess.commit();
        }
    }

    /**
     * <p>LOMe[uALoID̃nbVe[u擾܂B</p>
     * @param pstmt
     * @param path
     * @param value
     * @return 擾LoID̃nbVe[u
     * @throws SQLException
     */
    private Hashtable getLoIDTable(PreparedStatement pstmt, String path, String value) throws SQLException {
        ResultSet rs = null;
        Hashtable loIDTable = new Hashtable();
        try {
            pstmt.setString(1, path);
            pstmt.setString(2, value);
            rs = pstmt.executeQuery();
            
            if (rs == null) {
                return null;
            }
            
            while(rs.next()) {
                String loID = rs.getString(1).trim();
                loIDTable.put(loID, loID);
            }
            
            //ꌏ擾łȂꍇB
            if (loIDTable.size() == 0) {
                loIDTable = null;
            }
            return loIDTable;
        }
        finally {
            if (rs == null) {
                rs.close();
            }
        }
    }
    
    /**
     * <p>LOMe[uALoID̃xN^擾܂B</p>
     * @param pstmt
     * @param path
     * @param value
     * @return 擾LoIDi[xN^
     * @throws SQLException
     */
    private Vector getLoIDArray(PreparedStatement pstmt, String path, String value) throws SQLException {
        ResultSet rs = null;
        Vector loIDArray = new Vector();
        try {
            pstmt.setString(1, path);
            pstmt.setString(2, value);
            rs = pstmt.executeQuery();
            
            if (rs == null) {
                return null;
            }
            
            while(rs.next()) {
                String loID = rs.getString(1).trim();
                loIDArray.add(loID);
            }
            
            //ꌏ擾łȂꍇB
            if (loIDArray.size() == 0) {
                loIDArray = null;
            }
            return loIDArray;
        }
        finally {
            if (rs == null) {
                rs.close();
            }
        }
    }
    
    /**
     * <p>LoID̃}b`Os܂B</p>
     * @param loIDTable
     * @param loIDArray
     * @return }b`LoIDi[nbV}bv
     */
    public static final Hashtable matchingLoID(Hashtable loIDTable, Vector loIDArray) {
        //擾łȂAnullԂďIB
        if (loIDTable == null || loIDArray == null) {
            return new Hashtable();
        }

        Hashtable matchID = new Hashtable();
        Iterator loIDIterator = loIDArray.iterator();
//        System.out.println("loIDTable" + loIDTable);
        while (loIDIterator.hasNext()) {
            String loID2 = (String) loIDIterator.next();
            String loID = (String) loIDTable.get(loID2);
//            System.out.println("loids" + loID2 + "/" + loID);
            if (loID != null) {
                matchID.put(loID, loID);
            }
        }
        
        return matchID;
    }
    
    /**
     * ʂɂē͂LOMDBɓo^܂B
     * @param displayData
     * @return 
     * @throws SQLException
     */
    public boolean enrollDisplayData(Vector displayData) throws SQLException {
        DataAccess dataAccess = new DataAccess();
        boolean isSuccess = false;

        dataAccess.trans();
        //LoIDi[
        String loID = (String) displayData.get(0);
        if (loID == null) {
            return isSuccess;
        }
        //LoID̗vf폜
        displayData.remove(0);

        try {
            //LOM_TYPEɁApXL[ɂLOM_TYPE擾B
            Hashtable displayType = getDisplayType(dataAccess);
            //LoIDɁALOMx폜
            deleteLomDara(dataAccess, loID);
            //LOMf[^ݒB
            insertDisplayData(dataAccess, loID, displayData, displayType);
        }
        catch (SQLException ex) {
            dataAccess.rollback();
            throw ex;
        }
        
        dataAccess.commit();
        isSuccess = true;

        return isSuccess;
    }
    
    /**
     * <p>pXL[ƂLOM_TYPEe[u̍LOM_TYPEi[nbVe[u擾܂B</p>
     * @param dataAccess DBڑ
     * @return pXL[ƂLOM_TYPEe[u̍LOM_TYPEi[nbVe[u
     * @throws SQLException
     */
    private Hashtable getDisplayType(DataAccess dataAccess) throws SQLException {
        ResultSet rs = null;
        Hashtable displayType = new Hashtable();
        try {
            rs = dataAccess.executeQuery(QUERY_GET_LOM_TYPE);
            if (rs == null) {
                return null;
            }
            while(rs.next()) {
                String path = getEncodingString(rs.getString(LOM_TYPE_PATH));
                String lom_type = getEncodingString(rs.getString(LOM_TYPE));
                displayType.put(path, lom_type);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return displayType;
    }

    /**
     * <p>LoIDLOM폜܂B</p>
     * @param dataAccess DBڑ
     * @param loID LOID
     * @throws SQLException
     */
    private void deleteLomDara(DataAccess dataAccess, String loID) throws SQLException {
        StringBuffer queryString = new StringBuffer();
        queryString.append("DELETE FROM lom WHERE loid = '").append(StringEscapeUtils.escapeSql(loID)).append("'");
        dataAccess.execute(queryString.toString());
    }
    
    /**
     * <p>f[^o^s܂B</p>
     * @param dataAccess DBڑ
     * @param loID LoID
     * @param displayDataArray
     * @param displayType
     * @throws SQLException
     */
    private void insertDisplayData(DataAccess dataAccess,
            						String loID,
            						Vector displayDataArray,
            						Hashtable displayType) throws SQLException{
        PreparedStatement insertPstmt = null;
        try {
            Iterator iterator = displayDataArray.iterator();

            while(iterator.hasNext()) {
                DisplayData displayData = (DisplayData) iterator.next();
                String path = displayData.getPath();
                String lom_type = (String) displayType.get(path);

                Iterator values = displayData.getDisplayValueIterator();
                while(values.hasNext()) {
                    int lom_no = getNextLomNo(dataAccess);
                    DisplayValue displayValue = (DisplayValue)values.next();
                    insertPstmt = dataAccess.prepareStatement(QUERY_INSERT_LOM);
                    insertPstmt.setInt(1, lom_no);
                    insertPstmt.setString(2, loID);
                    insertPstmt.setString(3, path);
                    insertPstmt.setString(4, lom_type);
                    insertPstmt.setString(5, displayValue.getLomTypeValue());
                    insertPstmt.execute();
                }
            }
        }
        catch (Exception ex) {
            dataAccess.rollback();
            throw new SQLException(ex.getMessage());
        }
        finally {
            if (insertPstmt != null) {
                insertPstmt.close();
            }
        }
    }
    
    /**
     * <p>}jtFXgt@CLOMDBɓo^܂B</p>
     * @param dataAccess DBڑ
     * @param params
     * @return 
     * @throws SQLException
     * @throws Exception
     */
    public boolean enrollEntryData(DataAccess dataAccess, Hashtable params) throws SQLException, Exception{
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD enrollEntryData(" + params + ")", DebugLog.ROW);
        boolean isSuccess = false;

        String loID = (String) params.get(Setup.LOID);
        if (loID == null) {
            return isSuccess;
        }
        
        File manifest = ScormManifestUtil.getManifestTempFile((String)params.get(Setup.MATERIALID));
        File entry = getLomEntryFile();
//        System.out.println("getManifestOK? " + manifest + "/" + entry);
        EntryDataFactory factory = new EntryDataFactory(manifest, entry);
        Vector entryData = factory.makeEntryData();
//        System.out.println("entry.xml擾");
		DebugLog.write(getClass(),"entry.xml擾", DebugLog.ROW);
        //LOMڍXV
        updateLomType(dataAccess, entryData, factory.getEntryTable());
//        System.out.println("LOMڍXV");
		DebugLog.write(getClass(),"LOMڍXV", DebugLog.ROW);
        //Iڂvalue{LuAlom_typevalueɒu
        changeVocabulary(dataAccess, entryData);
//        System.out.println("Lom.Valueϊ");
		DebugLog.write(getClass(),"Lom.Valueϊ", DebugLog.ROW);
        //LoIDɁALOMx폜
        deleteLomDara(dataAccess, loID);
        //LOMXV
        insertEntryData(dataAccess, loID, entryData);

        isSuccess = true;

//        System.out.println("I");
		DebugLog.write(getClass(),"Lom.Valueϊ", DebugLog.ROW);
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL enrollEntryData(" + isSuccess + ")", DebugLog.ROW);

        return isSuccess;
    }

    /**
     * <p>LOM荞ݗvft@C擾܂B</p>
     * @return 擾LOM荞݃t@C
     * @throws LOException
     */
	private File getLomEntryFile() throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormManifestUtil.class,
			"HEAD getLomEntryFile()",
			DebugLog.ROW);

		ScormLoEnv env = new ScormLoEnv();
		String entryFile = env.getLomEntryFile();
		// \bhIO
		DebugLog.write(
			ScormManifestUtil.class,
			"TAIL getLomEntryFile()"
				+ " return " + entryFile,
			DebugLog.ROW);
		return new File(entryFile);

	}

	/**
     * <p>LOM_TYPEe[u̍XVs܂B</p>
     * @param dataAccess DBڑ
	 * @param entryData
	 * @param entryTable
	 * @throws SQLException
	 */
    private void updateLomType(DataAccess dataAccess, Vector entryData, Hashtable entryTable) throws SQLException {
        PreparedStatement insertPstmt = null;

        Hashtable dbPathTable = getLomPath(dataAccess);
        try {
            for (int i = 0; i < entryData.size(); ++i) {
                EntryDataUnit dataUnit = (EntryDataUnit) entryData.get(i);
                
                // Iڂ̏ꍇ
                if (dataUnit.isChoices()) {
                    //LOM_TYPEɍڂꍇ͑I݂ōڂǉ
                    if (dbPathTable.get(dataUnit.getNodeString()) == null) {
                        String displayNo = getNextDisplayNo(dataAccess);
                        insertPstmt = dataAccess.prepareStatement(QUERY_INSERT_LOM_TYPE);
                        insertPstmt.setString(1, displayNo);
                        insertPstmt.setString(2, dataUnit.getNodeString());
                        insertPstmt.setString(3, LOM_TYPE_MAGIC_NO);
                        insertPstmt.setString(4, dataUnit.getName());
                        insertPstmt.setString(5, "0");
                        insertPstmt.setString(6, dataUnit.getValue());
                        insertPstmt.setString(7, dataUnit.getValue());
                        insertPstmt.execute();
                        dbPathTable.put(dataUnit.getNodeString(), "1");
                    }
                    else {
                        if (!checkVocabulary(dataAccess, dataUnit.getNodeString(), dataUnit.getValue())) {
                            String displayNo = getDisplayNo(dataAccess, dataUnit.getNodeString());
                            String value = (String) dbPathTable.get(dataUnit.getNodeString());
                            insertPstmt = dataAccess.prepareStatement(QUERY_INSERT_LOM_TYPE);
                            insertPstmt.setString(1, displayNo);
                            insertPstmt.setString(2, dataUnit.getNodeString());
                            insertPstmt.setString(3, LOM_TYPE_MAGIC_NO);
                            insertPstmt.setString(4, dataUnit.getName());
                            insertPstmt.setString(5, value);
                            insertPstmt.setString(6, dataUnit.getValue());
                            insertPstmt.setString(7, dataUnit.getValue());
                            insertPstmt.execute();
                            int nextValue = Integer.parseInt(value);
                            dbPathTable.put(dataUnit.getNodeString(), String.valueOf(nextValue));
                        }
                    }
                }
                else {
                    //LOM_TYPEɍڂꍇ
                    if (dbPathTable.get(dataUnit.getNodeString()) == null) {
                        String displayNo = getNextDisplayNo(dataAccess);
                        insertPstmt = dataAccess.prepareStatement(QUERY_INSERT_LOM_TYPE);
                        insertPstmt.setString(1, displayNo);
                        insertPstmt.setString(2, dataUnit.getNodeString());
                        insertPstmt.setString(3, LOM_TYPE_MAGIC_NO);
                        insertPstmt.setString(4, dataUnit.getName());
                        insertPstmt.setString(5, null);
                        insertPstmt.setString(6, null);
                        insertPstmt.setString(7, null);
                        insertPstmt.execute();
                        dbPathTable.put(dataUnit.getNodeString(), "1");
                    }
                }
            }
        }
        catch(SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (insertPstmt != null) {
                insertPstmt.close();
            }
        }
    }

    /**
     * <p>LOM_TYPEe[uPATHL[value̍ڐlƂnbVe[uԂ܂B</p>
     * @param dataAccess DBڑ
     * @return LOM_TYPEe[uPATHL[value̍ڐlƂnbVe[u
     * @throws SQLException
     */
    private Hashtable getLomPath(DataAccess dataAccess) throws SQLException {
        Hashtable tempTable = new Hashtable();
        ResultSet rs = null;
        
        try {
            rs = dataAccess.executeQuery(QUERY_GET_LOM_PATH);
            if (rs != null) {
                while (rs.next()) {
                    tempTable.put(rs.getString(LOM_TYPE_PATH), rs.getString(LOM_TYPE_VALUE));
                }
            }
        }
        catch (Exception ex) {
            dataAccess.rollback();
            throw new SQLException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return tempTable;
    }

    /**
     * <p>{Lũ`FbNs܂B</p>
     * <p>e[uLOM_TYPEscorm_vocabularyƔrÃ{Lu̗L`FbN܂B
     *    e[uɑ݂Ă<code>true</code>A݂ĂȂ<code>false</code>Ԃ܂B</p>
     * @param dataAccess
     * @param path
     * @param vocabulary
     * @return
     * @throws SQLException
     */
    private boolean checkVocabulary(DataAccess dataAccess, String path, String vocabulary) throws SQLException {
        StringBuffer queryString = new StringBuffer();
        queryString.append("SELECT value FROM lom_type ");
        queryString.append(" WHERE path='").append(StringEscapeUtils.escapeSql(path)).append("'");
        queryString.append(" AND scorm_vocabulary='").append(StringEscapeUtils.escapeSql(vocabulary)).append("'");
        ResultSet rs = dataAccess.executeQuery(queryString.toString());
        try {
            String displayNo = null;
            if (rs == null) {
                throw new SQLException("{Lũ`FbNɎs܂B");
            }
            while (rs.next()) {
                displayNo = rs.getString(1);
            }
            if (displayNo == null) {
                return false;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return true;
    }
    
    /**
     * <p>LOM_TYPEe[uDisplayNo̎̒l擾܂B</p>
     * <p>LOMڂƂɎgpBo^LOMڂ̂߂ɁA
     *    ݂display_no̍ől̎̐擾܂B
     *    [l̕ɕϊAԂ܂B
     * </p>
     * @param dataAccess DBڑ
     * @return LOM_TYPEe[uDisplayNo̎̒l
     * @throws SQLException
     */
    private String getNextDisplayNo(DataAccess dataAccess) throws SQLException {
        ResultSet rs = null;
        
        try {
            rs = dataAccess.executeQuery(QUERY_GET_MAX_DISPLAY_NO);
            int no = 0;
            if (rs != null && rs.next()) {
                    no = rs.getInt(1);
            }
            ++no;
            DecimalFormat format = new DecimalFormat("0000000000");
            return format.format(no);
        }
        catch (Exception ex) {
            dataAccess.rollback();
            throw new SQLException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        
    }

    /**
     * <p>LOM_TYPEe[udisplay_no擾܂B</p>
     * @param dataAccess
     * @param path 擾display_nõpX
     * @return 擾display_no
     * @throws SQLException
     */
    private String getDisplayNo(DataAccess dataAccess, String path) throws SQLException {
//        "SELECT DISTINCT display_no FROM lom_type WHERE path=?"
        StringBuffer queryString = new StringBuffer();
        queryString.append("SELECT DISTINCT display_no FROM lom_type ");
        queryString.append(" WHERE path='").append(StringEscapeUtils.escapeSql(path)).append("'");
        ResultSet rs = dataAccess.executeQuery(queryString.toString());
        try {
            if (rs == null) {
                throw new SQLException("display_no̎擾Ɏs܂B");
            }
            String displayNo = null;
            while (rs.next()) {
                displayNo = rs.getString(LOM_TYPE_DISPLAY_NO);
            }
            if (displayNo == null) {
                throw new SQLException("display_no̎擾Ɏs܂B");
            }

            return displayNo;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }
    
    /**
     * <p>EntryDataUnitvalue{LuA{LuɑΉLOM_TYPE̍ڒl֕ύX܂B</p>
     * @param dataAccess DBڑ
     * @param entryData
     * @throws SQLException
     */
    private void changeVocabulary(DataAccess dataAccess, Vector entryData) throws SQLException{
        ResultSet rs = null;
        try {
            for (int i = 0; i < entryData.size(); ++i) {
                EntryDataUnit dataUnit = (EntryDataUnit) entryData.get(i);
                if (dataUnit.isChoices()) {
                    StringBuffer queryString = new StringBuffer();
                    queryString.append("SELECT value FROM lom_type ");
                    queryString.append(" WHERE path='").append(StringEscapeUtils.escapeSql(dataUnit.getNodeString())).append("'");
                    queryString.append(" AND scorm_vocabulary='").append(StringEscapeUtils.escapeSql(dataUnit.getValue())).append("'");
                    rs = dataAccess.executeQuery(queryString.toString());
                    if (rs != null && rs.next()) {
                        String value = rs.getString(LOM_TYPE_VALUE);
                        EntryDataUnit replaceUnit = new EntryDataUnit(dataUnit.getNodeString(),
                                										dataUnit.getName(),
                                										value,
                                										dataUnit.isChoices());
                        entryData.set(i, replaceUnit);
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /**
     * <p>LOMe[uɃf[^o^܂B</p>
     * <p>SCORMLOM擾ۂɎgp܂B
     * </p>
     * @param dataAccess DBڑ
     * @param loID LoID
     * @param entryData
     * @throws SQLException
     */
    private void insertEntryData(DataAccess dataAccess, String loID, Vector entryData) throws SQLException{
        Hashtable displayType = getDisplayType(dataAccess);
        Iterator iterator = entryData.iterator();
        while(iterator.hasNext()) {
            int lom_no = getNextLomNo(dataAccess);
            EntryDataUnit dataUnit = (EntryDataUnit) iterator.next();
//            private static final String QUERY_INSERT_LOM = "INSERT INTO LOM VALUES(?, ?, ?, ?, ?)";
            StringBuffer queryString = new StringBuffer();
            queryString.append("INSERT INTO LOM VALUES(");
            queryString.append(lom_no);
            queryString.append(", '").append(StringEscapeUtils.escapeSql(loID)).append("'");
            queryString.append(", '").append(StringEscapeUtils.escapeSql(dataUnit.getNodeString())).append("'");
            queryString.append(", '").append(StringEscapeUtils.escapeSql((String) displayType.get(dataUnit.getNodeString()))).append("'");
            queryString.append(", '").append(StringEscapeUtils.escapeSql(dataUnit.getValue())).append("'");
            queryString.append(")");
    		DebugLog.write(getClass(),
    				"SQL insertEntryData:" + queryString.toString(), DebugLog.ROW);
            dataAccess.execute(queryString.toString());
        }
    }

    /**
     * <p>LOM_NO̎̒l擾B</p>
     * <p>DBLOMe[uɓo^ۂLOM_NO擾B
     *    擾LOM_NÓA݂LOM_NO̍ől1Ẑݒ肳B
     * </p>
     * @param dataAccess
     * @return LOM_NO
     * @throws SQLException
     */
    private int getNextLomNo(DataAccess dataAccess) throws SQLException {
//        private static final String QUERY_GET_MAX_LOM_NO = "SELECT max(lom_no) FROM lom";
        StringBuffer queryString = new StringBuffer();
        queryString.append("SELECT max(lom_no) FROM lom");
        ResultSet rs = null;

        try {
            int lom_no = 0;
            
            rs = dataAccess.executeQuery(queryString.toString());
            if (rs != null && rs.next()) {
                lom_no = rs.getInt(1);
                ++lom_no;
            }
            else {
                throw new SQLException("f[^x[X̃e[uLOM̃ANZXɎs܂B");
            }
            return lom_no;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /**
     * <p>̃GR[fBOs܂B</p>
     * <p>eDBɑ΂ẴGR[fBOsBsہÂ<code>null</code>̏ꍇA
     *    [̕Ԃ܂B</p>
     * @param value
     * @return GR[fBO̕
     */
    private static final String getEncodingString(String value) {
        if (value == null) {
            value = "";
        }
        return ChangeEncode.setChar(value);
    }
}
