/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XMSBase f[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.Base;

// Java API
import java.util.*;
import java.sql.*;

import org.apache.commons.lang.StringEscapeUtils;
// XMS API
import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.Base.Gui.*;

/**
 * Base(XMS_B)̃f[^ANZXNXłB<BR>
 * XMSBaseǗXMOEntrye[uւ̓o^AXVA폜A@\܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class XMSBaseDataAccess
	implements XMSBaseMessage, XMSBaseTable
{

	/**
	 * RXgN^<BR>
	 * NX̏s܂
	 */
	public XMSBaseDataAccess() {
	}

	/**
	 * XMOEntrye[uւ̓o^s܂
	 * @exception XMOException o^ŗOꍇ
	 */
	synchronized public String insertEntry( Hashtable htbParam )
		throws XMOException
	{

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(ENTRY_TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			// CT[gs\bhĂт܂
			insertEntryAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XMOEntrye[uւ̓o^s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	private void insertEntryAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// o^p̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		// o^SQL擾܂
		String strSQL = objDataAccess.getInsertSQL( htbData );

		// o^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * XMOEntrye[uւ̍XVs܂
	 */
	synchronized public String updateEntry( Hashtable htbParam )
		throws XMOException
	{

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(ENTRY_TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htbParam );

			// XVs\bhs܂
			updateEntryAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XMOEntrye[uւ̍XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	private void updateEntryAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );

	}

	/**
	 * XMOEntrye[uւ̍폜s܂
	 * @param htbParam 폜
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	synchronized public String deleteEntry( Hashtable htbParam )
		throws XMOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(ENTRY_TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htbParam );

			// 폜s\bhs܂
			deleteEntryAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return "";
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	private void deleteEntryAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + ENTRY_TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}

		// 폜s
		objDataAccess.execute( sbSQL.toString() );
	}

	/**
	 * XMOEntrye[uւ̌s܂
	 * @param htbParam 
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	public Vector selectEntry( Hashtable htbParam )
		throws XMOException
	{
		Vector vecReturn = new Vector();
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(ENTRY_TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htbParam );

			// 폜s\bhs܂
			vecReturn = selectEntryAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception SQLException f[^x[XG[ꍇ
	 */
	private Vector selectEntryAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + ENTRY_TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		// \[gΐݒ
		String strOrderBy   = (String)htbParam.get(ORDER_BY);
		if(strOrderBy != null)
		{
			sbSQL.append(strOrderBy);
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			// etB[h̒l擾܂
			String strXmoID = ChangeEncode.setChar( rs.getString( XMO_ID ) );
			String strXmoName = ChangeEncode.setChar( rs.getString( XMO_NAME ) );
			String strXmoOutLine = ChangeEncode.setChar( rs.getString( XMO_OUT_LINE ) );
			String strXmoUri = ChangeEncode.setChar( rs.getString( XMO_URI ) );
			String strXmoOnFlg = ChangeEncode.setChar( rs.getString( XMO_ON_FLG ) );
			String strClassName = ChangeEncode.setChar( rs.getString( CLASS_NAME_F ) );
			String strTreeViewType = ChangeEncode.setChar( rs.getString( TREE_VIEW_TIPE ) );
			String strIniMenu = ChangeEncode.setChar( rs.getString( INI_MENU ) );
			String strPriority = ChangeEncode.setChar( rs.getString( PRIORITY ) );
			// AssignmentsDataNX̃CX^X
			XMOEntryData objData = new XMOEntryData();
			// etB[hlZbg܂
			objData.setXmoID( strXmoID );
			objData.setXmoName( strXmoName );
			objData.setXmoOutLine( strXmoOutLine );
			objData.setXmoUri( strXmoUri );
			objData.setXmoOnFlg( strXmoOnFlg );
			objData.setClassName( strClassName );
			objData.setTreeViewType( strTreeViewType );
			objData.setIniMenu( strIniMenu );
			objData.setPriority( strPriority );
			// ԋpxN^[AssignmentsDataNXǉ܂
			vecReturn.add( objData );
		}

		return vecReturn;

	}

	/**
	 * őXMOID擾
	 * @return String őAssignID
	 */
	private String getMaxAssignID( DataAccess objDataAccess )
		throws SQLException
	{

			String strMaxAssignID = "";
			String strSQL="";
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( Environment.DB_SQLSERVER )){
				strSQL = "select MAX(CONVERT(INT," + XMO_ID + ")) + 1 as maxassignid from " + ENTRY_TABLE_NAME;
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( Environment.DB_ORACLE )){
				strSQL = "select MAX(TO_NUMBER("+ XMO_ID +")) + 1 as maxassignid from " + ENTRY_TABLE_NAME;
			//PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( Environment.DB_POSTGRE )){
				strSQL = "select MAX(TO_NUMBER("+ XMO_ID +",'999999999999999')) + 1 as maxassignid from " + ENTRY_TABLE_NAME;
			}

			Vector vecList = new Vector();
			try {
				ResultSet rs = objDataAccess.executeQuery(strSQL);

				while(rs.next()) {
					int intTemp = 0;
					intTemp = rs.getInt( "maxassignid" );
					strMaxAssignID = new Integer(intTemp).toString();
				}
			}
			catch( SQLException e ) {
				// ŃO͂
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
				throw e;
			}
		}
		catch(Exception ex)
		{

		}
		return strMaxAssignID;
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {

		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, XMO_ID );
		putData( htbData, htbParam, XMO_NAME );
		putData( htbData, htbParam, XMO_OUT_LINE );
		putData( htbData, htbParam, XMO_URI );
		putData( htbData, htbParam, XMO_ON_FLG );
		putData( htbData, htbParam, CLASS_NAME_F );
		putData( htbData, htbParam, TREE_VIEW_TIPE );
		putData( htbData, htbParam, INI_MENU );
		putData( htbData, htbParam, PRIORITY );
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * w肳ꂽeIDz̃O[vƃ[Ȕ{ʂ̕\f[^NXɊi[ĕԂ܂B<BR>
	 * zGroupAndPeoplesort_noŃ\[g܂B
	 * @param strParentID eID
	 * @param objDataAccess f[^ANZXNX
	 * @return BaseDisplayData[] ʏ
	 * @exception SQLException DBO
	 */
	public BaseDisplayData[] getGroupDisplay(String strParentID, DataAccess objDataAccess)
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT Groups.group_id AS group_id, " );
		sbSQL.append( "People.user_id AS user_id, Groups.group_name AS group_name, " );
		sbSQL.append( "People.user_name AS user_name, " );
		sbSQL.append( "Groups.custom_msg_dir AS group_msg_dir, " );
		sbSQL.append( "People.custom_msg_dir AS people_mas_dir, " );
		sbSQL.append( "Groups.group_type AS group_type, People.sex AS sex, People.user_type AS user_type " );
		sbSQL.append( "FROM GroupAndPeople LEFT OUTER JOIN " );
		sbSQL.append( "People ON " );
		sbSQL.append( "GroupAndPeople.childID = People.user_id LEFT OUTER JOIN " );
		sbSQL.append( "Groups ON GroupAndPeople.childID = Groups.group_id " );
		sbSQL.append( "WHERE (GroupAndPeople.parentID = '" + StringEscapeUtils.escapeSql(strParentID) + "') " );
		sbSQL.append( "ORDER BY GroupAndPeople.sort_no" );

		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL));

		// ʈꎞۊǗpVector
		Vector vecResult = new Vector();
		while(rs.next()) {
			String strUserID = rs.getString( "user_id" );
			BaseDisplayData objDisplayData = new BaseDisplayData();

			if( strUserID != null ) {
				// [U񂩂\f[^쐬

				// IDݒ
				objDisplayData.setID( ChangeEncode.setChar(strUserID) );
				// Oݒ
				objDisplayData.setTitle( ChangeEncode.setChar(rs.getString( "user_name" )) );
				// IDݒ
				objDisplayData.setDescription( ChangeEncode.setChar(rs.getString( "people_mas_dir" )) );
				// IDݒ
				objDisplayData.setType( ChangeEncode.setChar(rs.getString( "sex" ) + "^" + rs.getString( "user_type" )) );
			}
			else {
				// O[v񂩂\f[^쐬
				String strGroupID = rs.getString( "group_id" );

				// IDݒ
				objDisplayData.setID( ChangeEncode.setChar(strGroupID) );
				// Oݒ
				objDisplayData.setTitle( ChangeEncode.setChar(rs.getString( "group_name" )) );
				// IDݒ
				objDisplayData.setDescription( ChangeEncode.setChar(rs.getString( "group_msg_dir" )) );
				// IDݒ
				objDisplayData.setType( ChangeEncode.setChar(rs.getString( "group_type" )) );
			}

			vecResult.add( objDisplayData );
		}

		BaseDisplayData[] objDisplayList = new BaseDisplayData[vecResult.size()];

		vecResult.copyInto( objDisplayList );

		return objDisplayList;
	}

	/**
	 * w肳ꂽeIDzLȌ{ʂ̕\f[^NXɊi[ĕԂ܂B<BR>
	 * zLORelationsort_noŃ\[g܂B
	 * @param strParentID eID
	 * @param objDataAccess f[^ANZXNX
	 * @return BaseDisplayData[] ʏ
	 * @exception SQLException DBO
	 */
	public BaseDisplayData[] getLoDisplay(String strParentID, DataAccess objDataAccess)
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT LO.LOID AS LOID, LO.LOTitle AS LOTile, " );
		sbSQL.append( "LO.Prere AS Prere, " );
		sbSQL.append( "LO.LOType AS LOType, LO.Loexplanation AS Loexplanation " );
		sbSQL.append( "FROM LO INNER JOIN " );
		sbSQL.append( "LORelation ON LO.LOID = LORelation.childID " );
		sbSQL.append( "WHERE (LORelation.parentID = '" + StringEscapeUtils.escapeSql(strParentID) + "') " );
		sbSQL.append( "ORDER BY LORelation.sort_no" );

		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL));

		// ʈꎞۊǗpVector
		Vector vecResult = new Vector();
		while(rs.next()) {
			BaseDisplayData objDisplayData = new BaseDisplayData();

			// IDݒ
			objDisplayData.setID( ChangeEncode.setChar(rs.getString( "LOID" )) );
			// Oݒ
			objDisplayData.setTitle( ChangeEncode.setChar(rs.getString( "LOTile" )) );
			// IDݒ
			objDisplayData.setDescription( ChangeEncode.setChar(rs.getString( "Loexplanation" )) );
			// IDݒ
			objDisplayData.setType( ChangeEncode.setChar(rs.getString( "LOType" )) );
			// Oݒ
			objDisplayData.setPrere( ChangeEncode.setChar(rs.getString( "Prere" )) );

			vecResult.add( objDisplayData );
		}

		BaseDisplayData[] objDisplayList = new BaseDisplayData[vecResult.size()];

		vecResult.copyInto( objDisplayList );

		return objDisplayList;
	}

}

