/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	OCʃANVNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX̓OCʂ̃ANVNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf.actions;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.otm.OTMUser;
import jp.co.ntt.lms.otm.util.OTMSessionUtil;
import jp.co.ntt.lms.toeic650.common.TOEIC650CommonConst;
import jp.co.ntt.lms.xmf.XmfOperateSession;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xms.common.user.User;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsInnerException;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.XmsWarningException;
import jp.co.ntt.lms.xms.login.base.OperateSession;
import jp.co.ntt.lms.xms.login.base.Role;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 *  OCʃANVNX
 * 
 *  ̃NX̓OCʂ̃ANVNXłB
 * 
 *  @author  
 *  @version 1.0
 */
public class LoginAction extends Action
{

    /**
     * [UID̃p[^L[ <BR>
     */
    private final String USER_ID = "userId";

    /**
     * pX[h̃p[^L[ <BR>
     */
    private final String PASSWORD = "password";

    /**
     * pX[hsL <BR>
     */
    private final int ERR_PASS_LIMIT_COUNT = 3;

    /**
     * OC̃ZbVL[B <BR>
     */
    private static final String IS_LOGIN = "isLogin";

    /**
     * OCID̃ZbVL[B <BR>
     */
    private static final String LOGIN_ID = "loginId";

    /**
     * tOB <BR>
     */
    private static final String INI_FLAG = "ini_flag";

    /*
     * execute ̃I[o[Ch
     * 
     * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
    {

        // [UID
        String loginID = null;
        // pX[h
        String password = null;
        // \tO
        String iniflg = null;

        // ZbV擾
        HttpSession session = request.getSession();
        session.removeAttribute(IS_LOGIN);

        // \tO擾
        // \tO̓J^OFʉʂ烍OCɁuonvƂȂB
        // ȊÕOÍunullvƂȂ
        iniflg = request.getParameter(INI_FLAG);

        // uonv̓ZbV胍OCIDƃpX[h擾
        if (iniflg != null && iniflg.length() > 0)
        {
            loginID = (String) session.getAttribute(LOGIN_ID);
            password = (String) session.getAttribute(PASSWORD);
        }
        else
        {
            // p[^̏
            loginID = request.getParameter(USER_ID);
            password = request.getParameter(PASSWORD);
        }

        // p[^null`FbNs
        if (loginID == null)
        {
            // p[^G[
            throw new XmsInnerException("p[^G[iOCIDnullj");
        }
        if (password == null)
        {
            // p[^G[
            throw new XmsInnerException("p[^G[ipX[hnullj");
        }

        // XMŐN`FbN
        if (isLaunch() == false)
        {
            // NȂ珈I
            // XMON
            // [jObZ[WɑΉL[RXgN^Őݒ肷
            // ʃNXŃbZ[W擾Aʂɕ\
            throw new XmsWarningException("base.w.login.starting");
        }

        // [UIuWFNg̃CX^X
        User userObject = new User();
        // OC`FbN̖߂l
        // OCł̓OCIDƃpX[h̐yсA폜tÕ`FbNsB
        // `FbN͕ʓrisRolesAssignment\bhōsB
        boolean checkResultLogin = userObject.checkLogin(loginID, password);

        // OCsꍇ
        // se`FbNB
        if (checkResultLogin == false)
        {

            // Peoplee[uɃOCID݂Ăǂ
            if (userObject.isExist() == false)
            {
                // ݂ĂȂꍇ
                // [jOƂ
                throw new XmsWarningException("base.w.login.loginidmissmatch");
            }

            // 폜ԂɂȂĂǂ
            //-----------------------------------------------------------------------------
            // 폜ԂƂ
            //   OCID̃R[h݂͑邪A폜tOu1vɂȂĂ邱ƁB
            //   ADɂčꂽ[U폜ꍇiƂȂj폜ԁB
            //-----------------------------------------------------------------------------
            if (userObject.isDeleted() == true)
            {
                // ݂ĂȂꍇ
                // [jOƂ
                throw new XmsWarningException("base.w.login.loginidmissmatch");
            }

            // pX[hvĂǂ
            if (userObject.isAgreePassword() == false)
            {
                // pX[h`FbNŎsꍇ̓pX[h}C_`FbNs
                // iAēꃍOCIDłRpX[hԈႦꍇ
                //   pX[h}C_ʂɑJڂ)

                // ݂̃pX[hsv񐔂擾
                int intAccessCount = this.getErrPassCount(session, loginID);

                // s񐔂L񐔂ɒBǂ
                if (intAccessCount == ERR_PASS_LIMIT_COUNT)
                {
                    // BĂꍇ
                    // ZbVɏi[

                    OperateSession.setSessionFromErrorPassword(session,
                            loginID, new Integer(0), userObject.getUserID());

                    // RԈႦꍇ̓pX[h}C_ʂɑJڂ
                    return mapping.findForward("reminder");
                }

                // R񖢖̏ꍇ
                // ̉񐔂ZbVɊi[

                OperateSession.setSessionFromErrorPassword(session, loginID,
                        new Integer(intAccessCount), null);

                // pX[hsbZ[W
                throw new XmsWarningException("base.w.login.passwordmissmacth");
            }

        }

        // 蓖ĂĂ邩
        // [UɃATCĂiRolejPȏ゠true
        if (userObject.isRolesAssignment() == false)
        {
            // P蓖ĂĂȂꍇ
            // [jOƂ
            // 蓖Ė̃bZ[W
            throw new XmsWarningException("base.w.login.noroles");
        }

        // OCɏIꍇ
        // ZbV̐ݒ
        OperateSession.setSessionFromLogin(session, userObject);

        // ftHgc[\^Cv̎擾
        //--------------------------------------------------------------
        // c[\^CvƂ
        // {ʂɂă[Uc[ALOc[̂ǂ\̂
        // Ƃl
        //   [Uc[Fu1v
        //   L0c[ Fu2v
        //
        // ftHgc[^CvƂ
        //   [UɊ蓖ĂĂ錠iXMOEntryj
        //   ܂Ƃ߂́ij[jɊ蓖ĂĂDx
        //   ԍilԏĵ̃c[\^Cv̂
        //--------------------------------------------------------------
        String defaultTreeType = userObject.getDefaultTreeType();

        // wK҂ǂ̔
        boolean isLearner = userObject.isLearner();

        // URLp[^Ɏg
        String learner = null;

        //--------------------------------------------------------------
        // wK҃tO
        //   wK FuYESv
        //   wK҂ȂiǗҁjFuNOv
        //
        // wK҂Ƃ
        //   [UɊ蓖ĂĂ錠iXMOEntryĵA
        //      wK݂̂ꍇ
        //      OǗ݂̂ꍇ
        //      wKƃOǗ݂̂ꍇ
        //   ̂ꂩB
        //--------------------------------------------------------------
        if (isLearner == true)
        {
            learner = "YES";
        }
        else
        {
            learner = "NO";
        }

        // URL̍쐬
        // {ʂ֑J
        //--------------------------------------------------------------------------
        // URLp[^
        // tree_view_type Fc[\^Cvi1F[Uc[ 2FLOc[j
        // learner FwK҃tOiPj
        // ini_menu Fj[iQj
        //
        // P wK҂̏ꍇ͊{ʂ̐U镑قȂ
        //       PD\c[؂芷{^\ɂB
        //       QDvpeBʂ̃^O\ɂB
        // Q j[̗pr
        //       ShowSubGroupChildren.jsp܂URLp[^ƂĈpł邪A
        //       ǎgpĂȂ
        //--------------------------------------------------------------------------

        XmfOperateSession.setUserInfo(session, userObject);
        
        request.setAttribute("tree_view_type", defaultTreeType);
        request.setAttribute("learner", learner);
        request.getSession().setAttribute("learner", learner);
        request.setAttribute("ini_menu", "");

        return mapping.findForward("init");
        
//        // ADD 20050512 N.Umehara
//        // wK҂̏ꍇAANʂփ_CNgB
//        if (isLearner == true)
//        {
//        	Vector listRole = userObject.getRoleList();
//        	for (int i=0; i < listRole.size(); i++ )
//        	{
//        		Role role = (Role)listRole.get(i);
//        		String strRoleName = role.getRoleName();
//        		if (strRoleName.equals("JEZ[")==true)
//        		if (role.getRoleID().equals(TOEIC650CommonConst.ROLE_COUNSELOR))
//            		return mapping.findForward("counselor");
//        			
//       	}
//        	
//            return mapping.findForward("student");
//        }
//        else
//        {
//            return mapping.findForward("init");
//        }

    }

    /**
     * XMON`FbNsB <BR>
     * 
     * @return true: Nς false: N
     * @exception XmsException
     *                VXeO
     */
    private boolean isLaunch() throws XmsException
    {

        try
        {
            // XMSNCAg𐶐
            XMSBaseClient BaseObject = new XMSBaseClient();

            // XMON`FbN
            // ԋpl̂܂ܕԋp
            return BaseObject.isLaunch();

        }
        catch (Exception ex)
        {
            throw new XmsSystemException(ex);
        }
    }

    /**
     * AēꃍOCIDŃpX[hԈႦ񐔂ԂB <BR>
     * ÕOCIDƍ̃OCID̏ꍇ́AZbVɕێ pX[hԈႦ񐔂PvXAłȂꍇ͂PԂB
     * 
     * @param session
     *            HTTPSessionIuWFNg
     * @param loginID
     *            ̃OCID
     * @return int AēꃍOCIDŃpX[hԈႦ
     */
    private int getErrPassCount(HttpSession session, String loginID)
    {

        // ݂̃pX[hsv񐔂ZbV擾
        Integer objAccessCount = (Integer) session
                .getAttribute(OperateSession.ERR_PASS_COUNT);

        // ÕOCIDZbV擾
        String strBeforeLoginID = (String) session
                .getAttribute(OperateSession.LOGIN_ID);

        // ANZX
        int intAccessCount = 0;

        if (objAccessCount != null)
        {
            intAccessCount = (objAccessCount).intValue();
        }

        if (loginID.equals(strBeforeLoginID) == true)
        {
            // Oɓ͂OCIDƍ̃OCID̏ꍇ
            // 񐔂PvXĕԂB
            intAccessCount++;
        }
        else
        {
            // Oɓ͂ꂽOCIDƍ
            // OCIDقȂꍇ͂PԂB
            intAccessCount = 1;
        }

        return intAccessCount;
    }
}