/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	CAEg`NX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX̓CAEg`NXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;

/**
 *  CAEg`NX
 * 
 *  ̃NX̓t[̃CAEg`NXłB
 * 
 *  @author  
 *  @version 1.0
 */
public class LayoutElement implements Serializable {

	protected Node layout;
	
	/**
	 * CAEgǂݍށB
	 * 
	 * @param node m[h
	 */
	public void loadLayout(Node node)
	{
		layout = node;
	}

	/**
	 * namelԂB
	 * 
	 * @return namel
	 */
	public String getName()
	{
		return NodeUtil.getAttribute(layout, "name");
	}
	
	/**
	 * resourcelԂ
	 * 
	 * @return resourcel
	 */
	public String getResource()
	{
		return NodeUtil.getAttribute(layout, "resource");
	}
	
	/**
	 * orientlԂ
	 * 
	 * @return orientl
	 */
	public String getOrient()
	{
		return NodeUtil.getAttribute(layout, "orient");
	}
	
	/**
	 * m[h box vfǂԂB
	 * 
	 * @return ʂu[l
	 */
	public boolean isBox()
	{
		return "box".equals(layout.getNodeName());
	}

	/**
	 * m[h component vfǂԂB
	 * 
	 * @return ʂu[l
	 */
	public boolean isComponent()
	{
		return "component".equals(layout.getNodeName());
	}
	
	/**
	 * ʗvf̔z擾B
	 * component vf̏ꍇ͋̔z񂪕ԋpB
	 * 
	 * @return ʗvf̔zB
	 */
	public LayoutElement[] getElements()
	{
		ArrayList elements = new ArrayList();
		
		if ((layout != null) && !isComponent())
		{
			List nodeList = NodeUtil.getNamedChildElementList(layout, new String[]{"box", "component"});
			for (int i=0; i < nodeList.size(); i++)
			{
				LayoutElement element = new LayoutElement();
				element.loadLayout((Node)nodeList.get(i));
				elements.add(element);
			}
		}
		
		return (LayoutElement[])elements.toArray(new LayoutElement[]{});
	}
	
	/**
	 * w肵namelCAEgvf݂邩ǂԋpB
	 * 
	 * @param name namel
	 * @return ʂu[l
	 */
	public boolean contains(String name)
	{
		boolean result = false;
		LayoutElement[] elements = getElements();
		for (int i=0; i < elements.length; i++)
		{
			if (name.equals(elements[i].getName()))
			{
				result = true;
				break;
			}
			if (elements[i].contains(name))
			{
				result = true;
				break;
			}
		}
		return result;
	}	
}
