/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	LOݒǗNX
//
//		ύX
//			2005.02.03  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NXLOݒǗNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * LOݒǗNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class LOConfiguration {
	
	private String loID = null;
	private String completeRate = null;
	private String notCompleteRate = null;
	private String notStartRate = null;
	private Map unitWeight = null;
	private List statusList = null;
	private String startDate = null;
	private String timeSpan = null;
	
	/**
	 * RXgN^łB
	 * 
	 */
	public LOConfiguration() {
		this.statusList = new ArrayList();
		this.unitWeight = new HashMap();
	}
	
	/**
	 * Xe[^X̐iݒ肵܂B
	 * 
	 * @param completeRate Xe[^X̐i
	 */
	public void setCompleteRate(String completeRate) {
		this.completeRate = completeRate;
	}

	/**
	 * LoIDݒ肵܂B
	 * 
	 * @param loID LoID
	 */
	public void setLoID(String loID) {
		this.loID = loID;
	}

	/**
	 * Xe[^X̐iݒ肵܂B
	 * 
	 * @param notCompleteRate Xe[^X̐i 
	 */
	public void setNotCompleteRate(String notCompleteRate) {
		this.notCompleteRate = notCompleteRate;
	}
	
	/**
	 * Xe[^X̐iݒ肵܂B
	 * 
	 * @param notStartRate Xe[^X̐i 
	 */
	public void setNotStartRate(String notStartRate) {
		this.notStartRate = notStartRate;
	}
	
	/**
	 * jbg̏d݂ݒ肵܂B
	 * 
	 * @param unitWeight jbg̏d 
	 */
	public void setUnitWeight(HashMap unitWeight) {
		this.unitWeight = unitWeight;
	}
	
	/**
	 * LoID擾܂B
	 * 
	 * @return String LOID 
	 */
	public String getLoID() {
		return loID;
	}

	/**
	 * Xe[^X̐i擾܂B
	 * 
	 * @return String Xe[^X̐i
	 */
	public String getCompleteRate() {
		return ( this.completeRate == null ? "" : this.completeRate );
	}
	
	/**
	 * Xe[^X̐i擾܂B
	 * 
	 * @return String Xe[^X̐i
	 */
	public String getNotCompleteRate() {
		return ( this.notCompleteRate == null ? "" : this.notCompleteRate );
	}
	
	/**
	 * Xe[^X̐i擾܂B
	 * 
	 * @return String Xe[^X̐i
	 */
	public String getNotStartRate() {
		return ( this.notStartRate == null ? "" : this.notStartRate );
	}
	
	/**
	 * wKJn擾܂B
	 * 
	 * @return Date wKJn
	 */
	public Date getStartDate() {
		
		if (this.startDate == null 
				|| this.startDate.length() == 0) return null;
		
		return this.convertToDate(this.startDate);
	}
	
	/**
	 * wKJnݒ肵܂B
	 * 
	 * @param startDate wKJn
	 */
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}
	
	/**
	 * wKԂ擾܂B
	 * 
	 * @return TimeSpan wK
	 */
	public TimeSpan getTimeSpan() {
		
		if (this.timeSpan == null 
				|| this.timeSpan.length() ==0) return null;
		
		try {
			return TimeSpan.parseTimeSpan(this.timeSpan);
		} catch (Exception ex) {
			DebugLog.write(this.getClass(),"Oݒt@CwKԕϊs:" + ex.getMessage(), DebugLog.MID);
			return null;
		}
	}
	
	/**
	 * wKԂݒ肵܂B
	 * 
	 * @param timeSpan wK
	 */
	public void setTimeSpan(String timeSpan) {
		this.timeSpan = timeSpan;
	}
	
	/**
	 * w肳ꂽiYi󋵖擾܂B 
	 * 
	 * @return String i󋵖
	 */
	public String getProgressStatusName(long progressRate) {
		
		Iterator ite = this.statusList.iterator();
		while(ite.hasNext()) {
			ProgressStatus status = (ProgressStatus)ite.next();
			if (status.contains(progressRate) ) return status.name;
		}
		return "";
	}

	/**
	 * w肳ꂽjbgID̃jbg̏d݂擾܂B 
	 * 
	 * @return String jbg̏d
	 */
	public String getUnitWeight(String unitID) {
		
		if (this.unitWeight.containsKey(unitID)==false) return ""; 
		
		return this.unitWeight.get(unitID).toString();
	}
	
	/**
	 * jbg̏d݂ݒ肵܂B
	 * 
	 * @param unitID jbgID
	 * @param weight d
	 */
	public void setUnitWeight(String unitID, String weight) {
		
		String rightWeight = weight;
		
		try {
			if( Double.parseDouble(weight) > 1 ) rightWeight = "";
		} catch(NumberFormatException ex) {
			rightWeight = "";
		}

		this.unitWeight.put(unitID, rightWeight);
	}
	
	/**
	 * i󋵂ݒ肵܂B
	 * 
	 * @param name i󋵖
	 * @param minValue Yi̍ŏl
	 * @param maxValue Yi̍ől
	 */
	public void setProgressStatus( String name, String minValue, String maxValue ) {
		
		this.statusList.add(new ProgressStatus(name, minValue, maxValue) );
	}
	
	/**
	 * w肳ꂽɎw肳ꂽŃpfBOs܂B
	 * 
	 * @param target ΏۂƂȂ镶
	 * @param digit pfBO̒̕
	 * @param padString pfBO镶
	 * @return String@pfBOꂽ
	 */
	private String leftPad(String target, int digit, String padString){
		
		if (target.length() >= digit) return target;
		
		String paddingString = target;
		
		for (int i=0; i<(digit-target.length()); i++ ) {
			paddingString = padString + paddingString;
		}
		
		return paddingString;
	}

	/**
	 * w肳ꂽttɕϊ܂B
	 * 
	 * @param dateTimeString ISO8601`̓t
	 * @return Date ϊꂽt
	 */
	private Date convertToDate(String dateTimeString) {

		final int BASIC_DATE_ONLY_LENGTH = 8;
		final int EXTEND_DATE_ONLY_LENGTH = 10;
		final int BASIC_DATE_TIME_LENGTH = 15;
		final int EXTEND_DATE_TIME_LENGTH = 19;
		
		final String BASIC_DATE_ONLY_FORMAT = "yyyyMMdd";
		final String EXTEND_DATE_ONLY_FORMAT = "yyyy-MM-dd";
		final String BASIC_DATE_TIME_FORMAT = "yyyyMMdd'T'hhmmss";
		final String EXTEND_DATE_TIME_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
		
		SimpleDateFormat sdf = null;
		
		try {
			// t`ƂɃtH[}bgϊ
			switch ( dateTimeString.length() ) {
			
			// "yyyyMMdd" `
			case BASIC_DATE_ONLY_LENGTH :
				sdf = new SimpleDateFormat(BASIC_DATE_ONLY_FORMAT);
				return sdf.parse(dateTimeString);
				
			// "yyyy-MM-dd" `
			case EXTEND_DATE_ONLY_LENGTH :
				sdf = new SimpleDateFormat(EXTEND_DATE_ONLY_FORMAT);
				return sdf.parse(dateTimeString);
				
			// "yyyyMMddThhmmss" `
			case BASIC_DATE_TIME_LENGTH :
				sdf = new SimpleDateFormat(BASIC_DATE_TIME_FORMAT);
				return sdf.parse(dateTimeString);
				
			// "yyyy-MM-ddThh:mm:ss" `
			case EXTEND_DATE_TIME_LENGTH :
				sdf = new SimpleDateFormat(EXTEND_DATE_TIME_FORMAT);
				return sdf.parse(dateTimeString);
				
			default :
				return null;
			}
		} catch (ParseException pex) {
			DebugLog.write(this.getClass(),"Oݒt@CwKJnϊs", DebugLog.ROW);
			return null;
		}
	}
	
	/**
	 * i󋵃NXłB
	 * 
	 * @author Katsuhiko Sakurai (UNITEC)
	 * @version 1.0
	 */
	public class ProgressStatus {
		
		private String name = null;
		private String min = null;
		private String max = null;
		
		/**
		 * RXgN^łB
		 * 
		 * @param name i󋵖
		 * @param min ΏۂƂȂi̍ŏl
		 * @param max ΏۂƂȂi̍ől
		 */
		public ProgressStatus( String name, String min, String max ) {
			this.name = ( name==null ? "" : name );
			this.max = ( max==null ? "" : max );
			this.min = ( min==null ? "" : min );
		}
	
		/**
		 * ΏۂƂȂi̍ől擾܂B
		 * 
		 * @return String ΏۂƂȂi̍ől
		 */
		public String getMax() {
			return this.max;
		}

		/**
		 * ΏۂƂȂi̍ŏl擾܂B
		 * 
		 * @return String ΏۂƂȂi̍ŏl
		 */
		public String getMin() {
			return this.min;
		}

		/**
		 * i󋵖̂擾܂B
		 * 
		 * @return String i󋵖
		 */
		public String getName() {
			return this.name;
		}
		
		/**
		 * w肳ꂽii󋵂̑ΏۂƂȂĂ邩ǂ𔻕ʂ܂B
		 * 
		 * @param progressRate i
		 * @return boolean Ώۂ̐iǂ True:Ώ۔͈͂Ɋ܂܂
		 */
		public boolean contains( long progressRate ) {
			
			try {
				if ( this.min.length()==0 && this.max.length() == 0 ) {
					return false;
	
				} else if (this.min.length() == 0 ){
					return ( progressRate <=Integer.parseInt(this.max) );
	
				} else if (this.max.length() == 0 ){
					return ( Integer.parseInt(this.min) <= progressRate );
				
				} else {
					return ( Integer.parseInt(this.min) <= progressRate && progressRate <=Integer.parseInt(this.max) );
				}
			}catch (NumberFormatException nfe) {
				DebugLog.write(this.getClass(), "i󋵔͈͐lϊG[", DebugLog.MID);
				return false;
			}
		}
	}
}
