/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Offline ItCO[eBeBNX
//			ύX
//				2004.01.08	VK쐬	񞊁@q
//
package jp.co.ntt.lms.lo.Offline.OfflineLog;

import java.util.*;
import java.text.*;
import org.w3c.dom.*;

/**
 * Offline ItCO[eBeBNX<BR>
 * eėp\bh񋟂܂B
 */
public class OfflineUtil {

	/**
	 * HHHH:MM:SS.SS `̕long^̃~bɕϊ܂
	 * @param strTime HHHH:MM:SS.SS`̕
	 * @return long ~bɕϊl
	 * @exception OfflineLogFormatException ϊɎsꍇ
	 */
	public static long parseTime( String strTime )
		throws OfflineLogFormatException
	{
		StringTokenizer token = new StringTokenizer( strTime, ":" );

		long lngHour = 0;
		long lngMinute = 0;
		float fltSecond = 0;

		int intCount = 0;
		try {
			while( token.hasMoreTokens() ) {

				String strValue = token.nextToken();
				switch( intCount ) {
					case 0:
						// 
						lngHour = Long.parseLong( strValue );
						break;
					case 1:
						// 
						lngMinute = Long.parseLong( strValue );
						break;
					case 2:
						// b
						fltSecond = Float.parseFloat( strValue );
						break;
					default:
						throw new OfflineLogFormatException();
				}

				// JEgAbv
				intCount++;
			}
		}
		catch( NumberFormatException ne ) {
			throw new OfflineLogFormatException(ne.getMessage());
		}

		if( intCount != 3 ) {
			throw new OfflineLogFormatException();
		}

		long lngRes = 0;

		lngRes = (lngHour * 3600000L) + (lngMinute * 60000L) + (long)(fltSecond * 1000L);

		return lngRes;
	}

	/**
	 * long^̃~bHHHH:MM:SS.SS `̕ɕϊ܂
	 * @param lngTime ~bɕϊl
	 * @return String HHHH:MM:SS.SS`̕
	 */
	public static String formatTime( long lngTime ) {

		// ]ێ
		long lngRem = 0;

		// Ԃ̎Zo
		int intHour = (int)(lngTime / 3600000L);
		lngRem = lngTime % 3600000L;

		// ̎Zo
		int intMinute = (int)(lngRem / 60000L);
		lngRem = lngRem % 60000L;

		// b̎Zo
		float fltSecond = lngRem / 1000F;

		// Ԃ̃tH[}bg
		DecimalFormat objHourFormat = new DecimalFormat( "0000" );
		String strHour = objHourFormat.format( intHour );

		// ̃tH[}bg
		DecimalFormat objMinuteFormat = new DecimalFormat( "00" );
		String strMinute = objMinuteFormat.format( intMinute );

		// b̃tH[}bg
		DecimalFormat objSecondFormat = new DecimalFormat( "00.##" );
		String strSecond = objSecondFormat.format( fltSecond );


		return strHour + ":" + strMinute + ":" + strSecond;
	}


	/**
	 * yyyy:mm:ss HH:MM:SS `̕t^ɕϊ܂
	 * @param strDate yyyy:mm:ss HH:MM:SS`̕
	 * @return Date tɕϊl
	 * @exception OfflineLogFormatException ϊɎsꍇ
	 */
	public static Date parseDate( String strDate )
		throws OfflineLogFormatException
	{
		Date objDate = null;

		// t񂩂J_[IuWFNg𐶐
		DateFormat objFormat = new SimpleDateFormat( "yyyy/MM/dd HH:mm:ss" );
		objFormat.setLenient( false );
		try {
			objDate = objFormat.parse( strDate );
		}
		catch( ParseException pe ) {
			throw new OfflineLogFormatException( pe.getMessage() );
		}

		return objDate;
	}

	/**
	 * Xe[^X(String)Xe[^X(char)ɕϊ܂B
	 * ȉ̕ȊO̓G[Ƃ܂B
	 * <PRE>
	 *    n    not attemptedӖB
	 *    i    incompleteӖB
	 *    f    failedӖB
	 *    c    completedӖB
	 *    p    passedӖB
	 *    b    browasedӖB	 * </PRE>
	 * @param strStatus Xe[^X
	 * @return char Xe[^X
	 * @exception OfflineLogFormatException
	 */
	public static char parseStatus( String strStatus )
		throws OfflineLogFormatException
	{

		if( strStatus.length() != 1 ) {
			throw new OfflineLogFormatException( "Invalid Status : " + strStatus );
		}

		char chrStatus = strStatus.charAt(0);
		if( chrStatus != OfflineLogConst.NOT_ATTEMPT_STATUS &&
			chrStatus != OfflineLogConst.INCOMPLETE_STATUS &&
			chrStatus != OfflineLogConst.FAILED_STATUS &&
			chrStatus != OfflineLogConst.COMPLETED_STATUS &&
			chrStatus != OfflineLogConst.PASSED_STATUS &&
			chrStatus != OfflineLogConst.BROWASED_STATUS
		) {

			throw new OfflineLogFormatException( "Invalid Status : " + strStatus );
		}

		return chrStatus;

	}

	/**
	 * Ggʕ(String)Ggʕ(char)ɕϊ܂B
	 * ȉ̕ȊO̓G[Ƃ܂B
	 * <PRE>
	 *    b    ubNӖ
	 *    s    SCOӖ
	 *    a    AUӖB
	 *    t    assetӖ
	 *    c    SACӖ
	 * </PRE>
	 * @param strElementType Ggʕ
	 * @return char Ggʕ
	 * @exception OfflineLogFormatException
	 */
	public static char parseElementType( String strElementType )
		throws OfflineLogFormatException
	{

		if( strElementType.length() != 1 ) {
			throw new OfflineLogFormatException( "Invalid ElementType : " + strElementType );
		}

		char chrElementType = strElementType.charAt(0);
		if( chrElementType != OfflineLogConst.BLOCK_TYPE &&
			chrElementType != OfflineLogConst.SCO_TYPE &&
			chrElementType != OfflineLogConst.AU_TYPE &&
			chrElementType != OfflineLogConst.ASSET_TYPE &&
			chrElementType != OfflineLogConst.SAC_TYPE
		) {

			throw new OfflineLogFormatException( "Invalid ElementType : " + strElementType );
		}

		return chrElementType;

	}

	/**
	 * m[hɐݒ肳Ăl擾܂B
	 * 擾oȂꍇnullԂ܂B
	 * @param objNode m[h
	 * @return String m[h̒l
	 */
	static String getNodeValue( Node objNode ) {
		// eLXg̎擾
		NodeList objNodeList = objNode.getChildNodes();
		if( objNodeList != null ) {
			for( int i = 0; i < objNodeList.getLength(); i++ ) {
				//#TEXTZNV܂#CDATAZNV̂ݎ擾
				if( objNodeList.item(i).getNodeType() == Node.TEXT_NODE ||
					objNodeList.item(i).getNodeType() == Node.CDATA_SECTION_NODE )
				{
					return objNodeList.item(i).getNodeValue();
				}
			}
		}

		return null;
	}

	/**
	 * m[hzw肳ꂽm[hm[hA̒l擾ĕԂ܂B
	 * m[hm[h݂ꍇ̓c[̏ʂD悳܂B
	 * m[h݂ȂꍇnullԂ܂B
	 * @param String strNodeName m[h
	 * @param objNode m[hIuWFNg
	 */
	static String getNodeValueFromNodeName( String strNodeName, Element objElm ) {

		NodeList objNodeList = objElm.getElementsByTagName( strNodeName );

		if( objNodeList.getLength() > 0 ) {

			return OfflineUtil.getNodeValue( objNodeList.item(0) );
		}

		return null;
	}

	/**
	 * w肳ꂽm[h̔z̎qm[hw肳ꂽm[h̃m[h擾ĕԂ܂B
	 * @param objNode m[h
	 * @param strName m[h
	 * @return Node[] m[hz
	 */
	static Node[] getNodeList( Node objNode, String strName ) {

		Vector vecNodeList = new Vector();

		// qm[hXg̎擾
		NodeList objNodeList = objNode.getChildNodes();
		if( objNodeList != null ) {
			for( int i = 0; i < objNodeList.getLength(); i++ ) {
				Node objNodeTemp = objNodeList.item(i);
				if( objNodeTemp.getNodeName().equals( strName ) ) {
					vecNodeList.add( objNodeTemp );
				}
			}
		}

		Node[] objNodes = new Node[vecNodeList.size()];
		vecNodeList.copyInto( objNodes );

		return objNodes;

	}
}


