//
// CopyRight (C) 2003, NTT All rights reserved.
//
//	Offline ʃO@OL_AiccCoree[uANZXNX
//			ύX
//				2004.01.08	VK쐬	꓇@pK
//
package jp.co.ntt.lms.lo.Offline.Aicc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
/**
 * OfflineތʃO@OL_AiccCoree[uANZXNXłB<BR>
 * @author H.Takishima
 * @version 2.0.4.0.0 2004.01.08
 */
public class AiccCoreDataAccess
	extends AiccDataAccess implements AiccConst {

	public static final String TABLE_NAME = "OL_AiccCore";

	/**
	 * RXgN^
	 **/
	public AiccCoreDataAccess() {
		super( TABLE_NAME );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֓o^s܂
	 * @param objRecords AiccCoreR[hz
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void insert(	AiccCoreRecord[] objRecords,
										DataAccess objDataAccess  )
		throws SQLException
	{
		for( int i = 0; i < objRecords.length; i++ ) {
			// f[^ϊ
			Hashtable htbData = changeData( objRecords[i] );
			insertAction( htbData, objDataAccess );
		}
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֓o^s܂
	 * @param objRecord AiccCoreR[hIuWFNg
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void insert(	AiccCoreRecord objRecord,
										DataAccess objDataAccess  )
		throws SQLException
	{

		// f[^ϊ
		Hashtable htbData = changeData( objRecord );
		insertAction( htbData, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֓o^s܂
	 * @param htbData p[^
	 * @exception SQLException DBG[
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbParam, TABLE_NAME );

		// o^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍XVs܂
	 * @param objRecord f[^ݒ肵܂
	 * @param strUserID [UIDXVɐݒ肵܂
	 * @param strLoID LOID LOIDXVɐݒ肵܂
	 * @param strSessionID ZbVID ZbVIDXVɐݒ肵܂
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void update(	AiccCoreRecord objRecord,
										String strUserID,
										String strLoID,
										String strSessionID,
										DataAccess objDataAccess  )
		throws SQLException
	{

		// f[^ϊ
		Hashtable htbData = changeData( objRecord );

		String strCondition = AiccMakeCondition.makeCondition(	strUserID,
																strLoID,
																strSessionID );
		updateAction( htbData, strCondition, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍XVs܂<BR>
	 * @param objRecord f[^ݒ肵܂
	 * @param strCondition ݒ肵܂
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void update(	AiccCoreRecord objRecord,
										String strCondition,
										DataAccess objDataAccess  )
		throws SQLException
	{

		// f[^ϊ
		Hashtable htbData = changeData( objRecord );
		updateAction( htbData, strCondition, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍XVs܂
	 * @param strCondition XV
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBG[
	 */
	private void updateAction(	Hashtable htbParam,
								String strCondition,
								DataAccess objDataAccess )
		throws SQLException
	{

		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getUpdateSQL( htbParam, TABLE_NAME );

		// SQLA
		if( strCondition != null ) {
			strSQL = strSQL + strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍폜s܂
	 * @param strUserID [UID폜ɐݒ肵܂
	 * @param strLoID LOID LOID폜ɐݒ肵܂
	 * @param strSessionID ZbVID ZbVID폜ɐݒ肵܂
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void delete(	String strUserID,
										String strLoID,
										String strSessionID,
										DataAccess objDataAccess  )
		throws SQLException
	{
		String strCondition = AiccMakeCondition.makeCondition(	strUserID,
																strLoID,
																strSessionID );
		// 폜
		deleteAction( strCondition, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍폜s܂
	 * @param strCondition 폜
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public synchronized void delete(	String strCondition,
										DataAccess objDataAccess  )
		throws SQLException
	{
		// 폜
		deleteAction( strCondition, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[u֍폜s܂
	 * @param strCondition 폜
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void deleteAction(	String strCondition,
								DataAccess objDataAccess )
		throws SQLException
	{

		// 폜pSQL𐶐܂
		try {
			//XMS.init@C[hNX̃CX^X
			Environment objEnv = new Environment();
	
			StringBuffer sbfSQL = new StringBuffer();
			sbfSQL.append("DELETE FROM ");
			sbfSQL.append(TABLE_NAME);
	
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( Environment.DB_SQLSERVER )){
				sbfSQL.append(" WITH(TABLOCKX) ");
			}
			sbfSQL.append(strCondition);
	
			// 폜s
			objDataAccess.execute( sbfSQL.toString() );
		} catch(Exception e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
		}
	}


	/**
	 * OfflineތʃO@OL_AiccCoree[uf[^擾܂
	 * @param strUserID [UIDɐݒ肵܂
	 * @param strLoID LOID LOIDɐݒ肵܂
	 * @param strSessionID ZbVID ZbVIDɐݒ肵܂
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return AiccCoreRecord[] ʂ̔z
	 * @exception SQLException f[^x[XG[
	 */
	public AiccCoreRecord[] getData(	String strUserID,
										String strLoID,
										String strSessionID,
										DataAccess objDataAccess )
		throws SQLException
	{
		String strCondition = AiccMakeCondition.makeCondition(	strUserID,
																strLoID,
																strSessionID );

		return getData( strCondition, objDataAccess );
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[uf[^擾܂
	 * @param strCondition 
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return AiccCoreRecord[] ʂ̔z
	 * @exception SQLException f[^x[XG[
	 */
	public AiccCoreRecord[] getData(	String strCondition,
										DataAccess objDataAccess )
		throws SQLException
	{
		AiccCoreRecord[] objResult = null;

		if( strCondition == null ) {
			strCondition = "";
		}

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME + strCondition;

		ResultSet rs = objDataAccess.executeQuery(strSQL);
		Vector vecResult = new Vector();

		while( rs.next() ) {
			AiccCoreRecord objData = new AiccCoreRecord();
			// ZbVR[hɃRs[
			objData.setLessonStatus( ChangeEncode.setChar(rs.getString( LESSON_STATUS )) );
			objData.setRawScore( ChangeEncode.setChar(rs.getString( RAW_SCORE )) );
			objData.setMaxScore( ChangeEncode.setChar(rs.getString( MAX_SCORE )) );
			objData.setMinScore( ChangeEncode.setChar(rs.getString( MIN_SCORE )) );
			objData.setStayTime( ChangeEncode.setChar(rs.getString( STAY_TIME )) );
			objData.setLessonLocation( ChangeEncode.setChar(rs.getString( LESSON_LOCATION )) );
			objData.setExist( ChangeEncode.setChar(rs.getString( EXIST )) );
			objData.setUserID( ChangeEncode.setChar(rs.getString( USERID )) );
			objData.setLoID( ChangeEncode.setChar( rs.getString( LOID )) );
			objData.setSessionID( ChangeEncode.setChar(rs.getString( SESSIONID )) );
			objData.setUid( ChangeEncode.setChar(rs.getString( UID )) );

			// ʊi[pVectorɊi[
			vecResult.add( objData );
		}

		// zɕϊ
		objResult = new AiccCoreRecord[vecResult.size()];
		vecResult.copyInto( objResult );

		return objResult;
	}

	/**
	 * OfflineރXe[^X擾@OL_AiccCoree[uXe[^X擾܂
	 * @param strUserID [U[ID
	 * @param strLOID   LOID
	 * @param strUID    UIDXg
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return char ʂ̃Xe[^X
	 * @exception SQLException f[^x[XG[
	 */
	public char getStatus(	String strUserID,
							String strLOID,
							String[] strUID,
							DataAccess objDataAccess )
		throws SQLException
	{
		char charRet = FAILED;	// Xe[^X
		String STATUS_COUNTER = "status_counter";
		int intCnt = 0;

		// UID̃Xg
		StringBuffer strUIDTemp = new StringBuffer();
		for( int i = 0; i < strUID.length; i++ ) {
			strUIDTemp.append( "'" + StringEscapeUtils.escapeSql(strUID[i]) + "'," );
		}
		String strUIDList = strUIDTemp.substring(0,strUIDTemp.length()-1);

		/*
		 * i
		 */
		// SQL̑gݗ
		StringBuffer sbPSQL = new StringBuffer();
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv = new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){		
				sbPSQL.append("SELECT COUNT(DISTINCT " + UID + ") AS " + STATUS_COUNTER + " ");
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbPSQL.append("SELECT COUNT(DISTINCT " +"\""+UID+"\"" + ") AS " + STATUS_COUNTER + " ");
			}
			sbPSQL.append("FROM " + TABLE_NAME + " ");
			sbPSQL.append("WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
			sbPSQL.append("AND " + LOID + "='"+ StringEscapeUtils.escapeSql(new String(strLOID)) + "' ");

			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbPSQL.append("AND UID IN (" + strUIDList + ") ");
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbPSQL.append("AND"+" \"UID\" "+"IN (" + strUIDList + ") ");
			}


			sbPSQL.append("AND (Lesson_Status LIKE '" + PASSED + "%')");

			// i擾
			ResultSet rsP = objDataAccess.executeQuery(sbPSQL.toString());

			while( rsP.next() ) {
				intCnt = rsP.getInt( STATUS_COUNTER );
			}

			// Sy[Wȉꍇ
			if(intCnt == strUID.length){
				charRet = PASSED;
				return charRet;
			}

			/*
			 * C
			 */
			// SQL̑gݗ
			StringBuffer sbCSQL = new StringBuffer();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){	
				sbCSQL.append("SELECT COUNT(DISTINCT " + UID + ") AS " + STATUS_COUNTER + " ");
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbCSQL.append("SELECT COUNT(DISTINCT " +" \""+UID+"\"" + ") AS " + STATUS_COUNTER + " ");
			}
			sbCSQL.append("FROM " + TABLE_NAME + " ");
			sbCSQL.append("WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
			sbCSQL.append("AND " + LOID + "='"+ StringEscapeUtils.escapeSql(new String(strLOID)) + "' ");

			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){	
				sbCSQL.append("AND UID IN (" + strUIDList + ") ");
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbCSQL.append("AND"+" \"UID\" "+"IN (" + strUIDList + ") ");
			}
			sbCSQL.append("AND (Lesson_Status LIKE '" + PASSED + "%' OR Lesson_Status LIKE '" + COMPLETED + "%')");

			// C擾
			ResultSet rsC = objDataAccess.executeQuery(sbCSQL.toString());

			intCnt = 0;
			while( rsC.next() ) {
				intCnt = rsC.getInt( STATUS_COUNTER );
			}

			// Sy[WC̏ꍇ
			if(intCnt == strUID.length){
				charRet = COMPLETED;
				return charRet;
			}
		}
		catch(Exception ex)
		{

		}	
		return charRet;
	}


	/**
	 * OfflineތʃO@OL_AiccCoree[u烍O*100擾܂
	 * @param strUserID 	[UID
	 * @param strLOID 		LOID
	 * @param strSessionID 	ZbVID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return O*100
	 * @exception SQLException f[^x[XG[
	 */
	public String getFullScore(String strUserID,
								String strLOID,
								String strSessionID,
								DataAccess objDataAccess )
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbPSQL = new StringBuffer();

		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbPSQL.append("SELECT COUNT(DISTINCT UID) * 100 AS FullScore ");
			//Oraclȅꍇ OR PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbPSQL.append("SELECT COUNT(DISTINCT"+" \"UID\""+") * 100 AS FullScore ");
			}

			sbPSQL.append("FROM " + TABLE_NAME + " ");
			sbPSQL.append("WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
			sbPSQL.append("AND " + LOID + "='"+ StringEscapeUtils.escapeSql(strLOID) + "' ");
			sbPSQL.append("AND " + RAW_SCORE + " IS NOT NULL ");
		}
		catch(Exception ex)
		{

		}
		// _l擾
		DebugLog.write( this.getClass(),sbPSQL.toString(), DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery(sbPSQL.toString());

		// ftHg0
		String strRet = "0";
		if( rs.next() ) {
			strRet = rs.getString(1);
		}

		return strRet;
	}


	/**
	 * OfflineތʃO@OL_AiccCoree[uMaxScore̍vl擾܂
	 * @param strUserID 	[UID
	 * @param strLOID 		LOID
	 * @param strSessionID 	ZbVID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return MaxScore̍vl
	 * @exception SQLException f[^x[XG[
	 */
	public String getSumMaxScore(	String strUserID,
									String strLOID,
									String strSessionID,
									DataAccess objDataAccess)
		throws SQLException
	{
		// vl擾
		return getSumScore(strUserID, strLOID, strSessionID, objDataAccess, MAX_SCORE);
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[uMinScore̍vl擾܂
	 * @param strUserID 	[UID
	 * @param strLOID 		LOID
	 * @param strSessionID 	ZbVID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return MinScore̍vl
	 * @exception SQLException f[^x[XG[
	 */
	public String getSumMinScore(	String strUserID,
									String strLOID,
									String strSessionID,
									DataAccess objDataAccess)
		throws SQLException
	{
		// vl擾
		return getSumScore(strUserID, strLOID, strSessionID, objDataAccess, MIN_SCORE);
	}
	/**
	 * OfflineތʃO@OL_AiccCoree[uRawScore̍vl擾܂
	 * @param strUserID 	[UID
	 * @param strLOID 		LOID
	 * @param strSessionID 	ZbVID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return RawScore̍vl
	 * @exception SQLException f[^x[XG[
	 */
	public String getSumRawScore(	String strUserID,
									String strLOID,
									String strSessionID,
									DataAccess objDataAccess)
		throws SQLException
	{
		// vl擾
		return getSumScore(strUserID, strLOID, strSessionID, objDataAccess, RAW_SCORE);
	}

	/**
	 * OfflineތʃO@OL_AiccCoree[ustrFieldName̍vl擾܂
	 * @param strUserID 	[UID
	 * @param strLOID 		LOID
	 * @param strSessionID 	ZbVID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @param strFieldName 	vtB[h
	 * @return strFieldName̍vl
	 * @exception SQLException f[^x[XG[
	 */
	private String getSumScore(	String strUserID,
								String strLOID,
								String strSessionID,
								DataAccess objDataAccess,
								String strFieldName )
		throws SQLException
	{
		// SQL̑gݗ
		StringBuffer sbPSQL = new StringBuffer();
		// ftHg0
		String strRet = "0";
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv = new Environment();

			if(strFieldName != null && !strFieldName.equals(RAW_SCORE))
			{
				sbPSQL.append("SELECT SUM(MaxScore) AS MaxScore, SUM(MinScore) AS MinScore ");
				sbPSQL.append("FROM (SELECT MAX(MaxScore) AS MaxScore, MIN(MinScore) AS MinScore ");
				sbPSQL.append("FROM " + TABLE_NAME + " ");
				sbPSQL.append("WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
				sbPSQL.append("AND " + LOID + "='"+ StringEscapeUtils.escapeSql(strLOID) + "' ");

				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
					sbPSQL.append("GROUP BY UserID, LOID, UID) WorkTable");
				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					sbPSQL.append("GROUP BY UserID, LOID,"+"\"UID\""+") WorkTable");
				}

				// ō_ƍŒᓾ_̏Wvl擾
				DebugLog.write( this.getClass(),sbPSQL.toString(), DebugLog.ROW );
				ResultSet rs = objDataAccess.executeQuery(sbPSQL.toString());
				if( rs.next() ) {
					if(strFieldName != null && strFieldName.equals(MAX_SCORE))
					{
						strRet = rs.getString("MaxScore");
					}
					else if(strFieldName != null && strFieldName.equals(MIN_SCORE))
					{
						strRet = rs.getString("MinScore");
					}
				}
			}
			else if(strFieldName != null && strFieldName.equals(RAW_SCORE))
			{
				sbPSQL.append("SELECT SUM(OL_AiccCore.RawScore) ");
				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
					sbPSQL.append("FROM (SELECT UID, USERID, LOID, MAX(CONVERT(INT,SessionID)) AS SessionID ");
				//Oraclȅꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
					sbPSQL.append("FROM (SELECT "+"\"UID\""+", USERID, LOID, MAX(TO_NUMBER(SessionID)) AS SessionID ");
				//PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					sbPSQL.append("FROM (SELECT "+"\"UID\""+", USERID, LOID, MAX(TO_NUMBER(SessionID,'99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999')) AS SessionID ");
				}
				sbPSQL.append("FROM " + TABLE_NAME + " ");
				sbPSQL.append("WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
				sbPSQL.append("AND " + LOID + "='"+ StringEscapeUtils.escapeSql(strLOID) + "' ");
				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
					sbPSQL.append("GROUP BY UID, LOID, UserID) WORK INNER JOIN ");
					sbPSQL.append("OL_AiccCore ON WORK .UID = OL_AiccCore.UID AND ");
				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					sbPSQL.append("GROUP BY "+"\"UID\""+", LOID, UserID) WORK INNER JOIN ");
					sbPSQL.append("OL_AiccCore ON WORK ."+"\"UID\""+" = OL_AiccCore."+"\""+UID+"\""+" AND ");
				}

				if ( objEnv.getDBType().equals( Environment.DB_SQLSERVER )
					|| objEnv.getDBType().equals( Environment.DB_ORACLE ) ) {
					// SQLServerOraclȅꍇ
					sbPSQL.append( "WORK .SessionID = AiccCore.SessionID AND " );
					sbPSQL.append( "WORK .USERID = AiccCore.UserID AND WORK .LOID = AiccCore.LOID" );
	
				} else {
					// PostgreSQL̏ꍇ
					sbPSQL.append("WORK .SessionID = TO_NUMBER(AiccCore.SessionID,'99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999')  AND ");
					sbPSQL.append("WORK .USERID = AiccCore.UserID AND WORK .LOID = AiccCore.LOID");
				}


				// _̏Wvl擾
				DebugLog.write( this.getClass(),sbPSQL.toString(), DebugLog.ROW );
				ResultSet rs = objDataAccess.executeQuery(sbPSQL.toString());
				if(rs.next())
				{
					strRet = rs.getString(1);
				}
			}
		}
		catch(Exception ex)
		{

		}
		return strRet;
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable changeData( AiccCoreRecord objRecord ) {
		Hashtable htbData = new Hashtable();
		// bXXe[^X
		putData( htbData, LESSON_STATUS, objRecord.getLessonStatus() );
		putData( htbData, RAW_SCORE, objRecord.getRawScore() );
		putData( htbData, MAX_SCORE, objRecord.getMaxScore() );
		putData( htbData, MIN_SCORE, objRecord.getMinScore() );
		putData( htbData, STAY_TIME, objRecord.getStayTime() );
		putData( htbData, LESSON_LOCATION, objRecord.getLessonLocation() );
		putData( htbData, EXIST, objRecord.getExist() );
		putData( htbData, USERID, objRecord.getUserID() );
		putData( htbData, LOID, objRecord.getLoID() );
		putData( htbData, SESSIONID, objRecord.getSessionID() );
		putData( htbData, UID, objRecord.getUid() );

		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, String strKey, String strValue ) {
		if( strValue != null && !strValue.equals( "" ) ) {
			htbData.put( strKey, strValue );
		}
	}


}

