/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	LO ʃNCAgi
//			ύX
//				2004.01.08	VK쐬	񞊒q
//				2004.09.24	M0004	A.Shimoma
//
package jp.co.ntt.lms.lo;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Vector;

import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.MenuData;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.Lo.MaterialData;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * ׂĂLoTop̃NCAgi̐eNXɂȂ܂B<BR>
 * eLoTopɊ֘ANCAgi쐬ꍇ͂̃NXp
 * ĂB
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class LoTopClient
	implements LoPropertyDef
{

	/**
	 * [gIuWFNgLbV܂
	 */
	private static final Hashtable mhtbLoTop = new Hashtable();

	/**
	 * RMIWXgo^̃vtBbNX
	 */
	public static final String LO_PRE = "LoTop";

	/**
	 * LOʂێ܂
	 */
	private String mstrLoType = "";

	/**
	 * NXێ܂
	 */
	private String mstrClassName = "";

	/**
	 * T[oێ܂
	 */
	private String mstrServerName = "";

	/**
	 * p[^ێ܂
	 */
	private Hashtable mhtbParam = new Hashtable();

	/**
	 * [gIuWFNgێ܂
	 */
	private LoTop mobjLoTop;

	/**
	 * j[Xgʂݒ肵܂
	 */
	private MenuData[] mobjMenuList;

	/**
	 * ރXgʂݒ肵܂
	 */
	private MaterialData[] mobjMaterialList;

	/**
	 * wKJnʂݒ肵܂
	 */
	private LearnData mobjLearnData;

	/**
	 * wKJnG[y[Wݒ肵܂
	 */
	private String mstrLearnErrorURL = "/view/lo/Com/Err.vm";

	/**
	 * wKIʂݒ肵܂
	 */
	private Object mobjEndLearn;

	/**
	 * ʃO擾ʂݒ肵܂
	 */
	private LoLogSessionRecord[] mobjLoLogSessionRecord;

	/**
	 * ʃO擾ʂێ܂
	 */
	private String[][] mobjLoLogResult;

	/**
	 * ꃍO擾ʂݒ肵܂
	 */
	private Object mobjIndividualLog;

	/**
	 * ʃO擾ʂݒ肵܂
	 */
	private String[][] mobjIndividualLogResult;
	/**
	 * ʃO(CSV)擾ʂݒ肵܂
	 */
	private String[][] mobjIndividualLogCSVResult;

	/**
	 * Loʏێ܂
	 */
	private LoComData[] mobjLoComData;

	/**
	 * sʂݒ肵܂
	 */
	private Object mobjExecute;

	/**
	 * ލ\ݒ肵܂
	 */
	private Object mobjMaterialNode;

	/**
	 * ލ\t@Ceݒ肵܂
	 */
	private String mstrMaterialFile;


	/**
	 * bZ[Wf[^IuWFNgێ܂
	 */
	private MessageData mobjMessageData;

	/**
	 * Xe[^X`dR[hێ܂
	 */
	private PropagateRelationRecord[] mobjPropagateRelationRecord;


	/**
	 * RMIʐMgC
	 */
	private static final int RMI_RETRY_COUNT = 10;

	/**
	 * RMIʐMgCҋ@
	 */
	private static final int RMI_RETRY_WAIT = 1000;

	/**
	 * RXgN^łB<BR>
	 * 擾RMIIuWFNg̓o^w肵ĂB
	 * @param strServerName LOT[o
	 * @param strLoType LO
	 */
	public LoTopClient( String strServerName, String strLoType ) throws Exception {
		// vCx[gϐɃNXݒ(LOTOP + Lo)
		mstrClassName = LO_PRE + strLoType;
		synchronized( this.getClass() ){
			// LbVw肳ꂽNX̃[gIuWFNgo܂
			LoTop objLoTop = (LoTop)mhtbLoTop.get( mstrClassName );
			// LbVɑ݂Ȃꍇ͍쐬
			if( objLoTop == null ) {
				objLoTop = getLoTop( strServerName, mstrClassName );
			}
			mobjLoTop = objLoTop;
		}
		// T[ôݒ
		mstrServerName = strServerName;
		// LOʂݒ
		mstrLoType = strLoType;
		// LOʂHashtableɊi[
		mhtbParam.put( LO_TYPE, strLoType );
	}

	/**
	 * LoTop擾\bh
	 */
	private LoTop getLoTop( String strServerName, String strClassName )
		throws Exception
	{
		LoTop objLoTop = null;
		try{
			Environment objEnvironment = new Environment();
			int intLoPort = new Integer( objEnvironment.getLoRegistryPort() ).intValue();
			Registry registry = LocateRegistry.getRegistry( strServerName, intLoPort );
			for( int i=0; i<RMI_RETRY_COUNT; i++ ){
				try{
					objLoTop = (LoTop)registry.lookup( "//" + strServerName + "/" + strClassName );
					break;
				}catch( Exception ex ){
					// gC񐔏I
					if( i == RMI_RETRY_COUNT -1 ) {
						// OX[
						throw ex;
					}
					try{
						Thread.sleep(RMI_RETRY_WAIT);
					}
					catch(InterruptedException ex2){
					}
				}
			}
			mhtbLoTop.put( strClassName, objLoTop );
		}catch(Exception e){
			// Oo
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw e;
		}
		return objLoTop;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̃j[Xg擾܂
	 * @return boolean j[擾
	 */
	public boolean getMenuList()
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		vecRet          = getMenuList(mhtbParam);
		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕Kj[Xgf[^
					mobjMenuList = (MenuData[])vecRet.get(1);
					//MenuData̔zZbg
					setMobjMenuList(mobjMenuList);
				}
			}
		}
		return boolRet;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̃j[Xg擾܂
	 * @return Vector bZ[Wf[^ƃj[Xg
	 */
	private Vector getMenuList(Hashtable htbParam)
	{
		Vector vecRet = new Vector();
		try
		{
			vecRet = mobjLoTop.getMenuList(htbParam);
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getMenuList(htbParam);
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getMenuList(htbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecRet;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̋ރXg擾܂
	 * @return boolean ރXg擾̐
	 */
	public boolean getMaterialList()
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		vecRet          = getMaterialList(mhtbParam);
		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕Kj[Xgf[^
					mobjMaterialList = (MaterialData[])vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̋ރXg擾܂
	 * @return Vector bZ[Wf[^ƋރXg
	 */
	private Vector getMaterialList( Hashtable htbParam )
	{
		Vector vecList = new Vector();
		try
		{
			vecList = mobjLoTop.getMaterialList(htbParam);
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecList = mobjLoTop.getMaterialList(htbParam);
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjLoTop.getMaterialList(htbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecList;
	}

	/**
	 * LÕZbgAbvs܂
	 * @param strSetupStatus ZbgAbv敪
	 * <PRE>
	 *      SETUP_INSERT   o^
	 *      SETUP_UPDATE   XV
	 *      SETUP_DELETE   폜
	 *      SETUP_ADDUSER  [Uo^
	 *      SETUP_DELUSER  [U폜
	 * </PRE>
	 * @return boolean 
	 */
	public boolean setUp( String strSetupStatus, Hashtable htbParam ) {
		boolean boolRet = false;
		Vector vecRet = new Vector();

		mhtbParam = htbParam;
		// p[^ɏ敪i[
		setValue( SETUP_STATUS, strSetupStatus );
		vecRet          = setUp();
		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕Kj[Xgf[^
					mobjMaterialList = (MaterialData[])vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * LOZbgAbv<BR>
	 * @return Vector 
	 */
	private Vector setUp()
	{
		Vector vecList = new Vector();
		try
		{
			vecList = mobjLoTop.setUp(mhtbParam);
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecList = mobjLoTop.setUp(mhtbParam);
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjLoTop.setUp(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		return vecList;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * wKJn\ǂ`FbN܂B<BR>
	 * wKJn\ȂΊwKJnURLݒ肵A<BR>
	 * trueԂ܂B
	 * @param strUserID [UID
	 * @param strPassword pX[h
	 * @param strLoID LOID
	 * @param strReturnURL ߂URL
	 * @return boolean wKJn
	 */
	public boolean startLearn(
							  String strUserID,
							  String strPassword,
							  String strLoID,
							  String strReturnURL,
							  String strRealLOID,
							  String strXCServerNo,
							  String strCookieXCSNo
							  ) throws Exception
	{
		// oϐݒ
		setUserID( strUserID );
		setPassword( strPassword );
		setLoID( strRealLOID );
		setReturnURL( strReturnURL );
		setPropagateLOID( strLoID );
		// wKΏLOID̐ݒ
		setTargetLOID( strLoID );
		setXCServerNo( strXCServerNo );
		setCookieXCSNo( strCookieXCSNo );
		// ߂l
		boolean boolRet = false;
		// wKJnf[^擾
		Vector vecRet   = startLearn(mhtbParam);

		// bZ[Wf[^ƊwKJnf[^ݒ
		if(vecRet.size() > 0)
		{
			// G[胁bZ[Wf[^擾
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(vecRet.size() > 1)
				{
					// wKJnURLݒ
					mobjLearnData = (LearnData)vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̊wKJn\bhĂт܂B<BR>
	 * @return Vector bZ[Wf[^ƊwKJn
	 */
	private Vector startLearn( Hashtable htbParam )
	{
		Vector vecList = new Vector();
		try
		{
			vecList = mobjLoTop.startLearn(htbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecList = mobjLoTop.startLearn(htbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjLoTop.startLearn(htbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecList;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * wKI\ǂ`FbN܂B<BR>
	 * wKI\ȂΌʂݒ肵A<BR>
	 * trueԂ܂B
	 * @return boolean wKI
	 */
	public boolean endLearn()
		throws Exception
	{
		// ߂l
		boolean boolRet = false;
		// wKIf[^擾
		Vector vecRet   = endLearn( mhtbParam );

		// bZ[Wf[^ƊwKJnURLݒ
		if(vecRet.size() > 0)
		{
			// G[胁bZ[Wf[^擾
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(vecRet.size() > 1)
				{
					mobjEndLearn = vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * {LoTop\bh̋Ns܂B<BR>
	 * LoTop̊wKI\bhĂт܂
	 * @return Vector bZ[Wf[^NULL
	 */
	public Vector endLearn( Hashtable htbParam )
	{
		Vector vecList = new Vector();
		try
		{
			vecList = mobjLoTop.endLearn(htbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecList = mobjLoTop.endLearn(htbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjLoTop.endLearn(htbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecList;
	}

	/**
	 * ʃO擾p̌ǉ܂B<BR>
	 * SQL`t@C'?'ǉԂŒu܂B<BR>
	 * ݒ肷鑤͌ĂяoSQLɂ킹āAǉ鏇Ԃ߂ĂB
	 * @param strCondition 
	 */
	public void addLoLogCondition( String strCondition ) {
		// nbVVectoroB
		Vector vecLogCondition = (Vector)mhtbParam.get( LOG_CONDITION );

		if( vecLogCondition == null ) {
			// Vectornull̏ꍇ͐VKɍ쐬
			vecLogCondition = new Vector();
			// nbVp[^ɒǉ
			mhtbParam.put( LOG_CONDITION, vecLogCondition );
		}

		// VectorɌݒ肷
		vecLogCondition.add( strCondition );
	}

	/**
	 * ʃO̎擾s܂B
	 * @param strQueryID sSQLIDw肵܂
	 * @return boolean ʃO̎擾̐
	 */
	public boolean getLoLog( String strQueryID ) {
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try {
			// [UIDi[
			if( strQueryID != null ) {
				mhtbParam.put( QUERY_ID, strQueryID );
			}
			vecRet = mobjLoTop.getLoLog(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getLoLog(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getLoLog(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KOXgf[^
					mobjLoLogResult = (String[][])vecRet.get(1);
				}
			}
		}
		return boolRet;
	}


	/**
	 * PROPAGATERELATIONR[h̎擾s܂B
	 * @param strRelatedID vɎgpĂLOID
	 * @return boolean R[h擾̐
	 */
	public boolean getPropagateRelation( String strRelatedID ) {
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try {
			// RELATEDIDi[
			if( strRelatedID != null ) {
				mhtbParam.put( RELATEDID, strRelatedID );
			}
			vecRet = mobjLoTop.getPropagateRelation(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getPropagateRelation(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getPropagateRelation(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KR[hf[^
					mobjPropagateRelationRecord = (PropagateRelationRecord[])vecRet.get(1);
				}
			}
		}
		return boolRet;
	}


	/**
	 * LORs[܂
	 * @param vecParam Xg\̃p[^
	 * @return boolean Rs[
	 */
	public boolean doCopy( Vector vecParam ) {
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try {
			// p[^i[
			if( vecParam != null ) {
				mhtbParam.put( COPY_PARAM, vecParam );
			}
			vecRet = mobjLoTop.doCopy(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.doCopy(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.doCopy(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
			}
		}
		return boolRet;
	}

	/**
	 * ʃO̎擾s܂B
	 * @param strQueryID sSQLIDw肵܂
	 * @return boolean ʃO̎擾̐
	 */
	public boolean getIndividualLog( String strQueryID ) {
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try {
			// [UIDi[
			if( strQueryID != null ) {
				mhtbParam.put( QUERY_ID, strQueryID );
			}
			vecRet = mobjLoTop.getIndividualLog(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getIndividualLog(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getIndividualLog(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KOXgf[^
					Vector vecResultData = (Vector)vecRet.get(1);
					mobjIndividualLogResult = (String[][])vecResultData.get(0);
				}
			}
		}
		return boolRet;
	}

// 20040924 M0004 ADD start NTTR(N)

	/**
	 * ʃO̎擾s܂B
	 * @param strQueryID		sSQLIDw肵܂
	 * @param strUserID 		擾郆[UID̃Xgw肵܂
	 * @param strUID 			擾UID̃Xgw肵܂
	 * @param inGroupColumn		NG[IN($USER_LIST$)ŗpJ
	 * @param inUIDColumn		NG[IN($UID_LIST$)ŗpJ
	 * @return boolean ʃO̎擾̐
	 */
	public boolean getIndividualLogCSV(
		String strQueryID,
		String[] strUserID,
		String[] strUID,
		String inGroupColumn,
		String inUIDColumn ) {

		boolean boolRet = false;
		Vector vecRet = new Vector();
		try {
			// [UIDi[
			if ( strQueryID != null ) {
				mhtbParam.put( QUERY_ID, strQueryID );
				mhtbParam.put( IN_COLUMN_USER_LIST, inGroupColumn );
				mhtbParam.put( IN_COLUMN_UID_LIST, inUIDColumn );
			}
			mhtbParam.put( USERID_LIST, strUserID );
			mhtbParam.put( UID_LIST, strUID );
			vecRet = mobjLoTop.getIndividualLogCSV( mhtbParam );
		} catch ( RemoteException ce ) {
			try {
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getIndividualLogCSV( mhtbParam );
			} catch ( RemoteException re ) {
				for ( int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getIndividualLogCSV( mhtbParam );
						break;
					} catch ( RemoteException re2 ) {
						// gC񐔂Iꍇ
						if ( i == RMI_RETRY_COUNT - 1 ) {
							re2.printStackTrace();
						}
						try {
							Thread.sleep( RMI_RETRY_WAIT );
						} catch ( InterruptedException ie ) {
						}
					}
				}
			} catch ( Exception e ) {
				e.printStackTrace();
			}
		}
		int intSize = vecRet.size();
		if ( intSize > 0 ) {
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = ( MessageData ) vecRet.get( 0 );
			if ( mobjMessageData == null ) {
				// I
				boolRet = true;
				if ( intSize > 1 ) {
					// ẑQԖڂ͕KOXgf[^
					Vector vecResultData = ( Vector ) vecRet.get( 1 );
					mobjIndividualLogCSVResult = ( String[][] ) vecResultData.get( 0 );
				}
			}
		}
		return boolRet;
	}

// 20040924 M0004 ADD end

	/**
	 * ʃO̎擾s܂B
	 * @param strQueryID	sSQLIDw肵܂
	 * @param strUserID 	擾郆[UID̃Xgw肵܂
	 * @param strUID 		擾UID̃Xgw肵܂
	 * @return boolean ʃO̎擾̐
	 */
	public boolean getIndividualLogCSV( String strQueryID, String[] strUserID, String[] strUID ) {

		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try {
			// [UIDi[
			if( strQueryID != null ) {
				mhtbParam.put( QUERY_ID, strQueryID );
			}
			mhtbParam.put( USERID_LIST, strUserID );
			mhtbParam.put( UID_LIST, strUID );
			vecRet = mobjLoTop.getIndividualLogCSV(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getIndividualLogCSV(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getIndividualLogCSV(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KOXgf[^
					Vector vecResultData = (Vector)vecRet.get(1);
					mobjIndividualLogCSVResult = (String[][])vecResultData.get(0);
				}
			}
		}
		return boolRet;
	}

	/**
	 * ʃO̎擾s܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return boolean ʃO擾̐
	 */
	public boolean getIndividualLog( String strUserID, String strLoID )
	{
		Vector vecRet   = new Vector();

		String[] strUserIDList = null;
		String[] strLoIDList = null;
		if( strUserID != null ) {
			strUserIDList = new String[1];
			strUserIDList[0] = strUserID;
		}
		if( strLoID != null  ) {
			strLoIDList = new String[1];
			strLoIDList[0] = strLoID;
		}
		return getIndividualLog( strUserIDList, strLoIDList );
	}

	/**
	 * ʃO̎擾s܂
	 * @param strUserID [UIDXg
	 * @param strLoID LOIDXg
	 * @return Vector bZ[Wf[^ƌʃO
	 */
	public boolean getIndividualLog( String[] strUserID, String[] strLoID )
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try
		{
			// [UIDi[
			if( strUserID != null )
			{
				mhtbParam.put( USER_LIST, strUserID );
			}
			// LOIDi[
			if( strLoID != null )
			{
				mhtbParam.put( LOID_LIST, strLoID );
			}
			vecRet = mobjLoTop.getIndividualLog(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getIndividualLog(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getIndividualLog(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KOXgf[^
					mobjIndividualLog = vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * ʃO̍폜s܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return boolean ʃO擾̐
	 */
	public boolean deleteIndividualLog( String strUserID, String strLoID )
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try
		{
			// [UIDi[
			if( strUserID != null )
			{
				mhtbParam.put( USER, strUserID );
			}
			// LOIDi[
			if( strLoID != null )
			{
				mhtbParam.put( LOID, strLoID );
			}
			vecRet = mobjLoTop.deleteIndividualLog(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.deleteIndividualLog(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.deleteIndividualLog(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
			}
		}
		return boolRet;
	}

	/**
	 * ʃO̍XVs܂
	 * 
	 * @param loID LOID
	 * @param condition 
	 * @return boolean ʃO擾̐
	 */
	public boolean changeTypeUpdateIndividualLog( String loID, String condition ) {
		boolean boolRet = false;
		Vector vecRet = new Vector();
		try {
			// LOIDi[
			if ( loID != null ) {
				mhtbParam.put( LOID, loID );
			}
			// i[
			if ( condition != null ) {
				mhtbParam.put( CONDITION_KEY, condition );
			}
			vecRet = mobjLoTop.changeTypeUpdateIndividualLog( mhtbParam );
		} catch ( RemoteException ce ) {
			try {
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.deleteIndividualLog( mhtbParam );
			} catch ( RemoteException re ) {
				for ( int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.deleteIndividualLog( mhtbParam );
						break;
					} catch ( RemoteException re2 ) {

						// gC񐔂Iꍇ
						if ( i == RMI_RETRY_COUNT - 1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						} catch ( InterruptedException ie ) {
						}
					}
				}
			} catch ( Exception e ) {
				e.printStackTrace();
			}
		}

		int intSize = vecRet.size();
		if ( intSize > 0 ) {
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = ( MessageData ) vecRet.get( 0 );
			if ( mobjMessageData == null ) {
				// I
				boolRet = true;
			}
		}
		return boolRet;
	}

	/**
	 * ʃǑʂ擾܂
	 */
	public String[][] getLoLogResult() {
		return mobjLoLogResult;
	}

	/**
	 * IDLȌڍ׏擾܂
	 * @return boolean s̐
	 */
	public boolean getData( String strLoID ) {
		setLoID( strLoID );
		return getData( mhtbParam );
	}

	/**
	 * LOڍ׏擾
	 */
	private boolean getData(Hashtable htbParam) {
		boolean boolRet = false;
		Vector vecRet = new Vector();
		try
		{
			vecRet = mobjLoTop.getData(mhtbParam);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getData(mhtbParam);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getData(mhtbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				boolRet = true;
				if(intSize > 1)
				{
					// ẑQԖڂ͕KOXgf[^
					mobjLoComData = (LoComData[])vecRet.get(1);
				}
			}
		}
		return boolRet;
	}

	/**
	 * LOڍ׏擾R[hԂ܂
	 */
	public int getDataLength() {
		if( mobjLoComData != null ) {
			return mobjLoComData.length;
		}
		else {
			return 0;
		}
	}

	/**
	 * CfbNXw肵āAڍ׏擾܂
	 */
	public LoComData getDataInfo( int index ) {
		if( mobjLoComData == null ) {
			return null;
		}
		else {
			return mobjLoComData[index];
		}
	}

	/**
	 * p[^[ݒ肵܂
	 * @param strMehodName N郁\bh
	 * @return boolean s̐
	 */
	public boolean execute( String strMethodName )
	{
		boolean boolRet = false;

		boolRet = execute(strMethodName, mhtbParam);

		return boolRet;
	}

	/**
	 * eLoɓo^Ă郁\bhN܂
	 * @param strMehodName N郁\bh
	 * @param objParams N郁\bh̃p[^
	 * @return boolean s̐
	 */
	public boolean execute( String strMethodName, Hashtable objParams )
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try
		{
			vecRet = mobjLoTop.execute(strMethodName, objParams);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.execute(strMethodName, objParams);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.execute(strMethodName, objParams);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				if(intSize > 1)
				{
					mobjExecute  = vecRet.get(1);
				}
				boolRet      = true;
			}
		}
		return boolRet;
	}

	/**
	 * ލ\擾
	 * @param
	 * @param objParams N郁\bh̃p[^
	 * @return boolean s̐
	 */
	public boolean getMaterialStruct(Hashtable objParams)
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try
		{
			vecRet = mobjLoTop.getMaterialStruct(objParams);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getMaterialStruct(objParams);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getMaterialStruct(objParams);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				if(intSize > 1)
				{
					mobjMaterialNode  = vecRet.get(1);
				}
				boolRet      = true;
			}
		}
		return boolRet;
	}

	/**
	 * ލ\t@Ce擾
	 * @param
	 * @param objParams N郁\bh̃p[^
	 * @return boolean s̐
	 */
	public boolean getMaterialStructFile(Hashtable objParams)
	{
		boolean boolRet = false;
		Vector vecRet   = new Vector();
		try
		{
			vecRet = mobjLoTop.getMaterialStructFile(objParams);
		}
		catch( RemoteException ce )
		{
			try
			{
				// Ď擾
				mobjLoTop = getLoTop( mstrServerName, mstrClassName );
				vecRet = mobjLoTop.getMaterialStructFile(objParams);
			}
			catch( RemoteException re ) {
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecRet = mobjLoTop.getMaterialStructFile(objParams);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}

		int intSize     = vecRet.size();
		if(intSize > 0)
		{
			// ẑPԖڂ͕KbZ[Wf[^
			mobjMessageData = (MessageData)vecRet.get(0);
			if(mobjMessageData == null)
			{
				// I
				if(intSize > 1)
				{
					mstrMaterialFile  = (String)vecRet.get(1);
				}
				boolRet = true;
			}
		}
		return boolRet;
	}


	/**
	 * p[^̐ݒNA܂
	 */
	public void clear() {
		mhtbParam = new Hashtable();
	}

	/**
	 * IDw肵܂
	 */
	public void setMaterialID( String strMaterialID ) {
		if( strMaterialID != null ) {
			mhtbParam.put( MATLID, strMaterialID );
		}
	}

	/**
	 * [UIDݒ肵܂
	 */
	public void setUserID( String strUserID ) {
		if( strUserID != null ) {
			mhtbParam.put( USER, strUserID );
		}
	}

	/**
	 * [UpX[hݒ肵܂
	 */
	public void setPassword( String strPassword ) {
		if( strPassword != null ) {
			mhtbParam.put( PASSWD, strPassword );
		}
	}

	/**
	 * O擾̃^[QbgƂȂIDw肵܂
	 */
	public void setTargetID( String strTargetID ) {
		if( strTargetID != null ) {
			mhtbParam.put( TARGET_ID, strTargetID );
		}
	}

	/**
	 * [U^Cvݒ肵܂
	 */
	public void setUserType( String strUserType ) {
		if( strUserType != null ) {
			mhtbParam.put( USER_TYPE, strUserType );
		}
	}

	/**
	 * ߂URLݒ肵܂
	 */
	public void setReturnURL( String strReturnURL ) {
		if( strReturnURL != null ) {
			mhtbParam.put( RETURN_URL, strReturnURL );
		}
	}

	/**
	 * ނ̎AhXݒ肵܂
	 */
	public void setMaterialURL( String strMaterialURL ) {
		if( strMaterialURL != null ) {
			mhtbParam.put( MATERIAL_URL, strMaterialURL );
		}
	}

	/**
	 * Loʂݒ肵܂
	 */
	public void setLoType( String strLoType ) {
		if( strLoType != null ) {
			mhtbParam.put( LO_TYPE, strLoType );
		}
	}

	/**
	 * LoIDݒ肵܂
	 */
	public void setLoID( String strLoID ) {
		if( strLoID != null ) {
			mhtbParam.put( LOID, strLoID );
		}
	}
	/**
	 * wKΏLoIDݒ肵܂
	 */
	public void setTargetLOID( String strTargetLoID ) {
		if( strTargetLoID != null ) {
			mhtbParam.put( TARGETLOID, strTargetLoID );
		}
	}
	/**
	 * RealLoIDݒ肵܂
	 */
	public void setRealLoID( String strRealLoID ) {
		if( strRealLoID != null ) {
			mhtbParam.put( REAL_LOID, strRealLoID );
		}
	}

	/**
	 * IDݒ肵܂
	 */
	public void setAuID( String strAuID ) {
		if( strAuID != null ) {
			mhtbParam.put( AUID, strAuID );
		}
	}

	/**
	 * wKJnj[URLݒ肵܂
	 */
	public void setLearnURL( String strLearnURL ) {
		if( strLearnURL != null ) {
			mhtbParam.put( LEARN_URL, strLearnURL );
		}
	}

	/**
	 * p[^ɔCӂ̃L[Œlݒ肵܂
	 * @param strKey L[
	 * @param strValue l
	 */
	public void setValue( String strKey, String strValue ) {
		if( strKey == null || strValue == null ) {
			return;
		}

		mhtbParam.put( strKey, strValue );
	}

	/**
	 * wKJnf[^擾܂
	 * @return LearnData wKJnf[^
	 */
	public LearnData getLearnData()
	{
		return mobjLearnData;
	}

	/**
	 * wKJnG[URL擾܂
	 */
	public String getLearnErrorURL()
	{
		return mstrLearnErrorURL;
	}

	/**
	 * j[Xg̎w胁j[f[^擾
	 *
	 * @param int CfbNX
	 * @return MenuData j[f[^IuWFNg
	 */
	public MenuData getMenuData(int intIndex)
	{
		return mobjMenuList[intIndex];
	}

	/**
	 * j[Xg擾
	 *
	 * @return int j[Xg
	 */
	public int getMenuListSize()
	{
		if(mobjMenuList == null)
		{
			return 0;
		}
		return mobjMenuList.length;
	}

	/**
	 * ރXg̎w苳ރf[^擾
	 *
	 * @param int CfbNX
	 * @return MenuData ރf[^IuWFNg
	 */
	public MaterialData getMaterialData(int intIndex)
	{
		return mobjMaterialList[intIndex];
	}

	/**
	 * ރXg擾
	 *
	 * @return int ރXg
	 */
	public int getMaterialSize()
	{
		if(mobjMaterialList == null)
		{
			return 0;
		}
		return mobjMaterialList.length;
	}

	/**
	 * wKIʎ擾
	 *
	 * @return Object wKI
	 */
	public Object getEndLearn()
	{
		return mobjEndLearn;
	}

	/**
	 * ʃOXg̎w苤ʃOf[^擾
	 *
	 * @param int CfbNX
	 * @return LoLogSessionRecord ʃOf[^IuWFNg
	 */
	public LoLogSessionRecord getLoLogSessionRecord(int intIndex)
	{
		return mobjLoLogSessionRecord[intIndex];
	}

	/**
	 * ʃOXg擾
	 *
	 * @return int ʃOXg
	 */
	public int getLoLogSessionRecordSize()
	{
		if(mobjLoLogSessionRecord == null)
		{
			return 0;
		}
		return mobjLoLogSessionRecord.length;
	}

	/**
	 * ʃO擾
	 *
	 * @return Object ʃO
	 */
	public Object getIndividualLog()
	{
		return mobjIndividualLog;
	}

	/**
	 * ʃOʎ擾
	 *
	 * @return String[][] ʃO
	 */
	public String[][] getIndividualLogResult()
	{
		return mobjIndividualLogResult;
	}
	/**
	 * ʃO(CSV)ʎ擾
	 *
	 * @return String[][] ʃO
	 */
	public String[][] getIndividualLogCSVResult()
	{
		return mobjIndividualLogCSVResult;
	}

	/**
	 * sʎ擾
	 *
	 * @return Object s
	 */
	public Object getExecute()
	{
		return mobjExecute;
	}

	/**
	 * ލ\擾
	 *
	 * @return Object s
	 */
	public Object getMaterialStruct()
	{
		return mobjMaterialNode;
	}

	/**
	 * bZ[Wf[^IuWFNg擾܂
	 * @return MessageData bZ[Wf[^IuWFNg
	 */
	public MessageData getMessageData() {
		return mobjMessageData;
	}

	/**
	 * ލ\t@Ce擾
	 *
	 * @return String t@Ce
	 */
	public String getMaterialFile()
	{
		return mstrMaterialFile;
	}

	/**
	 * p[^ݒ肵܂
	 * @param htbParam p[^
	 */
	public void setParam( Hashtable htbParam ) {
		mhtbParam = htbParam;
	}

	/**
	 * Xe[^X`dR[hԋp܂B
	 *
	 * @return PropagateRelationRecord s
	 */
	public PropagateRelationRecord[] getPropageteRecords()
	{
		return mobjPropagateRelationRecord;
	}

	/**
	 * Xe[^X`dpLOIDݒ肵܂
	 */
	public void setPropagateLOID( String strPropagateLOID ) {
		if( strPropagateLOID != null ) {
			mhtbParam.put( PROPAGATE_LOID, strPropagateLOID );
		}
	}
	/**
	 * MenuData̔z擾
	 * @return MenuData̔z
	 */
	public MenuData[] getMobjMenuList() {
		return mobjMenuList;
	}

	/**
	 * MenuData̔zԋp
	 * @param MenuData̔z
	 */
	public void setMobjMenuList(MenuData[] mobjMenuList) {
		this.mobjMenuList = mobjMenuList;
	}

	/**
	 * T[o[ݒ肵܂
	 */
	public void setXCServerNo( String strServerNo ) {
		if( strServerNo == null || strServerNo.equals("")) {
			strServerNo = "NULL";
		}
		mhtbParam.put( XC_SERVER_NO, strServerNo );
	}

	/**
	 * T[o[ݒ肵܂Q
	 */
	public void setCookieXCSNo( String strCookieServerNo ) {
		if( strCookieServerNo == null || strCookieServerNo.equals("")) {
			strCookieServerNo = "NULL";
		}
		mhtbParam.put( XC_COOKIE_SERVER_NO, strCookieServerNo );
	}
}

