/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ZbVLOOf[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.lo;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.XMODate;

/**
 * ZbVLOO@f[^ANZXNXłB<BR>
 * @version 0.0.0.1 2004.01.08
 * @author T.Nijou
 */
public class LoLogSessionDataAccess {

	/** e[uێ܂ */
	private static final String TABLE_NAME = "LoLogSession";

	/** e[u` */
	private static final String FULLSCORE = "fullscore";				// _
	private static final String STUDY_START_DATE = "study_start_date";	// wKJn
	private static final String RESIDANCETIME = "residanceTime";		// ݐϑ؍ݎ
	private static final String PASSDAY = "passday";					// i
	private static final String STUDY_END_DATE = "study_end_date";		// C
	private static final String HIGHTSCORE = "highScore";				// ō_
	private static final String LOWSSCORE = "lowsScore";				// Œ_
	private static final String EXECISE_POINT = "execise_point";		// _
	private static final String USERID = "UserID";						// [UID
	private static final String LOID = "LOID";							// LOID
	private static final String SESSIONID = "SessionID";				// ZbVID
	private static final String LUNCH_TIMES = "Lunchtimes";				// wK
	private static final String CONDITION_KEY = "condition_key";		// ConditionKey	

	/**
	 * RXgN^
	 **/
	public LoLogSessionDataAccess() {
	}

	/**
	 * ZbVLOOe[u֓o^s܂
	 * @param objLoLogSession Of[^NX
	 * @exception LOException LOƎO
	 */
	public void insert( LoLogSessionRecord objLoLogSession )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			insertAction( objLoLogSession, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * ZbVLOOe[uւ̕R[h̓o^s܂<BR>
	 * @param objLoLogSession Of[^NX
	 * @exception LOException LOƎO
	 */
	public void insert( LoLogSessionRecord[] objLoLogSession )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// o^s܂(z񐔕[v)
			for( int i = 0; i < objLoLogSession.length; i++ ) {
				insertAction( objLoLogSession[i], objDataAccess );
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * ZbVLOOe[uւ̓o^s܂<BR>
	 * gUNV̊Ǘ͏ʂōs܂B
	 * @param objLoLogSession Of[^NX
	 * @exception SQLException DBɎsꍇ
	 */
	public void insert( LoLogSessionRecord objLoLogSession, DataAccess objDataAccess )
		throws SQLException
	{
		insertAction( objLoLogSession, objDataAccess );
	}

	/**
	 * ZbVLOOe[uւ̕R[h̓o^s܂<BR>
	 * gUNV̊Ǘ͏ʂōs܂B
	 * @param objLoLogSession Of[^NX
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception SQLException DBɎsꍇ
	 */
	public void insert( LoLogSessionRecord[] objLoLogSession, DataAccess objDataAccess )
		throws SQLException
	{
		// o^s܂(z񐔕[v)
		for( int i = 0; i < objLoLogSession.length; i++ ) {
			insertAction( objLoLogSession[i], objDataAccess );
		}
	}

	/**
	 * ZbVLOOe[uւ̓o^s܂
	 * @param objLoLogSession Of[^NX
	 * @exception SQLException DBG[
	 */
	private void insertAction( LoLogSessionRecord objLoLogSession, DataAccess objDataAccess )
		throws SQLException
	{

		// DBɓo^f[^nbVe[uɊi[܂
		Hashtable htbData = setData( objLoLogSession );

		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbData, TABLE_NAME );

		// o^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * LOOZbVe[uo^܂͍XV܂B<BR>
	 * gUNV͏ʂs܂B
	 * @param LoLogSessionRecord XVe
	 * @param String [UID
	 * @param String LOID
	 * @param String wK
	 * @exception SQLException DBG[
	 */
	public void insertUpdate(	LoLogSessionRecord objLoLogSession,
								String strUserID,
								String strLoID,
								String strLunchtimes,
								DataAccess objDataAccess )
		throws SQLException
	{
		// o^܂͍XVpHashtable쐬
		Hashtable htbData = setData( objLoLogSession );

		// o^XVU蕪܂
		if( getLoLog( strUserID, strLoID, strLunchtimes, objDataAccess ) == null ) {
			// o^
			insertAction( htbData, objDataAccess );
		}
		else {
			updateAction( htbData, strUserID, strLoID, strLunchtimes, objDataAccess );
		}
	}

	/**
	 * [UIDLOIDw肵āAs܂<BR>
	 * ̃\bhgpۂ̓gUNV͏ʂŊǗ܂B
	 * @param String [UID
	 * @param String LOID
	 * @param String wK
	 * @param DataAccess f[^ANZXIuWFNg
	 * @return LoLogSessionRecord[]  ʂȂꍇnull
	 * @excetption SQLException DBG[
	 */
	public LoLogSessionRecord getLoLog(String strUserID, String strLoID, String StudyCount, DataAccess objDataAccess)
		throws SQLException
	{
		if( strUserID == null && strLoID == null && StudyCount == null) {
			return null;
		}

		Hashtable htbParam = new Hashtable();
		htbParam.put( USERID, strUserID );
		htbParam.put( LOID, strLoID );
		htbParam.put( LUNCH_TIMES, StudyCount );

		Vector vecResult = selectAction( htbParam, objDataAccess );
		Vector vecLogList = (Vector)vecResult.get(0);
		if( vecLogList.size() > 0 ) {
			LoLogSessionRecord objRecord = (LoLogSessionRecord)vecLogList.get(0);
			return objRecord;
		}

		return null;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @param DataAccess f[^ANZXIuWFNg
	 * @return Vector 
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htParam, DataAccess objDataAccess )
		throws SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );
		// ̎擾
		String strCondition = (String)htParam.get( CONDITION_KEY );

		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		else {
			sbSQL.append( createCondition( htParam ) );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		Vector vecRet = new Vector();
		while(rs.next()) {
			String strFullScore = rs.getString( FULLSCORE );
			String strStudyStartDate = XMODate.parseTime(rs.getTimestamp( STUDY_START_DATE ));
			String strResidenceTime = rs.getString( RESIDANCETIME );
			String strPassDay = XMODate.parseTime(rs.getTimestamp( PASSDAY ));
			String strStudyEndDate = XMODate.parseTime(rs.getTimestamp( STUDY_END_DATE ));
			String strHighScore = rs.getString( HIGHTSCORE );
			String strLowScore = rs.getString( LOWSSCORE );
			String strExecisePoint = rs.getString( EXECISE_POINT );
			String strUserID = rs.getString( USERID );
			String strLOID = rs.getString( LOID );
			String strSessionID = rs.getString( SESSIONID );
			String strLunchTimes = rs.getString( LUNCH_TIMES );
			LoLogSessionRecord objData = new LoLogSessionRecord();
			objData.setFullScore( strFullScore );
			objData.setStudyStartDate( strStudyStartDate );
			objData.setResidanceTime( strResidenceTime );
			objData.setPassday( strPassDay );
			objData.setStudyEndDate( strStudyEndDate );
			objData.setHighScore( strHighScore );
			objData.setLowScore( strLowScore );
			objData.setExecisePoint( strExecisePoint );
			objData.setUserID( strUserID );
			objData.setLoID( strLOID );
			objData.setUserID( strSessionID );
			objData.setLoID( strLunchTimes );

			vecReturn.add( objData );
		}
		vecRet.add(vecReturn);
		return vecRet;
	}

	/**
	 * LOOZbVe[uւ̓o^s܂
	 * @param htbData Of[^
	 * @exception SQLException DBG[
	 */
	private void insertAction( Hashtable htbData, DataAccess objDataAccess )
		throws SQLException
	{

		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbData, TABLE_NAME );

		// o^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * LOOZbVe[uւ̍XVs܂
	 * @param htbParam XV
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param strLunchtimes wK
	 */
	public void updateAction(	Hashtable htbParam,
								String strUserID,
								String strLoID,
								String strLunchtimes,
								DataAccess objDataAccess )
		throws SQLException
	{
		String strCondition = createCondition( strUserID, strLoID, strLunchtimes );
		String strSQL = objDataAccess.getUpdateSQL( htbParam, TABLE_NAME );
		strSQL += strCondition;

		// XVs
		objDataAccess.execute( strSQL );
	}

	/**
	 * UserIDLOIDL[ɂāAds菜R[h(ꂪwK񐔂ɂȂ܂)Ԃ܂B
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return int wK
	 * @exception SQLException ŗOꍇ
	 */
	public int getStudyCount( String strUserID, String strLoID )
		throws LOException
	{

		// ߂l
		int intStudyCount = 0;

		// SQL̑gݗ
		String strSQL = "SELECT COUNT(DISTINCT " + SESSIONID + ") as count FROM " + TABLE_NAME + " WHERE " +
						USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'";

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			ResultSet rs = objDataAccess.executeQuery(strSQL);

			if( rs.next() ) {
				String strTemp = rs.getString( "count" );
				try {
					intStudyCount = new Integer( strTemp ).intValue();
				}
				catch( NumberFormatException ne ) {}
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return intStudyCount;
	}

	/**
	 * UserIDLOIDL[ɂāAԑ傫ō_擾܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param objDataAccess
	 * @return String highScore ԑ傫ō_ R[hꌏȂƂnullԂ
	 * @exception SQLException ŗOꍇ
	 */
	public String getMaxHighScore( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		return getScoreCom( strUserID, strLoID, HIGHTSCORE, objDataAccess );
	}

	/**
	 * UserIDLOIDL[ɂāAԏŒ_擾܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param objDataAccess
	 * @return String LowScore ԏŒ_ R[hꌏȂƂnullԂ
	 * @exception SQLException ŗOꍇ
	 */
	public String getMinLowScore( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		return getScoreCom( strUserID, strLoID, LOWSSCORE, objDataAccess );
	}

	/**
	 * UserIDLOIDL[ɂāAԑ傫_擾܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param objDataAccess
	 * @return String fullscore ԑ傫_ R[hꌏȂƂnullԂ
	 * @exception SQLException ŗOꍇ
	 */
	public String getMaxFullScore( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		return getScoreCom( strUserID, strLoID, FULLSCORE, objDataAccess );
	}

	/**
	 * ֐
	 * _̎擾\bh
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param strFieldName 擾tB[h
	 * @param objDataAccess
	 * @return String Score 擾 R[hꌏȂƂnullԂ
	 * @exception SQLException ŗOꍇ
	 */
	private String getScoreCom( String strUserID, String strLoID, String strFieldName, DataAccess objDataAccess )
		throws SQLException
	{
		String strScore = null;
		String strSelect = null;
		if( HIGHTSCORE.equals( strFieldName ) ) {
			strSelect = "MAX(" + HIGHTSCORE + ")";
		}
		else if( LOWSSCORE.equals( strFieldName ) ) {
			strSelect = "MIN(" + LOWSSCORE + ")";
		}
		else if( FULLSCORE.equals( strFieldName ) ) {
			strSelect = "MAX(" + FULLSCORE + ")";
		}
		else {
			return null;
		}

		// SQL̑gݗ
		StringBuffer strSQL = new StringBuffer();
		strSQL.append( "SELECT " );
		strSQL.append( strSelect  );
		strSQL.append( " as score FROM " );
		strSQL.append( TABLE_NAME );
		strSQL.append( " WHERE " );
		strSQL.append( USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' " );
		strSQL.append( " AND " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'" );

		ResultSet rs = objDataAccess.executeQuery(new String(strSQL));

		if( rs.next() ) {
			strScore = rs.getString( "score" );
		}

		return strScore;
	}

	/**
	 * LoLogSessione[u̍ŐVR[h̋ފ擾܂B
	 * @param String [UID
	 * @param String LOID
	 * @return String[] ފJnƋފ̔z
	 */
	public String[] getStudyDateList(String strUserID, String strLoID, DataAccess objDataAccess)
		throws SQLException
	{
		// ŐVwKԎ擾SQL̑gݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append("SELECT MAX(study_start_date) AS maxstartdate FROM ");
		strSQL.append(TABLE_NAME);
		if(strUserID != null || strLoID != null)
		{
			strSQL.append(" WHERE ");
			if(strUserID != null)
			{
				strSQL.append(USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
			}
			if(strUserID != null && strLoID != null)
			{
				strSQL.append(" AND ");	
			}
			if(strLoID != null)
			{
				strSQL.append(LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' ");
			}
		}

		// ʊi[pString
		String strMaxStartDate = "";
		String strMaxEndDate = "";

		ResultSet rs = objDataAccess.executeQuery(strSQL.toString());
		while(rs.next())
		{
			strMaxStartDate = XMODate.parseTime(rs.getTimestamp("maxstartdate"));
		}

		if(strMaxStartDate != null && !strMaxStartDate.equals(""))
		{
			// ŐVwKIR[h擾SQL̑gݗ
			StringBuffer strSQL2 = new StringBuffer();

			strSQL2.append("SELECT * FROM ");
			strSQL2.append(TABLE_NAME);
			strSQL2.append(" WHERE ");
			if(strUserID != null || strLoID != null)
			{
				if(strUserID != null)
				{
					strSQL2.append(USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND ");
				}
				if(strLoID != null)
				{
					strSQL2.append(LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND ");
				}
			}
			try{
				//XMS.init@C[hNX̃CX^X
				Environment objEnv=new Environment();
				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
					strSQL2.append(STUDY_START_DATE + "='" + StringEscapeUtils.escapeSql(strMaxStartDate) + "' ");
				//Oraclȅꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
					strSQL2.append(STUDY_START_DATE + "=TO_DATE('" + StringEscapeUtils.escapeSql(strMaxStartDate) + "','YYYY/MM/DD HH24:MI:SS')");
				//PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					strSQL2.append(STUDY_START_DATE + "=TO_TIMESTAMP('" + StringEscapeUtils.escapeSql(strMaxStartDate) + "','YYYY/MM/DD HH24:MI:SS')");
				}
			}
			catch(Exception ex)
			{

			}
			DebugLog.write( this.getClass(),strSQL2.toString(), DebugLog.ROW );
			ResultSet rs2 = objDataAccess.executeQuery(strSQL2.toString());
			while(rs2.next())
			{
				strMaxEndDate = rs2.getString(STUDY_END_DATE);
			}
		}

		String[] strResult = new String[2];
		strResult[0] = strMaxStartDate;
		strResult[1] = strMaxEndDate;
		return strResult;
	}

	/**
	 * LoLogSessione[ǔs܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return Vector ʁiLoLogSessionRecordi[)
	 */
	public Vector getSessionLog( String strUserID, String strLoID )
		throws LOException
	{

		// SQL̑gݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT * FROM " );
		strSQL.append( TABLE_NAME );
		if( strUserID != null || strLoID != null ) {
			strSQL.append( " WHERE " );
			if( strUserID != null ) {
				strSQL.append( USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' " );
			}
			if(strUserID != null && strLoID != null)
			{
				strSQL.append( " AND " );
			}
			if( strLoID != null ) {
				strSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' " );
			}
		}
		strSQL.append( " ORDER BY " + SESSIONID );
		strSQL.append( ", " + STUDY_START_DATE );
		strSQL.append( ", " + STUDY_END_DATE );

		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		// ʊi[pVector
		Vector vecResult = new Vector();
		try {
			// gUNVJn
			objDataAccess.trans();

			ResultSet rs = objDataAccess.executeQuery(strSQL.toString());

			while( rs.next() ) {
				LoLogSessionRecord objRecord = new LoLogSessionRecord();
				// ZbVR[hɃRs[
				objRecord.setFullScore( rs.getString( FULLSCORE ) );
				objRecord.setStudyStartDate( XMODate.parseTime( rs.getTimestamp( STUDY_START_DATE ) ) );
				objRecord.setResidanceTime( rs.getString( RESIDANCETIME ) );
				objRecord.setPassday( XMODate.parseTime( rs.getTimestamp( PASSDAY ) ) );
				objRecord.setStudyEndDate( XMODate.parseTime( rs.getTimestamp( STUDY_END_DATE ) ) );
				objRecord.setHighScore( rs.getString( HIGHTSCORE ) );
				objRecord.setLowScore( rs.getString( LOWSSCORE ) );
				objRecord.setExecisePoint( rs.getString( EXECISE_POINT ) );
				objRecord.setUserID( rs.getString( USERID ) );
				objRecord.setLoID( rs.getString( LOID ) );
				objRecord.setSessionID( rs.getString( SESSIONID ) );
				objRecord.setLunchTimes( rs.getString( LUNCH_TIMES ) );

				// ʊi[pVectorɊi[
				vecResult.add( objRecord );
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}

		return vecResult;

	}

	/**
	 * LoLogSessione[ǔs܂
	 * @param strUserID [UIDXg
	 * @param strLoID LoIDXg
	 * @param strConditionKey Whereǉ
	 * @return Vector ʁiLoLogSessionRecordi[)
	 */
	public Vector getSessionLog(String[] strUserIDList,
								String[] strLoIDList,
								String strConditionKey)
		throws LOException
	{
		int i            = 0;
		String strAllSQL = "";
		int intLoIndex   = 0;
		Vector vecResult = new Vector();										// ʊi[pVector

		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try
		{
			// gUNVJn
			objDataAccess.trans();
			while(intLoIndex < strLoIDList.length)
			{
				// Lȏgݗ
				StringBuffer strLoSQL = new StringBuffer();
				try
				{
					for(i = 0; i < 100; i++)
					{
						strLoSQL.append("'");
						strLoSQL.append(StringEscapeUtils.escapeSql(strLoIDList[intLoIndex++]));
						strLoSQL.append("'");
						strLoSQL.append(",");
					}
				}
				catch(ArrayIndexOutOfBoundsException ae)
				{
					// Ō"'"폜܂
					strLoSQL.deleteCharAt(strLoSQL.length() - 1);
				}
				finally
				{
					// Ō","폜܂
					strLoSQL.deleteCharAt(strLoSQL.length() - 1);
				}

				// Useȓgݗ
				int intUserIndex = 0;
				while(intUserIndex < strUserIDList.length)
				{
					StringBuffer strUserSQL = new StringBuffer();
					try
					{
						for(i = 0; i < 100; i++)
						{
							strUserSQL.append("'");
							strUserSQL.append(StringEscapeUtils.escapeSql(strUserIDList[intUserIndex++]));
							strUserSQL.append("'");
							strUserSQL.append(",");
						}
					}
					catch(ArrayIndexOutOfBoundsException ae)
					{
						// Ō"'"폜܂
						strUserSQL.deleteCharAt(strUserSQL.length() - 1);
					}
					finally
					{
						// Ō","폜܂
						strUserSQL.deleteCharAt(strUserSQL.length() - 1);
					}

					StringBuffer strSQL = new StringBuffer();
					strSQL.append("SELECT * FROM ");
					strSQL.append(TABLE_NAME);
					strSQL.append(" WHERE LOID in (");
					strSQL.append(strLoSQL);
					strSQL.append(") AND UserID in (");
					strSQL.append(strUserSQL);
					strSQL.append(")");
					if(strConditionKey != null)
					{
						strSQL.append(" AND " + strConditionKey);
					}
					strSQL.append( " ORDER BY " + SESSIONID );
					strSQL.append( ", " + STUDY_START_DATE );
					strSQL.append( ", " + STUDY_END_DATE );

					strAllSQL = strSQL.toString();
					ResultSet rs = objDataAccess.executeQuery(strAllSQL);
					while( rs.next() )
					{
						LoLogSessionRecord objRecord = new LoLogSessionRecord();
						// ZbVR[hɃRs[
						objRecord.setFullScore( rs.getString( FULLSCORE ) );
						objRecord.setStudyStartDate( XMODate.parseTime( rs.getTimestamp( STUDY_START_DATE ) ) );
						objRecord.setResidanceTime( rs.getString( RESIDANCETIME ) );
						objRecord.setPassday( XMODate.parseTime( rs.getTimestamp( PASSDAY ) ) );
						objRecord.setStudyEndDate( XMODate.parseTime( rs.getTimestamp( STUDY_END_DATE ) ) );
						objRecord.setHighScore( rs.getString( HIGHTSCORE ) );
						objRecord.setLowScore( rs.getString( LOWSSCORE ) );
						objRecord.setExecisePoint( rs.getString( EXECISE_POINT ) );
						objRecord.setUserID( rs.getString( USERID ) );
						objRecord.setLoID( rs.getString( LOID ) );
						objRecord.setSessionID( rs.getString( SESSIONID ) );
						objRecord.setLunchTimes( rs.getString( LUNCH_TIMES ) );
						// ʊi[pVectorɊi[
						vecResult.add( objRecord );
					}
				}
			}
			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e )
		{
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try
			{
				objDataAccess.rollback();
			}
			catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return vecResult;
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, FULLSCORE );
		putData( htbData, htbParam, STUDY_START_DATE );
		putData( htbData, htbParam, RESIDANCETIME );
		putData( htbData, htbParam, PASSDAY );
		putData( htbData, htbParam, STUDY_END_DATE );
		putData( htbData, htbParam, HIGHTSCORE );
		putData( htbData, htbParam, LOWSSCORE );
		putData( htbData, htbParam, EXECISE_POINT );
		putData( htbData, htbParam, USERID );
		putData( htbData, htbParam, LOID );
		putData( htbData, htbParam, SESSIONID );
		putData( htbData, htbParam, LUNCH_TIMES );
		return htbData;
	}

	/**
	 * o^AXṼf[^LoLogRecord쐬܂
	 * @param objLoLogRecord
	 */
	private Hashtable setData( LoLogSessionRecord objRecord ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, FULLSCORE, objRecord.getFullScore() );
		putData( htbData, STUDY_START_DATE, objRecord.getStudyStartDate() );
		putData( htbData, RESIDANCETIME, objRecord.getResidanceTime() );
		putData( htbData, PASSDAY, objRecord.getPassday() );
		putData( htbData, STUDY_END_DATE, objRecord.getStudyEndDate() );
		putData( htbData, HIGHTSCORE, objRecord.getHighScore() );
		putData( htbData, LOWSSCORE, objRecord.getLowScore() );
		putData( htbData, EXECISE_POINT, objRecord.getExecisePoint() );
		putData( htbData, USERID, objRecord.getUserID() );
		putData( htbData, LOID, objRecord.getLoID() );
		putData( htbData, SESSIONID, objRecord.getSessionID() );
		putData( htbData, LUNCH_TIMES, objRecord.getLunchTimes() );

		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, String strKey, String strValue ) {
		if( strKey == null || strValue == null ) {
			return;
		}

		if( !strValue.equals( "" ) ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * Hashtable烆[UIDLOID擾ď쐬܂
	 */
	private String createCondition( Hashtable htbData ) {
		String strUserID = (String)htbData.get( USERID );
		String strLoID = (String)htbData.get( LOID );
		String strLunchtimes = (String)htbData.get( LUNCH_TIMES );
		return createCondition( strUserID, strLoID, strLunchtimes );
	}

	/**
	 * [UIDLOID쐬܂
	 */
	private String createCondition( String strUserID, String strLoID, String strLunchtimes ) {

		String strUserIDCon = null;
		String strLoIDCon = null;
		String strLunchtimesCon = null;
		StringBuffer sbCondition = new StringBuffer();
		if( strUserID != null ) {
			strUserIDCon = USERID + " ='" + StringEscapeUtils.escapeSql(strUserID) + "'";
		}
		if( strLoID != null ) {
			strLoIDCon = LOID + " ='" + StringEscapeUtils.escapeSql(strLoID) + "'";
		}
		if( strLunchtimes != null ) {
			strLunchtimesCon = LUNCH_TIMES + " ='" + StringEscapeUtils.escapeSql(strLunchtimes) + "'";
		}

		if( strUserIDCon != null || strLoIDCon != null || strLunchtimesCon != null ) {
			sbCondition.append( " WHERE " );
			if( strUserIDCon != null ) {
				sbCondition.append( strUserIDCon );
				if( strLoIDCon != null ) {
					sbCondition.append( " AND " );
				}
			}
			if( strLoIDCon != null ) {
				sbCondition.append( strLoIDCon );
				if( strLunchtimesCon != null ) {
					sbCondition.append( " AND " );
				}
			}
			if( strLunchtimesCon != null ) {
				sbCondition.append( strLunchtimesCon );
			}
		}

		return sbCondition.toString();
	}

	/**
	 * [UIDLOIDw肵ăR[h폜܂B
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @exception SQLException
	 */
	public void delete( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );
		sbSQL.append( " WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
		sbSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'" );

		objDataAccess.execute( new String( sbSQL ) );
	}

	/**
	 * LOIDw肵ăR[h폜܂B
	 * 
	 * @param strLoID LOID
	 * @param objDataAccess
	 * @exception SQLException
	 */
	public void delete( String strLoID, DataAccess objDataAccess )
		throws SQLException {
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );
		sbSQL.append( " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'" );

		objDataAccess.execute( sbSQL.toString() );
	}

	/**
	 * ŐV̓_擾܂B<BR>
	 * ŐV̓_Ƃ͊wKJnƂŋ߂̓_łB
	 * @param strUserID
	 * @param strLoID
	 * @return String ŐV̓_
	 */
	public String getNewestExcisePoint(String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "SELECT " + EXECISE_POINT + " FROM " + TABLE_NAME + " WHERE " );
		sbSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
		sbSQL.append( STUDY_START_DATE + "=(SELECT MAX(" + STUDY_START_DATE + ") FROM " + TABLE_NAME );
		sbSQL.append( " WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "')");

		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL) );

		String strExcisePoint = null;
		if( rs.next() ) {
			strExcisePoint = rs.getString(EXECISE_POINT);
		}

		return strExcisePoint;
	}

	/**
	 * ŏ̍it擾܂B<BR>
	 * @param strUserID
	 * @param strLoID
	 * @return String ŐV̓_
	 */
	public String getFirstPassDay(String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "SELECT " + PASSDAY + " FROM " + TABLE_NAME + " WHERE " );
		sbSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
		sbSQL.append( PASSDAY + "=(SELECT MIN(" + PASSDAY + ") FROM " + TABLE_NAME + " WHERE " );
		sbSQL.append( USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "')");

		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL) );

		String strPassDay = null;
		if( rs.next() ) {
			strPassDay = XMODate.parseTime( rs.getTimestamp( PASSDAY ) );
		}

		return strPassDay;
	}

	/**
	 * ŏ̍it擾܂B<BR>
	 * @param strUserID
	 * @param strLoID
	 * @return String ŐV̓_
	 */
	public String getFirstStudyEndDate(String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();

		sbSQL.append( "SELECT " + STUDY_END_DATE + " FROM " + TABLE_NAME + " WHERE " );
		sbSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
		sbSQL.append( STUDY_END_DATE + "=(SELECT MIN(" + STUDY_END_DATE + ") FROM " + TABLE_NAME + " WHERE " );
		sbSQL.append( USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "')");

		ResultSet rs = objDataAccess.executeQuery(new String(sbSQL) );

		String strStudyEndDate = null;
		if( rs.next() ) {
			strStudyEndDate = XMODate.parseTime( rs.getTimestamp( STUDY_END_DATE ) );
		}

		return strStudyEndDate;
	}

	/**
	 * w肵[UAނ̑gݍ킹̑wKԂ߂܂B<br>
	 * ̃\bhł́AgUNVɊւ鑀͍s܂B<br>
	 *
	 * @param userID [UIDB
	 * @param loID ނLOIDB
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @return LoLogSessione[uAw肵[UAނ̑gݍ킹
	 *          Y郌R[h̊wKԍvl߂܂B
	 *          Y郌R[hȂꍇAO߂܂B
	 * @throws LOException f[^x[XANZXOƂB
	 */
	public static long getResidanceTime(
			String userID, String loID, DataAccess dataAccess)
			throws LOException {
		// ̃\bh̖߂liwKԐj
		long residanceTime = 0L;
		ResultSet rs = null;
		boolean successFlag = false;

		StringBuffer query = new StringBuffer();
		try {
			query.append( "SELECT SUM(" + RESIDANCETIME + ")" );
			query.append( " as totalResidance" );
			query.append( " FROM " + TABLE_NAME );
			query.append( " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(loID) + "'" );
			query.append( " AND " + USERID + "='" + StringEscapeUtils.escapeSql(userID) + "'" );
			// NG[s
			rs = dataAccess.executeQuery(query.toString());
			// R[h΁A擾B
			if ( rs.next() ) {
				residanceTime = rs.getLong( "totalResidance" );
			}
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(LoLogSessionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			if (rs != null) {
				try {
					rs.close();
				}
				catch (SQLException e) {
					DebugLog.write(
						LoLogSessionDataAccess.class, e, DebugLog.HIGHT);
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		return residanceTime;
	}

	/**
	 * w̃[UEނ̂̑g킹
	 * N񐔂̃R[h݂邩mF܂B<br>
	 * @param userID [UIDB
	 * @param loID ނLOIDB
	 * @param loginSession N񐔁B
	 * @return R[h݂trueA݂ȂfalseB
	 * @throws LOException f[^x[XANZXɎsꍇB
	 */
	public static boolean isExistLoginSession(
			String userID, String loID, String loginSession)
			throws LOException {
		boolean existFlag = false;
		ResultSet rs = null;
		StringBuffer query = new StringBuffer();
		boolean successFlag = false;
		DataAccess dataAccess = null;

		try {
			query.append( "SELECT " + SESSIONID );
			query.append( " FROM " + TABLE_NAME );
			query.append( " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(loID) + "'" );
			query.append( " AND " + USERID + "='" + StringEscapeUtils.escapeSql(userID) + "'" );
			query.append( " AND " + SESSIONID + "='" + StringEscapeUtils.escapeSql(loginSession) + "'" );
			// NG[s
			dataAccess = new DataAccess(TABLE_NAME);
			dataAccess.trans();
			rs = dataAccess.executeQuery(query.toString());
			// R[h΁A擾B
			existFlag = rs.next();

			dataAccess.commit();
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(LoLogSessionDataAccess.class, e, DebugLog.HIGHT);
			try {
				dataAccess.rollback();
			}
			catch (SQLException e1) {
				DebugLog.write(
					LoLogSessionDataAccess.class, e1, DebugLog.HIGHT);
			}
			throw new LOException(e.getMessage());
		}
		finally {
			if (rs != null) {
				try {
					rs.close();
				}
				catch (SQLException e) {
					DebugLog.write(
						LoLogSessionDataAccess.class, e, DebugLog.HIGHT);
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		return existFlag;
	}
}

