/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	JtFeA@ʃe[uf[^ANZXNX
//			ύX
//				2005.12.19	VK쐬	rF 
//
//
package jp.co.ntt.lms.lo.Cafeteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoDataAccess;
import jp.co.ntt.lms.lo.LoPropertyDef;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.SqlEscape;
import jp.co.ntt.lms.xmo.util.XMODate;


/**
 * Cafeteria@ʃe[uf[^ANZXNXłB<BR>
 */
public class CafeteriaLoDataAccess extends LoDataAccess 
	implements CafeteriaLoTable
{

	/**
	 * RXgN^
	 **/
	public CafeteriaLoDataAccess() {
	}

	/**
	 * Cafeteria@ʃe[u֓o^s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void insert( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			// @nbVCafeteriaLoe[uKvȃf[^̂ݎ擾܂

			Hashtable htbData = changeData( htbParam );
			insertAction( htbData, objDataAccess );

			// AnbVCafeteriaLoListe[uKvȃf[^̂ݎ擾,
			//@o^s܂B
			insertLoList( htbParam, objDataAccess );

			// BnbVPrimaryApproverListe[uKvȃf[^̂ݎ擾,
			//@o^s܂B
			insertApproverList( htbParam, objDataAccess, TABLE_NAME4);

			// CnbVApproverListe[uKvȃf[^̂ݎ擾,
			//@o^s܂B
			insertApproverList( htbParam, objDataAccess, TABLE_NAME5);

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * CafeteriaLoListʃe[u֓o^s܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void insertLoList( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// nbVCafeteriaLoListe[uKvȃf[^̂ݎ擾܂
		CafeteriaLoData objGetList = (CafeteriaLoData)htbParam.get(CAFETERIA_LIST_DATA);
		//Xgf[^ꍇXge[uɐݒ肷
		CafeteriaLoListData[] objList = objGetList.getLoList();

		for(int i=0; i<objList.length; i++){
			Hashtable htbDataList = (Hashtable)changeDataLoList( htbParam,objList[i] );

			//CafeteriaLoList@ʃe[uւ̓o^s܂
			insertActionLoList(htbDataList, objDataAccess );
		}

	}

	/**
	 * ApproverListʃe[u֓o^s܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void insertApproverList( Hashtable htbParam, DataAccess objDataAccess, String strTableName )
		throws SQLException
	{
		CafeteriaLoData objGetList = null;
		CafeteriaApproverListData[] objList = null;

		// nbVPrimaryApprover_Liste[uKvȃf[^̂ݎ擾܂
		if(strTableName.equals(TABLE_NAME4)){
			objGetList = (CafeteriaLoData)htbParam.get(PRIMARYAPPROVER_LIST_DATA);
			if(objGetList != null){
				//Xgf[^ꍇXge[uɐݒ肷
				objList = objGetList.getPrimaryApproverList();
			}
		}
		else{
			objGetList = (CafeteriaLoData)htbParam.get(APPROVER_LIST_DATA);
			if(objGetList != null){
				//Xgf[^ꍇXge[uɐݒ肷
				objList = objGetList.getApproverList();
			}
		}

		if(objList != null){
			for(int i=0; i<objList.length; i++){
				Hashtable htbDataList = (Hashtable)changeDataApproverList( htbParam,objList[i] );

				//PrimaryApproverListʃe[uւ̓o^s܂
				insertActionApproverList(htbDataList, objDataAccess, strTableName);
			}
		}
	}

	/**
	 * CafeteriaLo@ʃe[uւ̓o^s܂
	 * @param htbData p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void insertAction( Hashtable htbData, DataAccess objDataAccess )
		throws SQLException
	{

		// CafeteriaLoe[uo^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbData );
		// CafeteriaLoe[uo^s
		objDataAccess.execute( strSQL );

	}

	/**
	 * CafeteriaLoList@ʃe[uւ̓o^s܂
	 * @param htbData p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void insertActionLoList( Hashtable htbData, DataAccess objDataAccess )
		throws SQLException
	{

		// CafeteriaLoListe[uo^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbData ,TABLE_NAME2);

		// CafeteriaLoListe[uo^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * ApproverList@ʃe[uւ̓o^s܂
	 * @param htbData p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void insertActionApproverList( Hashtable htbData, DataAccess objDataAccess, String strTableName )
		throws SQLException
	{
		String strSQL = objDataAccess.getInsertSQL( htbData ,strTableName);

		// PrimaryApproverListe[uo^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * Cafeteria@ʃe[u֍XVs܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void update( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			//@CafeteriaLo@ʃe[u֍XV
			updateAction( htbParam, objDataAccess );

			//ACafeteriaLoList@ʃe[uւ̍XV
			updateActionLoList(htbParam,objDataAccess);

			//BPrimaryApproverList@ʃe[uւ̍XV
			updateActionApproverList(htbParam,objDataAccess, TABLE_NAME4);

			//CApproverList@ʃe[uւ̍XV
			updateActionApproverList(htbParam,objDataAccess, TABLE_NAME5);

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * ApproverList@ʃe[uւ̍XVs܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	public void updateActionApproverList( Hashtable htbParam, DataAccess objDataAccess, String strTableName )
		throws SQLException
	{

		//ApproverList@ʃe[uւ̍폜s܂
		deleteActionApproverList( htbParam, objDataAccess, strTableName );

		//ApproverList@e[uKvȃf[^̂ݎ擾,o^s
		insertApproverList( htbParam, objDataAccess, strTableName );

	}

	/**
	 * CafeteriaLoList@ʃe[uւ̍XVs܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	public void updateActionLoList( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		//@CafeteriaLoList@ʃe[uւ̍폜s܂
		deleteActionLoList( htbParam, objDataAccess );

		//ACafeteriaLoList@e[uKvȃf[^̂ݎ擾,o^s
		insertLoList( htbParam, objDataAccess );

	}

	/**
	 * CafeteriaLo  CafeteriaLoList@ʃe[u֍폜s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void delete( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			//@CafeteriaLo e[u폜
			deleteAction( htbParam, objDataAccess );

			//ACafeteriaLoListe[u폜
			deleteActionLoList( htbParam, objDataAccess );

			//BPrimaryApproverListe[u폜
			deleteActionApproverList( htbParam, objDataAccess, TABLE_NAME4 );

			//CApproverListe[u폜
			deleteActionApproverList( htbParam, objDataAccess, TABLE_NAME5 );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Cafeteria@ʃe[uւ̍폜s܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		// nbVKvȃf[^̂ݎ擾܂
		Hashtable htbData = changeData( htbParam );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			// LOID擾
			String strLoID = (String)htbParam.get( LOID );
			if( strLoID != null ) {
				strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'";
			}
		}
		if( strCondition == null ) {
			strCondition = "";
		}

		// 폜pSQL𐶐܂
		String strSQL = "DELETE FROM " + TABLE_NAME + strCondition;

		// 폜s
		objDataAccess.execute( strSQL );

	}
	/**
	 * CafeteriaLoList@ʃe[uւ̍폜s܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void deleteActionLoList( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			// LOID擾
			String strLoID = (String)htbParam.get( LOID );
			if( strLoID != null ) {
				strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'";
			}
		}
		if( strCondition == null ) {
			strCondition = "";
		}

		// 폜pSQL𐶐܂
		String strSQL = "DELETE FROM " + TABLE_NAME2 + strCondition;

		// 폜s
		objDataAccess.execute( strSQL );
	}
	/**
	 * ApproverList@ʃe[uւ̍폜s܂
	 * @param htbParam p[^
	 * @param objDataAccess p[^
	 * @exception SQLException DBG[
	 */
	private void deleteActionApproverList( Hashtable htbParam, DataAccess objDataAccess, String strTableName )
		throws SQLException
	{

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			// LOID擾
			String strLoID = (String)htbParam.get( LOID );
			if( strLoID != null ) {
				strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'";
			}
		}
		if( strCondition == null ) {
			strCondition = "";
		}

		// 폜pSQL𐶐܂
		String strSQL = "DELETE FROM " + strTableName + strCondition;

		// 폜s
		objDataAccess.execute( strSQL );
	}
	/**
	 * CafeteriaLo@ʃe[uf[^擾
	 * @param htbParam p[^
	 */
	public CafeteriaLoData[] getData( Hashtable htbParam )
		throws LOException
	{
		CafeteriaLoData[] objResult = null;

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			String strLoID = (String)htbParam.get( LOID );
			if( strLoID != null ) {
				strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'";
			}
			else {
				strCondition = "";
			}
		}

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME + strCondition;

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();

			while( rs.next() ) {
				CafeteriaLoData objData = new CafeteriaLoData();
				// ZbVR[hɃRs[
				objData.setLoID( ChangeEncode.setChar(rs.getString( LOID )) );
				objData.setWinHeight( ChangeEncode.setChar(rs.getString( WINHEIGHT )) );
				objData.setWinWidth( ChangeEncode.setChar(rs.getString( WINWIDTH )) );

				objData.setJougenControl( ChangeEncode.setChar(rs.getString( JOUGEN_CONTROL )) );
				objData.setApproveType( ChangeEncode.setChar(rs.getString( APPROVE_TYPE )) );
				objData.setKakinControl( ChangeEncode.setChar(rs.getString( KAKIN_CONTROL )) );
				objData.setAssignControl( ChangeEncode.setChar(rs.getString( ASSIGN_CONTROL )) );
				objData.setIndividualApplyMax( ChangeEncode.setChar(rs.getString( INDIVIDUAL_APPLY_MAX )) );
				objData.setApplyEmailAddress( ChangeEncode.setChar(rs.getString( APPLY_EMAIL_ADDRESS )) );
				// ʊi[pVectorɊi[
				vecResult.add( objData );
			}

			//CafeteriaLoListf[^擾
			CafeteriaLoListData[]  objListData = getLoListData(objDataAccess, strCondition);
			
			//CafeteriaPrimaryApproverListf[^擾
			CafeteriaApproverListData[]  objPrimaryApproverListData = getApproverListData(objDataAccess, strCondition, TABLE_NAME4);
			
			//CafeteriaApproverListf[^擾
			CafeteriaApproverListData[]  objApproverListData = getApproverListData(objDataAccess, strCondition, TABLE_NAME5);
			
			// R~bg
			objDataAccess.commit();
			// zɕϊ
			objResult = new CafeteriaLoData[vecResult.size()];
			vecResult.copyInto( objResult );

			//CafeteriaLoListf[^Zbg
			objResult[0].setLoList(objListData);

			//PrimaryApproverListf[^Zbg
			objResult[0].setPrimaryApproverList(objPrimaryApproverListData);

			//ApproverListf[^Zbg
			objResult[0].setApproverList(objApproverListData);

		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
		return objResult;
	}
	
	/**
	 * ApproverList@ʃe[uf[^擾
	 * @param objDataAccess p[^
	 * @param strCondition p[^
	 */
	public CafeteriaApproverListData[] getApproverListData( DataAccess objDataAccess ,String strCondition, String strTableName)
		throws LOException
	{
		CafeteriaApproverListData[] objResult = null;

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + strTableName + strCondition 
									+ " ORDER BY "+ LOID +","+SORT_NO;
		try {
			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();
				
			while( rs.next() ) {
				CafeteriaApproverListData objDataList = new CafeteriaApproverListData();
				// ZbVR[hɃRs[
				objDataList.setLOID( ChangeEncode.setChar(rs.getString( LOID )) );
				objDataList.setUserID(ChangeEncode.setChar(rs.getString( USER_ID )) );
				objDataList.setSortNo( ChangeEncode.setChar(rs.getString( SORT_NO )) );
				// ʊi[pVectorɊi[
				vecResult.add( objDataList );
			}
			// zɕϊ
			objResult = new CafeteriaApproverListData[vecResult.size()];
			vecResult.copyInto( objResult );

			return objResult;
		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
	}

	/**
	 * CafeteriaLoList@ʃe[uf[^擾
	 * @param objDataAccess p[^
	 * @param strCondition p[^
	 */
	public CafeteriaLoListData[] getLoListData( DataAccess objDataAccess ,String strCondition)
		throws LOException
	{
		CafeteriaLoListData[] objResult = null;

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME2 + strCondition 
									+ " ORDER BY "+ LOID +","+SORT_NO;
		try {
			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();
				
			while( rs.next() ) {
				CafeteriaLoListData objDataList = new CafeteriaLoListData();
				// ZbVR[hɃRs[
				objDataList.setLOID( ChangeEncode.setChar(rs.getString( LOID )) );
				objDataList.setCafeteriaListLOID( ChangeEncode.setChar(rs.getString( CAFETERIA_LIST_LOID )) );
				objDataList.setSortNo( ChangeEncode.setChar(rs.getString( SORT_NO )) );

				objDataList.setApplyMax( ChangeEncode.setChar(rs.getString( APPLY_MAX )) );
				objDataList.setApplyCnt( ChangeEncode.setChar(rs.getString( APPLY_CNT )) );
				objDataList.setApproveCnt( ChangeEncode.setChar(rs.getString( APPROVE_CNT )) );
				objDataList.setAccountPrice( ChangeEncode.setChar(rs.getString( ACCOUNT_PRICE )) );
				// ʊi[pVectorɊi[
				vecResult.add( objDataList );
			}
			// zɕϊ
			objResult = new CafeteriaLoListData[vecResult.size()];
			vecResult.copyInto( objResult );

			return objResult;
		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
	}

	/**
	 * CafeteriaLoe[uo^AXṼf[^gݗĂ܂
	 * @param htbParam p[^
	 * @return Hashtable
	 */
	protected Hashtable changeData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();

		putData( htbData, htbParam, LOID );					// LOID
		putData( htbData, htbParam, WINHEIGHT );			// WindowTCY(c)
		putData( htbData, htbParam, WINWIDTH );				// WindowTCY()

		putData( htbData, htbParam, JOUGEN_CONTROL );		// ApproveControl
		putData( htbData, htbParam, KAKIN_CONTROL );		// KakinControl
		putData( htbData, htbParam, APPROVE_TYPE );			// ApproveType
		putData( htbData, htbParam, ASSIGN_CONTROL );		// AssignControl
		putData( htbData, htbParam, INDIVIDUAL_APPLY_MAX );	// IndividualApplyMax
		putData( htbData, htbParam, APPLY_EMAIL_ADDRESS );	// ApplyEmailAddress

		return htbData;
	}
	/**
	 * CafeteriaApproverListe[uo^AXṼf[^gݗĂ܂
	 * @param htbParam p[^
	 * @return Hashtable
	 */
	private Hashtable changeDataApproverList( Hashtable htbParam ,CafeteriaApproverListData objList) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, LOID );			// LOID
		putApproverDataList( htbData, objList);		// CafeteriaApproverList
		return htbData;
	}

	/**
	 * CafeteriaLoListe[uo^AXṼf[^gݗĂ܂
	 * @param htbParam p[^
	 * @return Hashtable
	 */
	private Hashtable changeDataLoList( Hashtable htbParam ,CafeteriaLoListData objList) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, LOID );			// LOID
		putDataList( htbData, objList);				//JtFeAXg
		return htbData;
	}

	/**
	 * CafeteriaLoListf[^SHashtableɒǉ郁\bhł
	 * @param htbData p[^
	 */
	private void putDataList( Hashtable htbData, CafeteriaLoListData objList ) {
		
		htbData.put( CAFETERIA_LIST_LOID, (String)objList.getCafeteriaListLOID() );	//JtFeALOID
		htbData.put( SORT_NO, (String)objList.getSortNo());							//JtFeA\

		htbData.put( APPLY_MAX, (String)objList.getApplyMax());						//ApplyMax
		htbData.put( APPLY_CNT, (String)objList.getApplyCnt());						//ApplyCnt
		htbData.put( APPROVE_CNT, (String)objList.getApproveCnt());					//ApproveCnt
		htbData.put( ACCOUNT_PRICE, (String)objList.getAccountPrice());				//AccountPrice
	}

	/**
	 * CafeteriaApproverListf[^SHashtableɒǉ郁\bhł
	 * @param htbData p[^
	 */
	private void putApproverDataList( Hashtable htbData, CafeteriaApproverListData objList ) {
		
		htbData.put( USER_ID, (String)objList.getUserID());		//FUserLOID
		htbData.put( SORT_NO, (String)objList.getSortNo());		//Fҕ\
	}

	/**
	 * CafeteriaListLOAssignRequest@ʃe[u֓o^s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void insertAssignRequest( Hashtable htbParam )
		throws LOException, SQLException, Exception
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME3);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			// CafeteriaListLOAssignRequeste[uKvȃf[^̂ݎ擾܂
			Hashtable htbData = changeAssignRequestData( htbParam );
			
			String strCafeteriaListLOAssignRequestID = this.getNewCafeteriaListLOAssignRequestID(objDataAccess);
			htbData.put(ASSIGN_REQUEST_ID, SqlEscape.escape(strCafeteriaListLOAssignRequestID));
			
			insertAction( htbData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaListLOAssignRequeste[uo^AXṼf[^gݗĂ܂
	 * @param htbParam p[^
	 * @return Hashtable
	 */
	protected Hashtable changeAssignRequestData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();

		putData( htbData, htbParam, ASSIGN_REQUEST_ID );	// AssignRequestID
		putData( htbData, htbParam, USER_ID );				// UserID
		putData( htbData, htbParam, LOID );					// LOID
		putData( htbData, htbParam, CAFETERIA_LIST_LOID );	// CafeteriaListLOID
		putData( htbData, htbParam, STATUS );				// Status
		putData( htbData, htbParam, REQUEST_DATE );			// RequestDate
		putData( htbData, htbParam, PRIMARYAPPROVE_DATE );	// PrimaryApproveDate
		putData( htbData, htbParam, PRIMARYAPPROVER );		// PrimaryApprover
		putData( htbData, htbParam, APPROVE_DATE );			// ApproveDate
		putData( htbData, htbParam, APPROVER );				// Approver
		putData( htbData, htbParam, ASSIGN_DATE );			// AssignDate
		putData( htbData, htbParam, ASSIGNER );				// Assigner
		putData( htbData, htbParam, REJECT_DATE );			// RejectDate
		putData( htbData, htbParam, REJECTER );				// Rejecter
		return htbData;
	}
	
	/**
	 * VCafeteriaListLOAssignRequestIDԂB
	 * @param objDataAccess f[^ANZXIuWFNgB
	 * @return String VCafeteriaListLOAssignRequestIDB
	 * @throws SQLException
	 */
	public String getNewCafeteriaListLOAssignRequestID(DataAccess objDataAccess)
		throws SQLException, Exception
	{
		String strSQL = null;
		Environment objEnv = new Environment();
		if (objEnv.getDBType().equals(Environment.DB_SQLSERVER))
		{
			strSQL = "SELECT MAX(CONVERT(INT, AssignRequestID)) + 1 AS MaxAssignRequestID FROM CafeteriaListLOAssignRequest";
		}
		else if (objEnv.getDBType().equals(Environment.DB_ORACLE))
		{
			strSQL = "SELECT MAX(TO_NUMBER(AssignRequestID)) + 1 AS MaxAssignRequestID FROM CafeteriaListLOAssignRequest";
		}
		else if (objEnv.getDBType().equals(Environment.DB_POSTGRE))
		{
			strSQL = "SELECT MAX(TO_NUMBER(AssignRequestID, '9999999999')) + 1 AS MaxAssignRequestID FROM CafeteriaListLOAssignRequest";
		}
		ResultSet rs = objDataAccess.executeQuery(strSQL);
		if (rs.next())
			return (new Integer(rs.getInt("MaxAssignRequestID"))).toString();
		else
			return "1";
	}
	
	/**
	 * CafeteriaListLOAssignRequestʃe[u֍폜s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void deleteAssignRequest( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME3);
		try {
			// gUNVJn
			objDataAccess.trans();

			//CafeteriaListLOAssignRequestʃe[u֍폜
			deleteAssignRequestAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaListLOAssignRequestʃe[uւ̍폜s܂B
	 * @param htbParam p[^
	 * @param objDataAccess
     * 
	 * @exception SQLException DBG[
	 */
	public void deleteAssignRequestAction(Hashtable htbParam, DataAccess objDataAccess)
		throws SQLException {

		// 폜̍쐬
		String strSQL = "";
		String strAssignRequestID = (String) htbParam.get(ASSIGN_REQUEST_ID);
		strSQL = "DELETE FROM " + TABLE_NAME3 + " WHERE " + ASSIGN_REQUEST_ID + "='" + StringEscapeUtils.escapeSql(strAssignRequestID) + "'";

		// XVs
		objDataAccess.execute(strSQL);
	}
	/**
	 * CafeteriaListLOAssignRequestʃe[u֍XVs܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void updateAssignRequest( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME3);
		try {
			// gUNVJn
			objDataAccess.trans();

			//CafeteriaListLOAssignRequestʃe[u֍XV
			updateAssignRequestAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaListLOAssignRequestʃe[uւ̍XVs܂B
	 * @param htbParam p[^
	 * @param objDataAccess
     * 
	 * @exception SQLException DBG[
	 */
	public void updateAssignRequestAction(Hashtable htbParam, DataAccess objDataAccess)
		throws SQLException {

		// nbVKvȃf[^̂ݎ擾܂
		Hashtable htbData = changeAssignRequestData(htbParam);

		// XVpSQL𐶐܂
		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// XV̍쐬
		String strCondition = "";
		String strAssignRequestID = (String) htbParam.get(ASSIGN_REQUEST_ID);
		strCondition = " WHERE " + ASSIGN_REQUEST_ID + "='" + StringEscapeUtils.escapeSql(strAssignRequestID) + "'";

		// SQLA
		strSQL = strSQL + strCondition;

		// XVs
		objDataAccess.execute(strSQL);
	}
	/**
	 * CafeteriaListLOAssignRequest@ʃe[uf[^擾
	 * @param htbParam p[^
	 */
	public CafeteriaListLOAssignRequestData[] selectAssignRequestData( Hashtable htbParam )
		throws LOException
	{
		CafeteriaListLOAssignRequestData[] objResult = null;

		// ̎擾
		String strCondition = (String)htbParam.get( LoPropertyDef.CONDITION_KEY );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			String strUserID = (String)htbParam.get( LoPropertyDef.USER );
			String strLoID = (String)htbParam.get( LoPropertyDef.LOID );
			String strCafeListLOID = (String)htbParam.get( CAFETERIA_LIST_LOID );
			String strStatus = (String)htbParam.get(STATUS);
			String strAssignRequestId = (String)htbParam.get(ASSIGN_REQUEST_ID);
			if(strUserID == null && strLoID == null && strCafeListLOID == null && strStatus == null && strAssignRequestId == null){
				strCondition = "";
			}
			else{
				int initFlag = 0;
				StringBuffer strBuffer = new StringBuffer();
				strBuffer.append(" WHERE ");
				if(strUserID != null && !strUserID.equals("")){
					strBuffer.append("\"" + USER_ID + "\" ='" + StringEscapeUtils.escapeSql(strUserID) + "' ");
					initFlag = 1;
				}
				if(strLoID != null && !strLoID.equals("")){
					if(initFlag == 1){
						strBuffer.append(" AND ");
					}
					strBuffer.append(LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' ");
					initFlag = 1;
				}
				if(strCafeListLOID != null && !strCafeListLOID.equals("")){
					if(initFlag == 1){
						strBuffer.append(" AND ");
					}
					strBuffer.append(CAFETERIA_LIST_LOID + "='" + StringEscapeUtils.escapeSql(strCafeListLOID) + "' ");
					initFlag = 1;
				}
				if (strStatus != null && !strStatus.equals(""))
				{
					if(initFlag == 1){
						strBuffer.append(" AND ");
					}
					strBuffer.append("(" + STATUS + "='" + StringEscapeUtils.escapeSql(strStatus) + "') ");
					initFlag = 1;
				}
				if (strAssignRequestId != null && !strAssignRequestId.equals(""))
				{
					if(initFlag == 1){
						strBuffer.append(" AND ");
					}
					strBuffer.append("(" + ASSIGN_REQUEST_ID + "='" + StringEscapeUtils.escapeSql(strAssignRequestId) + "') ");
					initFlag = 1;
				}
				strCondition = strBuffer.toString();
			}
		}
		
		String strOrderBy = (String)htbParam.get(ORDER_BY_KEY);
		if (strOrderBy == null)
			strOrderBy = "";

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME3 + strCondition + strOrderBy;

		DebugLog.write( this.getClass(), strSQL, DebugLog.HIGHT );

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME3);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();

			Timestamp ts = null;
			while( rs.next() ) {
				CafeteriaListLOAssignRequestData objData = new CafeteriaListLOAssignRequestData();
				// ZbVR[hɃRs[
				objData.setAssignRequestID(ChangeEncode.setChar(rs.getString(ASSIGN_REQUEST_ID)));
				objData.setUserID(ChangeEncode.setChar(rs.getString(USER_ID)));
				objData.setLOID((ChangeEncode.setChar(rs.getString(LOID))));
				objData.setCafeteriaListLOID(ChangeEncode.setChar(rs.getString(CAFETERIA_LIST_LOID)));
				objData.setStatus(ChangeEncode.setChar(rs.getString(STATUS)));
				objData.setRequestDate(ChangeEncode.setChar(this.getDateString(rs, REQUEST_DATE)));
				objData.setPrimaryApproveDate(ChangeEncode.setChar(this.getDateString(rs, PRIMARYAPPROVE_DATE)));
				objData.setPrimaryApprover(ChangeEncode.setChar(rs.getString(PRIMARYAPPROVER)));
				objData.setApproveDate(ChangeEncode.setChar(this.getDateString(rs, APPROVE_DATE)));
				objData.setApprover(ChangeEncode.setChar(rs.getString(APPROVER)));
				objData.setAssignDate(ChangeEncode.setChar(this.getDateString(rs, ASSIGN_DATE)));
				objData.setAssigner(ChangeEncode.setChar(rs.getString(ASSIGNER)));
				objData.setRejectDate(ChangeEncode.setChar(this.getDateString(rs, REJECT_DATE)));
				objData.setRejecter(ChangeEncode.setChar(rs.getString(REJECTER)));
				// ʊi[pVectorɊi[
				vecResult.add( objData );
			}

			// R~bg
			objDataAccess.commit();
			// zɕϊ
			objResult = new CafeteriaListLOAssignRequestData[vecResult.size()];
			vecResult.copyInto( objResult );

		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
		return objResult;
	}
	
	
	/**
	 * ʃZbgt擾ĕԂB
	 * @param rs
	 * @param columnName
	 * @return
	 * @throws SQLException
	 */
	private String getDateString(ResultSet rs, String columnName) throws SQLException
	{
		Timestamp ts = rs.getTimestamp(columnName);
		if (ts == null)
			return null;
		
		return XMODate.parseTime(ts);
		
	}
	
	/**
	 * CafeteriaLoList@ʃe[uf[^擾
	 * @param htbParam p[^
	 */
	public CafeteriaLoListData[] selectCafeteriaLoListData( Hashtable htbParam )
		throws LOException
	{
		CafeteriaLoListData[] objResult = null;

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			String strCafeListLOID = (String)htbParam.get( CAFETERIA_LIST_LOID );
			if(strCafeListLOID != null){
				strCondition = " WHERE " + CAFETERIA_LIST_LOID + "='" + StringEscapeUtils.escapeSql(strCafeListLOID) + "' ";
			}
		}

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME2 + strCondition;

		DebugLog.write( this.getClass(), strSQL, DebugLog.HIGHT );

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME2);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();

			while( rs.next() ) {
				// ZbVR[hɃRs[
				CafeteriaLoListData objDataList = new CafeteriaLoListData();
				// ZbVR[hɃRs[
				objDataList.setLOID( ChangeEncode.setChar(rs.getString( LOID )) );
				objDataList.setCafeteriaListLOID( ChangeEncode.setChar(rs.getString( CAFETERIA_LIST_LOID )) );
				objDataList.setSortNo( ChangeEncode.setChar(rs.getString( SORT_NO )) );

				objDataList.setApplyMax( ChangeEncode.setChar(rs.getString( APPLY_MAX )) );
				objDataList.setApplyCnt( ChangeEncode.setChar(rs.getString( APPLY_CNT )) );
				objDataList.setApproveCnt( ChangeEncode.setChar(rs.getString( APPROVE_CNT )) );
				objDataList.setAccountPrice( ChangeEncode.setChar(rs.getString( ACCOUNT_PRICE )) );
				// ʊi[pVectorɊi[
				vecResult.add( objDataList );
			}

			// R~bg
			objDataAccess.commit();
			// zɕϊ
			objResult = new CafeteriaLoListData[vecResult.size()];
			vecResult.copyInto( objResult );

		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
		return objResult;
	}

///////////////////////////////////////////////////////////////////////////////////////////	
// CafeteriaLoListData PƗp\h
///////////////////////////////////////////////////////////////////////////////////////////	

	/**
	 * CafeteriaLo_LoList@ʃe[u֓o^s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void insertCafeteriaListLo( Hashtable htbParam )
		throws LOException, SQLException, Exception
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME2);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			// CafeteriaLo_LoListe[uKvȃf[^̂ݎ擾܂
			Hashtable htbData = changeCafeteriaListLoData( htbParam );
			
			insertAction( htbData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaLo_LoListe[uo^AXṼf[^gݗĂ܂
	 * @param htbParam p[^
	 * @return Hashtable
	 */
	protected Hashtable changeCafeteriaListLoData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();

		putData( htbData, htbParam, LOID );					// LOID
		putData( htbData, htbParam, CAFETERIA_LIST_LOID );	// CafeteriaListLOID
		putData( htbData, htbParam, SORT_NO );
		putData( htbData, htbParam, APPLY_MAX );
		putData( htbData, htbParam, APPLY_CNT );
		putData( htbData, htbParam, APPROVE_CNT );
		putData( htbData, htbParam, ACCOUNT_PRICE );
		return htbData;
	}
	
	/**
	 * CafeteriaLo_LoListʃe[u֍폜s܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void deleteCafeteriaListLo( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME2);
		try {
			// gUNVJn
			objDataAccess.trans();

			//CafeteriaLo_LoListʃe[u֍폜
			deleteCafeteriaListLoAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaLo_LoListʃe[uւ̍폜s܂B
	 * @param htbParam p[^
	 * @param objDataAccess
     * 
	 * @exception SQLException DBG[
	 */
	public void deleteCafeteriaListLoAction(Hashtable htbParam, DataAccess objDataAccess)
		throws SQLException {

		// 폜̍쐬
		String strSQL = "";
		String strLoID = (String) htbParam.get(LOID);
		String strCafeteriaListLoID = (String) htbParam.get(CAFETERIA_LIST_LOID);
		strSQL = "DELETE FROM " + TABLE_NAME2 + " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND "+ CAFETERIA_LIST_LOID + "='" + StringEscapeUtils.escapeSql(strCafeteriaListLoID) + "'";

		// XVs
		objDataAccess.execute(strSQL);
	}
	/**
	 * CafeteriaLo_LoListʃe[u֍XVs܂
	 * @param htbParam p[^
	 * @exception LOException LOƎO
	 */
	public synchronized void updateCafeteriaListLo( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME2);
		try {
			// gUNVJn
			objDataAccess.trans();

			//CafeteriaLo_LoListʃe[u֍XV
			updateCafeteriaListLoAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}
	/**
	 * CafeteriaLo_LoListʃe[uւ̍XVs܂B
	 * @param htbParam p[^
	 * @param objDataAccess
     * 
	 * @exception SQLException DBG[
	 */
	public void updateCafeteriaListLoAction(Hashtable htbParam, DataAccess objDataAccess)
		throws SQLException {

		// nbVKvȃf[^̂ݎ擾܂
		Hashtable htbData = changeCafeteriaListLoData(htbParam);

		// XVpSQL𐶐܂
		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// XV̍쐬
		String strCondition = "";
		String strLoID = (String) htbParam.get(LOID);
		String strCafeteriaListLoID = (String) htbParam.get(CAFETERIA_LIST_LOID);
		strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND "+ CAFETERIA_LIST_LOID + "='" + StringEscapeUtils.escapeSql(strCafeteriaListLoID) + "'";

		// SQLA
		strSQL = strSQL + strCondition;

		// XVs
		objDataAccess.execute(strSQL);
	}
	/**
	 * CafeteriaLo_LoList@ʃe[uf[^擾
	 * @param htbParam p[^
	 */
	public CafeteriaLoListData[] selectCafeteriaListLo( Hashtable htbParam )
		throws LOException
	{
		CafeteriaLoListData[] objResult = null;

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );

		// 擾ĂȂꍇ
		if( strCondition == null ) {
			String strLoID = (String) htbParam.get(LOID);
			String strCafeteriaListLoID = (String) htbParam.get(CAFETERIA_LIST_LOID);
			strCondition = " WHERE " + LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "' AND "+ CAFETERIA_LIST_LOID + "='" + StringEscapeUtils.escapeSql(strCafeteriaListLoID) + "'";
		}

		// SQL̑gݗ
		String strSQL = "SELECT * FROM " + TABLE_NAME2 + strCondition;

		DebugLog.write( this.getClass(), strSQL, DebugLog.HIGHT );

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME2);
		try {
			// gUNVJn
			objDataAccess.trans( htbParam );

			ResultSet rs = objDataAccess.executeQuery(strSQL);
			Vector vecResult = new Vector();

			while( rs.next() ) {
				CafeteriaLoListData objData = new CafeteriaLoListData();
				// ZbVR[hɃRs[
				objData.setLOID( ChangeEncode.setChar(rs.getString( LOID )) );
				objData.setCafeteriaListLOID( ChangeEncode.setChar(rs.getString( CAFETERIA_LIST_LOID )) );
				objData.setSortNo( ChangeEncode.setChar(rs.getString( SORT_NO )) );
				objData.setApplyMax( ChangeEncode.setChar(rs.getString( APPLY_MAX )) );
				objData.setApplyCnt( ChangeEncode.setChar(rs.getString( APPLY_CNT )) );
				objData.setApproveCnt( ChangeEncode.setChar(rs.getString( APPROVE_CNT )) );
				objData.setAccountPrice( ChangeEncode.setChar(rs.getString( ACCOUNT_PRICE )) );

				// ʊi[pVectorɊi[
				vecResult.add( objData );
			}

			// R~bg
			objDataAccess.commit();
			// zɕϊ
			objResult = new CafeteriaLoListData[vecResult.size()];
			vecResult.copyInto( objResult );

		}
		catch( SQLException se ) {
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( se.getMessage() );
		}
		return objResult;
	}
}

