/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StringUtilsTest.java,v 1.1 2005/02/28 13:25:47 rampil Exp $
 */
package org.logical_paradox.common.util;

import junit.framework.TestCase;

/**
 * 񑀍샆[eBeB̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class StringUtilsTest extends TestCase {

	/**
	 * Constructor for StringUtilsTest.
	 * @param arg0
	 */
	public StringUtilsTest(String arg0) {
		super(arg0);
	}
	/**
	 * <pre>
	 * 񌟍̃eXg
	 * {ꕶ̏ꍇ
	 * </pre>
	 */
	public void testSearchWordIndexes001() {
		final String text =
			"Open-SEDḰA{bg^T[`GWĴ`鑼ɁAvO~OƂlXɑ΂āAyĎhIȃI`񋟂ړI܂B" +
			"ۂɂǂ̂悤ɂėVׂ΂悢ɂẮAiKIɗᎦĂƍlĂ܂B" +
			"I[v\[X̃vWFNgł̂ŁÂ܂܎pA邢͎pړĨT[`GWĴ͎~߂܂񂪁AuyvVłƁAJƂĂ͊v܂B";

		final String word = "܂B";

		Integer[] locations = StringUtils.searchWordIndexes(text, word);
		assertEquals(3, locations.length);
	}
	/**
	 * <pre>
	 * 񌟍̃eXg
	 * p1ŁAΏە̖vꍇ
	 * </pre>
	 */
	public void testSearchWordIndexes002() {
		final String text = "Xbs121098sdfXeqcsacCX";
		final String word = "X";

		Integer[] locations = StringUtils.searchWordIndexes(text, word);
		assertEquals(3, locations.length);

		assertEquals(0, locations[0].intValue());
		assertEquals(12, locations[1].intValue());
		assertEquals(20, locations[2].intValue());
	}
}
