/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DateTimeTest.java,v 1.1 2005/02/28 13:25:47 rampil Exp $
 */
package org.logical_paradox.common.util;

import java.util.Calendar;

import junit.framework.TestCase;

/**
 * t샆[eBeB̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class DateTimeTest extends TestCase {

	/**
	 * Constructor for DateTimeTest.
	 * @param arg0
	 */
	public DateTimeTest(String arg0) {
		super(arg0);
	}
	/**
	 * ݂̓t擾ł邩ǂ̃eXg
	 */
	public void testCurrentDateTime() {
		DateTime dt = DateTime.getInstance();
		long a = System.currentTimeMillis();
		long b = dt.currentTimeInMillis();

		// ق5msȉłOKƂ
		assertTrue(a-b < 5);
	}
	/**
	 * ߋ̓tɐݒ肷eXg
	 */
	public void testPastDateTime() throws InterruptedException {
		Calendar cal = Calendar.getInstance();
		cal.set(2004,10,26);
		// 2004-10-26Ɍݓݒ
		long time = cal.getTimeInMillis();
		DateTime dt = DateTime.getInstance(time);
		long pasttime = dt.getCurrentTime().getTime();
		// 1ȏ̍قāCߋ̓tƂ
		assertTrue(System.currentTimeMillis() - pasttime > 1000*60*60*24);

		// ݂̓t𕜌
		cal.setTimeInMillis(pasttime);
		assertEquals(2004, cal.get(Calendar.YEAR));
		assertEquals(10, cal.get(Calendar.MONTH));
		assertEquals(26, cal.get(Calendar.DAY_OF_MONTH));

		System.out.println("ݓ=" + dt.getCurrentTime());

		// 2b҂
		Thread.sleep(1010);
		long pastpasttime = dt.currentTimeInMillis();

		// Ƃ̍1000ȏ゠邩ǂeXg
		assertTrue(pastpasttime - pasttime >= 1000);

		System.out.println("ݓ=" + dt.getCurrentTime());
	}
	/**
	 * ̓tݒ肷eXg
	 *
	 */
	public void testFutureDateTime() throws InterruptedException {
		Calendar cal = Calendar.getInstance();
		cal.set(2006,2,20);
		// 2006-02-20Ɍݓݒ
		long time = cal.getTimeInMillis();
		DateTime dt = DateTime.getInstance(time);
		long pasttime = dt.getCurrentTime().getTime();
		// 1ȏ̍قāCߋ̓tƂ
		assertTrue(pasttime - System.currentTimeMillis() > 1000*60*60*24);

		// ݂̓t𕜌
		cal.setTimeInMillis(pasttime);
		assertEquals(2006, cal.get(Calendar.YEAR));
		assertEquals(2, cal.get(Calendar.MONTH));
		assertEquals(20, cal.get(Calendar.DAY_OF_MONTH));

		System.out.println("ݓ=" + dt.getCurrentTime());

		// 1b҂
		Thread.sleep(1010);
		long pastpasttime = dt.currentTimeInMillis();

		// Ƃ̍1000ȏ゠邩ǂeXg
		assertTrue(pastpasttime - pasttime >= 1000);

		System.out.println("ݓ=" + dt.getCurrentTime());
	}
}
