/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SessionUnbounderTest.java,v 1.1 2005/02/28 13:26:25 rampil Exp $
 */
package org.logical_paradox.common.session;

import junit.framework.TestCase;

/**
 * ؂̃ZbV폜邽߂GC
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SessionUnbounderTest extends TestCase {

	/**
	 * Constructor for SessionUnbounderTest.
	 * @param arg0
	 */
	public SessionUnbounderTest(String arg0) {
		super(arg0);
	}
	/**
	 * L؂̑SẴZbV폜邩ǂeXg
	 *
	 */
	public void testDestroyAllSessions() throws InterruptedException, IllegalSessionStateException {
		// GCNԊu0.25sec, ZbV̗L1sec
		SessionManager man = new SessionManager(250, 1000);
		Session[] sessions = new Session[12];
		
		// KɃZbV쐬
		for(int i = 0; i < sessions.length; i++) {
			sessions[i] = man.getSession();
		}

		// 2b҂
		Thread.sleep(2000);

		// 쐬ZbVSłĂ邩ǂ肷
		for(int i = 0; i < sessions.length; i++) {
			assertTrue(null == man.getSession(sessions[i].getSessionId(), false));
			try {
				sessions[i].setAttribute("logical-paradox.org", "");
				fail();
			} catch(IllegalSessionStateException se) {
				// 
			}
		}
	}
	/**
	 * L؂łȂ̃ZbVSẴZbVO邩ǂ̃eXg
	 */
	public void testDestroySessionsWithoutSomeOfThem() throws Exception {
		// GCNԊu0.1sec, ZbV̗L1.5sec
		SessionManager man = new SessionManager(100, 1500);
		Session[] sessions = new Session[12];
		
		// KɃZbV쐬
		for(int i = 0; i < sessions.length; i++) {
			sessions[i] = man.getSession();
		}

		// 1b҂
		Thread.sleep(1000);

		// 3Ԗڂ̃ZbVɃ^b`
		sessions[2].touch();
		// 10Ԗڂ̃ZbVɃ^b`
		sessions[9].touch();

		// 0.7b҂
		Thread.sleep(700);

		// 쐬ZbVSłĂ邩ǂ肷
		for(int i = 0; i < sessions.length; i++) {
			if(i == 2 || i == 9) {
				// 3Ԗڂ10Ԗڂ݂͑͂
				assertTrue(null != man.getSession(sessions[i].getSessionId(), false));
				sessions[i].setAttribute("logical-paradox.org", "");
			} else {
				// ȊO͑SłĂ͂
				assertTrue(null == man.getSession(sessions[i].getSessionId(), false));
				try {
					sessions[i].setAttribute("logical-paradox.org", "");
					fail();
				} catch(IllegalSessionStateException se) {
					// 
				}
			}
		}
	}
}
