/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SessionTest.java,v 1.1 2005/02/28 13:26:25 rampil Exp $
 */
package org.logical_paradox.common.session;

import junit.framework.TestCase;

/**
 * ZbṼeXgR[h
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SessionTest extends TestCase {

	/**
	 * Constructor for SessionTest.
	 * @param arg0
	 */
	public SessionTest(String arg0) {
		super(arg0);
	}
	/**
	 * ZbVۂɓo^Ă郊Xi[Ă΂邩ǂ̎
	 */
	public void testSessionUnbound() throws IllegalSessionStateException {
		Session session = new Session("session-id");
		SessionBindingListenerImpl listener = new SessionBindingListenerImpl();
		session.setSessionBindingListener(listener);

		assertEquals(false, listener.isDoSomething());
		// ZbV
		session.unbound();

		assertEquals(true, listener.isDoSomething());
	}
	/**
	 * CxgȂԂŃZbV邩ǂ
	 */
	public void testSessionUnboundWithoutEvent() throws IllegalSessionStateException {
		Session session = new Session("session-id");
		SessionBindingListenerImpl listener = new SessionBindingListenerImpl();
		session.setSessionBindingListener(listener);

		assertEquals(false, listener.isDoSomething());
		// Xi[폜
		session.removeSessionBindingListener();

		// ZbV
		session.unbound();

		// o^Xi[͍폜Ă̂ŁCCxgnh͌Ă΂Ȃ
		assertEquals(false, listener.isDoSomething());
	}
	/**
	 * ZbV^CAEg̃eXg
	 */
	public void testSessionTimeout() throws InterruptedException, IllegalSessionStateException {
		Session session = new Session("sid", 1000);
		// 5ms҂
		Thread.sleep(5);
		assertEquals(true, session.isActive());
		// 1000ms҂
		Thread.sleep(1000);
		assertEquals(false, session.isActive());

		// touch
		session.setAttribute("something", "something");
		assertEquals(true, session.isActive());
	}
	class SessionBindingListenerImpl implements SessionBindingListener {
		private boolean doSomething = false;
		public void onUnBound() {
			doSomething = true;
		}
		public boolean isDoSomething() {
			return doSomething;
		}
	}
}
