/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.io;

import java.io.InputStream;
import java.io.PrintWriter;

import org.logical_paradox.common.io.ExpandableBuffer;

import junit.framework.TestCase;

/**
 * ExpandableBuffer̃eXgP[X
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class ExpandableBufferTest extends TestCase {

	/**
	 * Constructor for ExpandableBufferTest.
	 * @param arg0
	 */
	public ExpandableBufferTest(String arg0) {
		super(arg0);
	}
	/**
	 * obt@TCY̎geXg
	 * @throws Exception
	 */
	public void testAutomaticExpand() throws Exception {
		ExpandableBuffer buffer = new ExpandableBuffer(8);
		assertTrue("obt@TCYubNTCYŏĂȂ", buffer.size() == 8);
		byte[] str = "12345678901234567890".getBytes();
		buffer.write(str);
		
		// 8oCg̃ubN2g24oCĝ͂
		assertTrue("gꂽTCY", buffer.size() == 24);
		
		// ۂɂ20oCgł͂
		assertTrue("LTCY:" + buffer.using(), buffer.using() == 20);
		
		// 񂾃f[^̂܂܂ƎMł邩ǂ̃eXg
		buffer.seek(0);
		InputStream istream = buffer.getInputStream();
		int b = 0;
		int i = 0;
		while((b = istream.read()) > 0) {
			assertEquals("rɎs", str[i], (byte)b);
			i++;
		}
	}
	/**
	 * ݌ñeXg
	 * @throws Exception
	 */
	public void testOutputStream() throws Exception {
		ExpandableBuffer buffer = new ExpandableBuffer(8);
		assertTrue("obt@TCYubNTCYŏĂȂ", buffer.size() == 8);
		PrintWriter out = new PrintWriter(buffer.getOutputStream());
		out.print("****111122223333");
		out.flush();

		assertTrue("V[N|C^iłȂ", buffer.using() > 0);
		InputStream istream = buffer.getInputStream();
		buffer.seek(0);		
		byte[] str = new byte[buffer.using()];
		byte b = 0;
		int i = 0;
		while((b = (byte)istream.read()) > 0) {
			str[i++] = b;
		}
		assertEquals("񂪈Ⴄ:" +  new String(str), "****111122223333", new String(str));
	}
	/**
	 * oCgϊ̃eXg
	 *
	 */
	public void testByteStream() throws Exception {
		ExpandableBuffer buffer = new ExpandableBuffer();
		buffer.write(0xff);
		buffer.write(0xfe);
		buffer.write(0xfd);
		
		byte[] array = buffer.byteStream();
		
		assertEquals(3, array.length);
		assertEquals((byte)0xff, array[0]);
		assertEquals((byte)0xfe, array[1]);
		assertEquals((byte)0xfd, array[2]);
	}
}
