/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.util;

import java.util.ArrayList;

/**
 * ėp̕񃆁[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class StringUtils {
	// _eLXg̗vf
	public static final String RANDOM_TEXT_SEED ="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

	/**
	 * RXgN^
	 *
	 */
	private StringUtils() {
	}
	/**
	 * null܂͋󂩂ǂԂ
	 * @param msg ؑΏە
	 * @return true: / false:w肳Ă
	 */
	public static final boolean isEmpty(String msg) {
		return msg == null || msg.trim().length() == 0;
	}
	/**
	 * nullłȂCłȂǂԂ
	 * @param msg ؑΏە
	 * @return true:Ȃɂ̕ / false:null܂͋
	 */
	public static final boolean isNotEmpty(String msg) {
		return isEmpty(msg) == false;
	}
	/**
	 * 񂪐ϊ\ǂԂ
	 * @param msg ؑΏە
	 * @return true:ϊ\ / false:ϊs\
	 */
	public static final boolean isIntStr(String msg) {
		boolean rc = true;
		try {
			Integer.parseInt(msg);
		} catch(NumberFormatException ne) {
			rc = false;
		}
		return rc;
	}
	/**
	 * 񂪑{ɕϊ\ǂԂ
	 * @param msg ؑΏە
	 * @return true:ϊ\ / false:ϊs\
	 */
	public static final boolean isLongStr(String msg) {
		boolean rc = true;
		try {
			Long.parseLong(msg);
		} catch(NumberFormatException ne) {
			rc = false;
		}
		return rc;
	}
	/**
	 * 񒆂Ɋ܂܂鐧LN^Sď
	 * @param str Ώۂ̕
	 * @return ꂽ
	 */
	public static final String trimControlChars(String str) {
		StringBuffer sb = new StringBuffer();
		char[] characters = str.toCharArray();
		
		for(int i = 0; i < characters.length; i++) {
			// ISOR[hȊȌꍇ͂̂܂ܒǉ
			if(characters[i] >= '\u0020') {
				sb.append(characters[i]);
			}
		}
		return sb.toString();
	}
	/**
	 * w肳ꂽeLXgɑ݂P̏oʒuSĕԂ
	 * @param text Ώە
	 * @return 
	 */
	public static Integer[] searchWordIndexes(String text, String word) {
		ArrayList locations = new ArrayList();
		int bgn = 0;
		do {
			bgn = text.indexOf(word, bgn);
			if(bgn >= 0 && bgn < text.length()) {
				locations.add(new Integer(bgn));
				bgn++;
			}
		} while(bgn >= 0);

		return (Integer[])locations.toArray(new Integer[0]);
	}
	/**
	 * _ȕԂ
	 * @param length 
	 * @param fixed true:Œ蒷 / false:ϒ
	 * @return ꂽ
	 */
	public static final String randomText(int length, boolean fixed) {
		StringBuffer sb = new StringBuffer();

		if(fixed == false) {
			// 񒷂ϒƂĎw肳ꂽꍇ́Cۂɏo͂镶̒肷
			length = (int) (Math.random() * 8) +1;
		}

		// _ȕ𐶐
		for(int i = 0; i < length; i++) {
			sb.append(RANDOM_TEXT_SEED.charAt((int) (Math.random() * RANDOM_TEXT_SEED.length())));
		}

		return sb.toString();
	}
}
