/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;

import org.logical_paradox.common.io.ByteStream;
import org.logical_paradox.common.io.ExpandableBuffer;

/**
 * ByteStream̔zi[RNV
 * ̃RNV̂ByteStreamimplementsĂ邽߁CoCgɕϊ\
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public abstract class ArrayListByteStream extends ArrayList implements ByteStream {
	/**
	 * ftHgRXgN^
	 */
	public ArrayListByteStream() {
	}
	/**
	 * RXgN^
	 * 
	 * @param bs ɒǉIuWFNg̔z
	 */
	public ArrayListByteStream(ByteStream[] bs) {
		add(bs);
	}
	/**
	 * RXgN^
	 * @param bs ɕIuWFNg̃oCg
	 */
	public ArrayListByteStream(byte[] bs) {
		byteStreamToObject(bs);
	}
	/**
	 * RNV̓eSĈꊇăoCgɕϊ
	 * oCgΐCi[ĂByteStreambyteStream()\bhŎsD<br>
	 * ܂CϊꂽoCg̐擪ɁCvfi[(4oCg)
	 * 
	 * @return oCg
	 */
	public byte[] byteStream() {
		// g\obt@𐶐
		ExpandableBuffer buffer = new ExpandableBuffer();
		try {
			// vf̏o
			synchronized(this) {
				byte[] element = null;
				for(Iterator it = iterator(); it.hasNext();) {
					ByteStream bs = (ByteStream)it.next();
					element = bs.byteStream();
					// vf̃oCgTCYint(4oCg) BIG endianŊi[
					buffer.write(element.length & 0xff000000);
					buffer.write(element.length & 0x00ff0000);
					buffer.write(element.length & 0x0000ff00);
					buffer.write(element.length & 0x000000ff);
					buffer.write(element);					// vf̃oCg
				}
			}
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}

		return buffer.byteStream();
	}
	/**
	 * oCg񂩂IuWFNg̔z𕜌
	 * ̃NXbyteStream()ɂĐꂽoCgȊO͕łȂ
	 * @param bstream oCg
	 */
	protected void byteStreamToObject(byte[] bstream) {
		ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
		buffer.put(bstream);
		buffer.rewind();

		// IuWFNg̕
		while(buffer.hasRemaining()) {
			int objectByteSize = buffer.getInt();
			byte[] objectBody = new byte[objectByteSize];
			buffer.get(objectBody);
			
			add(buildByteStreamObject(objectBody));
		}
	}
	/**
	 * oCg񂩂IuWFNg𕜌
	 * ̓Iɕ邩́CTuNXŎ
	 * @param bstream oCg
	 * @return ꂽIuWFNg
	 */
	protected abstract ByteStream buildByteStreamObject(byte[] bstream);
}
