/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * java.io.RandomAccessFiledelegator<br>
 * ̃NXł̓}gjava.io.RandomAccessFileɏn
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class CommonRandomAccessFileDelegator implements RandomAccessFileDelegator {
	private final RandomAccessFile _file;

	public CommonRandomAccessFileDelegator(String filename, String mode) throws FileNotFoundException {
		_file = new RandomAccessFile(filename, mode);
	}
	public CommonRandomAccessFileDelegator(File file, String mode) throws FileNotFoundException {
		_file = new RandomAccessFile(file, mode);
	}
	public void close() throws IOException {
		_file.close();
	}
	public long length() throws IOException {
		return _file.length();
	}
	public void seek(long pos) throws IOException {
		_file.seek(pos);
	}
	public int read(byte[] b) throws IOException {
		return _file.read(b);
	}
	public void readFully(byte[] b) throws IOException {
		_file.readFully(b);
	}
	public int readInt() throws IOException {
		return _file.readInt();
	}
	public long readLong() throws IOException {
		return _file.readLong();
	}
	public void write(byte[] b) throws IOException {
		_file.write(b);
	}
	public void write(int b) throws IOException {
		_file.write(b);
	}
}
