/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.fsm;

import java.util.ArrayList;

/**
 * LԑJڋ@B
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class FiniteStateMachine {
	private final String name;

	/** IԂ̃Xg */
	private ArrayList finiteStates = new ArrayList();
	/** ԂωۂɌĂяo郊Xi[ */
	private ChangeStateListener changeStateListener = null;
	/**  */
	private State state;

	/**
	 * ftHgRXgN^͎gp֎~
	 */
	private FiniteStateMachine() {
		name = "no-name";
	}

	/**
	 * ԑJڋ@B쐬RXgN^
	 * @param name ԑJڋ@B̖
	 */
	public FiniteStateMachine(String name) throws Exception {
		this.name = name;
		init();
	}
	/**
	 * 
	 */
	public void init() throws Exception {
	}
	/**
	 * I
	 * @throws Exception
	 */
	public void finish() throws Exception {
	}
	/**
	 * ԑJڋ@Bɑ΂āCIԂǉ
	 * ԑJڋ@B́CԂIԂɂȂۂɒ~
	 * @param state 
	 */
	public void addFiniteState(State state) {
		finiteStates.add(state);
	}
	/**
	 * Xebvs
	 * @param symbol ͋L
	 * @return true:p / false:I
	 */
	public boolean stepExec(Symbol symbol) {
		// Cxgnho^Ă΁C͑OɃCxg̔
		if(changeStateListener != null) {
			StateEvent e = new StateEvent(this, state);
			changeStateListener.onPreChanged(e);
		}
		input(symbol);
		// Cxgnho^Ă΁C͌ɃCxg̔
		if(changeStateListener != null) {
			StateEvent e = new StateEvent(this, state);
			changeStateListener.onPostChanged(e);
		}

		return isFiniteState() == false;
	}

	/**
	 * IԂɂȂ܂ŌpĎs
	 * @param ͋L
	 */
	public void execute(Symbol[] symbols) throws Exception {
		int cnt = 0;
		while(cnt < symbols.length && stepExec(symbols[cnt++]) == true);
		finish();
	}
	/**
	 * ԂωۂɌĂяoCxgXi[o^
	 * @param listener ԑJڎ̃CxgXi[
	 */
	public void setStateChangedListener(ChangeStateListener listener) {
		// ̂̂폜Ăݒ肷
		removeStateChangedLister();
		changeStateListener = listener;
	}
	/**
	 * ԕω̃CxgXi[
	 */
	public void removeStateChangedLister() {
		changeStateListener = null;
	}


	//--------------------- ȍ~̓TuNXŎ邱 -------------------
	/**
	 * ͋LԂɑ΂ė^
	 * ͂ꂽLɂāCԂJڂƂ^C~OŃCxg
	 * @param symbol ͋L
	 */
	protected abstract void input(Symbol symbol);
	/**
	 * ݂̏ԂIԂɂ邩ǂԂ
	 * @return true:I / false:p
	 */
	protected abstract boolean isFiniteState();
	/**
	 * ʂԂ
	 * @return 
	 */
	public abstract Object getResult();
}
