/*
 * Copyright (C) 2006-2007 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 */

#ifndef __RS485DEVS_H__
#define __RS485DEVS_H__

enum {PK_HEAD0, PK_HEAD1, PK_IDNUM, PK_FLG, PK_ADR, PK_LEN, PK_CNT, PK_DATA0
	, PK_HEADER_LEN = PK_DATA0
	, PK_SUM_LEN = 1
	, PK_DATA_MAX = 255 - PK_SUM_LEN
};

enum {PKFLG_WriteNoRtn=0, PKFLG_WriteWithRtn=1, PKFLG_Read=3
                       , PKFLG_FactRst=0x10};

enum e_srvMemMap {
    SMM_ModelNum_L,
    SMM_ModelNum_H,
    SMM_FirmVer,
    SMM_Resv03,

    SMM_Rs485ID,
    SMM_Resv05,
    SMM_Baudrate,
    SMM_Resv07,
    SMM_CW__Limit_L,
    SMM_CW__Limit_H,
    SMM_CCW_Limit_L,	
    SMM_CCW_Limit_H,
    SMM_LoadLimit_L,
    SMM_LoadLimit_H,
    SMM_TempLimit_L,
    SMM_TempLimit_H,
    SMM_Resv16,
    SMM_Resv17,
    SMM_Resv18,
    SMM_Resv19,
    SMM_Resv20,
    SMM_Resv21,
    SMM_Resv22,
    SMM_Resv23,
    SMM_MarginCW,
    SMM_MarginCCW,
    SMM_SlopeCW,
    SMM_SlopeCCW,
    SMM_Punch_L,
    SMM_Punch_H,

    SMM_GPos_L,
    SMM_GPos_H,
    SMM_Gtim_L,
    SMM_Gtim_H,
    SMM_AccelTime,
    SMM_MaxTorque,
    SMM_EnblTorque,
    SMM_LED,
    SMM_PIDCoef,
    SMM_Resv39,
    SMM_Resv40,
    SMM_Resv41,
    SMM_PrsntPos_L,
    SMM_PrsntPos_H,
    SMM_PrsntTim_L,
    SMM_PrsntTim_H,
    SMM_Resv46,
    SMM_Resv47,
    SMM_PrsntLoad_L,
    SMM_PrsntLoad_H,
    SMM_PrsntTemp_L,
    SMM_PrsntTemp_H,
    SMM_Resv52,
    SMM_Resv53,
    SMM_Status,
    SMM_ActF,
    SMM_Moving,
    SMM_Lock,
    SMM_Resv58,
    SMM_Resv59
};

enum e_LedMemMap {
    LMM_ModelNum_L,
    LMM_ModelNum_H,
    LMM_FirmVer,
    LMM_Resv03,
    LMM_Rs485ID,
    LMM_Baudrate,
    LMM_PwmServoCalib_L,
    LMM_PwmServoCalib_H,
    LMM_IntensityRed,
    LMM_IntensityGreen,

    LMM_Resv10,
    LMM_Resv11,
    LMM_Position,
    LMM_MoveTime,
    LMM_SwState,
    LMM_Sw1Cnt,
    LMM_Sw2Cnt,
    LMM_Sw3Cnt, 
    LMM_BankToLed,
    LMM_ServoPower,

    LMM_LedToBank,
    LMM_Resv21,
    LMM_LedMatrixData,

    LMM_Resv37 = 37,
    LMM_LedIntensity,
    LMM_Lock
};

enum e_AccelMemMap {
    AMM_ModelNum_L,
    AMM_ModelNum_H,
    AMM_FirmVer,
    AMM_Resv03,
    AMM_Rs485ID,
    AMM_Baudrate,
    AMM_Resv06,
    AMM_Resv07,

    AMM_AccelX_L,
    AMM_AccelX_H,
    AMM_AccelY_L,
    AMM_AccelY_H,
    AMM_AccelZ_L,
    AMM_AccelZ_H,

    AMM_Resv20 = 20,
    AMM_LOCK
};

enum e_rs485ID {
    rs485ID_LED_BREST = 0x50, rs485ID_LED_LEFT, rs485ID_LED_RIGHT,
    rs485ID_Accel = 0x60,

    rs485ID_BDY1 = 1, rs485ID_NEK1,

    rs485ID_LLG1 = 11, rs485ID_LLG2, rs485ID_LLG3,
    rs485ID_LLG4, rs485ID_LLG5, rs485ID_LLG6,

    rs485ID_RLG1 = 21, rs485ID_RLG2, rs485ID_RLG3,
    rs485ID_RLG4, rs485ID_RLG5, rs485ID_RLG6,

    rs485ID_LAM1 = 31, rs485ID_LAM2, rs485ID_LAM3,
    rs485ID_LAM4 = rs485ID_LED_LEFT,

    rs485ID_RAM1 = 41, rs485ID_RAM2, rs485ID_RAM3,
    rs485ID_RAM4 = rs485ID_LED_RIGHT,

    MaxRs485Servo = rs485ID_RAM3,
    MaxRs485ID = rs485ID_Accel
};

/**
 * Device group name
 */
enum e_DevGrp {
    DG_BodySrv, DG_LLegSrv, DG_RLegSrv, DG_LArmSrv, DG_RArmSrv,
    DG_LedBtn,
    DG_Accel,
    NUM_e_DevGrp
};

/* defines */
#define COM_BUF_SIZE(dataSize)	(dataSize + PK_DATA0 + PK_SUM_LEN)

#endif	// __RS485DEVS_H__
