/*
 * Copyright (C) 2004-2007 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 */

#ifndef __LIBSERVO_H__
#define __LIBSERVO_H__

#include <sys/types.h>
#include <stdbool.h>

size_t editSrvRst(u_char id, size_t bufLen, /*@out@*/u_char buf[/*@i@*/bufLen]);
size_t editSrvAng(bool isLong, u_char id, uint16_t angle, uint16_t time
    , size_t bufLen, /*@out@*/u_char buf[bufLen]);
size_t editSrvPwr(bool isLong, u_char id, u_char sw, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvCmgn(bool isLong, u_char id, u_char mgn, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvCslp(bool isLong, u_char id, u_char mgn, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvPunch(bool isLong, u_char id, uint16_t pnc, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvParams(bool isLong, u_char id, u_char mgn, u_char slp, u_short pnc
    , size_t bufLen, /*@out@*/u_char buf[bufLen]);
size_t editSrvTrq(bool isLong, u_char id, u_char trq, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);

size_t editPwmSrvAng(u_char id, uint16_t angle, uint16_t time,
    size_t bufLen, /*@out@*/u_char buf[bufLen]);

#endif	//__LIBSERVO_H__
