/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresMeasureDAO.java
 *  FW[IuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import openolap.viewer.AxisLevel;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.common.Messages;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;

/**
 *  NXFPostgresMeasureDAO
 *  FW[IuWFNg̉iǗNXł
 */
public class PostgresMeasureDAO implements MeasureDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	// ********** RXgN^ **********

	/**
	 *  W[IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresMeasureDAO() {}	

	/**
	 *  W[IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresMeasureDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * W[IuWFNg߂B<br>
	 *   W[IuWFNg̏ԁF<br>
	 *     W[o[IuWFNgFȂ
	 * @return W[IuWFNg
	 */
	public Measure findMeasureWithoutMember() {
	
		final boolean measureFLG = true;
		boolean isUsedSelecterFLG = false;

		Measure measure = new Measure(Constants.MeasureID, 
										Messages.getString("PostgresMeasureDAO.MeasureName"),  //$NON-NLS-1$
										Messages.getString("PostgresMeasureDAO.MeasureComment"),  //$NON-NLS-1$
										new ArrayList(),		// axisLevelList
										null, 					// defaultMemberKey
										measureFLG, 			// isMeasure
										isUsedSelecterFLG);		// isUsedSelecter

		return measure;
	}

	/**
	 * W[IuWFNg߂B<br>
	 *   W[IuWFNg̏ԁF<br>
	 *     W[o[IuWFNgF
	 * @param cubeSeq L[uV[PXԍ
	 * @param commonSettings AvP[V̋ʐݒ
	 * @return W[IuWFNg
	 * @exception SQLException ɗO
	 */
	public Measure findMeasureWithMember(String cubeSeq, CommonSettings commonSettings) throws SQLException {

		// Measure IuWFNg擾
		Measure measure = this.findMeasureWithoutMember();

		// Measure IuWFNg AxisLevel IuWFNgǉ
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		AxisLevelDAO axisLevelDAO = daoFactory.getAxisLevelDAO(this.conn);
		Iterator it = axisLevelDAO.selectAxisLevels(cubeSeq,measure).iterator();
		while (it.hasNext()) {
			AxisLevel axisLevel = (AxisLevel) it.next();
			measure.addAxisLevelList(axisLevel);
		}

		// Measure IuWFNg MeasureMember IuWFNgǉ

		MeasureMemberDAO measureMemberDAO = daoFactory.getMeasureMemberDAO(this.conn);
		ArrayList measureMemberList = measureMemberDAO.selectMeasureMembers(cubeSeq, commonSettings);
		Iterator it2 = measureMemberList.iterator();

		while (it2.hasNext()) {
			MeasureMember measureMem = (MeasureMember) it2.next();
			measure.addAxisMember(measureMem);
		}

		return measure;
	}

}
