/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFReport.java
 *  F|[g킷NXłB
 *
 *  쐬: 2003/12/29
 */

package openolap.viewer;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import openolap.viewer.common.Constants;
import openolap.viewer.common.Messages;
import openolap.viewer.controller.RequestHelper;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFReport
 *  F|[g킷NXłB
 */
public class Report implements Serializable {

	// ********** CX^Xϐ **********

	/** |[g */
	private String reportName = null;

	/** |[gID */
	final private String reportID;

	/** eID(|[gi[tH_ID) */
	private String parentID;

	/** L[u */
	final private Cube cube;

	/** GbW킷IuWFNgXg */
	final private ArrayList edgeList;

	/** F킷IuWFNg̃Xg */
	final private ArrayList colorList;

	/** Ԏ */
	final private boolean hasTimeDim;

	/** VK쐬Ŗۑ̃|[g(true)A|[g(false) */
	private boolean isNewReport = false;

	// ********** RXgN^ **********

	/**
	 * |[gIuWFNg𐶐܂B
	 */
	public Report(String reportID, String reportName, Cube cube, ArrayList edgeList, ArrayList colorList, boolean hasTimeDim){
		this.reportID = reportID;
		this.reportName = reportName;
		this.parentID = null;
		this.cube = cube;
		this.edgeList = edgeList;
		this.colorList = colorList;
		this.hasTimeDim = hasTimeDim;
	}


	// ********** ÓI\bh **********

	/**
	 * ԎꍇtrueAȂꍇfalse߂B
	 * @param edgeList Xg
	 */
	public static boolean investigateTimeDimension(ArrayList edgeList) {
		Edge col = (Edge)Edge.getTheEdge("COL",edgeList);
		Edge row = (Edge)Edge.getTheEdge("ROW",edgeList);
		Edge page = (Edge)Edge.getTheEdge("PAGE",edgeList);

		return (col.investigateTimeDimension() || row.investigateTimeDimension() || page.investigateTimeDimension());
	}

	/**
	 * ^ꂽfBVXgAW[XgzuGbW킷IuWFNg̃Xg߂B
	 * @param dimList fBV킷IuWFNg̃Xg
	 * @param measure W[킷IuWFNg
	 * @return GbW킷IuWFNg̃Xg
	 */
	public static ArrayList initializeEdge(ArrayList dimList, Measure measure) {
		if ( (dimList == null) || (measure == null) ) { throw new IllegalArgumentException(); }
		if (dimList.size() < 1) { throw new IllegalArgumentException(); }

		Col col = null;
		Row row = null;
		Page page = null;
		ArrayList pageAxisList = new ArrayList();

		dimList.add(measure);

		col = new Col((Axis)dimList.get(0));
		row = new Row((Axis)dimList.get(1));

		if ( dimList.size()-2 > 0 ) { // fBVӂȏ㎝iy[WGbWjꍇ
			for(int i=0; i<(dimList.size()-2); i++){
				pageAxisList.add(dimList.get(i+2));
				page = new Page(pageAxisList);
			}
		} else {	// y[WGbWɎ݂ȂꍇAArrayList
			page = new Page(new ArrayList());
		}

		ArrayList edgeList = new ArrayList();
		edgeList.add(col);
		edgeList.add(row);
		edgeList.add(page);

		return edgeList;
	}

	public static String getInitialReportName() {
		return Messages.getString("Report.tempInitialReportName"); //$NON-NLS-1$
	}

	// ********** \bh **********

	/**
	 * ReportIuWFNg̍sAGbWɔzuꂽfBVɁAo[IuWFNgZbg
	 * @param helper RequestHelper킷IuWFNg̃Xg
	 * @param report |[g킷IuWFNg
	 * @param conn RlNV킷IuWFNg
	 */
	public void setSelectedCOLROWDimensionMembers(RequestHelper helper, Report report, Connection conn) throws SQLException {

		DimensionMemberDAO dimMemberDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);

		Iterator it = report.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();

			if (edge.getPosition().equals(Constants.Page)) {
				continue;
			}

			int i = 0;
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				Dimension dim = null;
				if(axis instanceof Dimension) {
					dim = (Dimension) axis;
				} else {
					i++;
					continue;
				}

				String selectedMemberList = "";
				if (edge.getPosition().equals(Constants.Col)) {
					selectedMemberList = "'," + helper.getRequest().getSession().getAttribute("viewCol" + i + "KeyList_hidden") + ",'";
				} else if (edge.getPosition().equals(Constants.Row)) {
					selectedMemberList = "'," + helper.getRequest().getSession().getAttribute("viewRow" + i + "KeyList_hidden") + ",'";
				}

				ArrayList dimMemberList = dimMemberDAO.selectDimensionMembers(dim, null, null, null, selectedMemberList);
				dim.clearAxisMember();
				dim.addAllAxisMember(dimMemberList);

				i++;
			}
		}
	}


	/**
	 * |[g̃fBVIuWFNgo[폜
	 */
	public void clearDimensionMembers() {

		Iterator it = edgeList.iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				if(!axis.isMeasure()){
					axis.clearAxisMember();
				}
			}
		}
	}


	/**
	 * |[g̎fBV߂B
	 * @return fBV
	 */
	public int getTotalDimensionNumber(){

		Iterator it = edgeList.iterator();
		int dimCounter = 0;
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				if(!axis.isMeasure()){
					dimCounter++;
				}
			}
		}

		return dimCounter;
	}

	/**
	 * |[g̎W[o[߂B
	 * @return W[o[
	 */
	public int getTotalMeasureMemberNumber(){
		ArrayList measureMemberList = this.getMeasure().getAxisMemberList();
		return measureMemberList.size();
	}

	/**
	 * ^ꂽ̂̃GbWIuWFNg߂B
	 * @param edgeType GbW킷́iCOL,ROW,PAGEj
	 * @return GbWIuWFNg
	 */
	public Edge getEdgeByType(String edgeType) {
		Iterator it = edgeList.iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getPosition().equals(edgeType)){
				return edge;
			}
		}
		return null;
	}

	/**
	 * W[IuWFNg߂B
	 * @return W[IuWFNg
	 */
	public Measure getMeasure() {
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if(edge.getMeasure() != null) {
				return edge.getMeasure();
			}
		}
		throw new IllegalStateException();
	}

	/**
	 * ^ꂽID̎IuWFNg߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @return IuWFNg
	 */
	public Axis getAxisByID(String sourceID) {
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator axisIt = edge.getAxisList().iterator();

			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				if(axis.getId().equals(sourceID)) {
					return axis;
				}
			}
		}
		return null;
	}

	/**
	 * AxisId ̏ŎIuWFNg擾B
	 * @return IuWFNg̃Xg
	 */
	public ArrayList getAxilOrderByID() {
		ArrayList axisList = new ArrayList();

		TreeMap axisIdObjMap = new TreeMap();
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator axisIt = edge.getAxisList().iterator();

			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();
				axisIdObjMap.put(Integer.decode(axis.getId()), axis);
			}
		}

		Iterator axisIt = axisIdObjMap.keySet().iterator();
		while (axisIt.hasNext()) {
			Integer axisID = (Integer) axisIt.next();
			Axis axis = (Axis) axisIdObjMap.get(axisID) ;
			axisList.add(axis);
		}

		return axisList;
	}

	/**
	 * ^ꂽzuĂGbŴ̖߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @param oAxis 킷IuWFNg
	 * @return GbW̖
	 */
	public String getThisAxisPosition(Axis oAxis) {
		if (oAxis == null){ return null; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.hasThisAxis(oAxis)){
				return edge.getPosition();
			}
		}
		return null;
	}

	/**
	 * ^ꂽzuĂGbŴ̖߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @param id ID
	 * @return GbW̖
	 */
	public String getThisAxisPosition(String id) {
		if (id == null){ return null; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.hasThisAxis(id)){
				return edge.getPosition();
			}
		}
		return null;
	}

	/**
	 * ^ꂽGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return GbWɔzuĂ邩
	 */
	public boolean isInCol(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Col)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return GbWɔzuĂ邩
	 */
	public boolean isInCol(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Col)) {
			return true;
		} else {
			return false;
		}
	}


	/**
	 * ^ꂽsGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return sGbWɔzuĂ邩
	 */
	public boolean isInRow(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Row)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽsGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return sGbWɔzuĂ邩
	 */
	public boolean isInRow(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Row)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽy[WGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return y[WGbWɔzuĂ邩
	 */
	public boolean isInPage(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Page)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽy[WGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return y[WGbWɔzuĂ邩
	 */
	public boolean isInPage(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Page)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽzuĂGbWł̒iCfbNX߂B
	 * CfbNX́u0vstart̒lłB
	 * ƂnullnĂꍇ́u-1v߂B
	 * ^ꂽ݂Ȃꍇ́u0v߂B
	 * @param oAxis IuWFNg
	 * @return GbWł̒iCfbNX
	 */
	public int getHieIndex(Axis oAxis) {
		if (oAxis == null){ return -1; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getAxisIndexInEdge(oAxis) != -1) {
				return edge.getAxisIndexInEdge(oAxis);
			}
		}
		return 0;
	}

	/**
	 * ^ꂽzuĂGbWł̒iCfbNX߂B
	 * CfbNX́u0vstart̒lłB
	 * ƂnullnĂꍇ́u-1v߂B
	 * ^ꂽ݂Ȃꍇ́u-1v߂B
	 * @param axisID ID
	 * @return GbWł̒iCfbNX
	 */
	public int getHieIndex(String axisID) {
		if (axisID == null){ return -1; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getAxisIndexInEdge(axisID) != -1) {
				return edge.getAxisIndexInEdge(axisID);
			}
		}
		return -1;
	}

	/**
	 * w肳ꂽGbWɔzuꂽo[̑gݍ킹߂B
	 * @param edgeName 
	 * @return o[̑gݍ킹
	 */
	public int getAxisMeberComboNum(String edgeName) {
		if ( (!Constants.Col.equals(edgeName)) && (!Constants.Row.equals(edgeName)) && (!Constants.Page.equals(edgeName)) ) {
			throw new IllegalStateException();
		}

		int totalNumber = 1;
		ArrayList edgeAxesList = this.getEdgeByType(Constants.Col).getAxisList();
		Iterator iter = edgeAxesList.iterator();
		while (iter.hasNext()) {
			Axis axis = (Axis) iter.next();
			totalNumber = totalNumber * (axis.getAxisMemberList().size());
		} 

		return totalNumber;
	}

	/**
	 * F\IuWFNg|[gɒǉB
	 * @param color F킷IuWFNg
	 */
	public void addColor(Color color) {
		if(color == null) { throw new IllegalArgumentException(); }
		this.colorList.add(color);
	}

	/**
	 * F\IuWFNg̃Xg|[gɒǉB
	 * @param color F킷IuWFNg
	 */
	public void addColor(ArrayList colorList) {
		if(colorList == null) { throw new IllegalArgumentException(); }

		Iterator it = colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			this.colorList.add(color);
		}
	}

	/**
	 * F\IuWFNg̃XgNAB
	 */
	public void clearColorList() {
		this.colorList.clear();
		
	}

	/**
	 * wb_[̐F\IuWFNg̃Xg߂B
	 * @return color F킷IuWFNg
	 */
	public ArrayList getHeaderColorList() {
		ArrayList headerColorList = new ArrayList();
		Iterator it = this.colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			if(color.isHeader()){
				headerColorList.add(color);
			}
		}
		return headerColorList;
	}

	/**
	 * f[^e[u̐F\IuWFNg̃Xg߂B
	 * @return color F킷IuWFNg
	 */
	public ArrayList getSpreadColorList() {
		ArrayList spreadColorList = new ArrayList();
		Iterator it = this.colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			if(!color.isHeader()){
				spreadColorList.add(color);
			}
		}
		return spreadColorList;
	}

	/**
	 * |[gۑB
	 * @param conn RlNV킷IuWFNg
	 * @exception SQLException DBւ̃|[gۑŗO
	 */
	public void saveReport(Connection conn) throws SQLException {
		DAOFactory daoFactory = DAOFactory.getDAOFactory();

		ReportDAO reportDAO = daoFactory.getReportDAO(conn);
		reportDAO.saveReport(this, conn);
	}


	// ********** Setter \bh **********

	/**
	 * |[gZbgB
	 * @param string |[g
	 */
	public void setReportName(String string) {
		reportName = string;
	}

	/**
	 * |[gIDZbgB
	 * @param string |[gID
	 */
	public void setParentID(String string) {
		parentID = string;
	}

	/**
	 * VK|[gtOZbgB
	 * @param string |[gID
	 */
	public void setNewReport(boolean b) {
		isNewReport = b;
	}

	// ********** Getter \bh **********

	/**
	 * |[g߂B
	 * @return |[g
	 */
	public String getReportName() {
		return reportName;
	}

	/**
	 * |[gID߂B
	 * @return |[gID
	 */
	public String getReportID() {
		return reportID;
	}

	/**
	 * |[g̐eIDi|[gi[tH_IDj߂B
	 * @return |[gID
	 */
	public String getParentID() {
		return parentID;
	}

	/**
	 * L[u߂B
	 * @return |[gID
	 */
	public Cube getCube() {
		return cube;
	}

	/**
	 * IuWFNg̃Xg߂B
	 * @return IuWFNg̃Xg
	 */
	public ArrayList getEdgeList() {
		return edgeList;
	}

	/**
	 * FIuWFNg̃Xg߂B
	 * @return FIuWFNg̃Xg
	 */
	public ArrayList getColorList() {
		return colorList;
	}

	/**
	 * ԎĂtrueAȂfalse߂B
	 * @return IuWFNg̃Xg
	 */
	public boolean hasTimeDim() {
		return hasTimeDim;
	}

	/**
	 * VK쐬Ŗۑ̃|[głtrueA|[głfalse߂B
	 * @return VK|[g
	 */
	public boolean isNewReport() {
		return isNewReport;
	}

}
