/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresMeasureMemberTypeDAO.java
 *  FW[o[^Cv̉iǗNXłB
 *
 *  쐬: 2004/01/12
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import openolap.viewer.MeasureMemberType;

/**
 *  NXFPostgresMeasureMemberTypeDAO
 *  FW[o[^Cv̉iǗNXłB
 */
public class PostgresMeasureMemberTypeDAO implements MeasureMemberTypeDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	// ********** RXgN^ **********

	/**
	 *  W[o[^Cv̉iǗIuWFNg𐶐܂B
	 */
	PostgresMeasureMemberTypeDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * f[^\[Xɓo^Ă郁W[o[^CṽXg߂<br>
	 * @return W[o[^CvIuWFNg̃Xg
	 * @exception SQLException ɗO
	 */
	public ArrayList getMeasureMemberTypeList() throws SQLException {
		
		ArrayList measureMemberTypeList = new ArrayList();
		
		String SQL = "";
		SQL += "select ";
		SQL += "    measure_member_type_id, ";
		SQL += "    name, ";
		SQL += "    comment, ";
		SQL += "    group_name, ";
		SQL += "    image_url, ";
		SQL += "    excel_format, ";
		SQL += "    function_name, ";
		SQL += "    unit_function_id ";
		SQL += "from ";
		SQL += "    oo_v_measure_member_type ";
		SQL += "order by measure_member_type_id ";

		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {
				MeasureMemberType measureMemberType = new MeasureMemberType(rs.getString("measure_member_type_id"),
																			 rs.getString("name"),
																			 rs.getString("comment"),
																			 rs.getString("group_name"),
																			 rs.getString("image_url"),
																			 rs.getString("excel_format"),
																			 rs.getString("function_name"),
																			 rs.getString("unit_function_id"));

				measureMemberTypeList.add(measureMemberType);
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return measureMemberTypeList;
	}




}
