/*
 * OpenI2CRADIO
 * Get status from chips.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"


void update_status(void)
{

    unsigned int adc;
    unsigned int ref;

    setup.fm = akc6955_get_fm();
    recv_signal = akc6955_read_level();
    diffstat = akc6955_get_diff();
    setup.volume = akc6955_getvolume();
    setup.prevolume = akc6955_get_prevolume();
        if(setup.fm != 0){
            setup.fmfreq = akc6955_get_freq();
            setup.fmband = akc6955_get_fmband();
            setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
            stereoflag = akc6955_get_stereo();
            akc6955_get_fmbandwidth(setup.fmbandwidth);
        } else {
            setup.amfreq = akc6955_get_freq();
            setup.amband = akc6955_get_amband();
            setup.amfreq_bank[setup.amband] = setup.amfreq;
	    setup.am_mode3k = akc6955_get_mode3k();
//            c.byte = akc6955_readcmd(AKC6955_CNR_AM);
//            if(c.b7) {
//                setup.am_mode3k = 0xff;
//            } else {
//                setup.am_mode3k = 0;
//            }
            stereoflag = 0x00;
        }
        tuneflag = akc6955_tune();
        cnrlevel = akc6955_get_cnr();
    // Battery
//    batlevel_6955 = akc6955_get_battery();
    //ADC:Battery
    startadc(_BATT_ADC);
    adc = polladc2();
    startadc(_BATT_ADC);
    adc = polladc2();
    //ADC:reference
    CVRCON2bits.FVREN = 1;
    while(CVRCON2bits.FVRST == 0) idle_time_ms(1);
    startadc(_REF_ADC);
    ref = polladc2();
    CVRCON2bits.FVREN = 0;
    //ADC:reference
    battlevel = adc_rawtobatt(adc, ref);
}
