/*
 * OpenI2CRADIO
 * I/O Port Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef IOPORTS_H
#define	IOPORTS_H

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#endif
#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "ui.h"

#ifdef	__cplusplus
extern "C" {
#endif

extern void set_amfmlamp(unsigned char f);
extern void set_powerlamp(unsigned char f);
extern void keyin_ioinit(void);

extern void set_radiopower(unsigned char f);
extern void set_examp_mute(unsigned char f);


extern void readkey_io(unsigned char state);
extern unsigned char statecount;
#ifdef	__cplusplus
}
#endif

#endif	/* IOPORTS_H */

