/*
 * OpenI2CRADIO
 * Internal ADCONVERTER Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef ADC_INT_H
#define	ADC_INT_H

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#endif
#include <adc.h>

#include "iodef.h"
#include "idle.h"
#include "ui.h"


#ifdef	__cplusplus
extern "C" {
#endif
extern void intadc_init(void);
extern unsigned int polladc(void);
extern unsigned int polladc2(void);
extern void startadc(unsigned char ch);
#ifdef __SDCC
extern void stopadc(void);
#endif
extern unsigned int adc_rawtobatt(unsigned int b, unsigned int reflevel);


#ifdef	__cplusplus
}
#endif

#endif	/* ADC_INT_H */

