/*
 * OpenI2CRADIO
 * Idle routine.
 * Using timer0.
 * Copyright (C) 2013-06-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#else
#include <htc.h>
#endif
#include <signal.h>
#include "iodef.h"


void idle_init(void)
{
#if defined(__SDCC)
    INTCONbits.TMR0IF = 0;
    INTCONbits.RBIF = 0;
    INTCON2bits.TMR0IP = 0;
//   INTCON = INTCON & ~(_TMR0IF |  _RBIF); // Enable tmr0 as interrupt and clear interrupt flags.
//   INTCON2 = ~_TMR0IP & _TMR0IP; // Interrupt is lower.
#else
   INTCON = INTCON & ~(_INTCON_TMR0IF_MASK |  _INTCON_RBIF_MASK); // Enable tmr0 as interrupt and clear interrupt flags.
   INTCON2bits.TMR0IP = 0; // Interrupt is lower.
#endif
   WDTCON = 1; // OK? WDT=Disabled.
}


void stop_idle(void)
{
    T0CONbits.TMR0ON = 0;
}


void idle(unsigned int initial)
{
//   unsigned char osccon;
   unsigned char  contword;
   unsigned int i;


   WDTCONbits.SWDTEN = 0; // Lame WDT OFF.
   /* Enable IDLE */
   OSCCONbits.IDLEN = 1;
   INTCONbits.TMR0IF = 0;
   INTCONbits.TMR0IE = 1; // Enable tmr0 as interrupt and clear interrupt flags.
   /* Set TMR0 for interrupt*/
   /* Pre-scaler: 1/16, PSA=0(ON), TOSE=0, T0CS=0(INTERNAL), T08BIT=0(16bit), TMR0ON=1(START) */
   T0CONbits.T0PS0 = 1;
   T0CONbits.T0PS1 = 1;
   T0CONbits.T0PS2 = 1;
#if defined(__SDCC)
//   contword = _T0PS0 | _T0PS1 | _T0PS2 | _TMR0ON; // Prescaler = 1:256.
#else
   contword = _T0CON_T0PS0_MASK | _T0CON_T0PS1_MASK | _T0CON_T0PS2_MASK | _T0CON_TMR0ON_MASK; // Prescaler = 1:256.
#endif   //contword =  _T0PS2 | _TMR0ON; // Pre-scakler is 1:32.
   //TMR0H = initial >> 8;
   i = initial;
   TMR0L = initial & 0xff;
   TMR0H = initial >> 8; // Write order : L->H
   T0CONbits.TMR0ON = 1; // Start
//   do {
       Sleep();
//       i = TMR0H << 8 + TMR0L; // Check if IDLE-Timer was elapsed.
//   } while(i < 3); // Dead area : 0-2.
   WDTCONbits.SWDTEN = 1; // WDT ON.
}


void idle_time_ms(unsigned int ms)
{
    unsigned int tim;
    unsigned char upper;

    if(ms == 0) return;
    upper = (ms & 0xe000) >> 13;
//    unsigned int upper;
    tim = ms << 3 - ms >> 4 - ms >>3;
    tim = 65535 - tim + 1; // tim = 65536 - tim;
    while(upper > 0) {
        idle(0x0000); // Upper is 65536 tick.
    }
    idle(tim);
}

void idle_time_62_5ms(void)
{
    // Tim = 1ms * 64 - 1ms - 0.5ms
    // Tim = 0.128ms * (488 + 2.2)
    //     =
    idle(65535 - 488 + 4);
}

void idle_time_35ms(void)
{
    // Tim = 35 / 0.128 = 273.44
    idle(65535 - 274 + 1);
}
