/*
 * OpenI2CRADIO
 * I2C Handler
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <pic18fregs.h>

#include "i2c_io.h"



#ifdef _I2C_IO_TWO_MSSPS
void i2c1_init(void)
{
    unsigned char b;
//    b = SSP1CON1;
    b = _SSPEN | _SSPM3;
    SSP1CON1 = b;
    SSP1ADD = 19; // Fosc:8000[KHz] / (4 * I2C:Clock:100[KHz]) - 1
    PIR1bits.SSPIF = 0;
    PIE1bits.SSPIE = 0;
    IPR1bits.SSPIP = 1;
}
void i2c2_init(void)
{
    unsigned char b;
    b =  _SSPEN | _SSPM3;
    SSP2CON1 = b;
    SSP2ADD = 4; // Fosc:8000[KHz] / (4 * I2C:Clock:400[KHz]) - 1
}
#else
 #ifdef _I2C_IO_ONE_MSSP
void i2c1_init(void)
{
 //   unsigned char b;
//    b = _SSPEN | _SSPM3;
    SSPCON1bits.SSPEN = 1;
    SSPCON1bits.SSPM3 = 1;
    SSPADD = 4; // Fosc:8000[KHz] / (4 * I2C:Clock:400[KHz]) - 1
    SSPSTAT = 0x80;
    PIR1bits.SSPIF = 0;
    PIE1bits.SSPIE = 0;
    IPR1bits.SSPIP = 1;
}
void i2c2_init(void)
{
    i2c1_init();
}

 #else // None MSSP, Software I2C
void i2c1_init(void)
{
}
void i2c2_init(void)
{
}
 #endif
#endif