/*
 * OpenI2CRADIO
 * EEPROM utils
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

void save_eeprom(void)
{
    unsigned int p = 0;
    unsigned int sum = 0x0000;
    unsigned char i;
    unsigned char j;
    unsigned char *q;

    // Magic word
    writeword_eeprom(p, &sum, 0x1298);
    p+= 2;
    // amfreq
    writeword_eeprom(p, &sum, amfreq);
    p+= 2;
    // amfreq
    writeword_eeprom(p, &sum, fmfreq);
    p+= 2;

    writebyte_eeprom(p, &sum, amband);
    p++;
    writebyte_eeprom(p, &sum, fmband);
    p++;
    writebyte_eeprom(p, &sum, fm);
    p++;
    writebyte_eeprom(p, &sum, am_mode3k);
    p++;
    writebyte_eeprom(p, &sum, am_userbandnum);
    p++;
    writebyte_eeprom(p, &sum, fm_userbandnum);
    p++;

#if 0
    for(i = 0 ; i < USER_BAND_NUM; i++){
        writebyte_eeprom(p, &sum, am_usrbands[i].mode3k);
        writebyte_eeprom(p + 1, &sum, am_usrbands[i].start);
        writebyte_eeprom(p + 2, &sum, am_usrbands[i].stop);
        writeword_eeprom(p + 3, &sum, am_usrbands[i].freq);
        p += 5;
    }
    for(i = 0 ; i < USER_BAND_NUM; i++){
        writebyte_eeprom(p, &sum, fm_usrbands[i].mode3k);
        writebyte_eeprom(p + 1, &sum, fm_usrbands[i].start);
        writebyte_eeprom(p + 2, &sum, fm_usrbands[i].stop);
        writeword_eeprom(p + 3, &sum, fm_usrbands[i].freq);
        p += 5;
    }
#else
    for(j = 0; j < USER_BAND_NUM; j++){
        q = (unsigned char *)&am_usrbands[j];
        for(i = 0; i < sizeof(_userband_t); i++){
            writebyte_eeprom(p, &sum, *q);
            p++;
            q++;
        }
    }
    for(j = 0; j < USER_BAND_NUM; j++){
        q = (unsigned char *)&fm_usrbands[j];
        for(i = 0; i < sizeof(_userband_t); i++){
            writebyte_eeprom(p, &sum, *q);
            p++;
            q++;
        }
    }
#endif
    amfreq_bank[amband] = amfreq;
    fmfreq_bank[fmband] = fmfreq;

    for(i = 0; i < 19; i++){
        writeword_eeprom(p    , &sum, amfreq_bank[i]);
        p += 2;
    }
    for(i = 0; i < 8; i++){
        writeword_eeprom(p    , &sum, fmfreq_bank[i]);
        p += 2;
    }

    writebyte_eeprom(p, &sum, threshold_amcnr);
    p++;
    writebyte_eeprom(p, &sum, threshold_fmcnr);
    p++;
    writebyte_eeprom(p, &sum, threshold_width);
    p++;
    writebyte_eeprom(p, &sum, threshold_fmstereo);
    p++;
    writebyte_eeprom(p, &sum, lowboost);
    p++;
    writebyte_eeprom(p, &sum, stereo);
    p++;

    writebyte_eeprom(p, &sum, volume);
    p++;
    writebyte_eeprom(p, &sum, prevolume);
    p++;
    writebyte_eeprom(p, &sum, fmbandwidth);
    p++;
    writeword_eeprom(p, &sum, backlight_long);
    p += 2;
    writeword_eeprom(p, &sum, ui_idlecount);
    p += 2;
    writebyte_eeprom(p, &sum, backlight_level);
    p += 1;

    // Write checksum
    eeprom_writebyte(p, sum >> 8);
    eeprom_writebyte(p + 1, sum & 0xff);
}

unsigned char load_eeprom(void)
{
    unsigned int p = 0;
    unsigned int sum = 0x0000;
    unsigned char i;
    unsigned char *q;
    unsigned char j;
    unsigned int magic;

    // Magic word
    magic = readword_eeprom(p, &sum);
    if(magic != 0x1298) return 0x01; // NO MAGICWORD
    p+= 2;
    // amfreq
    amfreq = readword_eeprom(p, &sum);
    p+= 2;
    // fmfreq
    fmfreq = readword_eeprom(p, &sum);
    p+= 2;

    amband = readbyte_eeprom(p, &sum);
    p++;
    fmband = readbyte_eeprom(p, &sum);
    p++;
    fm = readbyte_eeprom(p, &sum);
    p++;
    am_mode3k = readbyte_eeprom(p, &sum);
    p++;
    am_userbandnum = readbyte_eeprom(p, &sum);
    p++;
    fm_userbandnum = readbyte_eeprom(p, &sum);
    p++;
#if 0
    for(i = 0 ; i < USER_BAND_NUM; i++){
        am_usrbands[i].mode3k = readbyte_eeprom(p, &sum);
        am_usrbands[i].start  = readbyte_eeprom(p + 1, &sum);
        am_usrbands[i].stop   = readbyte_eeprom(p + 2, &sum);
        am_usrbands[i].freq   = readword_eeprom(p + 3, &sum);
        p += 5;
    }
    for(i = 0 ; i < USER_BAND_NUM; i++){
        fm_usrbands[i].mode3k = readbyte_eeprom(p, &sum);
        fm_usrbands[i].start  = readbyte_eeprom(p + 1, &sum);
        fm_usrbands[i].stop   = readbyte_eeprom(p + 2, &sum);
        fm_usrbands[i].freq   = readword_eeprom(p + 3, &sum);
        p += 5;
    }
#else
    for(j = 0; j < USER_BAND_NUM; j++){
        q = (unsigned char *)&am_usrbands[j];
        for(i = 0; i < sizeof(_userband_t); i++){
            *q = readbyte_eeprom(p, &sum);
            p++;
            q++;
        }
        if(am_usrbands[j].mode3k != 0){
            am_userband_freq[j].start = am_usrbands[j].start * 96;
            am_userband_freq[j].end   = am_usrbands[j].stop  * 96;
        } else {
            am_userband_freq[j].start = am_usrbands[j].start * 160;
            am_userband_freq[j].end   = am_usrbands[j].stop  * 160;
        }
    }
    for(j = 0; j < USER_BAND_NUM; j++){
        q = (unsigned char *)&fm_usrbands[j];
        for(i = 0; i < sizeof(_userband_t); i++){
            *q = readbyte_eeprom(p, &sum);
            p++;
            q++;
        }
        fm_userband_freq[j].start = fm_usrbands[j].start * 80 + 3000;
        fm_userband_freq[j].end   = fm_usrbands[j].stop * 80 + 3000;
    }
#endif
    amfreq = amfreq_bank[amband];
    fmfreq = fmfreq_bank[fmband];
    for(i = 0; i < 19; i++){
        amfreq_bank[i] = readword_eeprom(p    , &sum);
        p += 2;
    }
    for(i = 0; i < 8; i++){
        fmfreq_bank[i] = readword_eeprom(p    , &sum);
        p += 2;
    }
    threshold_amcnr = readbyte_eeprom(p, &sum);
    p++;
    threshold_fmcnr = readbyte_eeprom(p, &sum);
    p++;
    threshold_width = readbyte_eeprom(p, &sum);
    p++;
    threshold_fmstereo = readbyte_eeprom(p, &sum);
    p++;
    lowboost = readbyte_eeprom(p    , &sum);
    p++;
    stereo = readbyte_eeprom(p    , &sum);
    p++;
    volume = readbyte_eeprom(p, &sum);
    p++;
    prevolume = readbyte_eeprom(p, &sum);
    p++;
    fmbandwidth = readbyte_eeprom(p, &sum);
    p++;
    backlight_long = readword_eeprom(p, &sum);
    p += 2;
    ui_idlecount = readword_eeprom(p, &sum);
    p += 2;
    backlight_level = readbyte_eeprom(p, &sum);
    p += 1;
     // Write checksum
    magic = (eeprom_readbyte(p) << 8) + eeprom_readbyte(p+1);

    if(sum != magic) return 0x00;
    return 0xff;
}

/*
 * Check eeprom, and format/restore.
 */
void check_eeprom(void)
{
    unsigned char c;
        switch(load_eeprom()) {
        case 0x01: // No magic-word
            idle_time_ms(2000);
            c = printhelp_2lines("EEPROM FORMAT", "Press any key");
            _CLS();
            _LOCATE(0,0);
            printstr("Formatting...  ");
            format_eeprom(2,250);
            _LOCATE(0,0);
            printstr("Save defaults  ");
            setdefault();
            save_eeprom();
            break;
        case 0x00: // Checksum error
           idle_time_ms(2000);
            c = printhelp_2lines("X-) Sum error", "Press any key");
            c = pollkey_single();
            _CLS();
            _LOCATE(0,0);
            printstr("Formatting...");
            format_eeprom(2,250);
//            writeword_eeprom(0, &sum, 0x1298);
            _LOCATE(0,0);
            printstr("Save defaults");
            setdefault();
            save_eeprom();
            break;
        case 0xff: // Success
            return;
            break;
        default: // Unknown error
            break;
    }
    valinit();
}
