/*
 * OpenI2CRADIO
 * Menu sub-routines / USER BAND.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"


void call_userband(unsigned char num)
{
    unsigned int freq;
    unsigned int ch;
    unsigned char start;
    unsigned char end;
    unsigned char mode3k;
    unsigned char freq2;
    _userband_t *p;

    if(num >= USER_BAND_NUM) return;

    p = &(setup.am_usrbands[num]);
    if(setup.fm != 0){
        p = &(setup.fm_usrbands[num]);
    }
    freq = p->freq;
    start = p->start;
    end = p->stop;
    mode3k = p->mode3k;
    if(setup.fm != 0) {
        ch = ((freq - 3000) / 5) * 2;
        setup.fmband = AKC6955_BAND_FMUSER;
    } else {
        unsigned int q = 5;
        if(mode3k != 0) q = 3;
        ch = freq / q;
        setup.amband = AKC6955_BAND_AMUSER;
    }

    if(start > end) {
        unsigned char tmp;
        tmp = start;
        start = end;
        end = tmp;
    }

    freq2 = ch / 32;
    if(freq2 > end) {
        ch = end * 32;
    }
    if(freq2 < start){
        ch = start * 32;
    }
    akc6955_set_userband(start, end, ch, mode3k);
}

void set_userband(void)
{
    unsigned long from,to;
    unsigned char c;
    unsigned char pp;
    unsigned char mode3k;
    char cc;

    _CLS();
    _LOCATE(0,0);
    printstr("User ch:");
    c = pollkey_single();

    if(c > charcode_0) return;
    if(c < charcode_1) return;
    if(c == charcode_0) {
        c = 0;
    } else {
        c = c - charcode_1 + 1;
    }
    if(c >= USER_BAND_NUM) return;

    if(setup.fm != 0){
        from = setup.fm_usrbands[c].start * 80 + 3000; // 32*25/10
        to = setup.fm_usrbands[c].stop * 80 + 3000;
        _CLS();
        _LOCATE(0,0);
        printstr("FM#");
        print_numeric_nosupress(c, 1);
        _LOCATE(0,1);
        printstr(" From:");
        from = read_numeric(from, 5, 7, 1);
        if(from >= 0x80000000) goto _l0;
        _LOCATE(0,1);
        printstr(" To:  ");
        to = read_numeric(to, 5, 7, 1);
        if(to >= 0x80000000) goto _l0;
        setup.fm_usrbands[c].start = (from - 3000) / 80;
        setup.fm_usrbands[c].stop = (to - 3000) / 80;
        setup.fm_usrbands[c].freq = from;
        setup.fm_userbandnum = c;
    } else {
        mode3k = setup.am_usrbands[c].mode3k;
        pp = 96; // 3*32
        if(mode3k == 0) pp = 160; // 5*32
        from = setup.am_usrbands[c].start * pp;
        to = setup.am_usrbands[c].stop * pp;
        _CLS();
        _LOCATE(0,0);
        printstr("AM#");
        print_numeric_nosupress(c, 1);
        printstr(" Step:");
        _LOCATE(0,1);
        printstr("0=3k 1=5k");
        cc = pollkey_single();
        if(cc == charcode_0){
            pp = 96;
            mode3k = 0xff;
        } else if(cc = charcode_1) {
            pp = 160;
            mode3k = 0;
        }
        _CLS();
        _LOCATE(0,0);
        printstr("AM#");
        print_numeric_nosupress(c, 1);
        _LOCATE(0,1);
        printstr(" From:");
        from = read_numeric(from, 5, 7, 1);
        if(from >= 0x80000000) goto _l0;
        _LOCATE(0,1);
        printstr(" To:  ");
        to = read_numeric(to, 5, 7, 1);
        if(to >= 0x80000000) goto _l0;
        setup.am_usrbands[c].start = from / pp;
        setup.am_usrbands[c].stop = to  / pp;
        setup.am_usrbands[c].mode3k = mode3k;
        setup.am_usrbands[c].freq = from;
        setup.am_userbandnum = c;
    }
    call_userband(c);
_l0:
    _CLS();
}

void input_userband(void)
{
    unsigned char c;
    do{
    c = printhelp_2lines("User Band", "   #");
    if((c >= charcode_a) && (c <= charcode_f)){
        break;
    }
    if(c == charcode_0) {
        _PUTCHAR('0');
        if(setup.fm != 0){
           setup.fm_userbandnum = 0;
        } else {
           setup.am_userbandnum = 0;
        }
        call_userband(0);
    } else {
        c = c - charcode_1 + 1;
        if(c < USER_BAND_NUM) {
            _PUTCHAR(c + '0');
            if(setup.fm != 0){
               setup.fm_userbandnum = c;
            } else {
                setup.am_userbandnum = c;
            }
            call_userband(c);
        }
    }
    idle(setup.ui_idlecount);
    } while(1);
    _CLS();
}

